/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.dr.ui.tools.reactive.impl;

import com.vmware.dr.ui.tools.reactive.Publisher;
import com.vmware.dr.ui.tools.reactive.Subscriber;
import com.vmware.dr.ui.tools.reactive.impl.TransformStream;
import com.vmware.dr.ui.tools.reactive.impl.utils.Exceptions;
import java.util.function.Function;

public class MapTransformStream<U, R>
extends TransformStream<U, R> {
    private final Function<? super U, ? extends R> _mapper;

    protected MapTransformStream(Publisher<U> publisher, Function<? super U, ? extends R> mapper) {
        super(publisher);
        this._mapper = mapper;
    }

    @Override
    protected void processNext(U item, Subscriber<? super R> subscriber) {
        R mapped;
        try {
            mapped = this._mapper.apply(item);
        }
        catch (Throwable t) {
            subscriber.onError(Exceptions.wrap(t));
            return;
        }
        subscriber.onNext(mapped);
    }
}

