/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.core.engine;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.Stream;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.srm.client.topology.impl.core.engine.Context;
import com.vmware.srm.client.topology.impl.core.engine.Graph;
import com.vmware.srm.client.topology.impl.core.engine.Node;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Traversal<T extends Context> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Traversal.class);
    private final Graph<T> _graph;
    private final Node<T> _startNode;
    private final Set<Node<T>> _allNodes = new HashSet<Node<T>>();
    private final T _context;
    private final Set<Node<T>> _visited = new HashSet<Node<T>>();
    private final Set<Node<T>> _newEntities = new HashSet<Node<T>>();
    final ConcurrentMap<Node<T>, Set<Node<T>>> neighbourByNode = new ConcurrentHashMap<Node<T>, Set<Node<T>>>();

    Traversal(Graph<T> graph, Node<T> startNode, T context) {
        this._graph = graph;
        this._startNode = startNode;
        this._context = context;
    }

    Promise<Void> start(Map<Node<T>, Set<Node<T>>> currentNeighbourByNode) {
        this.neighbourByNode.putAll(currentNeighbourByNode);
        this._allNodes.addAll(currentNeighbourByNode.keySet());
        this._visited.add(this._startNode);
        return this.processAllReachable(this._startNode, this._context).collect().thenApply(unused -> null);
    }

    private Stream<Node<T>> processAllReachable(Node<T> from, T context) {
        return this.processNeighbours(from, context).toStream().flatMap(Streams::from).flatMap(newNode -> this.processAllReachable((Node<T>)newNode, context));
    }

    private Promise<Set<Node<T>>> processNeighbours(Node<T> node, T context) {
        LOGGER.trace("Discovering neighbours for '{}'", node);
        return node.discoverNeighbours(context).materialize().thenApply(pr -> this.processNeighbours(node, pr.isSuccessful() ? Collections.unmodifiableSet((Set)pr.getResult()) : Collections.emptySet(), pr.getError()));
    }

    private Set<Node<T>> processNeighbours(Node<T> node, Set<Node<T>> neighbours, Exception err) {
        Set current = (Set)this.neighbourByNode.get(node);
        if (err == null) {
            LOGGER.trace("Neighbours for {}: {}.", node, neighbours);
            Set<Node<T>> processed = this.processUpdates(node, neighbours, current);
            this.neighbourByNode.put(node, processed);
            return this.tryAddToVisited(processed);
        }
        LOGGER.trace("Failed to discover neighbours for {}.", node, (Object)err);
        if (current == null) {
            this.neighbourByNode.put(node, Collections.emptySet());
        }
        return Collections.emptySet();
    }

    private Set<Node<T>> processUpdates(Node<T> node, Set<Node<T>> suggested, Set<Node<T>> current) {
        HashSet<Node<T>> result = new HashSet<Node<T>>();
        if (current == null || current.isEmpty()) {
            for (Node<T> s : suggested) {
                Node<T> registered = this.tryRegisterAsNew(s);
                result.add(registered);
                if (s != registered) {
                    LOGGER.trace("Updating node '{}' with '{}'.", registered, s);
                    registered.update(s, this._context);
                    this._graph.dispose(s);
                }
                LOGGER.trace("New neighbour added: '{}', for '{}'.", registered, node);
                node.neighbourAdded(registered, this._context);
            }
            return result;
        }
        HashSet<Node<T>> currentInSuggested = new HashSet<Node<T>>(current);
        currentInSuggested.retainAll(suggested);
        result.addAll(currentInSuggested);
        HashSet<Node<T>> removed = new HashSet<Node<T>>(current);
        removed.removeAll(currentInSuggested);
        for (Node node2 : removed) {
            LOGGER.trace("Removing neighbour '{}' for '{}'.", (Object)node2, node);
            node.neighbourRemoved(node2, this._context);
        }
        block2: for (Node node3 : suggested) {
            for (Node node4 : currentInSuggested) {
                if (!node3.equals(node4)) continue;
                LOGGER.trace("Updating node '{}' with '{}'.", (Object)node4, (Object)node3);
                node4.update(node3, this._context);
                this._graph.dispose(node3);
                LOGGER.trace("Updated neighbour: '{}', for '{}'.", (Object)node4, node);
                node.neighbourUpdated(node4, this._context);
                continue block2;
            }
            Node<T> registered = this.tryRegisterAsNew(node3);
            result.add(registered);
            if (node3 != registered) {
                LOGGER.trace("Updating node '{}' with '{}'.", registered, (Object)node3);
                registered.update(node3, this._context);
                this._graph.dispose(node3);
            }
            LOGGER.trace("New neighbour added: '{}', for '{}'.", registered, node);
            node.neighbourAdded(registered, this._context);
        }
        return result;
    }

    private Node<T> tryRegisterAsNew(Node<T> suggested) {
        if (this._allNodes.contains(suggested)) {
            for (Node<T> old : this._allNodes) {
                if (!old.equals(suggested)) continue;
                return old;
            }
            throw new IllegalStateException("Should not reach here.");
        }
        Set<Node<T>> set = this._newEntities;
        synchronized (set) {
            if (this._newEntities.add(suggested)) {
                LOGGER.trace("Adding new node: '{}'.", suggested);
                suggested.added(this._context);
                return suggested;
            }
            for (Node<T> existing : this._newEntities) {
                if (!existing.equals(suggested)) continue;
                return existing;
            }
            throw new IllegalStateException("Should not reach here.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Node<T>> tryAddToVisited(Set<Node<T>> suggested) {
        if (suggested.isEmpty()) {
            return suggested;
        }
        HashSet<Node<T>> result = new HashSet<Node<T>>();
        Set<Node<T>> set = this._visited;
        synchronized (set) {
            for (Node<T> node : suggested) {
                if (!this._visited.add(node)) continue;
                result.add(node);
            }
        }
        return result;
    }
}

