/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.core.mxn.nodes.utils;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.utilities.StringUtils;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.vmomi.availability.srm.SrmService;
import com.vmware.srm.client.topology.impl.utils.Exceptions;
import com.vmware.vim.binding.dr.site.ConnectionSpec;
import com.vmware.vim.binding.dr.site.EndpointSslInfo;
import com.vmware.vim.binding.dr.site.ServiceSslInfo;
import com.vmware.vim.binding.dr.site.SiteInfo;
import com.vmware.vim.binding.impl.vmodl.TypeNameImpl;
import com.vmware.vim.binding.vmodl.DynamicProperty;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.TypeName;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.util.StringUtil;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;

public class SrmHelper {
    public static Promise<PairInfo> getPairInfoFor(SrmService service) {
        return service.getContent().thenCompose(content -> {
            PropertyCollector.FilterSpec fs = SrmHelper.getRemoteSiteSpec(content.getSiteManager());
            PropertyCollector pc = (PropertyCollector)service.createStub(content.getPropertyCollector());
            FuturePromise rcResult = new FuturePromise();
            pc.retrieveContents(new PropertyCollector.FilterSpec[]{fs}, (Future)rcResult);
            return rcResult;
        }).thenApply(SrmHelper::createInfoFromPcResult);
    }

    private static PropertyCollector.FilterSpec getRemoteSiteSpec(ManagedObjectReference siteManager) {
        PropertyCollector.TraversalSpec toRemoteSiteList = new PropertyCollector.TraversalSpec("toRemoteSite", SrmHelper.getTypeName("DrSiteSiteManager"), "remoteSiteList", Boolean.valueOf(false), null);
        PropertyCollector.ObjectSpec os = new PropertyCollector.ObjectSpec(siteManager, Boolean.valueOf(true), new PropertyCollector.SelectionSpec[]{toRemoteSiteList});
        String[] pathset = new String[]{"connectionSpec", "reconfigureConnectionNeeded", "host", "port", "uuid", "serviceTypeId", "name", "info"};
        PropertyCollector.PropertySpec ps = new PropertyCollector.PropertySpec(SrmHelper.getTypeName("DrSiteRemoteSite"), Boolean.valueOf(false), pathset);
        return new PropertyCollector.FilterSpec(new PropertyCollector.PropertySpec[]{ps}, new PropertyCollector.ObjectSpec[]{os}, Boolean.valueOf(false));
    }

    private static PairInfo createInfoFromPcResult(PropertyCollector.ObjectContent[] objContent) {
        if (ArrayUtils.isEmpty((Object[])objContent)) {
            return new PairInfo();
        }
        PropertyCollector.ObjectContent content = objContent[0];
        if (ArrayUtils.isNotEmpty((Object[])content.getMissingSet())) {
            Exception err = content.getMissingSet()[0].getFault();
            throw Exceptions.getRuntimeException(err);
        }
        ConnectionSpec spec = null;
        Boolean repairNeeded = null;
        String srmHost = null;
        Integer srmPort = null;
        String srmUuid = null;
        String srmName = null;
        String serviceTypeId = null;
        String vcName = null;
        for (DynamicProperty dp : content.getPropSet()) {
            String propName = dp.getName();
            Object propValue = dp.getVal();
            if ("connectionSpec".equals(propName)) {
                spec = (ConnectionSpec)propValue;
                continue;
            }
            if ("host".equals(propName)) {
                srmHost = (String)propValue;
                continue;
            }
            if ("port".equals(propName)) {
                srmPort = (Integer)propValue;
                continue;
            }
            if ("uuid".equals(propName)) {
                srmUuid = (String)propValue;
                continue;
            }
            if ("serviceTypeId".equals(propName)) {
                serviceTypeId = (String)propValue;
                continue;
            }
            if ("name".equals(propName)) {
                srmName = (String)propValue;
                continue;
            }
            if ("reconfigureConnectionNeeded".equals(propName)) {
                repairNeeded = (Boolean)propValue;
                continue;
            }
            if (!"info".equals(propName)) continue;
            vcName = ((SiteInfo)propValue).getVcName();
        }
        PairInfo info = new PairInfo();
        info.remoteSiteRef = content.getObj();
        info.srmUuid = srmUuid;
        if (repairNeeded.booleanValue()) {
            info.repairNeeded = true;
            return info;
        }
        Validate.notNull((Object)spec, (String)"connectionSpec");
        try {
            info.lsppUrl = new URI("https", null, spec.getAddress(), spec.getPort() == null ? 443 : spec.getPort(), "/lookupservice/sdk", null, null);
        }
        catch (URISyntaxException e) {
            throw Exceptions.getRuntimeException(e);
        }
        info.lsppThumbprint = spec.getThumbprint();
        info.vcUuid = spec.getVcInstanceId();
        info.vcUrl = SrmHelper.getVcURI(spec);
        try {
            info.srmUrl = new URI("https", null, srmHost, srmPort, null, null, null);
        }
        catch (URISyntaxException e) {
            throw Exceptions.getRuntimeException(e);
        }
        info.serviceTypeId = serviceTypeId;
        info.srmName = srmName;
        info.vcName = vcName;
        return info;
    }

    private static TypeName getTypeName(String wsdlType) {
        VmodlType type = VmodlTypeMap.Factory.getTypeMap().getVmodlType(wsdlType);
        return new TypeNameImpl(type);
    }

    private static URI getVcURI(ConnectionSpec spec) {
        URI result = URI.create("unknown:443");
        if (ArrayUtils.isNotEmpty((Object[])spec.sslInfo)) {
            block0: for (ServiceSslInfo sslInfo : spec.sslInfo) {
                if (ArrayUtils.isEmpty((Object[])sslInfo.endpointSslInfo)) continue;
                for (EndpointSslInfo ep : sslInfo.endpointSslInfo) {
                    if (!"vmomi".equals(ep.protocol) || !"com.vmware.vim".equals(ep.type)) continue;
                    result = URI.create(ep.url);
                    break block0;
                }
            }
        }
        return result;
    }

    public static class PairInfo {
        public boolean repairNeeded;
        public URI lsppUrl;
        public String lsppThumbprint;
        public URI vcUrl;
        public String vcUuid;
        public String vcName;
        public URI srmUrl;
        public String srmUuid;
        public String serviceTypeId;
        public String srmName;
        public ManagedObjectReference remoteSiteRef;

        public String toString() {
            return "PairInfo {" + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"repairNeeded = ", (Object)this.repairNeeded)), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"lsppUrl = ", (Object)this.lsppUrl)), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"lsppThumbprint = ", (Object)this.lsppThumbprint)), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"vcUrl = ", (Object)this.vcUrl)), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"vcUuid = ", (Object)this.vcUuid)), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"vcName = ", (Object)this.vcName)), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"srmUrl = ", (Object)this.srmUrl)), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"srmUuid = ", (Object)this.srmUuid)), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"serviceTypeId = ", (Object)this.serviceTypeId)), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"srmName = ", (Object)this.srmName)), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"remoteSiteRef = ", (Object)this.remoteSiteRef)), (boolean)false) + "\n}";
        }
    }
}

