/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.vlsi.record;

import com.vmware.srm.client.topology.impl.vmomi.vlsi.record.CallRecord;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.PriorityBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmomiRecordLookup {
    private static final Logger LOGGER = LoggerFactory.getLogger(VmomiRecordLookup.class);
    private static final Comparator<CallRecord> COMPARATOR = Comparator.comparingLong(CallRecord::getInstant);
    private final String _guid;
    private final Map<CallRecord, PriorityBlockingQueue<CallRecord>> _lookup;

    private static Map<CallRecord, PriorityBlockingQueue<CallRecord>> process(File guidDir, VmodlContext context, VmodlVersion version) throws IOException {
        HashMap<CallRecord, PriorityBlockingQueue<CallRecord>> result = new HashMap<CallRecord, PriorityBlockingQueue<CallRecord>>();
        try (DirectoryStream<Path> requestPaths = Files.newDirectoryStream(guidDir.toPath(), "request-*");){
            for (Path path : requestPaths) {
                File requestDir = path.toFile();
                CallRecord cr = CallRecord.deserializeFromFile(requestDir, context, version);
                PriorityBlockingQueue queue = result.computeIfAbsent(cr, key -> new PriorityBlockingQueue<CallRecord>(8, COMPARATOR));
                queue.put(cr);
            }
        }
        return result;
    }

    public VmomiRecordLookup(File opIdDir, String guid, VmodlContext context, VmodlVersion version) throws IOException {
        this._guid = guid;
        File guidDir = new File(opIdDir, guid);
        this._lookup = VmomiRecordLookup.process(guidDir, context, version);
    }

    public CallRecord lookup(Method method, ManagedObjectReference thisRef, Object[] args, VmodlContext context) {
        CallRecord key = new CallRecord(method, thisRef, Arrays.copyOf(args, args.length - 1), null, null, null, context);
        PriorityBlockingQueue<CallRecord> pbq = this._lookup.get(key);
        if (pbq == null) {
            LOGGER.warn("No queue found for key '{}', guid '{}'.", (Object)key, (Object)this._guid);
            return null;
        }
        CallRecord result = pbq.poll();
        if (result == null) {
            LOGGER.warn("No record found for key '{}', guid '{}'.", (Object)key, (Object)this._guid);
        }
        return result;
    }
}

