/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.importers.inventory;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.constants.vim.VIRTUAL_MACHINE;
import com.vmware.vr.client.impex.configurables.inventory.IeInventory;
import com.vmware.vr.client.impex.configurables.inventory.IeInventoryFolder;
import com.vmware.vr.client.impex.configurables.inventory.IeInventoryTree;
import com.vmware.vr.client.impex.configurables.inventory.InventoryConverter;
import com.vmware.vr.client.impex.configurables.inventory.datacenter.IeComputeResource;
import com.vmware.vr.client.impex.configurables.inventory.datacenter.IeDatacenter;
import com.vmware.vr.client.impex.configurables.inventory.datacenter.IeDatastore;
import com.vmware.vr.client.impex.configurables.inventory.datacenter.IeHost;
import com.vmware.vr.client.impex.configurables.inventory.datacenter.IeNetwork;
import com.vmware.vr.client.impex.configurables.inventory.datacenter.IeResourcePool;
import com.vmware.vr.client.impex.configurables.inventory.datacenter.IeVirtualApp;
import com.vmware.vr.client.impex.configurables.inventory.datacenter.IeVirtualMachine;
import com.vmware.vr.client.impex.tool.HmsConfigurablesWrapper;
import com.vmware.vr.client.impex.tool.ServersDataWrapper;
import com.vmware.vr.client.impex.utils.Lookup;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InventoryExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(InventoryExtractor.class);

    protected abstract ServersDataWrapper getServersDataWrapper();

    protected abstract HmsConfigurablesWrapper getConfigurablesWrapper();

    public Promise<InventoryLookup> traverse() {
        ConcurrentHashMap<String, ManagedObjectReference> inventory = new ConcurrentHashMap<String, ManagedObjectReference>(new HashMap());
        ConcurrentHashMap<String, String> vmIdToKey = new ConcurrentHashMap<String, String>(new HashMap());
        Promise<Void> traverseLocalInventory = this.traverseInventory(inventory, vmIdToKey, true);
        Promise<Void> traverseRemoteInventory = this.traverseInventory(inventory, vmIdToKey, false);
        return traverseLocalInventory.thenCombine(traverseRemoteInventory, (lUnused, rUnused) -> new InventoryLookup(inventory, vmIdToKey));
    }

    private Promise<Void> traverseInventory(Map<String, ManagedObjectReference> inventory, Map<String, String> vmIdToKey, boolean local) {
        ServersDataWrapper serversData = this.getServersDataWrapper();
        String vcGuid = local ? serversData.getLocalPair().server().vc().guid() : serversData.getRemotePair().server().vc().guid();
        IeInventoryTree ieTree = this.getTree(this.getConfigurablesWrapper().getInventory(), local);
        if (Objects.isNull(ieTree) || Objects.isNull(ieTree.getRoot())) {
            LOGGER.debug("Tree or its root is null for guid: '{}'.", (Object)vcGuid);
            return Promises.resolve(null);
        }
        return PCUtil.retrieveProperties(serversData.getView(), (PropertyCollector.FilterSpec[])new PropertyCollector.FilterSpec[]{InventoryConverter.getFilterSpec(vcGuid)}).thenApply(pcResult -> {
            ManagedObjectReference root = InventoryConverter.getRootFolder(vcGuid);
            ManagedObjectReference[] children = (ManagedObjectReference[])pcResult.getProperty(root, "childEntity");
            List<IeInventory> ieChildren = ieTree.getRoot().getChildren();
            this.getInventory(inventory, vmIdToKey, (PcResult)pcResult, children, ieChildren);
            return null;
        });
    }

    private void getInventory(Map<String, ManagedObjectReference> inventory, Map<String, String> vmIdToKey, PcResult pcResult, ManagedObjectReference[] entities, List<IeInventory> ieEntities) {
        Arrays.stream(entities).forEach(entity -> {
            switch (entity.getType()) {
                case "Folder": {
                    this.extractFolder(inventory, vmIdToKey, pcResult, (ManagedObjectReference)entity, ieEntities);
                    break;
                }
                case "Datacenter": {
                    this.extractDatacenter(inventory, vmIdToKey, pcResult, (ManagedObjectReference)entity, ieEntities);
                    break;
                }
                case "VirtualMachine": {
                    this.extractVm(inventory, vmIdToKey, pcResult, (ManagedObjectReference)entity, (List<? extends IeInventory>)ieEntities);
                    break;
                }
                case "ComputeResource": 
                case "ClusterComputeResource": {
                    this.extractComputeResource(inventory, vmIdToKey, pcResult, (ManagedObjectReference)entity, ieEntities);
                    break;
                }
                default: {
                    LOGGER.warn("Unexpected entity found '{}'", entity);
                }
            }
        });
    }

    private void extractFolder(Map<String, ManagedObjectReference> inventory, Map<String, String> vmIdToKey, PcResult pcResult, ManagedObjectReference folder, List<IeInventory> ieEntities) {
        String name = (String)pcResult.getProperty(folder, "name");
        IeInventoryFolder ieFolder = this.getMatch(IeInventoryFolder.class, name, ieEntities);
        if (Objects.isNull(ieFolder)) {
            LOGGER.debug("IeFolder is null");
            return;
        }
        ManagedObjectReference[] children = (ManagedObjectReference[])pcResult.getProperty(folder, "childEntity");
        if (Objects.nonNull(inventory.putIfAbsent(ieFolder.getId(), folder))) {
            LOGGER.debug("Folder with id: '{}' and moRef: '{}' is already put.", (Object)ieFolder.getId(), (Object)folder);
        }
        this.getInventory(inventory, vmIdToKey, pcResult, children, ieFolder.getChildren());
    }

    private void extractDatacenter(Map<String, ManagedObjectReference> inventory, Map<String, String> vmIdToKey, PcResult pcResult, ManagedObjectReference datacenter, List<IeInventory> ieEntities) {
        String name = (String)pcResult.getProperty(datacenter, "name");
        IeDatacenter ieDc = this.getMatch(IeDatacenter.class, name, ieEntities);
        if (Objects.isNull(ieDc)) {
            LOGGER.debug("IeDatacenter is null");
            return;
        }
        if (Objects.nonNull(inventory.putIfAbsent(ieDc.getId(), datacenter))) {
            LOGGER.debug("Datacenter with id: '{}' and moRef: '{}' is already put.", (Object)ieDc.getId(), (Object)datacenter);
        }
        this.extractNetworks(inventory, pcResult, datacenter, ieDc);
        this.extractDatastores(inventory, pcResult, datacenter, ieDc);
        ManagedObjectReference vmFolder = (ManagedObjectReference)pcResult.getProperty(datacenter, "vmFolder");
        IeInventoryFolder ieVmFolder = ieDc.getVmFolder();
        if (Objects.nonNull(ieVmFolder) && Objects.nonNull(ieVmFolder.getId())) {
            if (Objects.nonNull(inventory.putIfAbsent(ieVmFolder.getId(), vmFolder))) {
                LOGGER.debug("Vm folder with id: '{}' and moRef: '{}' is already put.", (Object)ieVmFolder.getId(), (Object)vmFolder);
            }
            ManagedObjectReference[] vmChildren = (ManagedObjectReference[])pcResult.getProperty(vmFolder, "childEntity");
            this.getInventory(inventory, vmIdToKey, pcResult, vmChildren, ieVmFolder.getChildren());
        }
        ManagedObjectReference hostFolder = (ManagedObjectReference)pcResult.getProperty(datacenter, "hostFolder");
        IeInventoryFolder ieHostFolder = ieDc.getHostFolder();
        if (Objects.nonNull(ieHostFolder) && Objects.nonNull(ieHostFolder.getId())) {
            if (Objects.nonNull(inventory.putIfAbsent(ieDc.getHostFolder().getId(), hostFolder))) {
                LOGGER.debug("Host folder with id: '{}' and moRef: '{}' is already put.", (Object)ieDc.getHostFolder().getId(), (Object)hostFolder);
            }
            ManagedObjectReference[] hostChildren = (ManagedObjectReference[])pcResult.getProperty(hostFolder, "childEntity");
            this.getInventory(inventory, vmIdToKey, pcResult, hostChildren, ieHostFolder.getChildren());
        }
    }

    private void extractNetworks(Map<String, ManagedObjectReference> inventory, PcResult pcResult, ManagedObjectReference datacenter, IeDatacenter ieDc) {
        ManagedObjectReference[] networks = (ManagedObjectReference[])pcResult.getProperty(datacenter, "network");
        Arrays.stream(networks).forEach(network -> {
            String name = (String)pcResult.getProperty(network, "name");
            IeNetwork ieNetwork = this.getMatch(IeNetwork.class, name, ieDc.getNetworks());
            if (Objects.nonNull(ieNetwork) && Objects.nonNull(inventory.putIfAbsent(ieNetwork.getId(), (ManagedObjectReference)network))) {
                LOGGER.debug("Network with id: '{}' and moRef: '{}' is already put.", (Object)ieNetwork.getId(), network);
            }
        });
    }

    private void extractDatastores(Map<String, ManagedObjectReference> inventory, PcResult pcResult, ManagedObjectReference datacenter, IeDatacenter ieDc) {
        ManagedObjectReference[] datastores = (ManagedObjectReference[])pcResult.getProperty(datacenter, "datastore");
        Arrays.stream(datastores).forEach(datastore -> {
            String name = (String)pcResult.getProperty(datastore, "name");
            IeDatastore ieDatastore = this.getMatch(IeDatastore.class, name, ieDc.getDatastores());
            if (Objects.nonNull(ieDatastore) && Objects.nonNull(inventory.putIfAbsent(ieDatastore.getId(), (ManagedObjectReference)datastore))) {
                LOGGER.debug("Datastore with id: '{}' and moRef: '{}' is already put.", (Object)ieDatastore.getId(), datastore);
            }
        });
    }

    private void extractVm(Map<String, ManagedObjectReference> inventory, Map<String, String> vmIdToKey, PcResult pcResult, ManagedObjectReference vm, List<? extends IeInventory> ieEntities) {
        String name = (String)pcResult.getProperty(vm, "name");
        IeVirtualMachine ieVm = this.getMatch(IeVirtualMachine.class, name, ieEntities);
        if (Objects.isNull(ieVm)) {
            LOGGER.debug("IeVm is null");
            return;
        }
        String id = ieVm.getId();
        String key = (String)pcResult.getProperty(vm, VIRTUAL_MACHINE.CONFIG_.INSTANCE_UUID);
        LOGGER.debug("Extracting Vm with id: '{}', name: '{}' and key: '{}'.", new Object[]{id, name, key});
        if (vm == null || StringUtils.isEmpty(id) || StringUtils.isEmpty(key)) {
            LOGGER.error("Failed to extract Vm with id: '{}', name: '{}' and key: '{}'. Ignore.", new Object[]{id, name, key});
        } else {
            if (Objects.nonNull(inventory.putIfAbsent(id, vm))) {
                LOGGER.debug("Vm with id: '{}' and key: '{}' is already put in inventory.", (Object)id, (Object)vm);
            }
            if (Objects.nonNull(vmIdToKey.putIfAbsent(id, key))) {
                LOGGER.debug("Vm with id: '{}' and key: '{}' is already put in vmKeys.", (Object)id, (Object)vm);
            }
        }
    }

    private void extractVmInfo(Map<String, ManagedObjectReference> inventory, Map<String, String> vmIdToKey, PcResult pcResult, IeResourcePool ieResourcePool, ManagedObjectReference resourcePool) {
        ManagedObjectReference[] vms = (ManagedObjectReference[])pcResult.getProperty(resourcePool, "vm");
        Arrays.stream(vms).forEach(vm -> this.extractVm(inventory, vmIdToKey, pcResult, (ManagedObjectReference)vm, (List<? extends IeInventory>)ieResourcePool.getVirtualMachines()));
    }

    private void extractHosts(Map<String, ManagedObjectReference> inventory, PcResult pcResult, ManagedObjectReference[] hosts, List<IeHost> ieHosts) {
        Arrays.stream(hosts).forEach(host -> {
            String name = (String)pcResult.getProperty(host, "name");
            IeHost ieHost = this.getMatch(IeHost.class, name, ieHosts);
            if (Objects.nonNull(ieHost) && Objects.nonNull(inventory.putIfAbsent(ieHost.getId(), (ManagedObjectReference)host))) {
                LOGGER.debug("Host with id: '{}' and moRef: '{}' is already put.", (Object)ieHost.getId(), host);
            }
        });
    }

    private void extractComputeResource(Map<String, ManagedObjectReference> inventory, Map<String, String> vmIdToKey, PcResult pcResult, ManagedObjectReference computeResource, List<IeInventory> ieEntities) {
        String name = (String)pcResult.getProperty(computeResource, "name");
        IeComputeResource ieComputeResource = this.getMatch(IeComputeResource.class, name, ieEntities);
        if (Objects.isNull(ieComputeResource)) {
            LOGGER.debug("IeComputeResource is null");
            return;
        }
        ManagedObjectReference[] hosts = (ManagedObjectReference[])pcResult.getProperty(computeResource, "host");
        this.extractHosts(inventory, pcResult, hosts, ieComputeResource.getHosts());
        IeResourcePool ieResourcePool = ieComputeResource.getResourcePool();
        if (Objects.isNull(ieResourcePool)) {
            LOGGER.debug("IeResourcePool is null");
            return;
        }
        ManagedObjectReference resourcePool = (ManagedObjectReference)pcResult.getProperty(computeResource, "resourcePool");
        if (Objects.nonNull(ieResourcePool.getId()) && Objects.nonNull(inventory.putIfAbsent(ieResourcePool.getId(), resourcePool))) {
            LOGGER.debug("Resource pool with id: '{}' and moRef: '{}' is already put.", (Object)ieResourcePool.getId(), (Object)resourcePool);
        }
        ManagedObjectReference[] resourcePoolChildren = (ManagedObjectReference[])pcResult.getProperty(resourcePool, "resourcePool");
        this.extractResourcePoolChildren(inventory, vmIdToKey, pcResult, resourcePoolChildren, ieResourcePool.getChildren(), false);
    }

    private void extractResourcePoolChildren(Map<String, ManagedObjectReference> inventory, Map<String, String> vmIdToKey, PcResult pcResult, ManagedObjectReference[] resourcePools, List<IeResourcePool> ieResourcePools, boolean extractVms) {
        Arrays.stream(resourcePools).forEach(resourcePool -> {
            String name = (String)pcResult.getProperty(resourcePool, "name");
            if ("ResourcePool".equals(resourcePool.getType())) {
                IeResourcePool ieResourcePool = this.getMatch(IeResourcePool.class, name, ieResourcePools);
                this.extractResourcePoolInfo(inventory, vmIdToKey, pcResult, ieResourcePool, (ManagedObjectReference)resourcePool, extractVms);
                if (extractVms) {
                    this.extractVmInfo(inventory, vmIdToKey, pcResult, ieResourcePool, (ManagedObjectReference)resourcePool);
                }
            } else if ("VirtualApp".equals(resourcePool.getType())) {
                IeVirtualApp ieVirtualApp = this.getMatch(IeVirtualApp.class, name, ieResourcePools);
                this.extractResourcePoolInfo(inventory, vmIdToKey, pcResult, ieVirtualApp, (ManagedObjectReference)resourcePool, true);
                this.extractVmInfo(inventory, vmIdToKey, pcResult, ieVirtualApp, (ManagedObjectReference)resourcePool);
            }
        });
    }

    private void extractResourcePoolInfo(Map<String, ManagedObjectReference> inventory, Map<String, String> vmIdToKey, PcResult pcResult, IeResourcePool ieResourcePool, ManagedObjectReference resourcePool, boolean extractVms) {
        if (Objects.isNull(ieResourcePool) || Objects.isNull(ieResourcePool.getId())) {
            return;
        }
        if (Objects.nonNull(inventory.putIfAbsent(ieResourcePool.getId(), resourcePool))) {
            LOGGER.debug("Resource pool with id: '{}' and moRef: '{}' is already put.", (Object)ieResourcePool.getId(), (Object)resourcePool);
        }
        ManagedObjectReference[] resourcePoolChildren = (ManagedObjectReference[])pcResult.getProperty(resourcePool, "resourcePool");
        this.extractResourcePoolChildren(inventory, vmIdToKey, pcResult, resourcePoolChildren, ieResourcePool.getChildren(), extractVms);
    }

    private <T> T getMatch(Class<T> type, String name, List<? extends IeInventory> ieEntities) {
        Objects.requireNonNull(type);
        if (Objects.isNull(name)) {
            LOGGER.debug("Match name is null for type '{}'.", (Object)type.getName());
            return null;
        }
        if (Objects.isNull(ieEntities)) {
            LOGGER.debug("Match entities are null for type '{}' and name '{}'.", (Object)type.getName(), (Object)name);
            return null;
        }
        T result = ieEntities.stream().filter(ieEntity -> name.equals(ieEntity.getName()) && Objects.nonNull(ieEntity.getId()) && type.isInstance(ieEntity)).findFirst().map(type::cast).orElse(null);
        if (Objects.isNull(result)) {
            LOGGER.warn("No match found for '{}', with type '{}'.", (Object)name, (Object)type.getName());
        }
        return result;
    }

    private IeInventoryTree getTree(Collection<IeInventoryTree> trees, boolean isLocal) {
        return trees.stream().filter(tree -> tree.isLocal() == isLocal).findFirst().orElse(null);
    }

    public static class InventoryLookup
    extends Lookup<String, ManagedObjectReference> {
        private final Map<String, String> _vmIdToKey;

        InventoryLookup(Map<String, ManagedObjectReference> inventory, Map<String, String> vmIdToKey) {
            super(inventory);
            this._vmIdToKey = vmIdToKey;
        }

        public VmKeysLookup getVmKeysLookup() {
            return new VmKeysLookup(this._vmIdToKey);
        }
    }

    public static class VmKeysLookup
    extends Lookup<String, String> {
        public VmKeysLookup(Map<String, String> vmIdToKey) {
            super(vmIdToKey);
        }
    }
}

