/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.tool;

import com.vmware.srm.client.topology.client.view.availability.PairSetup;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsPairSetup;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsServer;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsServersView;
import com.vmware.vim.binding.hms.ServiceInstanceContent;
import com.vmware.vr.client.impex.tool.ServersDataWrapper;
import org.apache.commons.lang.Validate;

public class HmsServersDataWrapper
implements ServersDataWrapper {
    private final HmsServersView _view;
    private final HmsPairSetup _localPair;
    private final HmsPairSetup _remotePair;
    private final ServiceInstanceContent _localContent;
    private final ServiceInstanceContent _remoteContent;

    public HmsServersDataWrapper(HmsServersView view, HmsPairSetup localPair, HmsPairSetup remotePair, ServiceInstanceContent localContent, ServiceInstanceContent remoteContent) {
        Validate.notNull(view, "View");
        Validate.notNull(localPair, "Local pair setup");
        Validate.notNull(remotePair, "Remote pair setup");
        Validate.notNull(localContent, "Local content");
        Validate.notNull(remoteContent, "Remote content");
        this._view = view;
        this._localPair = localPair;
        this._remotePair = remotePair;
        this._localContent = localContent;
        this._remoteContent = remoteContent;
    }

    public HmsServer getLocalServer() {
        return (HmsServer)this._localPair.server();
    }

    public HmsServer getRemoteServer() {
        return (HmsServer)this._remotePair.server();
    }

    public PairSetup<HmsServer> getLocalPair() {
        return this._localPair;
    }

    public PairSetup<HmsServer> getRemotePair() {
        return this._remotePair;
    }

    public HmsServersView getView() {
        return this._view;
    }

    public ServiceInstanceContent getLocalContent() {
        return this._localContent;
    }

    public ServiceInstanceContent getRemoteContent() {
        return this._remoteContent;
    }
}

