/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.tool.io.request;

import com.vmware.vr.client.impex.tool.io.IOHelper;
import com.vmware.vr.client.impex.tool.io.request.Request;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class HmsSelectionRequest
extends Request<String> {
    private final IOHelper _ioHelper;
    private final Map<String, String> _guidToName;
    private boolean _isLocal;

    public HmsSelectionRequest(IOHelper ioHelper, Map<String, String> guidToName, boolean isLocal) {
        super(false);
        this._ioHelper = ioHelper;
        this._guidToName = guidToName;
        this._isLocal = isLocal;
    }

    @Override
    public String handle() {
        return this.collect(this._ioHelper, this._guidToName);
    }

    protected String collect(IOHelper ioHelper, Map<String, String> guidToName) {
        int index;
        switch (guidToName.size()) {
            case 0: {
                ioHelper.writeln("No VR servers found.");
                return null;
            }
            case 1: {
                String selectedHmsGuid = guidToName.keySet().toArray(new String[1])[0];
                ioHelper.writeln("One VR server found: " + guidToName.get(selectedHmsGuid));
                return selectedHmsGuid;
            }
        }
        ArrayList<String> keys = new ArrayList<String>(guidToName.keySet());
        if (this._isLocal) {
            ioHelper.writeln("Available local VR servers:");
        } else {
            ioHelper.writeln("Available remote VR servers:");
        }
        for (int i = 0; i < keys.size(); ++i) {
            ioHelper.writeln(String.format("[%s] %s", i, guidToName.get(keys.get(i))));
        }
        while (true) {
            String input;
            if (!StringUtils.isNumeric(input = ioHelper.readln())) {
                ioHelper.writeln("Enter a number:");
                continue;
            }
            index = Integer.valueOf(input);
            if (index >= 0 && index < keys.size()) break;
            ioHelper.writeln(String.format("Enter a number in range [0:%s]:", keys.size() - 1));
        }
        return (String)keys.get(index);
    }
}

