/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.utils;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.srm.client.infrastructure.pc.utils.ObjectSpecBuilder;
import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.constants.dr.storage.REPLICATED_ARRAY_PAIR;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ArrayManagerUtil {
    public static Promise<Map<String, ManagedObjectReference>> getArrayPairKeyToMoRef(ServersView view, ManagedObjectReference storageManagerMoRef) {
        return ArrayManagerUtil.getArrayPairInventory(view, storageManagerMoRef).thenApply(pcResult -> {
            HashMap keyToMoRef = new HashMap();
            pcResult.getMoRefs().stream().filter(moRef -> "DrStorageReplicatedArrayPair".equals(moRef.getType())).forEach(moRef -> {
                String key = (String)pcResult.getProperty(moRef, REPLICATED_ARRAY_PAIR.INFO_.KEY);
                keyToMoRef.put(key, moRef);
                String peerKey = (String)pcResult.getProperty(moRef, REPLICATED_ARRAY_PAIR.PEER_.ARRAY_ID);
                ManagedObjectReference peer = (ManagedObjectReference)pcResult.getProperty(moRef, REPLICATED_ARRAY_PAIR.PEER_.ARRAY_PAIR);
                keyToMoRef.put(peerKey, peer);
            });
            return Collections.unmodifiableMap(keyToMoRef);
        });
    }

    private static Promise<PcResult> getArrayPairInventory(ServersView view, ManagedObjectReference storageManager) {
        PropertyCollector.PropertySpec arrayPairSpec = PCUtil.createPropertySpec((String)"DrStorageReplicatedArrayPair", (String[])new String[]{REPLICATED_ARRAY_PAIR.INFO_.KEY, REPLICATED_ARRAY_PAIR.PEER_.ARRAY_PAIR, REPLICATED_ARRAY_PAIR.PEER_.ARRAY_ID});
        ObjectSpecBuilder specBuilder = new ObjectSpecBuilder(storageManager);
        ObjectSpecBuilder.TraversalSpecBuilder rootTraversal = specBuilder.traverseTo("arrayManager");
        rootTraversal.traverseTo("DrStorageArrayManager", "arrayPair");
        PropertyCollector.FilterSpec filterSpec = new PropertyCollector.FilterSpec(new PropertyCollector.PropertySpec[]{arrayPairSpec}, new PropertyCollector.ObjectSpec[]{specBuilder.build()}, Boolean.valueOf(true));
        return PCUtil.retrieveProperties((ServersView)view, (PropertyCollector.FilterSpec[])new PropertyCollector.FilterSpec[]{filterSpec});
    }
}

