/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.utils;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.srm.client.infrastructure.pc.utils.ObjectSpecBuilder;
import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.srm.client.infrastructure.tuple.Tuple2;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.constants.dr.storage.STORAGE_ADAPTER;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public class StorageAdapterUtil {
    private StorageAdapterUtil() {
    }

    public static Promise<PcResult> getStorageAdapterInventory(ServersView view, ManagedObjectReference storageManager) {
        PropertyCollector.PropertySpec adapterSpec = PCUtil.createPropertySpec((String)"DrStorageStorageAdapter", (String[])new String[]{STORAGE_ADAPTER.INFO_.NAME_.TEXT});
        ObjectSpecBuilder specBuilder = new ObjectSpecBuilder(storageManager);
        specBuilder.traverseTo("adapter");
        PropertyCollector.FilterSpec filterSpec = new PropertyCollector.FilterSpec(new PropertyCollector.PropertySpec[]{adapterSpec}, new PropertyCollector.ObjectSpec[]{specBuilder.build()}, Boolean.valueOf(true));
        return PCUtil.retrieveProperties((ServersView)view, (PropertyCollector.FilterSpec[])new PropertyCollector.FilterSpec[]{filterSpec});
    }

    public static Promise<Map<String, ManagedObjectReference>> getSANameToMoRef(ServersView view, ManagedObjectReference storageManager) {
        Promise<PcResult> pcResultPromise = StorageAdapterUtil.getStorageAdapterInventory(view, storageManager);
        return pcResultPromise.thenApply(pcResult -> Collections.unmodifiableMap(pcResult.getMoRefs().stream().filter(moRef -> "DrStorageStorageAdapter".equals(moRef.getType())).map(moRef -> {
            String name = (String)pcResult.getProperty(moRef, STORAGE_ADAPTER.INFO_.NAME_.TEXT);
            return new Tuple2((Object)name, moRef);
        }).collect(Collectors.toMap(Tuple2::getFirst, Tuple2::getSecond))));
    }
}

