/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.tracing;

import com.vmware.tracing.TracingFilter;
import com.vmware.vim.sso.client.tracer.GlobalTracer;
import io.opentracing.Tracer;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServletTracerInitializer
implements ServletContextListener {
    private static final String TRACER = Tracer.class.getName();
    private static final Log _logger = LogFactory.getLog(ServletTracerInitializer.class);

    public ServletTracerInitializer() {
        _logger.info((Object)"Constructing ServletTracerInitializer");
    }

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext servletContext = sce.getServletContext();
        if (servletContext.getAttribute(TRACER) != null) {
            return;
        }
        _logger.info((Object)"Setting tracer");
        servletContext.setAttribute(TRACER, (Object)GlobalTracer.get());
        _logger.info((Object)"Setting filter");
        FilterRegistration.Dynamic filterReg = servletContext.addFilter("Tracer", (Filter)new TracingFilter());
        for (String servletName : servletContext.getServletRegistrations().keySet()) {
            if (StringUtils.containsIgnoreCase((String)servletName, (String)"vlsi") || StringUtils.containsIgnoreCase((String)servletName, (String)"vmomi")) continue;
            _logger.info((Object)("Registering " + servletName + " servlet"));
            filterReg.addMappingForServletNames(null, true, new String[]{servletName});
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

