/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.client.impl;

import com.vmware.vim.sso.client.SamlToken;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Util {
    private static final Logger _log = LoggerFactory.getLogger(Util.class);

    public static String randomNCNameUUID() {
        return "_" + UUID.randomUUID();
    }

    public static String createRedactedDescription(SamlToken token) {
        return String.format("%s [subject=%s, groups=%s, delegationChain=%s, startTime=%s, expirationTime=%s, renewable=%s, delegable=%s, isSolution=%s,confirmationType=%s]", token.getClass().getSimpleName(), Util.getTokenSubjectForLog(token), token.getGroupList(), token.getDelegationChain(), token.getStartTime(), token.getExpirationTime(), token.isRenewable(), token.isDelegable(), token.isSolution(), token.getConfirmationType());
    }

    static String getTokenSubjectForLog(SamlToken token) {
        String tokenSubject = null;
        if (token != null) {
            if (token.getSubject() != null) {
                tokenSubject = token.getSubject().toString();
            } else if (token.getSubjectNameId() != null) {
                tokenSubject = token.getSubjectNameId().toString();
            }
        }
        if (tokenSubject == null) {
            tokenSubject = "NULL";
        }
        return tokenSubject;
    }

    public static void setSecurityOptions(DocumentBuilderFactory factory) {
        try {
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (ParserConfigurationException ex) {
            _log.warn("Failed to apply factory setting", (Throwable)ex);
        }
    }

    private Util() {
    }
}

