/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authentication.websso;

import com.vmware.dr.ui.tools.reactive.impl.CachingStream;
import com.vmware.dr.ui.tools.reactive.impl.StreamImpl;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.srm.client.infrastructure.authentication.AuthenticationUtils;
import com.vmware.srm.client.infrastructure.authentication.websso.WebSsoAuthenticationStrategy;
import com.vmware.srm.client.infrastructure.http.BaseAsyncController;
import com.vmware.srm.client.infrastructure.init.InitFilter;
import com.vmware.srm.client.infrastructure.init.workflow.Configurator;
import com.vmware.srm.client.infrastructure.websso.LoginWorkflow;
import com.vmware.srm.client.infrastructure.websso.SsoContext;
import com.vmware.srm.client.topology.impl.init.Config;
import com.vmware.vim.sso.client.SamlToken;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebSsoLoginServlet
extends HttpServlet {
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (AuthenticationUtils.isAuthenticated(request)) {
            response.sendRedirect("/dr/");
            return;
        }
        Configurator configurator = InitFilter.getConfigurator(request);
        WebSsoLoginResponseController controller = new WebSsoLoginResponseController(request, response, configurator);
        controller.start(Config.get().getResponseTimeout());
    }

    private static class WebSsoLoginResponseController
    extends BaseAsyncController {
        private final Configurator _configurator;

        WebSsoLoginResponseController(HttpServletRequest request, HttpServletResponse response, Configurator configurator) {
            super(request, response);
            this._configurator = configurator;
        }

        @Override
        protected BaseAsyncController.HttpProcessStage createPipeline() {
            return () -> this._configurator.getWebSsoStrategy().thenApply(WebSsoAuthenticationStrategy.class::cast).thenApply(this::getLoginResponseStage).toStream();
        }

        private BaseAsyncController.HttpProcessStage getLoginResponseStage(WebSsoAuthenticationStrategy strategy) {
            return () -> {
                LoginImpl login;
                CachingStream result = new CachingStream();
                try {
                    login = new LoginImpl(strategy.getSsoContext(), (StreamImpl)result, strategy){
                        final /* synthetic */ StreamImpl val$result;
                        final /* synthetic */ WebSsoAuthenticationStrategy val$strategy;
                        {
                            this.val$result = streamImpl;
                            this.val$strategy = webSsoAuthenticationStrategy;
                            super(context);
                        }

                        @Override
                        protected void onSuccess(SamlToken token, String username, String sessionIndex, String redirectPath, SsoContext ssoContext, HttpServletRequest request, HttpServletResponse response) {
                            this.val$result.publishNext((Object)this.getSetupSessionStage(this.val$strategy, token, username, sessionIndex, redirectPath));
                            this.val$result.publishComplete();
                        }
                    };
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException("Failed to create 'LoginImpl' instance", e);
                }
                try {
                    login.complete(this._request, this._response);
                }
                finally {
                    result.publishComplete();
                }
                return result;
            };
        }

        private BaseAsyncController.HttpProcessStage getSetupSessionStage(WebSsoAuthenticationStrategy strategy, SamlToken token, String username, String sessionIndex, String redirectPath) {
            return () -> AuthenticationUtils.setupSession(strategy.getSsoContext(), strategy, username, token, sessionIndex, redirectPath, this._request, this._response).toStream().flatMap(unused -> Streams.empty());
        }
    }

    static class LoginImpl
    extends LoginWorkflow {
        LoginImpl(SsoContext context) throws NoSuchAlgorithmException {
            super(context, "/dr/");
        }

        @Override
        protected void onSuccess(SamlToken token, String username, String sessionIndex, String redirectPath, SsoContext ssoContext, HttpServletRequest request, HttpServletResponse response) {
        }
    }
}

