/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.websockets.requesthandlers.protocol.codec;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.vmware.srm.client.infrastructure.http.SerializationUtil;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrData;
import com.vmware.srm.client.infrastructure.websockets.requesthandlers.DrWsRequestHandler;
import com.vmware.srm.client.infrastructure.websockets.requesthandlers.lookup.DrWsHandlerLookup;
import com.vmware.srm.client.infrastructure.websockets.requesthandlers.protocol.data.DrWsRequest;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrWsRequestDeserializer
extends JsonDeserializer<DrWsRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DrWsRequestDeserializer.class);

    public DrWsRequest deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        long sequence = Long.parseLong(node.get("sequence").asText());
        String path = node.get("path").asText();
        if (StringUtils.isEmpty((String)path)) {
            throw context.weirdStringException(path, String.class, "Invalid 'path' value");
        }
        boolean isStop = node.get("stop").asBoolean();
        DrWsRequestHandler<?, ?> handler = DrWsHandlerLookup.get().lookup(path);
        if (handler == null) {
            LOGGER.error("No handler found for path '{}'", (Object)path);
            throw context.weirdStringException(path, String.class, "Request handler not found.");
        }
        Class<?> drDataClass = handler.getInputArgType();
        if (isStop || drDataClass == null) {
            DrWsRequest request = new DrWsRequest();
            request.setSequence(sequence);
            request.setPath(path);
            request.setStop(isStop);
            return request;
        }
        JsonNode drDataNode = node.get("drData");
        DrData data = (DrData)SerializationUtil.MAPPER.treeToValue((TreeNode)drDataNode, drDataClass);
        DrWsRequest request = new DrWsRequest();
        request.setSequence(sequence);
        request.setPath(path);
        request.setDrData(data);
        return request;
    }
}

