/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.websso;

import com.vmware.identity.websso.client.IDPConfiguration;
import com.vmware.identity.websso.client.LogoutProcessor;
import com.vmware.identity.websso.client.Message;
import com.vmware.identity.websso.client.MessageStore;
import com.vmware.identity.websso.client.MessageStoreImpl;
import com.vmware.identity.websso.client.SPConfiguration;
import com.vmware.identity.websso.client.SloRequestSettings;
import com.vmware.identity.websso.client.ValidationResult;
import com.vmware.identity.websso.client.endpoint.SloListener;
import com.vmware.identity.websso.client.endpoint.SloRequestSender;
import com.vmware.srm.client.infrastructure.utils.L10N;
import com.vmware.srm.client.infrastructure.websso.SsoContext;
import com.vmware.srm.client.infrastructure.websso.WebSsoWorkflow;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LogoutWorkflow
extends WebSsoWorkflow {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogoutWorkflow.class);
    private static final MessageStore MSG_STORE = new MessageStoreImpl();
    private final SsoContext _context;
    private final String _defaultOnSuccessPath;
    private final SPConfiguration _spConfig;
    private final IDPConfiguration _idpConfig;
    private final SloRequestSender _requestSender;
    private final SloListener _responseListener;

    protected LogoutWorkflow(SsoContext context, String defaultOnSuccessPath) {
        this._context = context;
        this._defaultOnSuccessPath = defaultOnSuccessPath;
        this._spConfig = this._context.getSpConfig();
        this._idpConfig = this._context.getIDPConfig();
        this._requestSender = new SloRequestSender();
        this._requestSender.setMetadataSettings(this._context.getMetadataSettings());
        this._requestSender.setMessageStore(MSG_STORE);
        this._requestSender.setLogoutProcessor((LogoutProcessor)new LogoutRequestProcessor());
        this._responseListener = new SloListener();
        this._responseListener.setMetadataSettings(this._context.getMetadataSettings());
        this._responseListener.setMessageStore(MSG_STORE);
        this._responseListener.setLogoutProcessor((LogoutProcessor)new LogoutResponseProcessor());
    }

    public void start(HttpServletRequest request, HttpServletResponse response, String username, String sessionIndex) throws IOException {
        if (sessionIndex == null) {
            throw new IllegalStateException("No session index found.");
        }
        if (username == null) {
            throw new IllegalStateException("No username found.");
        }
        SloRequestSettings sloSettings = new SloRequestSettings(this._spConfig.getAlias(), this._idpConfig.getAlias(), Boolean.valueOf(true), username, "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", sessionIndex, null);
        this._requestSender.sendRequest(sloSettings, response);
    }

    public void complete(HttpServletRequest request, HttpServletResponse response) {
        this._responseListener.slo(this._spConfig.getAlias(), request, response);
    }

    protected abstract void onSuccess(String var1);

    private class LogoutResponseProcessor
    implements LogoutProcessor {
        private LogoutResponseProcessor() {
        }

        public void internalError(Exception exc, HttpServletRequest request, HttpServletResponse response) {
            LOGGER.error("Failed to process SLO response: ", (Throwable)exc);
            WebSsoWorkflow.handleError(response, exc);
        }

        public void logoutError(Message msg, HttpServletRequest request, HttpServletResponse response) {
            ValidationResult validation = msg.getValidationResult();
            String errMsg = validation == null ? L10N.localize("websso.unknownError", new Object[0]) : (validation.getResponseCode() == 200 ? L10N.localize("websso.messageServerError", validation.getStatus(), validation.getSubstatus()) : L10N.localize("websso.messageDetail", validation.getResponseCode(), validation.getStatus(), validation.getSubstatus()));
            WebSsoWorkflow.handleError(response, 400, errMsg);
        }

        public void logoutRequest(Message msg, HttpServletRequest request, HttpServletResponse response, String tenant) {
            if (msg == null || StringUtils.isEmpty((String)msg.getSessionIndex())) {
                LOGGER.error("No message or sessionIndex for tenant: {}", (Object)tenant);
                return;
            }
            LogoutWorkflow.this.onSuccess(msg.getSessionIndex());
        }

        public void logoutSuccess(Message msg, HttpServletRequest request, HttpServletResponse response) {
            String sessionIndex = msg.getSessionIndex();
            try {
                LogoutWorkflow.this.onSuccess(sessionIndex);
                response.sendRedirect(LogoutWorkflow.this._defaultOnSuccessPath);
            }
            catch (Exception exc) {
                WebSsoWorkflow.handleError(response, exc);
            }
        }
    }

    private class LogoutRequestProcessor
    implements LogoutProcessor {
        private LogoutRequestProcessor() {
        }

        public void internalError(Exception exc, HttpServletRequest request, HttpServletResponse response) {
            LOGGER.error("Failed to send SLO request: ", (Throwable)exc);
            WebSsoWorkflow.handleError(response, exc);
        }

        public void logoutError(Message msg, HttpServletRequest request, HttpServletResponse response) {
        }

        public void logoutRequest(Message msg, HttpServletRequest request, HttpServletResponse response, String tenant) {
        }

        public void logoutSuccess(Message msg, HttpServletRequest request, HttpServletResponse response) {
        }
    }
}

