/*
 * *****************************************************
 * Copyright 2016 VMware, Inc.  All Rights Reserved.
 * *****************************************************
 */

package com.vmware.vsan.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.TaskInfoState;
import com.vmware.connection.helpers.WaitForValues;

public class VsanUtil {
   public static com.vmware.vsan.sdk.ManagedObjectReference
   ConvertToHealthMoRef(ManagedObjectReference moref) {
      if (moref == null) {
         return null;
      }
      com.vmware.vsan.sdk.ManagedObjectReference newmoref =
         new com.vmware.vsan.sdk.ManagedObjectReference();
      newmoref.setType(moref.getType());
      newmoref.setValue(moref.getValue());
      return newmoref;
   }

   public static ManagedObjectReference
   ConvertToVcMoRef(com.vmware.vsan.sdk.ManagedObjectReference moref) {
     if (moref == null) {
         return null;
      }
      ManagedObjectReference newmoref =
         new ManagedObjectReference();
      newmoref.setType(moref.getType());
      newmoref.setValue(moref.getValue());
      return newmoref;
   }

   /**
    * This method waits the task until it's done and returns a boolean value specifying
    * whether the task is succeeded or failed.
    *
    * @param waitForValue The helper instance for waiting on the given task
    * @param task ManagedObjectReference representing the Task.
    * @return boolean value representing the Task result.
    *
    */
   public static boolean
   WaitForTasks(WaitForValues waitForValues, ManagedObjectReference task) {
      boolean retVal = false;
      try {
         Object[] result =
            waitForValues.wait(task,
               new String[]{"info.state", "info.error"},
               new String[]{"state"},
               new Object[][]{new Object[]{
                  TaskInfoState.SUCCESS, TaskInfoState.ERROR}});

         if (result[0].equals(TaskInfoState.SUCCESS)) {
            retVal = true;
         } else {
            retVal = false;
         }
      } catch (Exception e) {
         System.out.println("Failed to wait for task : " + e.getMessage());
      }
      return retVal;
   }
}
