#
# Copyright 2006 VMware, Inc.  All rights reserved.
#

use 5.006001;
use strict;
use warnings;

use XML::LibXML;
use LWP::UserAgent;
use HTTP::Request;
use HTTP::Headers;
use HTTP::Response;
use HTTP::Cookies;
use Data::Dumper;



##################################################################################
package VsanComparator;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('VsanComparator');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanCompositeConstraint;
our @ISA = qw(VsanResourceConstraint);

our @property_list = (
   ['nestedConstraints', 'VsanResourceConstraint', 1, 0],
   ['conjoiner', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanCompositeConstraint', 'nestedConstraints', 'conjoiner');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanDataObfuscationRule;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('VsanDataObfuscationRule');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanJsonComparator;
our @ISA = qw(VsanComparator);

our @property_list = (
   ['comparator', undef, undef, 0],
   ['comparableValue', 'KeyAnyValue', undef, 0],
);


VIMRuntime::make_get_set('VsanJsonComparator', 'comparator', 'comparableValue');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanJsonComparator;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanJsonComparator', 'VsanJsonComparator', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanJsonComparator', 'VsanJsonComparator');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanJsonFilterRule;
our @ISA = qw(DynamicData);

our @property_list = (
   ['filterComparator', 'VsanComparator', undef, 0],
   ['comparablePath', undef, 1, 0],
   ['keysWithStrVal', undef, 1, 0],
   ['propertyName', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanJsonFilterRule', 'filterComparator', 'comparablePath', 'keysWithStrVal', 'propertyName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanMassCollectorPropertyParams;
our @ISA = qw(DynamicData);

our @property_list = (
   ['propertyName', undef, undef, 0],
   ['propertyParams', 'KeyAnyValue', 1, 0],
);


VIMRuntime::make_get_set('VsanMassCollectorPropertyParams', 'propertyName', 'propertyParams');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanMassCollectorPropertyParams;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanMassCollectorPropertyParams', 'VsanMassCollectorPropertyParams', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanMassCollectorPropertyParams', 'VsanMassCollectorPropertyParams');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanMassCollectorSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['objects', 'ManagedObjectReference', 1, 0],
   ['objectCollection', undef, undef, 0],
   ['properties', undef, 1, 1],
   ['propertiesParams', 'VsanMassCollectorPropertyParams', 1, 0],
   ['constraint', 'VsanResourceConstraint', undef, 0],
);


VIMRuntime::make_get_set('VsanMassCollectorSpec', 'objects', 'objectCollection', 'properties', 'propertiesParams', 'constraint');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanMassCollectorSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanMassCollectorSpec', 'VsanMassCollectorSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanMassCollectorSpec', 'VsanMassCollectorSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanNestJsonComparator;
our @ISA = qw(VsanComparator);

our @property_list = (
   ['nestedComparators', 'VsanJsonComparator', 1, 0],
   ['conjoiner', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanNestJsonComparator', 'nestedComparators', 'conjoiner');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanObjectTypeRule;
our @ISA = qw(DynamicData);

our @property_list = (
   ['objectType', undef, undef, 0],
   ['attributes', undef, 1, 0],
);


VIMRuntime::make_get_set('VsanObjectTypeRule', 'objectType', 'attributes');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanPropertyConstraint;
our @ISA = qw(VsanResourceConstraint);

our @property_list = (
   ['propertyName', undef, undef, 0],
   ['comparator', undef, undef, 0],
   ['comparableValue', 'KeyAnyValue', undef, 0],
);


VIMRuntime::make_get_set('VsanPropertyConstraint', 'propertyName', 'comparator', 'comparableValue');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanRegexBasedRule;
our @ISA = qw(DynamicData);

our @property_list = (
   ['rules', undef, 1, 0],
);


VIMRuntime::make_get_set('VsanRegexBasedRule', 'rules');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanResourceConstraint;
our @ISA = qw(DynamicData);

our @property_list = (
   ['targetType', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanResourceConstraint', 'targetType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanResourceConstraint;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanResourceConstraint', 'VsanResourceConstraint', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanResourceConstraint', 'VsanResourceConstraint');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterPowerContext;
our @ISA = qw(DynamicData);

our @property_list = (
   ['currentClusterPowerStatus', undef, undef, 1],
   ['orderedClusterPowerStatus', undef, 1, 0],
   ['trackingTask', 'ManagedObjectReference', undef, 0],
   ['lastErrorMessage', 'LocalizableMessage', undef, 0],
   ['lastErrorMOs', 'ManagedObjectReference', 1, 0],
);


VIMRuntime::make_get_set('ClusterPowerContext', 'currentClusterPowerStatus', 'orderedClusterPowerStatus', 'trackingTask', 'lastErrorMessage', 'lastErrorMOs');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PerformClusterPowerActionSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['targetPowerStatus', undef, undef, 1],
   ['isOrchestration', 'boolean', undef, 0],
   ['initialPowerStatus', undef, undef, 0],
   ['powerOffReason', undef, undef, 0],
   ['infraVMs', 'ManagedObjectReference', 1, 0],
   ['infraVMUuids', undef, 1, 0],
);


VIMRuntime::make_get_set('PerformClusterPowerActionSpec', 'targetPowerStatus', 'isOrchestration', 'initialPowerStatus', 'powerOffReason', 'infraVMs', 'infraVMUuids');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package QueryVsanManagedStorageSpaceUsageSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['datastoreTypes', undef, 1, 1],
);


VIMRuntime::make_get_set('QueryVsanManagedStorageSpaceUsageSpec', 'datastoreTypes');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanStorageComplianceResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['checkTime', undef, undef, 0],
   ['profile', undef, undef, 0],
   ['objectUUID', undef, undef, 0],
   ['complianceStatus', undef, undef, 1],
   ['mismatch', 'boolean', undef, 1],
   ['violatedPolicies', 'VsanStoragePolicyStatus', 1, 0],
   ['operationalStatus', 'VsanStorageOperationalStatus', undef, 0],
   ['objPolicyGenerationId', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanStorageComplianceResult', 'checkTime', 'profile', 'objectUUID', 'complianceStatus', 'mismatch', 'violatedPolicies', 'operationalStatus', 'objPolicyGenerationId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanStorageComplianceResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanStorageComplianceResult', 'VsanStorageComplianceResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanStorageComplianceResult', 'VsanStorageComplianceResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanStorageOperationalStatus;
our @ISA = qw(DynamicData);

our @property_list = (
   ['healthy', 'boolean', undef, 0],
   ['operationETA', undef, undef, 0],
   ['operationProgress', undef, undef, 0],
   ['transitional', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanStorageOperationalStatus', 'healthy', 'operationETA', 'operationProgress', 'transitional');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanStoragePolicyStatus;
our @ISA = qw(DynamicData);

our @property_list = (
   ['id', undef, undef, 0],
   ['expectedValue', undef, undef, 0],
   ['currentValue', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanStoragePolicyStatus', 'id', 'expectedValue', 'currentValue');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanStoragePolicyStatus;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanStoragePolicyStatus', 'VsanStoragePolicyStatus', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanStoragePolicyStatus', 'VsanStoragePolicyStatus');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VimClusterVSANPreferredFaultDomainInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['preferredFaultDomainName', undef, undef, 0],
   ['preferredFaultDomainId', undef, undef, 0],
);


VIMRuntime::make_get_set('VimClusterVSANPreferredFaultDomainInfo', 'preferredFaultDomainName', 'preferredFaultDomainId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VimClusterVSANStretchedClusterCapability;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hostMoId', undef, undef, 1],
   ['connStatus', undef, undef, 0],
   ['isSupported', 'boolean', undef, 0],
   ['hostCapability', 'VimHostVSANStretchedClusterHostCapability', undef, 0],
);


VIMRuntime::make_get_set('VimClusterVSANStretchedClusterCapability', 'hostMoId', 'connStatus', 'isSupported', 'hostCapability');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVimClusterVSANStretchedClusterCapability;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VimClusterVSANStretchedClusterCapability', 'VimClusterVSANStretchedClusterCapability', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVimClusterVSANStretchedClusterCapability', 'VimClusterVSANStretchedClusterCapability');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VimClusterVSANStretchedClusterFaultDomainConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['firstFdName', undef, undef, 1],
   ['firstFdHosts', 'ManagedObjectReference', 1, 1],
   ['secondFdName', undef, undef, 1],
   ['secondFdHosts', 'ManagedObjectReference', 1, 1],
);


VIMRuntime::make_get_set('VimClusterVSANStretchedClusterFaultDomainConfig', 'firstFdName', 'firstFdHosts', 'secondFdName', 'secondFdHosts');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VSANStretchedClusterHostVirtualApplianceStatus;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vcCluster', 'ManagedObjectReference', undef, 0],
   ['isVirtualApp', 'boolean', undef, 0],
   ['vcClusters', 'ManagedObjectReference', 1, 0],
   ['isVirtualAppValid', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VSANStretchedClusterHostVirtualApplianceStatus', 'vcCluster', 'isVirtualApp', 'vcClusters', 'isVirtualAppValid');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VimClusterVSANWitnessHostInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['nodeUuid', undef, undef, 1],
   ['faultDomainName', undef, undef, 0],
   ['preferredFdName', undef, undef, 0],
   ['preferredFdUuid', undef, undef, 0],
   ['unicastAgentAddr', undef, undef, 0],
   ['host', 'ManagedObjectReference', undef, 0],
   ['metadataMode', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VimClusterVSANWitnessHostInfo', 'nodeUuid', 'faultDomainName', 'preferredFdName', 'preferredFdUuid', 'unicastAgentAddr', 'host', 'metadataMode');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVimClusterVSANWitnessHostInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VimClusterVSANWitnessHostInfo', 'VimClusterVSANWitnessHostInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVimClusterVSANWitnessHostInfo', 'VimClusterVSANWitnessHostInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanAttachToSrOperation;
our @ISA = qw(DynamicData);

our @property_list = (
   ['task', 'ManagedObjectReference', undef, 0],
   ['success', 'boolean', undef, 0],
   ['timestamp', undef, undef, 0],
   ['srNumber', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanAttachToSrOperation', 'task', 'success', 'timestamp', 'srNumber');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanAttachToSrOperation;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanAttachToSrOperation', 'VsanAttachToSrOperation', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanAttachToSrOperation', 'VsanAttachToSrOperation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanCapability;
our @ISA = qw(DynamicData);

our @property_list = (
   ['target', 'ManagedObjectReference', undef, 0],
   ['capabilities', undef, 1, 0],
   ['statuses', undef, 1, 0],
);


VIMRuntime::make_get_set('VsanCapability', 'target', 'capabilities', 'statuses');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanCapability;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanCapability', 'VsanCapability', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanCapability', 'VsanCapability');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterAdvCfgSyncHostResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hostname', undef, undef, 1],
   ['value', undef, undef, 1],
   ['isDefault', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanClusterAdvCfgSyncHostResult', 'hostname', 'value', 'isDefault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanClusterAdvCfgSyncHostResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanClusterAdvCfgSyncHostResult', 'VsanClusterAdvCfgSyncHostResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanClusterAdvCfgSyncHostResult', 'VsanClusterAdvCfgSyncHostResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterAdvCfgSyncResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['inSync', 'boolean', undef, 1],
   ['name', undef, undef, 1],
   ['hostValues', 'VsanClusterAdvCfgSyncHostResult', 1, 0],
);


VIMRuntime::make_get_set('VsanClusterAdvCfgSyncResult', 'inSync', 'name', 'hostValues');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanClusterAdvCfgSyncResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanClusterAdvCfgSyncResult', 'VsanClusterAdvCfgSyncResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanClusterAdvCfgSyncResult', 'VsanClusterAdvCfgSyncResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterBalancePerDiskInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['uuid', undef, undef, 0],
   ['fullness', undef, undef, 1],
   ['variance', undef, undef, 1],
   ['fullnessAboveThreshold', undef, undef, 1],
   ['dataToMoveB', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanClusterBalancePerDiskInfo', 'uuid', 'fullness', 'variance', 'fullnessAboveThreshold', 'dataToMoveB');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanClusterBalancePerDiskInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanClusterBalancePerDiskInfo', 'VsanClusterBalancePerDiskInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanClusterBalancePerDiskInfo', 'VsanClusterBalancePerDiskInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterBalanceSummary;
our @ISA = qw(DynamicData);

our @property_list = (
   ['varianceThreshold', undef, undef, 1],
   ['disks', 'VsanClusterBalancePerDiskInfo', 1, 0],
);


VIMRuntime::make_get_set('VsanClusterBalanceSummary', 'varianceThreshold', 'disks');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterClomdLivenessResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['clomdLivenessResult', 'VsanHostClomdLivenessResult', 1, 0],
   ['issueFound', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('VsanClusterClomdLivenessResult', 'clomdLivenessResult', 'issueFound');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['config', 'VsanClusterConfigInfo', undef, 1],
   ['name', undef, undef, 1],
   ['hosts', undef, 1, 0],
   ['toBeDeleted', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanClusterConfig', 'config', 'name', 'hosts', 'toBeDeleted');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterCreateVmHealthTestResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['clusterResult', 'VsanClusterProactiveTestResult', undef, 1],
   ['hostResults', 'VsanHostCreateVmHealthTestResult', 1, 0],
);


VIMRuntime::make_get_set('VsanClusterCreateVmHealthTestResult', 'clusterResult', 'hostResults');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanClusterCreateVmHealthTestResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanClusterCreateVmHealthTestResult', 'VsanClusterCreateVmHealthTestResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanClusterCreateVmHealthTestResult', 'VsanClusterCreateVmHealthTestResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterDitEncryptionHealthSummary;
our @ISA = qw(DynamicData);

our @property_list = (
   ['overallHealth', undef, undef, 1],
   ['enabled', 'boolean', undef, 0],
   ['hostResults', 'VsanDitEncryptionHealthSummary', 1, 0],
);


VIMRuntime::make_get_set('VsanClusterDitEncryptionHealthSummary', 'overallHealth', 'enabled', 'hostResults');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterEncryptionHealthSummary;
our @ISA = qw(DynamicData);

our @property_list = (
   ['overallHealth', undef, undef, 0],
   ['configHealth', undef, undef, 0],
   ['kmsHealth', undef, undef, 0],
   ['vcKmsResult', 'VsanVcKmipServersHealth', undef, 0],
   ['hostResults', 'VsanEncryptionHealthSummary', 1, 0],
   ['aesniHealth', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanClusterEncryptionHealthSummary', 'overallHealth', 'configHealth', 'kmsHealth', 'vcKmsResult', 'hostResults', 'aesniHealth');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterFileServiceHealthSummary;
our @ISA = qw(DynamicData);

our @property_list = (
   ['overallHealth', undef, undef, 0],
   ['hostResults', 'VsanFileServiceHealthSummary', 1, 0],
);


VIMRuntime::make_get_set('VsanClusterFileServiceHealthSummary', 'overallHealth', 'hostResults');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterHclInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hclDbLastUpdate', undef, undef, 0],
   ['hclDbAgeHealth', undef, undef, 0],
   ['hostResults', 'VsanHostHclInfo', 1, 0],
   ['updateItems', 'VsanUpdateItem', 1, 0],
   ['hclDbAbsent', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanClusterHclInfo', 'hclDbLastUpdate', 'hclDbAgeHealth', 'hostResults', 'updateItems', 'hclDbAbsent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterHealthAction;
our @ISA = qw(DynamicData);

our @property_list = (
   ['actionId', undef, undef, 1],
   ['actionLabel', 'LocalizableMessage', undef, 1],
   ['actionDescription', 'LocalizableMessage', undef, 1],
   ['enabled', 'boolean', undef, 1],
   ['parameters', 'KeyValue', 1, 0],
);


VIMRuntime::make_get_set('VsanClusterHealthAction', 'actionId', 'actionLabel', 'actionDescription', 'enabled', 'parameters');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanClusterHealthAction;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanClusterHealthAction', 'VsanClusterHealthAction', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanClusterHealthAction', 'VsanClusterHealthAction');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterHealthCheckInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['testId', undef, undef, 1],
   ['testName', undef, undef, 0],
   ['groupId', undef, undef, 1],
   ['groupName', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanClusterHealthCheckInfo', 'testId', 'testName', 'groupId', 'groupName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanClusterHealthCheckInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanClusterHealthCheckInfo', 'VsanClusterHealthCheckInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanClusterHealthCheckInfo', 'VsanClusterHealthCheckInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterHealthConfigs;
our @ISA = qw(DynamicData);

our @property_list = (
   ['enableVsanTelemetry', 'boolean', undef, 0],
   ['vsanTelemetryInterval', undef, undef, 0],
   ['vsanTelemetryProxy', 'VsanClusterTelemetryProxyConfig', undef, 0],
   ['configs', 'VsanClusterHealthResultKeyValuePair', 1, 0],
);


VIMRuntime::make_get_set('VsanClusterHealthConfigs', 'enableVsanTelemetry', 'vsanTelemetryInterval', 'vsanTelemetryProxy', 'configs');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterHealthLink;
our @ISA = qw(VsanClusterHealthLinkBase);

our @property_list = (
   ['url', undef, undef, 1],
   ['category', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanClusterHealthLink', 'url', 'category');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanClusterHealthLink;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanClusterHealthLink', 'VsanClusterHealthLink', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanClusterHealthLink', 'VsanClusterHealthLink');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterHealthGroup;
our @ISA = qw(DynamicData);

our @property_list = (
   ['groupId', undef, undef, 1],
   ['groupName', undef, undef, 1],
   ['groupHealth', undef, undef, 1],
   ['groupTests', 'VsanClusterHealthTest', 1, 0],
   ['groupDetails', 'VsanClusterHealthResultBase', 1, 0],
   ['inProgress', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanClusterHealthGroup', 'groupId', 'groupName', 'groupHealth', 'groupTests', 'groupDetails', 'inProgress');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanClusterHealthGroup;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanClusterHealthGroup', 'VsanClusterHealthGroup', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanClusterHealthGroup', 'VsanClusterHealthGroup');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterHealthLinkBase;
our @ISA = qw(DynamicData);

our @property_list = (
   ['label', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanClusterHealthLinkBase', 'label');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterHealthQuerySpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['task', 'ManagedObjectReference', undef, 0],
   ['diskNames', undef, 1, 0],
   ['includeHealthRemediation', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanClusterHealthQuerySpec', 'task', 'diskNames', 'includeHealthRemediation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterHealthResultBase;
our @ISA = qw(DynamicData);

our @property_list = (
   ['label', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanClusterHealthResultBase', 'label');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanClusterHealthResultBase;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanClusterHealthResultBase', 'VsanClusterHealthResultBase', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanClusterHealthResultBase', 'VsanClusterHealthResultBase');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterHealthResultColumnInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['label', undef, undef, 1],
   ['type', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanClusterHealthResultColumnInfo', 'label', 'type');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanClusterHealthResultColumnInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanClusterHealthResultColumnInfo', 'VsanClusterHealthResultColumnInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanClusterHealthResultColumnInfo', 'VsanClusterHealthResultColumnInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterHealthResultKeyValuePair;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 0],
   ['value', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanClusterHealthResultKeyValuePair', 'key', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanClusterHealthResultKeyValuePair;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanClusterHealthResultKeyValuePair', 'VsanClusterHealthResultKeyValuePair', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanClusterHealthResultKeyValuePair', 'VsanClusterHealthResultKeyValuePair');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterHealthResultRow;
our @ISA = qw(DynamicData);

our @property_list = (
   ['values', undef, 1, 1],
   ['nestedRows', 'VsanClusterHealthResultRow', 1, 0],
);


VIMRuntime::make_get_set('VsanClusterHealthResultRow', 'values', 'nestedRows');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanClusterHealthResultRow;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanClusterHealthResultRow', 'VsanClusterHealthResultRow', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanClusterHealthResultRow', 'VsanClusterHealthResultRow');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterHealthResultTable;
our @ISA = qw(VsanClusterHealthResultBase);

our @property_list = (
   ['columns', 'VsanClusterHealthResultColumnInfo', 1, 0],
   ['rows', 'VsanClusterHealthResultRow', 1, 0],
);


VIMRuntime::make_get_set('VsanClusterHealthResultTable', 'columns', 'rows');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanClusterHealthResultTable;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanClusterHealthResultTable', 'VsanClusterHealthResultTable', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanClusterHealthResultTable', 'VsanClusterHealthResultTable');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterHealthResultWithRemediation;
our @ISA = qw(VsanClusterHealthResultBase);

our @property_list = (
   ['issueDescription', undef, undef, 0],
   ['issueDetail', 'VsanClusterHealthResultTable', 1, 0],
   ['troubleshooting', 'VsanHealthTroubleshooting', undef, 0],
   ['additionalResources', 'VsanClusterHealthLink', 1, 0],
);


VIMRuntime::make_get_set('VsanClusterHealthResultWithRemediation', 'issueDescription', 'issueDetail', 'troubleshooting', 'additionalResources');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterHealthSummary;
our @ISA = qw(DynamicData);

our @property_list = (
   ['clusterStatus', 'VsanClusterHealthSystemStatusResult', undef, 0],
   ['timestamp', undef, undef, 0],
   ['clusterVersions', 'VsanClusterHealthSystemVersionResult', undef, 0],
   ['objectHealth', 'VsanObjectOverallHealth', undef, 0],
   ['vmHealth', 'VsanClusterVMsHealthOverallResult', undef, 0],
   ['networkHealth', 'VsanClusterNetworkHealthResult', undef, 0],
   ['limitHealth', 'VsanClusterLimitHealthResult', undef, 0],
   ['advCfgSync', 'VsanClusterAdvCfgSyncResult', 1, 0],
   ['createVmHealth', 'VsanHostCreateVmHealthTestResult', 1, 0],
   ['physicalDisksHealth', 'VsanPhysicalDiskHealthSummary', 1, 0],
   ['encryptionHealth', 'VsanClusterEncryptionHealthSummary', undef, 0],
   ['hclInfo', 'VsanClusterHclInfo', undef, 0],
   ['groups', 'VsanClusterHealthGroup', 1, 0],
   ['overallHealth', undef, undef, 1],
   ['overallHealthDescription', undef, undef, 1],
   ['clomdLiveness', 'VsanClusterClomdLivenessResult', undef, 0],
   ['diskBalance', 'VsanClusterBalanceSummary', undef, 0],
   ['genericCluster', 'VsanGenericClusterBestPracticeHealth', undef, 0],
   ['networkConfig', 'VsanNetworkConfigBestPracticeHealth', undef, 0],
   ['vsanConfig', 'VsanConfigCheckResult', undef, 0],
   ['burnInTest', 'VsanBurnInTestCheckResult', undef, 0],
   ['perfsvcHealth', 'VsanPerfsvcHealthResult', undef, 0],
   ['cluster', 'ManagedObjectReference', undef, 0],
   ['fileServiceHealth', 'VsanClusterFileServiceHealthSummary', undef, 0],
   ['ditEncryptionHealth', 'VsanClusterDitEncryptionHealthSummary', undef, 0],
   ['healthScore', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanClusterHealthSummary', 'clusterStatus', 'timestamp', 'clusterVersions', 'objectHealth', 'vmHealth', 'networkHealth', 'limitHealth', 'advCfgSync', 'createVmHealth', 'physicalDisksHealth', 'encryptionHealth', 'hclInfo', 'groups', 'overallHealth', 'overallHealthDescription', 'clomdLiveness', 'diskBalance', 'genericCluster', 'networkConfig', 'vsanConfig', 'burnInTest', 'perfsvcHealth', 'cluster', 'fileServiceHealth', 'ditEncryptionHealth', 'healthScore');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanClusterHealthSummary;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanClusterHealthSummary', 'VsanClusterHealthSummary', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanClusterHealthSummary', 'VsanClusterHealthSummary');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterHealthSystemObjectsRepairResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['inRepairingQueueObjects', undef, 1, 0],
   ['failedRepairObjects', 'VsanFailedRepairObjectResult', 1, 0],
   ['issueFound', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('VsanClusterHealthSystemObjectsRepairResult', 'inRepairingQueueObjects', 'failedRepairObjects', 'issueFound');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterHealthSystemStatusResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['status', undef, undef, 1],
   ['goalState', undef, undef, 1],
   ['untrackedHosts', undef, 1, 0],
   ['trackedHostsStatus', 'VsanHostHealthSystemStatusResult', 1, 0],
);


VIMRuntime::make_get_set('VsanClusterHealthSystemStatusResult', 'status', 'goalState', 'untrackedHosts', 'trackedHostsStatus');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterHealthSystemVersionResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hostResults', 'VsanHostHealthSystemVersionResult', 1, 0],
   ['vcVersion', undef, undef, 0],
   ['issueFound', 'boolean', undef, 1],
   ['upgradePossible', 'boolean', undef, 0],
   ['vcBuild', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanClusterHealthSystemVersionResult', 'hostResults', 'vcVersion', 'issueFound', 'upgradePossible', 'vcBuild');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterHealthTest;
our @ISA = qw(DynamicData);

our @property_list = (
   ['testId', undef, undef, 0],
   ['testName', undef, undef, 0],
   ['testDescription', undef, undef, 0],
   ['testShortDescription', undef, undef, 0],
   ['testHealthyEntities', undef, undef, 0],
   ['testAllEntities', undef, undef, 0],
   ['testHealth', undef, undef, 0],
   ['testDetails', 'VsanClusterHealthResultBase', 1, 0],
   ['testActions', 'VsanClusterHealthAction', 1, 0],
   ['historicalResults', 'VsanHistoricalHealthTest', 1, 0],
   ['testCorrelation', 'VsanHealthCorrelation', undef, 0],
   ['reducedScore', undef, undef, 0],
   ['category', undef, undef, 0],
   ['riskIfNotFix', undef, undef, 0],
   ['lastStatusChangeTime', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanClusterHealthTest', 'testId', 'testName', 'testDescription', 'testShortDescription', 'testHealthyEntities', 'testAllEntities', 'testHealth', 'testDetails', 'testActions', 'historicalResults', 'testCorrelation', 'reducedScore', 'category', 'riskIfNotFix', 'lastStatusChangeTime');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanClusterHealthTest;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanClusterHealthTest', 'VsanClusterHealthTest', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanClusterHealthTest', 'VsanClusterHealthTest');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterHostVmknicMapping;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', undef, undef, 1],
   ['vmknic', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanClusterHostVmknicMapping', 'host', 'vmknic');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanClusterHostVmknicMapping;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanClusterHostVmknicMapping', 'VsanClusterHostVmknicMapping', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanClusterHostVmknicMapping', 'VsanClusterHostVmknicMapping');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterLimitHealthResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['issueFound', 'boolean', undef, 1],
   ['componentLimitHealth', undef, undef, 1],
   ['diskFreeSpaceHealth', undef, undef, 1],
   ['rcFreeReservationHealth', undef, undef, 1],
   ['hostResults', 'VsanLimitHealthResult', 1, 0],
   ['whatifHostFailures', 'VsanClusterWhatifHostFailuresResult', 1, 0],
   ['hostsCommFailure', undef, 1, 0],
);


VIMRuntime::make_get_set('VsanClusterLimitHealthResult', 'issueFound', 'componentLimitHealth', 'diskFreeSpaceHealth', 'rcFreeReservationHealth', 'hostResults', 'whatifHostFailures', 'hostsCommFailure');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterNetworkHealthResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hostResults', 'VsanNetworkHealthResult', 1, 0],
   ['issueFound', 'boolean', undef, 0],
   ['vsanVmknicPresent', 'boolean', undef, 0],
   ['matchingMulticastConfig', 'boolean', undef, 0],
   ['matchingIpSubnets', 'boolean', undef, 0],
   ['pingTestSuccess', 'boolean', undef, 0],
   ['largePingTestSuccess', 'boolean', undef, 0],
   ['hostLatencyCheckSuccess', 'boolean', undef, 0],
   ['potentialMulticastIssue', 'boolean', undef, 0],
   ['otherHostsInVsanCluster', undef, 1, 0],
   ['partitions', 'VsanClusterNetworkPartitionInfo', 1, 0],
   ['hostsWithVsanDisabled', undef, 1, 0],
   ['hostsDisconnected', undef, 1, 0],
   ['hostsCommFailure', undef, 1, 0],
   ['hostsInEsxMaintenanceMode', undef, 1, 0],
   ['hostsInVsanMaintenanceMode', undef, 1, 0],
   ['infoAboutUnexpectedHosts', 'VsanQueryResultHostInfo', 1, 0],
   ['clusterInUnicastMode', 'boolean', undef, 0],
   ['clusterInRDMAMode', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanClusterNetworkHealthResult', 'hostResults', 'issueFound', 'vsanVmknicPresent', 'matchingMulticastConfig', 'matchingIpSubnets', 'pingTestSuccess', 'largePingTestSuccess', 'hostLatencyCheckSuccess', 'potentialMulticastIssue', 'otherHostsInVsanCluster', 'partitions', 'hostsWithVsanDisabled', 'hostsDisconnected', 'hostsCommFailure', 'hostsInEsxMaintenanceMode', 'hostsInVsanMaintenanceMode', 'infoAboutUnexpectedHosts', 'clusterInUnicastMode', 'clusterInRDMAMode');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterNetworkLoadTestResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['clusterResult', 'VsanClusterProactiveTestResult', undef, 1],
   ['hostResults', 'VsanNetworkLoadTestResult', 1, 0],
);


VIMRuntime::make_get_set('VsanClusterNetworkLoadTestResult', 'clusterResult', 'hostResults');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanClusterNetworkLoadTestResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanClusterNetworkLoadTestResult', 'VsanClusterNetworkLoadTestResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanClusterNetworkLoadTestResult', 'VsanClusterNetworkLoadTestResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterNetworkPartitionInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hosts', undef, 1, 0],
   ['partitionUnknown', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanClusterNetworkPartitionInfo', 'hosts', 'partitionUnknown');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanClusterNetworkPartitionInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanClusterNetworkPartitionInfo', 'VsanClusterNetworkPartitionInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanClusterNetworkPartitionInfo', 'VsanClusterNetworkPartitionInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterNetworkPerfTaskSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['Cluster', 'ManagedObjectReference', undef, 0],
   ['DurationSec', undef, undef, 0],
   ['ownerVc', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanClusterNetworkPerfTaskSpec', 'Cluster', 'DurationSec', 'ownerVc');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterProactiveTestResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['overallStatus', undef, undef, 1],
   ['overallStatusDescription', undef, undef, 1],
   ['timestamp', undef, undef, 1],
   ['healthTest', 'VsanClusterHealthTest', undef, 0],
);


VIMRuntime::make_get_set('VsanClusterProactiveTestResult', 'overallStatus', 'overallStatusDescription', 'timestamp', 'healthTest');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterTelemetryProxyConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', undef, undef, 0],
   ['port', undef, undef, 0],
   ['user', undef, undef, 0],
   ['password', undef, undef, 0],
   ['autoDiscovered', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanClusterTelemetryProxyConfig', 'host', 'port', 'user', 'password', 'autoDiscovered');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterVMsHealthOverallResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['healthStateList', 'VsanClusterVMsHealthSummaryResult', 1, 0],
   ['overallHealthState', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanClusterVMsHealthOverallResult', 'healthStateList', 'overallHealthState');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterVMsHealthSummaryResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['numVMs', undef, undef, 1],
   ['state', undef, undef, 0],
   ['health', undef, undef, 1],
   ['vmInstanceUuids', undef, 1, 0],
);


VIMRuntime::make_get_set('VsanClusterVMsHealthSummaryResult', 'numVMs', 'state', 'health', 'vmInstanceUuids');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanClusterVMsHealthSummaryResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanClusterVMsHealthSummaryResult', 'VsanClusterVMsHealthSummaryResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanClusterVMsHealthSummaryResult', 'VsanClusterVMsHealthSummaryResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterVmdkLoadTestResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['task', 'ManagedObjectReference', undef, 0],
   ['clusterResult', 'VsanClusterProactiveTestResult', undef, 0],
   ['hostResults', 'VsanHostVmdkLoadTestResult', 1, 0],
);


VIMRuntime::make_get_set('VsanClusterVmdkLoadTestResult', 'task', 'clusterResult', 'hostResults');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanClusterVmdkLoadTestResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanClusterVmdkLoadTestResult', 'VsanClusterVmdkLoadTestResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanClusterVmdkLoadTestResult', 'VsanClusterVmdkLoadTestResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterWhatifHostFailuresResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['numFailures', undef, undef, 1],
   ['totalUsedCapacityB', undef, undef, 1],
   ['totalCapacityB', undef, undef, 1],
   ['totalRcReservationB', undef, undef, 1],
   ['totalRcSizeB', undef, undef, 1],
   ['usedComponents', undef, undef, 1],
   ['totalComponents', undef, undef, 1],
   ['componentLimitHealth', undef, undef, 0],
   ['diskFreeSpaceHealth', undef, undef, 0],
   ['rcFreeReservationHealth', undef, undef, 0],
   ['slackSpaceCapRequired', undef, undef, 0],
   ['diskSpaceThreshold', 'VsanHealthThreshold', undef, 0],
   ['capacityReservationInfo', 'VsanCapacityReservationInfo', undef, 0],
);


VIMRuntime::make_get_set('VsanClusterWhatifHostFailuresResult', 'numFailures', 'totalUsedCapacityB', 'totalCapacityB', 'totalRcReservationB', 'totalRcSizeB', 'usedComponents', 'totalComponents', 'componentLimitHealth', 'diskFreeSpaceHealth', 'rcFreeReservationHealth', 'slackSpaceCapRequired', 'diskSpaceThreshold', 'capacityReservationInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanClusterWhatifHostFailuresResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanClusterWhatifHostFailuresResult', 'VsanClusterWhatifHostFailuresResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanClusterWhatifHostFailuresResult', 'VsanClusterWhatifHostFailuresResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanConfigGeneration;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vcUuid', undef, undef, 1],
   ['genNum', undef, undef, 1],
   ['genTime', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanConfigGeneration', 'vcUuid', 'genNum', 'genTime');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanDiagnosticsThreshold;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entityType', undef, undef, 1],
   ['metric', undef, undef, 1],
   ['yellow', undef, undef, 0],
   ['red', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanDiagnosticsThreshold', 'entityType', 'metric', 'yellow', 'red');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanDiagnosticsThreshold;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanDiagnosticsThreshold', 'VsanDiagnosticsThreshold', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanDiagnosticsThreshold', 'VsanDiagnosticsThreshold');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanDiskFormatConversionCheckResult;
our @ISA = qw(VsanUpgradeSystemPreflightCheckResult);

our @property_list = (
   ['isSupported', 'boolean', undef, 1],
   ['targetVersion', undef, undef, 0],
   ['isDataMovementRequired', 'boolean', undef, 0],
   ['storagePoolDisk', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanDiskFormatConversionCheckResult', 'isSupported', 'targetVersion', 'isDataMovementRequired', 'storagePoolDisk');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanDiskFormatConversionSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['dataEfficiencyConfig', 'VsanDataEfficiencyConfig', undef, 0],
   ['dataEncryptionConfig', 'VsanDataEncryptionConfig', undef, 0],
   ['skipHostRemediation', 'boolean', undef, 0],
   ['allowDataMovement', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanDiskFormatConversionSpec', 'dataEfficiencyConfig', 'dataEncryptionConfig', 'skipHostRemediation', 'allowDataMovement');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VimClusterVsanDiskMappingsConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hostDiskMappings', 'VimClusterVsanHostDiskMapping', 1, 1],
);


VIMRuntime::make_get_set('VimClusterVsanDiskMappingsConfigSpec', 'hostDiskMappings');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanEntitySpaceUsage;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entityId', undef, undef, 0],
   ['spaceUsageByObjectType', 'VsanObjectSpaceSummary', 1, 0],
   ['totalCapacityB', undef, undef, 0],
   ['freeCapacityB', undef, undef, 0],
   ['efficientCapacity', 'VimVsanDataEfficiencyCapacityState', undef, 0],
);


VIMRuntime::make_get_set('VsanEntitySpaceUsage', 'entityId', 'spaceUsageByObjectType', 'totalCapacityB', 'freeCapacityB', 'efficientCapacity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanEntitySpaceUsage;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanEntitySpaceUsage', 'VsanEntitySpaceUsage', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanEntitySpaceUsage', 'VsanEntitySpaceUsage');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VimClusterVsanFaultDomainSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hosts', 'ManagedObjectReference', 1, 1],
   ['name', undef, undef, 1],
);


VIMRuntime::make_get_set('VimClusterVsanFaultDomainSpec', 'hosts', 'name');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVimClusterVsanFaultDomainSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VimClusterVsanFaultDomainSpec', 'VimClusterVsanFaultDomainSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVimClusterVsanFaultDomainSpec', 'VimClusterVsanFaultDomainSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VimClusterVsanFaultDomainsConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['faultDomains', 'VimClusterVsanFaultDomainSpec', 1, 1],
   ['witness', 'VimClusterVsanWitnessSpec', undef, 0],
);


VIMRuntime::make_get_set('VimClusterVsanFaultDomainsConfigSpec', 'faultDomains', 'witness');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHealthActionBase;
our @ISA = qw(DynamicData);

our @property_list = (
   ['description', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanHealthActionBase', 'description');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanHealthActionBase;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanHealthActionBase', 'VsanHealthActionBase', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanHealthActionBase', 'VsanHealthActionBase');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHealthActionSteps;
our @ISA = qw(VsanHealthActionBase);

our @property_list = (
   ['steps', 'VsanHealthActionBase', 1, 0],
);


VIMRuntime::make_get_set('VsanHealthActionSteps', 'steps');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHealthApiBasedAction;
our @ISA = qw(VsanHealthActionBase);

our @property_list = (
   ['apiAction', 'VsanClusterHealthAction', undef, 1],
);


VIMRuntime::make_get_set('VsanHealthApiBasedAction', 'apiAction');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHealthCmdBasedAction;
our @ISA = qw(VsanHealthActionBase);

our @property_list = (
   ['commands', undef, 1, 1],
);


VIMRuntime::make_get_set('VsanHealthCmdBasedAction', 'commands');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHealthCorrelation;
our @ISA = qw(DynamicData);

our @property_list = (
   ['primaryHealthTests', undef, 1, 0],
   ['relatedHealthTests', undef, 1, 0],
   ['skippedHealthTests', undef, 1, 0],
);


VIMRuntime::make_get_set('VsanHealthCorrelation', 'primaryHealthTests', 'relatedHealthTests', 'skippedHealthTests');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHealthExtMgmtPreCheckResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['overallResult', 'boolean', undef, 1],
   ['esxVersionCheckPassed', 'boolean', undef, 0],
   ['drsCheckPassed', 'boolean', undef, 0],
   ['eamConnectionCheckPassed', 'boolean', undef, 0],
   ['installStateCheckPassed', 'boolean', undef, 0],
   ['results', 'VsanClusterHealthTest', 1, 1],
   ['vumRegistered', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanHealthExtMgmtPreCheckResult', 'overallResult', 'esxVersionCheckPassed', 'drsCheckPassed', 'eamConnectionCheckPassed', 'installStateCheckPassed', 'results', 'vumRegistered');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHealthTroubleshooting;
our @ISA = qw(DynamicData);

our @property_list = (
   ['diagnosticSteps', 'VsanHealthActionBase', 1, 0],
   ['remediations', 'VsanHealthActionBase', 1, 0],
);


VIMRuntime::make_get_set('VsanHealthTroubleshooting', 'diagnosticSteps', 'remediations');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHealthTxtBasedAction;
our @ISA = qw(VsanHealthActionBase);

our @property_list = (
);


VIMRuntime::make_get_set('VsanHealthTxtBasedAction');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHistoricalHealthQuerySpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['clusters', 'ManagedObjectReference', 1, 1],
   ['start', undef, undef, 1],
   ['end', undef, undef, 0],
   ['testId', undef, undef, 0],
   ['groupId', undef, undef, 0],
   ['includeHealthRemediation', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanHistoricalHealthQuerySpec', 'clusters', 'start', 'end', 'testId', 'groupId', 'includeHealthRemediation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHistoricalHealthTest;
our @ISA = qw(DynamicData);

our @property_list = (
   ['timestamp', undef, undef, 1],
   ['health', undef, undef, 1],
   ['testDetails', 'VsanClusterHealthResultBase', 1, 0],
   ['testCorrelation', 'VsanHealthCorrelation', undef, 0],
);


VIMRuntime::make_get_set('VsanHistoricalHealthTest', 'timestamp', 'health', 'testDetails', 'testCorrelation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanHistoricalHealthTest;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanHistoricalHealthTest', 'VsanHistoricalHealthTest', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanHistoricalHealthTest', 'VsanHistoricalHealthTest');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostClomdLivenessResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hostname', undef, undef, 1],
   ['clomdStat', undef, undef, 1],
   ['error', 'LocalizedMethodFault', undef, 0],
);


VIMRuntime::make_get_set('VsanHostClomdLivenessResult', 'hostname', 'clomdStat', 'error');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanHostClomdLivenessResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanHostClomdLivenessResult', 'VsanHostClomdLivenessResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanHostClomdLivenessResult', 'VsanHostClomdLivenessResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostCreateVmHealthTestResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hostname', undef, undef, 1],
   ['state', undef, undef, 1],
   ['fault', 'LocalizedMethodFault', undef, 0],
);


VIMRuntime::make_get_set('VsanHostCreateVmHealthTestResult', 'hostname', 'state', 'fault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanHostCreateVmHealthTestResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanHostCreateVmHealthTestResult', 'VsanHostCreateVmHealthTestResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanHostCreateVmHealthTestResult', 'VsanHostCreateVmHealthTestResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VimClusterVsanHostDiskMapping;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['cacheDisks', 'HostScsiDisk', 1, 0],
   ['capacityDisks', 'HostScsiDisk', 1, 0],
   ['type', undef, undef, 1],
);


VIMRuntime::make_get_set('VimClusterVsanHostDiskMapping', 'host', 'cacheDisks', 'capacityDisks', 'type');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVimClusterVsanHostDiskMapping;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VimClusterVsanHostDiskMapping', 'VimClusterVsanHostDiskMapping', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVimClusterVsanHostDiskMapping', 'VimClusterVsanHostDiskMapping');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostHealthSystemVersionResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hostname', undef, undef, 1],
   ['version', undef, undef, 0],
   ['error', 'LocalizedMethodFault', undef, 0],
   ['build', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanHostHealthSystemVersionResult', 'hostname', 'version', 'error', 'build');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanHostHealthSystemVersionResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanHostHealthSystemVersionResult', 'VsanHostHealthSystemVersionResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanHostHealthSystemVersionResult', 'VsanHostHealthSystemVersionResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanIoInsightInstance;
our @ISA = qw(DynamicData);

our @property_list = (
   ['runName', undef, undef, 1],
   ['state', undef, undef, 0],
   ['startTime', undef, undef, 0],
   ['endTime', undef, undef, 0],
   ['hostsIoInsightInfo', 'VsanHostIoInsightInfo', 1, 0],
   ['hostUuids', undef, 1, 0],
   ['vmUuids', undef, 1, 0],
);


VIMRuntime::make_get_set('VsanIoInsightInstance', 'runName', 'state', 'startTime', 'endTime', 'hostsIoInsightInfo', 'hostUuids', 'vmUuids');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanIoInsightInstance;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanIoInsightInstance', 'VsanIoInsightInstance', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanIoInsightInstance', 'VsanIoInsightInstance');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanIoInsightInstanceQuerySpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['state', undef, undef, 0],
   ['entityRefId', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanIoInsightInstanceQuerySpec', 'state', 'entityRefId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanIscsiHomeObjectSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['storagePolicy', 'VirtualMachineProfileSpec', undef, 0],
   ['defaultConfig', 'VsanIscsiTargetServiceDefaultConfigSpec', undef, 0],
);


VIMRuntime::make_get_set('VsanIscsiHomeObjectSpec', 'storagePolicy', 'defaultConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanIscsiInitiatorGroup;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['initiators', undef, 1, 0],
   ['targets', 'VsanIscsiTargetBasicInfo', 1, 0],
);


VIMRuntime::make_get_set('VsanIscsiInitiatorGroup', 'name', 'initiators', 'targets');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanIscsiInitiatorGroup;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanIscsiInitiatorGroup', 'VsanIscsiInitiatorGroup', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanIscsiInitiatorGroup', 'VsanIscsiInitiatorGroup');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanIscsiLUN;
our @ISA = qw(VsanIscsiLUNCommonInfo);

our @property_list = (
   ['targetAlias', undef, undef, 1],
   ['uuid', undef, undef, 1],
   ['actualSize', undef, undef, 1],
   ['objectInformation', 'VsanObjectInformation', undef, 0],
);


VIMRuntime::make_get_set('VsanIscsiLUN', 'targetAlias', 'uuid', 'actualSize', 'objectInformation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanIscsiLUN;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanIscsiLUN', 'VsanIscsiLUN', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanIscsiLUN', 'VsanIscsiLUN');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanIscsiLUNCommonInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['lunId', undef, undef, 0],
   ['alias', undef, undef, 0],
   ['lunSize', undef, undef, 1],
   ['status', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanIscsiLUNCommonInfo', 'lunId', 'alias', 'lunSize', 'status');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanIscsiLUNSpec;
our @ISA = qw(VsanIscsiLUNCommonInfo);

our @property_list = (
   ['storagePolicy', 'VirtualMachineProfileSpec', undef, 0],
   ['newLunId', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanIscsiLUNSpec', 'storagePolicy', 'newLunId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanIscsiTarget;
our @ISA = qw(VsanIscsiTargetCommonInfo);

our @property_list = (
   ['lunCount', undef, undef, 0],
   ['objectInformation', 'VsanObjectInformation', undef, 0],
   ['ioOwnerHost', undef, undef, 0],
   ['initiators', undef, 1, 0],
   ['initiatorGroups', undef, 1, 0],
);


VIMRuntime::make_get_set('VsanIscsiTarget', 'lunCount', 'objectInformation', 'ioOwnerHost', 'initiators', 'initiatorGroups');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanIscsiTarget;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanIscsiTarget', 'VsanIscsiTarget', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanIscsiTarget', 'VsanIscsiTarget');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanIscsiTargetAuthSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['authType', undef, undef, 0],
   ['userNameAttachToTarget', undef, undef, 0],
   ['userSecretAttachToTarget', undef, undef, 0],
   ['userNameAttachToInitiator', undef, undef, 0],
   ['userSecretAttachToInitiator', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanIscsiTargetAuthSpec', 'authType', 'userNameAttachToTarget', 'userSecretAttachToTarget', 'userNameAttachToInitiator', 'userSecretAttachToInitiator');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanIscsiTargetBasicInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['alias', undef, undef, 1],
   ['iqn', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanIscsiTargetBasicInfo', 'alias', 'iqn');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanIscsiTargetBasicInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanIscsiTargetBasicInfo', 'VsanIscsiTargetBasicInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanIscsiTargetBasicInfo', 'VsanIscsiTargetBasicInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanIscsiTargetCommonInfo;
our @ISA = qw(VsanIscsiTargetBasicInfo);

our @property_list = (
   ['authSpec', 'VsanIscsiTargetAuthSpec', undef, 0],
   ['port', undef, undef, 0],
   ['networkInterface', undef, undef, 0],
   ['affinityLocation', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanIscsiTargetCommonInfo', 'authSpec', 'port', 'networkInterface', 'affinityLocation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanIscsiTargetServiceConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['defaultConfig', 'VsanIscsiTargetServiceDefaultConfigSpec', undef, 0],
   ['enabled', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanIscsiTargetServiceConfig', 'defaultConfig', 'enabled');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanIscsiTargetServiceDefaultConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['networkInterface', undef, undef, 0],
   ['port', undef, undef, 0],
   ['iscsiTargetAuthSpec', 'VsanIscsiTargetAuthSpec', undef, 0],
);


VIMRuntime::make_get_set('VsanIscsiTargetServiceDefaultConfigSpec', 'networkInterface', 'port', 'iscsiTargetAuthSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanIscsiTargetServiceSpec;
our @ISA = qw(VsanIscsiTargetServiceConfig);

our @property_list = (
   ['homeObjectStoragePolicy', 'VirtualMachineProfileSpec', undef, 0],
);


VIMRuntime::make_get_set('VsanIscsiTargetServiceSpec', 'homeObjectStoragePolicy');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanIscsiTargetSpec;
our @ISA = qw(VsanIscsiTargetCommonInfo);

our @property_list = (
   ['storagePolicy', 'VirtualMachineProfileSpec', undef, 0],
   ['newAlias', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanIscsiTargetSpec', 'storagePolicy', 'newAlias');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanNetworkDiagnostics;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['eventTypeId', undef, undef, 1],
   ['severity', undef, undef, 1],
   ['createdTime', undef, undef, 1],
   ['arguments', 'KeyAnyValue', 1, 0],
);


VIMRuntime::make_get_set('VsanNetworkDiagnostics', 'host', 'eventTypeId', 'severity', 'createdTime', 'arguments');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanNetworkDiagnostics;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanNetworkDiagnostics', 'VsanNetworkDiagnostics', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanNetworkDiagnostics', 'VsanNetworkDiagnostics');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanObjIdentityQuerySpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['knownSpbmProfileUuids', undef, 1, 0],
);


VIMRuntime::make_get_set('VsanObjIdentityQuerySpec', 'knownSpbmProfileUuids');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterObjectExtAttrs;
our @ISA = qw(DynamicData);

our @property_list = (
   ['uuid', undef, undef, 1],
   ['objectType', undef, undef, 0],
   ['objectPath', undef, undef, 0],
   ['groupUuid', undef, undef, 0],
   ['directoryName', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanClusterObjectExtAttrs', 'uuid', 'objectType', 'objectPath', 'groupUuid', 'directoryName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanClusterObjectExtAttrs;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanClusterObjectExtAttrs', 'VsanClusterObjectExtAttrs', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanClusterObjectExtAttrs', 'VsanClusterObjectExtAttrs');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanObjectExtraAttributes;
our @ISA = qw(DynamicData);

our @property_list = (
   ['uuid', undef, undef, 1],
   ['objPath', undef, undef, 1],
   ['objClass', undef, undef, 1],
   ['ufn', undef, undef, 1],
   ['isHbrCfg', 'boolean', undef, 1],
   ['ownerClusterUuid', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanObjectExtraAttributes', 'uuid', 'objPath', 'objClass', 'ufn', 'isHbrCfg', 'ownerClusterUuid');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanObjectIdentity;
our @ISA = qw(DynamicData);

our @property_list = (
   ['uuid', undef, undef, 1],
   ['type', undef, undef, 1],
   ['vmInstanceUuid', undef, undef, 0],
   ['vmNsObjectUuid', undef, undef, 0],
   ['vm', 'ManagedObjectReference', undef, 0],
   ['description', undef, undef, 0],
   ['spbmProfileUuid', undef, undef, 0],
   ['metadatas', 'KeyValue', 1, 0],
   ['typeExtId', undef, undef, 0],
   ['spbmProfileName', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanObjectIdentity', 'uuid', 'type', 'vmInstanceUuid', 'vmNsObjectUuid', 'vm', 'description', 'spbmProfileUuid', 'metadatas', 'typeExtId', 'spbmProfileName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanObjectIdentity;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanObjectIdentity', 'VsanObjectIdentity', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanObjectIdentity', 'VsanObjectIdentity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanObjectIdentityAndHealth;
our @ISA = qw(DynamicData);

our @property_list = (
   ['identities', 'VsanObjectIdentity', 1, 0],
   ['health', 'VsanObjectOverallHealth', undef, 0],
   ['spaceSummary', 'VsanObjectSpaceSummary', 1, 0],
   ['rawData', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanObjectIdentityAndHealth', 'identities', 'health', 'spaceSummary', 'rawData');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanObjectInformation;
our @ISA = qw(DynamicData);

our @property_list = (
   ['directoryName', undef, undef, 0],
   ['vsanObjectUuid', undef, undef, 0],
   ['vsanHealth', undef, undef, 0],
   ['policyAttributes', 'KeyValue', 1, 0],
   ['spbmProfileUuid', undef, undef, 0],
   ['spbmProfileGenerationId', undef, undef, 0],
   ['spbmComplianceResult', 'VsanStorageComplianceResult', undef, 0],
);


VIMRuntime::make_get_set('VsanObjectInformation', 'directoryName', 'vsanObjectUuid', 'vsanHealth', 'policyAttributes', 'spbmProfileUuid', 'spbmProfileGenerationId', 'spbmComplianceResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanObjectInformation;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanObjectInformation', 'VsanObjectInformation', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanObjectInformation', 'VsanObjectInformation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanObjectQuerySpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['uuid', undef, undef, 1],
   ['spbmProfileGenerationId', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanObjectQuerySpec', 'uuid', 'spbmProfileGenerationId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanObjectQuerySpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanObjectQuerySpec', 'VsanObjectQuerySpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanObjectQuerySpec', 'VsanObjectQuerySpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanObjectSpaceSummary;
our @ISA = qw(DynamicData);

our @property_list = (
   ['objType', undef, undef, 0],
   ['overheadB', undef, undef, 0],
   ['temporaryOverheadB', undef, undef, 0],
   ['primaryCapacityB', undef, undef, 0],
   ['provisionCapacityB', undef, undef, 0],
   ['reservedCapacityB', undef, undef, 0],
   ['overReservedB', undef, undef, 0],
   ['physicalUsedB', undef, undef, 0],
   ['usedB', undef, undef, 0],
   ['objTypeExt', undef, undef, 0],
   ['objTypeExtDesc', undef, undef, 0],
   ['snapshotUsedB', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanObjectSpaceSummary', 'objType', 'overheadB', 'temporaryOverheadB', 'primaryCapacityB', 'provisionCapacityB', 'reservedCapacityB', 'overReservedB', 'physicalUsedB', 'usedB', 'objTypeExt', 'objTypeExtDesc', 'snapshotUsedB');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanObjectSpaceSummary;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanObjectSpaceSummary', 'VsanObjectSpaceSummary', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanObjectSpaceSummary', 'VsanObjectSpaceSummary');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanPerfDiagnoseQuerySpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['startTime', undef, undef, 1],
   ['endTime', undef, undef, 1],
   ['queryType', undef, undef, 1],
   ['context', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanPerfDiagnoseQuerySpec', 'startTime', 'endTime', 'queryType', 'context');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanPerfDiagnosticException;
our @ISA = qw(DynamicData);

our @property_list = (
   ['exceptionId', undef, undef, 1],
   ['exceptionMessage', undef, undef, 1],
   ['exceptionDetails', undef, undef, 1],
   ['exceptionUrl', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanPerfDiagnosticException', 'exceptionId', 'exceptionMessage', 'exceptionDetails', 'exceptionUrl');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanPerfDiagnosticException;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanPerfDiagnosticException', 'VsanPerfDiagnosticException', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanPerfDiagnosticException', 'VsanPerfDiagnosticException');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanPerfDiagnosticResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['exceptionId', undef, undef, 1],
   ['recommendation', undef, undef, 0],
   ['aggregationFunction', undef, undef, 0],
   ['aggregationData', 'VsanPerfEntityMetricCSV', undef, 0],
   ['exceptionData', 'VsanPerfEntityMetricCSV', 1, 1],
);


VIMRuntime::make_get_set('VsanPerfDiagnosticResult', 'exceptionId', 'recommendation', 'aggregationFunction', 'aggregationData', 'exceptionData');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanPerfDiagnosticResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanPerfDiagnosticResult', 'VsanPerfDiagnosticResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanPerfDiagnosticResult', 'VsanPerfDiagnosticResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanPerfEntityMetricCSV;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entityRefId', undef, undef, 1],
   ['sampleInfo', undef, undef, 0],
   ['value', 'VsanPerfMetricSeriesCSV', 1, 0],
);


VIMRuntime::make_get_set('VsanPerfEntityMetricCSV', 'entityRefId', 'sampleInfo', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanPerfEntityMetricCSV;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanPerfEntityMetricCSV', 'VsanPerfEntityMetricCSV', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanPerfEntityMetricCSV', 'VsanPerfEntityMetricCSV');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanPerfEntityType;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['id', undef, undef, 1],
   ['graphs', 'VsanPerfGraph', 1, 1],
   ['description', undef, undef, 0],
   ['advancedGraphs', 'VsanPerfGraph', 1, 0],
   ['verboseGraphs', 'VsanPerfGraph', 1, 0],
);


VIMRuntime::make_get_set('VsanPerfEntityType', 'name', 'id', 'graphs', 'description', 'advancedGraphs', 'verboseGraphs');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanPerfEntityType;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanPerfEntityType', 'VsanPerfEntityType', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanPerfEntityType', 'VsanPerfEntityType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanPerfGraph;
our @ISA = qw(DynamicData);

our @property_list = (
   ['id', undef, undef, 1],
   ['metrics', 'VsanPerfMetricId', 1, 1],
   ['unit', undef, undef, 1],
   ['threshold', 'VsanPerfThreshold', undef, 0],
   ['name', undef, undef, 0],
   ['description', undef, undef, 0],
   ['secondGraph', 'VsanPerfGraph', undef, 0],
);


VIMRuntime::make_get_set('VsanPerfGraph', 'id', 'metrics', 'unit', 'threshold', 'name', 'description', 'secondGraph');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanPerfGraph;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanPerfGraph', 'VsanPerfGraph', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanPerfGraph', 'VsanPerfGraph');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanPerfHotspotEntitiesMetrics;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entityRefId', undef, undef, 1],
   ['startTime', undef, undef, 1],
   ['endTime', undef, undef, 1],
   ['metricsValue', 'VsanPerfMetricSeriesCSV', 1, 0],
);


VIMRuntime::make_get_set('VsanPerfHotspotEntitiesMetrics', 'entityRefId', 'startTime', 'endTime', 'metricsValue');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanPerfHotspotEntitiesMetrics;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanPerfHotspotEntitiesMetrics', 'VsanPerfHotspotEntitiesMetrics', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanPerfHotspotEntitiesMetrics', 'VsanPerfHotspotEntitiesMetrics');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanPerfHotspotQuerySpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['startTime', undef, undef, 1],
   ['endTime', undef, undef, 1],
   ['entity', undef, undef, 1],
   ['metricId', undef, undef, 1],
   ['numEntities', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanPerfHotspotQuerySpec', 'startTime', 'endTime', 'entity', 'metricId', 'numEntities');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanPerfMasterInformation;
our @ISA = qw(DynamicData);

our @property_list = (
   ['secSinceLastStatsWrite', undef, undef, 0],
   ['secSinceLastStatsCollect', undef, undef, 0],
   ['statsIntervalSec', undef, undef, 1],
   ['collectionFailureHostUuids', undef, 1, 0],
   ['renamedStatsDirectories', undef, 1, 0],
   ['statsDirectoryPercentFree', undef, undef, 0],
   ['verboseMode', 'boolean', undef, 0],
   ['verboseModeLastUpdate', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanPerfMasterInformation', 'secSinceLastStatsWrite', 'secSinceLastStatsCollect', 'statsIntervalSec', 'collectionFailureHostUuids', 'renamedStatsDirectories', 'statsDirectoryPercentFree', 'verboseMode', 'verboseModeLastUpdate');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanPerfMemberInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['thumbprint', undef, undef, 1],
   ['thumbprintList', 'VirtualMachineCertThumbprint', 1, 0],
   ['memberUuid', undef, undef, 0],
   ['isSupportUnicast', 'boolean', undef, 0],
   ['unicastAddressInfos', 'VsanUnicastAddressInfo', 1, 0],
   ['hostname', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanPerfMemberInfo', 'thumbprint', 'thumbprintList', 'memberUuid', 'isSupportUnicast', 'unicastAddressInfos', 'hostname');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanPerfMemberInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanPerfMemberInfo', 'VsanPerfMemberInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanPerfMemberInfo', 'VsanPerfMemberInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanPerfMetricId;
our @ISA = qw(DynamicData);

our @property_list = (
   ['label', undef, undef, 1],
   ['group', undef, undef, 0],
   ['rollupType', undef, undef, 0],
   ['statsType', undef, undef, 0],
   ['name', undef, undef, 0],
   ['description', undef, undef, 0],
   ['metricsCollectInterval', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanPerfMetricId', 'label', 'group', 'rollupType', 'statsType', 'name', 'description', 'metricsCollectInterval');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanPerfMetricId;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanPerfMetricId', 'VsanPerfMetricId', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanPerfMetricId', 'VsanPerfMetricId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanPerfMetricSeriesCSV;
our @ISA = qw(DynamicData);

our @property_list = (
   ['metricId', 'VsanPerfMetricId', undef, 1],
   ['threshold', 'VsanPerfThreshold', undef, 0],
   ['numExceptions', undef, undef, 0],
   ['values', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanPerfMetricSeriesCSV', 'metricId', 'threshold', 'numExceptions', 'values');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanPerfMetricSeriesCSV;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanPerfMetricSeriesCSV', 'VsanPerfMetricSeriesCSV', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanPerfMetricSeriesCSV', 'VsanPerfMetricSeriesCSV');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanPerfNodeInformation;
our @ISA = qw(DynamicData);

our @property_list = (
   ['version', undef, undef, 1],
   ['hostname', undef, undef, 0],
   ['error', 'LocalizedMethodFault', undef, 0],
   ['isCmmdsMaster', 'boolean', undef, 1],
   ['isStatsMaster', 'boolean', undef, 1],
   ['vsanMasterUuid', undef, undef, 0],
   ['vsanNodeUuid', undef, undef, 0],
   ['masterInfo', 'VsanPerfMasterInformation', undef, 0],
   ['diagnosticMode', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanPerfNodeInformation', 'version', 'hostname', 'error', 'isCmmdsMaster', 'isStatsMaster', 'vsanMasterUuid', 'vsanNodeUuid', 'masterInfo', 'diagnosticMode');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanPerfNodeInformation;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanPerfNodeInformation', 'VsanPerfNodeInformation', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanPerfNodeInformation', 'VsanPerfNodeInformation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanPerfQuerySpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entityRefId', undef, undef, 1],
   ['startTime', undef, undef, 0],
   ['endTime', undef, undef, 0],
   ['group', undef, undef, 0],
   ['labels', undef, 1, 0],
   ['interval', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanPerfQuerySpec', 'entityRefId', 'startTime', 'endTime', 'group', 'labels', 'interval');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanPerfQuerySpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanPerfQuerySpec', 'VsanPerfQuerySpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanPerfQuerySpec', 'VsanPerfQuerySpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanPerfThreshold;
our @ISA = qw(DynamicData);

our @property_list = (
   ['direction', undef, undef, 1],
   ['yellow', undef, undef, 0],
   ['red', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanPerfThreshold', 'direction', 'yellow', 'red');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanPerfTimeRange;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['startTime', undef, undef, 1],
   ['endTime', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanPerfTimeRange', 'name', 'startTime', 'endTime');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanPerfTimeRange;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanPerfTimeRange', 'VsanPerfTimeRange', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanPerfTimeRange', 'VsanPerfTimeRange');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanPerfTimeRangeQuerySpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 0],
   ['startTimeFrom', undef, undef, 0],
   ['startTimeTo', undef, undef, 0],
   ['endTimeFrom', undef, undef, 0],
   ['endTimeTo', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanPerfTimeRangeQuerySpec', 'name', 'startTimeFrom', 'startTimeTo', 'endTimeFrom', 'endTimeTo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanPerfTopEntities;
our @ISA = qw(DynamicData);

our @property_list = (
   ['metricId', 'VsanPerfMetricId', undef, 1],
   ['entities', 'VsanPerfTopEntity', 1, 1],
);


VIMRuntime::make_get_set('VsanPerfTopEntities', 'metricId', 'entities');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanPerfTopEntity;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entityRefId', undef, undef, 1],
   ['value', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanPerfTopEntity', 'entityRefId', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanPerfTopEntity;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanPerfTopEntity', 'VsanPerfTopEntity', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanPerfTopEntity', 'VsanPerfTopEntity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanPerfTopQuerySpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['timeStamp', undef, undef, 1],
   ['entity', undef, undef, 1],
   ['metricId', undef, undef, 1],
   ['numEntities', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanPerfTopQuerySpec', 'timeStamp', 'entity', 'metricId', 'numEntities');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanPerfsvcConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['enabled', 'boolean', undef, 1],
   ['profile', 'VirtualMachineProfileSpec', undef, 0],
   ['diagnosticMode', 'boolean', undef, 0],
   ['verboseMode', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanPerfsvcConfig', 'enabled', 'profile', 'diagnosticMode', 'verboseMode');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanRemoteClusterQuerySpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['startTime', undef, undef, 0],
   ['endTime', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanRemoteClusterQuerySpec', 'startTime', 'endTime');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanSpaceQuerySpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entityType', undef, undef, 1],
   ['entityIds', undef, 1, 0],
);


VIMRuntime::make_get_set('VsanSpaceQuerySpec', 'entityType', 'entityIds');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanSpaceUsage;
our @ISA = qw(DynamicData);

our @property_list = (
   ['totalCapacityB', undef, undef, 1],
   ['freeCapacityB', undef, undef, 0],
   ['spaceOverview', 'VsanObjectSpaceSummary', undef, 0],
   ['spaceDetail', 'VsanSpaceUsageDetailResult', undef, 0],
   ['efficientCapacity', 'VimVsanDataEfficiencyCapacityState', undef, 0],
   ['whatifCapacities', 'VsanWhatifCapacity', 1, 0],
   ['uncommittedB', undef, undef, 0],
   ['capacityHealthThreshold', 'VsanHealthThreshold', undef, 0],
);


VIMRuntime::make_get_set('VsanSpaceUsage', 'totalCapacityB', 'freeCapacityB', 'spaceOverview', 'spaceDetail', 'efficientCapacity', 'whatifCapacities', 'uncommittedB', 'capacityHealthThreshold');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanSpaceUsageDetailResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['spaceUsageByObjectType', 'VsanObjectSpaceSummary', 1, 0],
);


VIMRuntime::make_get_set('VsanSpaceUsageDetailResult', 'spaceUsageByObjectType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanSpaceUsageWithDatastoreType;
our @ISA = qw(DynamicData);

our @property_list = (
   ['spaceUsage', 'VsanSpaceUsage', undef, 0],
   ['datastoreType', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanSpaceUsageWithDatastoreType', 'spaceUsage', 'datastoreType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanSpaceUsageWithDatastoreType;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanSpaceUsageWithDatastoreType', 'VsanSpaceUsageWithDatastoreType', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanSpaceUsageWithDatastoreType', 'VsanSpaceUsageWithDatastoreType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanStorageWorkloadType;
our @ISA = qw(DynamicData);

our @property_list = (
   ['specs', 'VsanVmdkLoadTestSpec', 1, 1],
   ['typeId', undef, undef, 1],
   ['name', undef, undef, 1],
   ['description', undef, undef, 1],
   ['duration', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanStorageWorkloadType', 'specs', 'typeId', 'name', 'description', 'duration');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanStorageWorkloadType;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanStorageWorkloadType', 'VsanStorageWorkloadType', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanStorageWorkloadType', 'VsanStorageWorkloadType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanStretchedClusterConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['cluster', 'ManagedObjectReference', undef, 1],
   ['preferredFdName', undef, undef, 0],
   ['faultDomainConfig', 'VimClusterVSANStretchedClusterFaultDomainConfig', undef, 0],
);


VIMRuntime::make_get_set('VsanStretchedClusterConfig', 'cluster', 'preferredFdName', 'faultDomainConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanStretchedClusterConfig;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanStretchedClusterConfig', 'VsanStretchedClusterConfig', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanStretchedClusterConfig', 'VsanStretchedClusterConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanSyncingObjectFilter;
our @ISA = qw(DynamicData);

our @property_list = (
   ['resyncType', undef, undef, 0],
   ['resyncStatus', undef, undef, 0],
   ['numberOfObjects', undef, undef, 0],
   ['offset', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanSyncingObjectFilter', 'resyncType', 'resyncStatus', 'numberOfObjects', 'offset');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanUnicastAddressInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['address', undef, undef, 1],
   ['port', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanUnicastAddressInfo', 'address', 'port');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanUnicastAddressInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanUnicastAddressInfo', 'VsanUnicastAddressInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanUnicastAddressInfo', 'VsanUnicastAddressInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanUpgradeStatusEx;
our @ISA = qw(VsanUpgradeSystemUpgradeStatus);

our @property_list = (
   ['isPrecheck', 'boolean', undef, 0],
   ['precheckResult', 'VsanDiskFormatConversionCheckResult', undef, 0],
);


VIMRuntime::make_get_set('VsanUpgradeStatusEx', 'isPrecheck', 'precheckResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanUpgradeSystemUpgradeHistoryStoragePoolOp;
our @ISA = qw(VsanUpgradeSystemUpgradeHistoryItem);

our @property_list = (
   ['operation', undef, undef, 1],
   ['diskInfo', 'VimVsanHostStoragePoolDiskInfo', undef, 1],
);


VIMRuntime::make_get_set('VsanUpgradeSystemUpgradeHistoryStoragePoolOp', 'operation', 'diskInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanVcKmipServersHealth;
our @ISA = qw(DynamicData);

our @property_list = (
   ['health', undef, undef, 0],
   ['error', 'LocalizedMethodFault', undef, 0],
   ['kmsProviderId', undef, undef, 0],
   ['kmsHealth', 'VsanKmsHealth', 1, 0],
   ['clientCertHealth', undef, undef, 0],
   ['clientCertExpireDate', undef, undef, 0],
   ['isAwsKms', 'boolean', undef, 0],
   ['cmkHealth', undef, undef, 0],
   ['kekExpireHealth', undef, undef, 0],
   ['kekExpireDate', undef, undef, 0],
   ['hostKeyExpireHealth', undef, undef, 0],
   ['hostKeyExpireDate', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanVcKmipServersHealth', 'health', 'error', 'kmsProviderId', 'kmsHealth', 'clientCertHealth', 'clientCertExpireDate', 'isAwsKms', 'cmkHealth', 'kekExpireHealth', 'kekExpireDate', 'hostKeyExpireHealth', 'hostKeyExpireDate');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanVcLifecycleCheckResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['status', undef, undef, 1],
   ['preCheckResults', 'LifecyclePreCheckResult', 1, 0],
   ['configDetails', 'LifecycleConfigDetails', undef, 1],
);


VIMRuntime::make_get_set('VsanVcLifecycleCheckResult', 'status', 'preCheckResults', 'configDetails');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanVcLifecycleCheckSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['operation', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanVcLifecycleCheckSpec', 'operation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanVsanClusterPcapGroup;
our @ISA = qw(DynamicData);

our @property_list = (
   ['master', undef, undef, 1],
   ['members', undef, 1, 0],
);


VIMRuntime::make_get_set('VsanVsanClusterPcapGroup', 'master', 'members');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanVsanClusterPcapGroup;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanVsanClusterPcapGroup', 'VsanVsanClusterPcapGroup', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanVsanClusterPcapGroup', 'VsanVsanClusterPcapGroup');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanVsanClusterPcapResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['pkts', undef, 1, 0],
   ['groups', 'VsanVsanClusterPcapGroup', 1, 0],
   ['issues', undef, 1, 0],
   ['hostResults', 'VsanVsanPcapResult', 1, 0],
);


VIMRuntime::make_get_set('VsanVsanClusterPcapResult', 'pkts', 'groups', 'issues', 'hostResults');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanVumSystemConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['enabled', 'boolean', undef, 0],
   ['autoCheckInterval', undef, undef, 0],
   ['metadataUpdateInterval', undef, undef, 0],
   ['releaseDbLastUpdate', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanVumSystemConfig', 'enabled', 'autoCheckInterval', 'metadataUpdateInterval', 'releaseDbLastUpdate');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanWhatifCapacity;
our @ISA = qw(DynamicData);

our @property_list = (
   ['totalWhatifCapacityB', undef, undef, 1],
   ['freeWhatifCapacityB', undef, undef, 1],
   ['storagePolicy', 'VirtualMachineProfileSpec', undef, 1],
   ['isSatisfiable', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('VsanWhatifCapacity', 'totalWhatifCapacityB', 'freeWhatifCapacityB', 'storagePolicy', 'isSatisfiable');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanWhatifCapacity;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanWhatifCapacity', 'VsanWhatifCapacity', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanWhatifCapacity', 'VsanWhatifCapacity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VimClusterVsanWitnessSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['preferredFaultDomainName', undef, undef, 1],
   ['diskMapping', 'VsanHostDiskMapping', undef, 0],
   ['storagePoolSpec', 'VsanAddStoragePoolDiskSpec', undef, 0],
);


VIMRuntime::make_get_set('VimClusterVsanWitnessSpec', 'host', 'preferredFaultDomainName', 'diskMapping', 'storagePoolSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsAccessControlSpec;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('CnsAccessControlSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfCnsAccessControlSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['CnsAccessControlSpec', 'CnsAccessControlSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfCnsAccessControlSpec', 'CnsAccessControlSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsAsyncQueryResult;
our @ISA = qw(CnsVolumeOperationResult);

our @property_list = (
   ['queryResult', 'CnsQueryResult', undef, 0],
);


VIMRuntime::make_get_set('CnsAsyncQueryResult', 'queryResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsBackingObjectDetails;
our @ISA = qw(DynamicData);

our @property_list = (
   ['capacityInMb', undef, undef, 0],
);


VIMRuntime::make_get_set('CnsBackingObjectDetails', 'capacityInMb');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsBaseCreateSpec;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('CnsBaseCreateSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsBlockBackingDetails;
our @ISA = qw(CnsBackingObjectDetails);

our @property_list = (
   ['backingDiskId', undef, undef, 0],
   ['backingDiskUrlPath', undef, undef, 0],
   ['backingDiskPath', undef, undef, 0],
   ['backingDiskObjectId', undef, undef, 0],
   ['usedCapacityInMb', undef, undef, 0],
);


VIMRuntime::make_get_set('CnsBlockBackingDetails', 'backingDiskId', 'backingDiskUrlPath', 'backingDiskPath', 'backingDiskObjectId', 'usedCapacityInMb');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsBlockVolumeRelocateSpec;
our @ISA = qw(CnsVolumeRelocateSpec);

our @property_list = (
);


VIMRuntime::make_get_set('CnsBlockVolumeRelocateSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsContainerCluster;
our @ISA = qw(DynamicData);

our @property_list = (
   ['clusterType', undef, undef, 1],
   ['clusterId', undef, undef, 1],
   ['vSphereUser', undef, undef, 1],
   ['clusterFlavor', undef, undef, 0],
   ['clusterDistribution', undef, undef, 0],
   ['delete', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('CnsContainerCluster', 'clusterType', 'clusterId', 'vSphereUser', 'clusterFlavor', 'clusterDistribution', 'delete');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfCnsContainerCluster;
our @ISA = qw(ComplexType);

our @property_list = (
   ['CnsContainerCluster', 'CnsContainerCluster', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfCnsContainerCluster', 'CnsContainerCluster');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsCursor;
our @ISA = qw(DynamicData);

our @property_list = (
   ['offset', undef, undef, 1],
   ['limit', undef, undef, 1],
   ['totalRecords', undef, undef, 0],
);


VIMRuntime::make_get_set('CnsCursor', 'offset', 'limit', 'totalRecords');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsEntityMetadata;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entityName', undef, undef, 1],
   ['labels', 'KeyValue', 1, 0],
   ['delete', 'boolean', undef, 0],
   ['clusterId', undef, undef, 0],
);


VIMRuntime::make_get_set('CnsEntityMetadata', 'entityName', 'labels', 'delete', 'clusterId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfCnsEntityMetadata;
our @ISA = qw(ComplexType);

our @property_list = (
   ['CnsEntityMetadata', 'CnsEntityMetadata', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfCnsEntityMetadata', 'CnsEntityMetadata');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsFileBackingDetails;
our @ISA = qw(CnsBackingObjectDetails);

our @property_list = (
   ['backingFileId', undef, undef, 0],
);


VIMRuntime::make_get_set('CnsFileBackingDetails', 'backingFileId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsFileCreateSpec;
our @ISA = qw(CnsBaseCreateSpec);

our @property_list = (
);


VIMRuntime::make_get_set('CnsFileCreateSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsKubernetesEntityMetadata;
our @ISA = qw(CnsEntityMetadata);

our @property_list = (
   ['entityType', undef, undef, 1],
   ['namespace', undef, undef, 0],
   ['referredEntity', 'CnsKubernetesEntityReference', 1, 0],
);


VIMRuntime::make_get_set('CnsKubernetesEntityMetadata', 'entityType', 'namespace', 'referredEntity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsKubernetesEntityReference;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entityType', undef, undef, 1],
   ['entityName', undef, undef, 1],
   ['namespace', undef, undef, 0],
   ['clusterId', undef, undef, 0],
);


VIMRuntime::make_get_set('CnsKubernetesEntityReference', 'entityType', 'entityName', 'namespace', 'clusterId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfCnsKubernetesEntityReference;
our @ISA = qw(ComplexType);

our @property_list = (
   ['CnsKubernetesEntityReference', 'CnsKubernetesEntityReference', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfCnsKubernetesEntityReference', 'CnsKubernetesEntityReference');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsKubernetesQueryFilter;
our @ISA = qw(CnsQueryFilter);

our @property_list = (
   ['namespaces', undef, 1, 0],
   ['podNames', undef, 1, 0],
   ['pvcNames', undef, 1, 0],
   ['pvNames', undef, 1, 0],
);


VIMRuntime::make_get_set('CnsKubernetesQueryFilter', 'namespaces', 'podNames', 'pvcNames', 'pvNames');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsNFSAccessControlSpec;
our @ISA = qw(CnsAccessControlSpec);

our @property_list = (
   ['netPermission', 'VsanFileShareNetPermission', undef, 1],
   ['delete', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('CnsNFSAccessControlSpec', 'netPermission', 'delete');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsPlacementResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['datastore', 'ManagedObjectReference', undef, 1],
   ['placementFaults', 'LocalizedMethodFault', 1, 0],
);


VIMRuntime::make_get_set('CnsPlacementResult', 'datastore', 'placementFaults');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfCnsPlacementResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['CnsPlacementResult', 'CnsPlacementResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfCnsPlacementResult', 'CnsPlacementResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsQueryFilter;
our @ISA = qw(DynamicData);

our @property_list = (
   ['volumeIds', 'CnsVolumeId', 1, 0],
   ['names', undef, 1, 0],
   ['containerClusterIds', undef, 1, 0],
   ['storagePolicyId', undef, undef, 0],
   ['datastores', 'ManagedObjectReference', 1, 0],
   ['labels', 'KeyValue', 1, 0],
   ['complianceStatus', undef, undef, 0],
   ['datastoreAccessibilityStatus', undef, undef, 0],
   ['cursor', 'CnsCursor', undef, 0],
   ['healthStatus', undef, undef, 0],
);


VIMRuntime::make_get_set('CnsQueryFilter', 'volumeIds', 'names', 'containerClusterIds', 'storagePolicyId', 'datastores', 'labels', 'complianceStatus', 'datastoreAccessibilityStatus', 'cursor', 'healthStatus');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsQueryResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['volumes', 'CnsVolume', 1, 0],
   ['cursor', 'CnsCursor', undef, 1],
);


VIMRuntime::make_get_set('CnsQueryResult', 'volumes', 'cursor');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsQuerySelection;
our @ISA = qw(DynamicData);

our @property_list = (
   ['names', undef, 1, 0],
);


VIMRuntime::make_get_set('CnsQuerySelection', 'names');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsSnapshotId;
our @ISA = qw(DynamicData);

our @property_list = (
   ['id', undef, undef, 1],
);


VIMRuntime::make_get_set('CnsSnapshotId', 'id');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsSnapshotVolumeSource;
our @ISA = qw(CnsVolumeSource);

our @property_list = (
   ['volumeId', 'CnsVolumeId', undef, 0],
   ['snapshotId', 'CnsSnapshotId', undef, 0],
);


VIMRuntime::make_get_set('CnsSnapshotVolumeSource', 'volumeId', 'snapshotId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsVSANFileCreateSpec;
our @ISA = qw(CnsFileCreateSpec);

our @property_list = (
   ['softQuotaInMb', undef, undef, 0],
   ['permission', 'VsanFileShareNetPermission', 1, 0],
);


VIMRuntime::make_get_set('CnsVSANFileCreateSpec', 'softQuotaInMb', 'permission');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsVolume;
our @ISA = qw(DynamicData);

our @property_list = (
   ['volumeId', 'CnsVolumeId', undef, 1],
   ['datastoreUrl', undef, undef, 0],
   ['name', undef, undef, 0],
   ['volumeType', undef, undef, 0],
   ['storagePolicyId', undef, undef, 0],
   ['metadata', 'CnsVolumeMetadata', undef, 0],
   ['backingObjectDetails', 'CnsBackingObjectDetails', undef, 0],
   ['complianceStatus', undef, undef, 0],
   ['datastoreAccessibilityStatus', undef, undef, 0],
   ['healthStatus', undef, undef, 0],
);


VIMRuntime::make_get_set('CnsVolume', 'volumeId', 'datastoreUrl', 'name', 'volumeType', 'storagePolicyId', 'metadata', 'backingObjectDetails', 'complianceStatus', 'datastoreAccessibilityStatus', 'healthStatus');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfCnsVolume;
our @ISA = qw(ComplexType);

our @property_list = (
   ['CnsVolume', 'CnsVolume', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfCnsVolume', 'CnsVolume');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsVolumeACLConfigureSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['volumeId', 'CnsVolumeId', undef, 1],
   ['accessControlSpecList', 'CnsAccessControlSpec', 1, 1],
);


VIMRuntime::make_get_set('CnsVolumeACLConfigureSpec', 'volumeId', 'accessControlSpecList');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfCnsVolumeACLConfigureSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['CnsVolumeACLConfigureSpec', 'CnsVolumeACLConfigureSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfCnsVolumeACLConfigureSpec', 'CnsVolumeACLConfigureSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsVolumeAttachDetachSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['volumeId', 'CnsVolumeId', undef, 1],
   ['vm', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('CnsVolumeAttachDetachSpec', 'volumeId', 'vm');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfCnsVolumeAttachDetachSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['CnsVolumeAttachDetachSpec', 'CnsVolumeAttachDetachSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfCnsVolumeAttachDetachSpec', 'CnsVolumeAttachDetachSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsVolumeAttachResult;
our @ISA = qw(CnsVolumeOperationResult);

our @property_list = (
   ['diskUUID', undef, undef, 0],
);


VIMRuntime::make_get_set('CnsVolumeAttachResult', 'diskUUID');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsVolumeCreateResult;
our @ISA = qw(CnsVolumeOperationResult);

our @property_list = (
   ['name', undef, undef, 0],
   ['placementResults', 'CnsPlacementResult', 1, 0],
);


VIMRuntime::make_get_set('CnsVolumeCreateResult', 'name', 'placementResults');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsVolumeCreateSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['volumeType', undef, undef, 1],
   ['datastores', 'ManagedObjectReference', 1, 0],
   ['metadata', 'CnsVolumeMetadata', undef, 0],
   ['backingObjectDetails', 'CnsBackingObjectDetails', undef, 1],
   ['profile', 'VirtualMachineProfileSpec', 1, 0],
   ['createSpec', 'CnsBaseCreateSpec', undef, 0],
   ['volumeSource', 'CnsVolumeSource', undef, 0],
);


VIMRuntime::make_get_set('CnsVolumeCreateSpec', 'name', 'volumeType', 'datastores', 'metadata', 'backingObjectDetails', 'profile', 'createSpec', 'volumeSource');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfCnsVolumeCreateSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['CnsVolumeCreateSpec', 'CnsVolumeCreateSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfCnsVolumeCreateSpec', 'CnsVolumeCreateSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsVolumeExtendSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['volumeId', 'CnsVolumeId', undef, 1],
   ['capacityInMb', undef, undef, 1],
);


VIMRuntime::make_get_set('CnsVolumeExtendSpec', 'volumeId', 'capacityInMb');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfCnsVolumeExtendSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['CnsVolumeExtendSpec', 'CnsVolumeExtendSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfCnsVolumeExtendSpec', 'CnsVolumeExtendSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsVolumeId;
our @ISA = qw(DynamicData);

our @property_list = (
   ['id', undef, undef, 1],
);


VIMRuntime::make_get_set('CnsVolumeId', 'id');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfCnsVolumeId;
our @ISA = qw(ComplexType);

our @property_list = (
   ['CnsVolumeId', 'CnsVolumeId', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfCnsVolumeId', 'CnsVolumeId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsVolumeMetadata;
our @ISA = qw(DynamicData);

our @property_list = (
   ['containerCluster', 'CnsContainerCluster', undef, 1],
   ['entityMetadata', 'CnsEntityMetadata', 1, 0],
   ['containerClusterArray', 'CnsContainerCluster', 1, 0],
);


VIMRuntime::make_get_set('CnsVolumeMetadata', 'containerCluster', 'entityMetadata', 'containerClusterArray');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsVolumeMetadataUpdateSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['volumeId', 'CnsVolumeId', undef, 1],
   ['metadata', 'CnsVolumeMetadata', undef, 1],
);


VIMRuntime::make_get_set('CnsVolumeMetadataUpdateSpec', 'volumeId', 'metadata');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfCnsVolumeMetadataUpdateSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['CnsVolumeMetadataUpdateSpec', 'CnsVolumeMetadataUpdateSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfCnsVolumeMetadataUpdateSpec', 'CnsVolumeMetadataUpdateSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsVolumeOperationBatchResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['volumeResults', 'CnsVolumeOperationResult', 1, 0],
);


VIMRuntime::make_get_set('CnsVolumeOperationBatchResult', 'volumeResults');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsVolumeOperationResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['volumeId', 'CnsVolumeId', undef, 0],
   ['fault', 'LocalizedMethodFault', undef, 0],
);


VIMRuntime::make_get_set('CnsVolumeOperationResult', 'volumeId', 'fault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfCnsVolumeOperationResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['CnsVolumeOperationResult', 'CnsVolumeOperationResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfCnsVolumeOperationResult', 'CnsVolumeOperationResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsVolumeRelocateSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['volumeId', 'CnsVolumeId', undef, 1],
   ['datastore', 'ManagedObjectReference', undef, 1],
   ['profile', 'VirtualMachineProfileSpec', 1, 0],
);


VIMRuntime::make_get_set('CnsVolumeRelocateSpec', 'volumeId', 'datastore', 'profile');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsVolumeSource;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('CnsVolumeSource');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsVsanFileShareBackingDetails;
our @ISA = qw(CnsFileBackingDetails);

our @property_list = (
   ['name', undef, undef, 0],
   ['accessPoints', 'KeyValue', 1, 0],
   ['permission', 'VsanFileShareNetPermission', 1, 0],
);


VIMRuntime::make_get_set('CnsVsanFileShareBackingDetails', 'name', 'accessPoints', 'permission');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsAlreadyRegisteredFault;
our @ISA = qw(CnsFault);

our @property_list = (
   ['volumeId', 'CnsVolumeId', undef, 1],
);


VIMRuntime::make_get_set('CnsAlreadyRegisteredFault', 'volumeId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsFault;
our @ISA = qw(VimFault);

our @property_list = (
   ['reason', undef, undef, 1],
);


VIMRuntime::make_get_set('CnsFault', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsInCompatibleFault;
our @ISA = qw(CnsPlacementFault);

our @property_list = (
   ['errors', 'LocalizedMethodFault', 1, 0],
);


VIMRuntime::make_get_set('CnsInCompatibleFault', 'errors');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsMissingControllerFault;
our @ISA = qw(CnsFault);

our @property_list = (
);


VIMRuntime::make_get_set('CnsMissingControllerFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsMissingPrivilegeFault;
our @ISA = qw(CnsPlacementFault);

our @property_list = (
   ['privileges', undef, 1, 0],
);


VIMRuntime::make_get_set('CnsMissingPrivilegeFault', 'privileges');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsNotRegisteredFault;
our @ISA = qw(CnsFault);

our @property_list = (
   ['volumeId', 'CnsVolumeId', undef, 1],
);


VIMRuntime::make_get_set('CnsNotRegisteredFault', 'volumeId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsPlacementFault;
our @ISA = qw(CnsFault);

our @property_list = (
);


VIMRuntime::make_get_set('CnsPlacementFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsRankedLowerFault;
our @ISA = qw(CnsPlacementFault);

our @property_list = (
);


VIMRuntime::make_get_set('CnsRankedLowerFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsSnapshotNotFoundFault;
our @ISA = qw(CnsFault);

our @property_list = (
   ['volumeId', 'CnsVolumeId', undef, 0],
   ['SnapshotId', 'CnsSnapshotId', undef, 1],
);


VIMRuntime::make_get_set('CnsSnapshotNotFoundFault', 'volumeId', 'SnapshotId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CnsVolumeNotFoundFault;
our @ISA = qw(CnsFault);

our @property_list = (
   ['volumeId', 'CnsVolumeId', undef, 1],
);


VIMRuntime::make_get_set('CnsVolumeNotFoundFault', 'volumeId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanNodeNotMaster;
our @ISA = qw(VimFault);

our @property_list = (
   ['vsanMasterUuid', undef, undef, 0],
   ['cmmdsMasterButNotStatsMaster', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanNodeNotMaster', 'vsanMasterUuid', 'cmmdsMasterButNotStatsMaster');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanSslVerifyCertFault;
our @ISA = qw(SSLVerifyFault);

our @property_list = (
   ['cert', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanSslVerifyCertFault', 'cert');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DevicePciId;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vendorId', undef, undef, 1],
   ['deviceId', undef, undef, 1],
   ['subVendorId', undef, undef, 1],
   ['subDeviceId', undef, undef, 1],
);


VIMRuntime::make_get_set('DevicePciId', 'vendorId', 'deviceId', 'subVendorId', 'subDeviceId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostSpbmDatastoreInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['datastoreUrl', undef, undef, 1],
   ['namespace', undef, undef, 1],
   ['defaultProfileId', undef, undef, 1],
);


VIMRuntime::make_get_set('HostSpbmDatastoreInfo', 'datastoreUrl', 'namespace', 'defaultProfileId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostSpbmHashInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['policyInfoHash', undef, undef, 1],
   ['datastoreInfoHash', undef, undef, 1],
);


VIMRuntime::make_get_set('HostSpbmHashInfo', 'policyInfoHash', 'datastoreInfoHash');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostSpbmPolicyBlobInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['policyBlob', undef, undef, 1],
   ['namespace', undef, undef, 1],
);


VIMRuntime::make_get_set('HostSpbmPolicyBlobInfo', 'policyBlob', 'namespace');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHostSpbmPolicyBlobInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HostSpbmPolicyBlobInfo', 'HostSpbmPolicyBlobInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHostSpbmPolicyBlobInfo', 'HostSpbmPolicyBlobInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostSpbmPolicyInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['profileId', undef, undef, 1],
   ['name', undef, undef, 1],
   ['description', undef, undef, 0],
   ['generationId', undef, undef, 1],
   ['policyBlobInfo', 'HostSpbmPolicyBlobInfo', 1, 1],
);


VIMRuntime::make_get_set('HostSpbmPolicyInfo', 'profileId', 'name', 'description', 'generationId', 'policyBlobInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LACPInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['dvsName', undef, undef, 1],
   ['lags', 'LAGInfo', 1, 0],
);


VIMRuntime::make_get_set('LACPInfo', 'dvsName', 'lags');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfLACPInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['LACPInfo', 'LACPInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfLACPInfo', 'LACPInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LAGInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['lagName', undef, undef, 1],
   ['groupState', undef, undef, 1],
   ['vnics', undef, 1, 0],
   ['uplinks', 'LAGUplinkInfo', 1, 0],
);


VIMRuntime::make_get_set('LAGInfo', 'lagName', 'groupState', 'vnics', 'uplinks');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfLAGInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['LAGInfo', 'LAGInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfLAGInfo', 'LAGInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LAGUplinkInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['uplinkName', undef, undef, 1],
   ['portState', undef, undef, 1],
   ['bundleState', undef, undef, 1],
);


VIMRuntime::make_get_set('LAGUplinkInfo', 'uplinkName', 'portState', 'bundleState');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfLAGUplinkInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['LAGUplinkInfo', 'LAGUplinkInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfLAGUplinkInfo', 'LAGUplinkInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PnicTSOInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['nicName', undef, undef, 1],
   ['isSupported', 'boolean', undef, 1],
   ['isEnabled', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('PnicTSOInfo', 'nicName', 'isSupported', 'isEnabled');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfPnicTSOInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['PnicTSOInfo', 'PnicTSOInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfPnicTSOInfo', 'PnicTSOInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VimHostVSANStretchedClusterHostCapability;
our @ISA = qw(DynamicData);

our @property_list = (
   ['featureVersion', undef, undef, 1],
);


VIMRuntime::make_get_set('VimHostVSANStretchedClusterHostCapability', 'featureVersion');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanBasicDeviceInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['deviceName', undef, undef, 1],
   ['pciId', undef, undef, 0],
   ['fwVersion', undef, undef, 0],
   ['features', undef, 1, 0],
);


VIMRuntime::make_get_set('VsanBasicDeviceInfo', 'deviceName', 'pciId', 'fwVersion', 'features');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanBasicDeviceInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanBasicDeviceInfo', 'VsanBasicDeviceInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanBasicDeviceInfo', 'VsanBasicDeviceInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterMembershipInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['clusterUuid', undef, undef, 0],
   ['health', undef, undef, 0],
   ['membershipUuid', undef, undef, 0],
   ['memberUuid', undef, 1, 0],
);


VIMRuntime::make_get_set('VsanClusterMembershipInfo', 'clusterUuid', 'health', 'membershipUuid', 'memberUuid');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanDaemonHealth;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['alive', 'boolean', undef, 1],
   ['error', 'LocalizedMethodFault', undef, 0],
);


VIMRuntime::make_get_set('VsanDaemonHealth', 'name', 'alive', 'error');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanDiskEncryptionHealth;
our @ISA = qw(DynamicData);

our @property_list = (
   ['diskHealth', 'VsanPhysicalDiskHealth', undef, 0],
   ['encryptionIssues', undef, 1, 0],
);


VIMRuntime::make_get_set('VsanDiskEncryptionHealth', 'diskHealth', 'encryptionIssues');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanDiskEncryptionHealth;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanDiskEncryptionHealth', 'VsanDiskEncryptionHealth', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanDiskEncryptionHealth', 'VsanDiskEncryptionHealth');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanDiskRebalanceResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['status', undef, undef, 1],
   ['bytesMoving', undef, undef, 0],
   ['remainingBytesToMove', undef, undef, 0],
   ['diskUsage', undef, undef, 0],
   ['maxDiskUsage', undef, undef, 0],
   ['minDiskUsage', undef, undef, 0],
   ['avgDiskUsage', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanDiskRebalanceResult', 'status', 'bytesMoving', 'remainingBytesToMove', 'diskUsage', 'maxDiskUsage', 'minDiskUsage', 'avgDiskUsage');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanDitEncryptionHealthSummary;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hostname', undef, undef, 0],
   ['health', undef, undef, 0],
   ['reason', 'LocalizableMessage', undef, 0],
   ['ditEncryptionInfo', 'VsanInTransitEncryptionInfo', undef, 0],
);


VIMRuntime::make_get_set('VsanDitEncryptionHealthSummary', 'hostname', 'health', 'reason', 'ditEncryptionInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanDitEncryptionHealthSummary;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanDitEncryptionHealthSummary', 'VsanDitEncryptionHealthSummary', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanDitEncryptionHealthSummary', 'VsanDitEncryptionHealthSummary');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanEncryptionHealthSummary;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hostname', undef, undef, 0],
   ['encryptionInfo', 'VsanHostEncryptionInfo', undef, 0],
   ['overallKmsHealth', undef, undef, 1],
   ['kmsHealth', 'VsanKmsHealth', 1, 0],
   ['encryptionIssues', undef, 1, 0],
   ['diskResults', 'VsanDiskEncryptionHealth', 1, 0],
   ['error', 'LocalizedMethodFault', undef, 0],
   ['aesniEnabled', 'boolean', undef, 0],
   ['inconsistentlyEncryptedObjectCount', undef, undef, 0],
   ['hostEncryptionDekId', undef, undef, 0],
   ['kekVerifierHealth', 'boolean', undef, 0],
   ['dekVerifierHealth', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanEncryptionHealthSummary', 'hostname', 'encryptionInfo', 'overallKmsHealth', 'kmsHealth', 'encryptionIssues', 'diskResults', 'error', 'aesniEnabled', 'inconsistentlyEncryptedObjectCount', 'hostEncryptionDekId', 'kekVerifierHealth', 'dekVerifierHealth');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanEncryptionHealthSummary;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanEncryptionHealthSummary', 'VsanEncryptionHealthSummary', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanEncryptionHealthSummary', 'VsanEncryptionHealthSummary');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanFailedRepairObjectResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['uuid', undef, undef, 1],
   ['errMessage', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanFailedRepairObjectResult', 'uuid', 'errMessage');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanFailedRepairObjectResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanFailedRepairObjectResult', 'VsanFailedRepairObjectResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanFailedRepairObjectResult', 'VsanFailedRepairObjectResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanFileServerHealthSummary;
our @ISA = qw(DynamicData);

our @property_list = (
   ['domainName', undef, undef, 0],
   ['fileServerIp', undef, undef, 0],
   ['nfsdHealth', undef, undef, 0],
   ['networkHealth', undef, undef, 0],
   ['rootfsHealth', undef, undef, 0],
   ['description', undef, undef, 0],
   ['smbConnections', undef, undef, 0],
   ['smbDaemonHealth', undef, undef, 0],
   ['adTestJoinHealth', undef, undef, 0],
   ['dnsLookupHealth', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanFileServerHealthSummary', 'domainName', 'fileServerIp', 'nfsdHealth', 'networkHealth', 'rootfsHealth', 'description', 'smbConnections', 'smbDaemonHealth', 'adTestJoinHealth', 'dnsLookupHealth');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanFileServerHealthSummary;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanFileServerHealthSummary', 'VsanFileServerHealthSummary', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanFileServerHealthSummary', 'VsanFileServerHealthSummary');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanFileServiceBalanceHealth;
our @ISA = qw(DynamicData);

our @property_list = (
   ['health', undef, undef, 0],
   ['description', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanFileServiceBalanceHealth', 'health', 'description');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanFileServiceHealthSummary;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hostname', undef, undef, 0],
   ['overallHealth', undef, undef, 0],
   ['enabled', 'boolean', undef, 0],
   ['vdfsdStatus', 'VsanResourceHealth', undef, 0],
   ['fsvmStatus', 'VsanResourceHealth', undef, 0],
   ['rootFsStatus', 'VsanFileServiceRootFsHealth', undef, 0],
   ['fileServerHealth', 'VsanFileServerHealthSummary', 1, 0],
   ['fileShareHealth', 'VsanFileServiceShareHealthSummary', 1, 0],
   ['balanceStatus', 'VsanFileServiceBalanceHealth', undef, 0],
);


VIMRuntime::make_get_set('VsanFileServiceHealthSummary', 'hostname', 'overallHealth', 'enabled', 'vdfsdStatus', 'fsvmStatus', 'rootFsStatus', 'fileServerHealth', 'fileShareHealth', 'balanceStatus');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanFileServiceHealthSummary;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanFileServiceHealthSummary', 'VsanFileServiceHealthSummary', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanFileServiceHealthSummary', 'VsanFileServiceHealthSummary');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanFileServiceRootFsHealth;
our @ISA = qw(DynamicData);

our @property_list = (
   ['created', 'boolean', undef, 0],
   ['health', undef, undef, 0],
   ['description', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanFileServiceRootFsHealth', 'created', 'health', 'description');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanFileServiceShareHealthSummary;
our @ISA = qw(DynamicData);

our @property_list = (
   ['overallHealth', undef, undef, 0],
   ['domainName', undef, undef, 0],
   ['shareUuid', undef, undef, 0],
   ['shareName', undef, undef, 0],
   ['objectHealth', 'VsanObjectOverallHealth', undef, 0],
   ['description', undef, undef, 0],
   ['extensible', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanFileServiceShareHealthSummary', 'overallHealth', 'domainName', 'shareUuid', 'shareName', 'objectHealth', 'description', 'extensible');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanFileServiceShareHealthSummary;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanFileServiceShareHealthSummary', 'VsanFileServiceShareHealthSummary', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanFileServiceShareHealthSummary', 'VsanFileServiceShareHealthSummary');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHclCommonDeviceInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['deviceName', undef, undef, 1],
   ['displayName', undef, undef, 0],
   ['driverName', undef, undef, 0],
   ['driverVersion', undef, undef, 0],
   ['vendorId', undef, undef, 0],
   ['deviceId', undef, undef, 0],
   ['subVendorId', undef, undef, 0],
   ['subDeviceId', undef, undef, 0],
   ['extraInfo', 'KeyValue', 1, 0],
   ['deviceOnHcl', 'boolean', undef, 0],
   ['releaseSupported', 'boolean', undef, 0],
   ['releasesOnHcl', undef, 1, 0],
   ['driverVersionsOnHcl', undef, 1, 0],
   ['driverVersionSupported', 'boolean', undef, 0],
   ['fwVersionSupported', 'boolean', undef, 0],
   ['fwVersionOnHcl', undef, 1, 0],
   ['fwVersion', undef, undef, 0],
   ['driversOnHcl', 'VsanHclDriverInfo', 1, 0],
);


VIMRuntime::make_get_set('VsanHclCommonDeviceInfo', 'deviceName', 'displayName', 'driverName', 'driverVersion', 'vendorId', 'deviceId', 'subVendorId', 'subDeviceId', 'extraInfo', 'deviceOnHcl', 'releaseSupported', 'releasesOnHcl', 'driverVersionsOnHcl', 'driverVersionSupported', 'fwVersionSupported', 'fwVersionOnHcl', 'fwVersion', 'driversOnHcl');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHclComputeResource;
our @ISA = qw(DynamicData);

our @property_list = (
   ['memory', 'VsanHclMemInfo', undef, 1],
);


VIMRuntime::make_get_set('VsanHclComputeResource', 'memory');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHclControllerInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['deviceName', undef, undef, 1],
   ['deviceDisplayName', undef, undef, 0],
   ['driverName', undef, undef, 0],
   ['driverVersion', undef, undef, 0],
   ['vendorId', undef, undef, 0],
   ['deviceId', undef, undef, 0],
   ['subVendorId', undef, undef, 0],
   ['subDeviceId', undef, undef, 0],
   ['extraInfo', 'KeyValue', 1, 0],
   ['deviceOnHcl', 'boolean', undef, 0],
   ['releaseSupported', 'boolean', undef, 0],
   ['releasesOnHcl', undef, 1, 0],
   ['driverVersionsOnHcl', undef, 1, 0],
   ['driverVersionSupported', 'boolean', undef, 0],
   ['fwVersionSupported', 'boolean', undef, 0],
   ['fwVersionOnHcl', undef, 1, 0],
   ['cacheConfigSupported', 'boolean', undef, 0],
   ['cacheConfigOnHcl', undef, 1, 0],
   ['raidConfigSupported', 'boolean', undef, 0],
   ['raidConfigOnHcl', undef, 1, 0],
   ['fwVersion', undef, undef, 0],
   ['raidConfig', undef, undef, 0],
   ['cacheConfig', undef, undef, 0],
   ['cimProviderInfo', 'VsanHostCimProviderInfo', undef, 0],
   ['usedByVsan', 'boolean', undef, 0],
   ['disks', 'VsanHclDiskInfo', 1, 0],
   ['issues', 'LocalizedMethodFault', 1, 0],
   ['remediableIssues', undef, 1, 0],
   ['driversOnHcl', 'VsanHclDriverInfo', 1, 0],
   ['fwAuxVersion', undef, undef, 0],
   ['queueDepth', undef, undef, 0],
   ['queueDepthOnHcl', undef, undef, 0],
   ['queueDepthSupported', 'boolean', undef, 0],
   ['diskMode', undef, undef, 0],
   ['diskModeOnHcl', undef, 1, 0],
   ['diskModeSupported', 'boolean', undef, 0],
   ['toolName', undef, undef, 0],
   ['toolVersion', undef, undef, 0],
   ['productId', undef, undef, 0],
   ['diskCapacity', undef, undef, 0],
   ['vcgEntryInfo', 'VsanVcgDeviceInfo', 1, 0],
   ['controllerType', undef, undef, 0],
   ['userSelectedVcgId', undef, undef, 0],
   ['vsanCompatibility', undef, 1, 0],
);


VIMRuntime::make_get_set('VsanHclControllerInfo', 'deviceName', 'deviceDisplayName', 'driverName', 'driverVersion', 'vendorId', 'deviceId', 'subVendorId', 'subDeviceId', 'extraInfo', 'deviceOnHcl', 'releaseSupported', 'releasesOnHcl', 'driverVersionsOnHcl', 'driverVersionSupported', 'fwVersionSupported', 'fwVersionOnHcl', 'cacheConfigSupported', 'cacheConfigOnHcl', 'raidConfigSupported', 'raidConfigOnHcl', 'fwVersion', 'raidConfig', 'cacheConfig', 'cimProviderInfo', 'usedByVsan', 'disks', 'issues', 'remediableIssues', 'driversOnHcl', 'fwAuxVersion', 'queueDepth', 'queueDepthOnHcl', 'queueDepthSupported', 'diskMode', 'diskModeOnHcl', 'diskModeSupported', 'toolName', 'toolVersion', 'productId', 'diskCapacity', 'vcgEntryInfo', 'controllerType', 'userSelectedVcgId', 'vsanCompatibility');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanHclControllerInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanHclControllerInfo', 'VsanHclControllerInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanHclControllerInfo', 'VsanHclControllerInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHclDiskInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['deviceName', undef, undef, 1],
   ['model', undef, undef, 0],
   ['isSsd', 'boolean', undef, 0],
   ['vsanDisk', 'boolean', undef, 1],
   ['issues', 'LocalizedMethodFault', 1, 0],
   ['remediableIssues', undef, 1, 0],
   ['uuid', undef, undef, 0],
   ['capacity', undef, undef, 0],
   ['vsanCompatibility', undef, 1, 0],
);


VIMRuntime::make_get_set('VsanHclDiskInfo', 'deviceName', 'model', 'isSsd', 'vsanDisk', 'issues', 'remediableIssues', 'uuid', 'capacity', 'vsanCompatibility');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanHclDiskInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanHclDiskInfo', 'VsanHclDiskInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanHclDiskInfo', 'VsanHclDiskInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHclFirmwareFile;
our @ISA = qw(DynamicData);

our @property_list = (
   ['fileType', undef, undef, 1],
   ['filenameOrUrl', undef, undef, 1],
   ['sha1sum', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanHclFirmwareFile', 'fileType', 'filenameOrUrl', 'sha1sum');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanHclFirmwareFile;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanHclFirmwareFile', 'VsanHclFirmwareFile', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanHclFirmwareFile', 'VsanHclFirmwareFile');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHclFirmwareUpdateSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['hbaDevice', undef, undef, 1],
   ['fwFiles', 'VsanHclFirmwareFile', 1, 1],
   ['allowDowngrade', 'boolean', undef, 0],
   ['firmwareComponent', 'VsanHostFwComponent', 1, 0],
);


VIMRuntime::make_get_set('VsanHclFirmwareUpdateSpec', 'host', 'hbaDevice', 'fwFiles', 'allowDowngrade', 'firmwareComponent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanHclFirmwareUpdateSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanHclFirmwareUpdateSpec', 'VsanHclFirmwareUpdateSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanHclFirmwareUpdateSpec', 'VsanHclFirmwareUpdateSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHclMemInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['memorySize', undef, undef, 0],
   ['vsanHostCompatibility', undef, 1, 0],
);


VIMRuntime::make_get_set('VsanHclMemInfo', 'memorySize', 'vsanHostCompatibility');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHclNicInfo;
our @ISA = qw(VsanHclCommonDeviceInfo);

our @property_list = (
   ['vmknic', undef, undef, 0],
   ['useByVsan', 'boolean', undef, 0],
   ['rdmaConfig', 'VsanNicRdmaInfo', undef, 0],
   ['vsanHostCompatibility', undef, 1, 0],
   ['nicLinkSpeedInMbps', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanHclNicInfo', 'vmknic', 'useByVsan', 'rdmaConfig', 'vsanHostCompatibility', 'nicLinkSpeedInMbps');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanHclNicInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanHclNicInfo', 'VsanHclNicInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanHclNicInfo', 'VsanHclNicInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHealthQuerySpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['includeAllRemoteClusters', 'boolean', undef, 0],
   ['remoteClusterUuids', undef, 1, 0],
   ['latencyOnly', 'boolean', undef, 0],
   ['mode', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanHealthQuerySpec', 'includeAllRemoteClusters', 'remoteClusterUuids', 'latencyOnly', 'mode');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostCimProviderInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['cimProviderSupported', 'boolean', undef, 0],
   ['installedCIMProvider', undef, undef, 0],
   ['cimProviderOnHcl', undef, 1, 0],
   ['cimProviderLinksOnHcl', 'VsanDownloadItem', 1, 0],
);


VIMRuntime::make_get_set('VsanHostCimProviderInfo', 'cimProviderSupported', 'installedCIMProvider', 'cimProviderOnHcl', 'cimProviderLinksOnHcl');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostEMMSummary;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hostname', undef, undef, 0],
   ['inMaintenanceMode', 'boolean', undef, 0],
   ['inDecomState', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanHostEMMSummary', 'hostname', 'inMaintenanceMode', 'inDecomState');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostFwComponent;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['url', undef, undef, 0],
   ['sha1sum', undef, undef, 0],
   ['currentVersion', undef, undef, 0],
   ['suggestedVersion', undef, undef, 0],
   ['componentID', undef, 1, 0],
);


VIMRuntime::make_get_set('VsanHostFwComponent', 'name', 'url', 'sha1sum', 'currentVersion', 'suggestedVersion', 'componentID');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanHostFwComponent;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanHostFwComponent', 'VsanHostFwComponent', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanHostFwComponent', 'VsanHostFwComponent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostHclInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hostname', undef, undef, 1],
   ['hclChecked', 'boolean', undef, 1],
   ['releaseName', undef, undef, 0],
   ['error', 'LocalizedMethodFault', undef, 0],
   ['controllers', 'VsanHclControllerInfo', 1, 0],
   ['pnics', 'VsanHclNicInfo', 1, 0],
   ['host', 'ManagedObjectReference', undef, 0],
   ['computeResource', 'VsanHclComputeResource', undef, 0],
   ['vsanHostCompatibility', undef, 1, 0],
);


VIMRuntime::make_get_set('VsanHostHclInfo', 'hostname', 'hclChecked', 'releaseName', 'error', 'controllers', 'pnics', 'host', 'computeResource', 'vsanHostCompatibility');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanHostHclInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanHostHclInfo', 'VsanHostHclInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanHostHclInfo', 'VsanHostHclInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostHealthSystemStatusResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hostname', undef, undef, 1],
   ['status', undef, undef, 1],
   ['issues', undef, 1, 0],
);


VIMRuntime::make_get_set('VsanHostHealthSystemStatusResult', 'hostname', 'status', 'issues');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanHostHealthSystemStatusResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanHostHealthSystemStatusResult', 'VsanHostHealthSystemStatusResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanHostHealthSystemStatusResult', 'VsanHostHealthSystemStatusResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostHwDeviceId;
our @ISA = qw(DynamicData);

our @property_list = (
   ['pciId', 'DevicePciId', undef, 1],
   ['productId', undef, undef, 0],
   ['diskCapacity', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanHostHwDeviceId', 'pciId', 'productId', 'diskCapacity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostIoInsightInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['ioinsightWorldId', undef, undef, 0],
   ['faultMessage', undef, undef, 0],
   ['ioinsightInfo', 'VsanIoInsightInfo', undef, 0],
);


VIMRuntime::make_get_set('VsanHostIoInsightInfo', 'host', 'ioinsightWorldId', 'faultMessage', 'ioinsightInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanHostIoInsightInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanHostIoInsightInfo', 'VsanHostIoInsightInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanHostIoInsightInfo', 'VsanHostIoInsightInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostQueryCheckLimitsSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['optionTypes', undef, 1, 0],
   ['fetchAll', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('VsanHostQueryCheckLimitsSpec', 'optionTypes', 'fetchAll');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostReference;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hostname', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanHostReference', 'hostname');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostVirtualApplianceInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hostKey', 'ManagedObjectReference', undef, 1],
   ['isVirtualApp', 'boolean', undef, 1],
   ['isDeployedFromOVF', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanHostVirtualApplianceInfo', 'hostKey', 'isVirtualApp', 'isDeployedFromOVF');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanHostVirtualApplianceInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanHostVirtualApplianceInfo', 'VsanHostVirtualApplianceInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanHostVirtualApplianceInfo', 'VsanHostVirtualApplianceInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostVmdkLoadTestResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hostname', undef, undef, 1],
   ['issueFound', 'boolean', undef, 1],
   ['faultMessage', undef, undef, 0],
   ['vmdkResults', 'VsanVmdkLoadTestResult', 1, 0],
);


VIMRuntime::make_get_set('VsanHostVmdkLoadTestResult', 'hostname', 'issueFound', 'faultMessage', 'vmdkResults');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanHostVmdkLoadTestResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanHostVmdkLoadTestResult', 'VsanHostVmdkLoadTestResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanHostVmdkLoadTestResult', 'VsanHostVmdkLoadTestResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHwToVcgInfoMapping;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vsanHostHwDeviceId', 'VsanHostHwDeviceId', undef, 1],
   ['vcgId', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanHwToVcgInfoMapping', 'vsanHostHwDeviceId', 'vcgId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanHwToVcgInfoMapping;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanHwToVcgInfoMapping', 'VsanHwToVcgInfoMapping', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanHwToVcgInfoMapping', 'VsanHwToVcgInfoMapping');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanIoInsightInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['state', undef, undef, 0],
   ['monitoredVMs', 'ManagedObjectReference', 1, 0],
);


VIMRuntime::make_get_set('VsanIoInsightInfo', 'state', 'monitoredVMs');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanIperfClientSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['Reverse', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('VsanIperfClientSpec', 'Reverse');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanKmsHealth;
our @ISA = qw(DynamicData);

our @property_list = (
   ['serverName', undef, undef, 1],
   ['health', undef, undef, 1],
   ['error', 'LocalizedMethodFault', undef, 0],
   ['trustHealth', undef, undef, 0],
   ['certHealth', undef, undef, 0],
   ['certExpireDate', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanKmsHealth', 'serverName', 'health', 'error', 'trustHealth', 'certHealth', 'certExpireDate');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanKmsHealth;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanKmsHealth', 'VsanKmsHealth', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanKmsHealth', 'VsanKmsHealth');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanLimitHealthResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hostname', undef, undef, 0],
   ['issueFound', 'boolean', undef, 1],
   ['maxComponents', undef, undef, 1],
   ['freeComponents', undef, undef, 1],
   ['componentLimitHealth', undef, undef, 1],
   ['lowestFreeDiskSpacePct', undef, undef, 1],
   ['usedDiskSpaceB', undef, undef, 1],
   ['totalDiskSpaceB', undef, undef, 1],
   ['diskFreeSpaceHealth', undef, undef, 1],
   ['reservedRcSizeB', undef, undef, 1],
   ['totalRcSizeB', undef, undef, 1],
   ['rcFreeReservationHealth', undef, undef, 1],
   ['totalLogicalSpaceB', undef, undef, 0],
   ['logicalSpaceUsedB', undef, undef, 0],
   ['dedupMetadataSizeB', undef, undef, 0],
   ['diskTransientCapacityUsedB', undef, undef, 0],
   ['dgTransientCapacityUsedB', undef, undef, 0],
   ['slackSpaceCapRequired', undef, undef, 0],
   ['resyncPauseThreshold', undef, undef, 0],
   ['spaceEfficiencyMetadataSizeB', 'VsanSpaceEfficiencyMetadataSize', undef, 0],
   ['hostRebuildCapacity', undef, undef, 0],
   ['minSpaceRequiredForVsanOp', undef, undef, 0],
   ['enforceCapResrvSpace', undef, undef, 0],
   ['cdReservedSizeB', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanLimitHealthResult', 'hostname', 'issueFound', 'maxComponents', 'freeComponents', 'componentLimitHealth', 'lowestFreeDiskSpacePct', 'usedDiskSpaceB', 'totalDiskSpaceB', 'diskFreeSpaceHealth', 'reservedRcSizeB', 'totalRcSizeB', 'rcFreeReservationHealth', 'totalLogicalSpaceB', 'logicalSpaceUsedB', 'dedupMetadataSizeB', 'diskTransientCapacityUsedB', 'dgTransientCapacityUsedB', 'slackSpaceCapRequired', 'resyncPauseThreshold', 'spaceEfficiencyMetadataSizeB', 'hostRebuildCapacity', 'minSpaceRequiredForVsanOp', 'enforceCapResrvSpace', 'cdReservedSizeB');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanLimitHealthResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanLimitHealthResult', 'VsanLimitHealthResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanLimitHealthResult', 'VsanLimitHealthResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanNetworkDiagnosticsHealthInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vnicInfo', 'HostVirtualNic', 1, 0],
   ['pnicTSOInfo', 'PnicTSOInfo', 1, 0],
   ['LACPInfo', 'LACPInfo', 1, 0],
);


VIMRuntime::make_get_set('VsanNetworkDiagnosticsHealthInfo', 'vnicInfo', 'pnicTSOInfo', 'LACPInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanNetworkHealthResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 0],
   ['hostname', undef, undef, 0],
   ['vsanVmknicPresent', 'boolean', undef, 0],
   ['ipSubnets', undef, 1, 0],
   ['issueFound', 'boolean', undef, 0],
   ['peerHealth', 'VsanNetworkPeerHealthResult', 1, 0],
   ['vMotionHealth', 'VsanNetworkPeerHealthResult', 1, 0],
   ['multicastConfig', undef, undef, 0],
   ['unicastConfig', undef, undef, 0],
   ['inUnicast', 'boolean', undef, 0],
   ['rdmaEnabled', 'boolean', undef, 0],
   ['rdtConnProtocol', undef, undef, 0],
   ['serverClusters', 'VsanServerClusterInfo', 1, 0],
);


VIMRuntime::make_get_set('VsanNetworkHealthResult', 'host', 'hostname', 'vsanVmknicPresent', 'ipSubnets', 'issueFound', 'peerHealth', 'vMotionHealth', 'multicastConfig', 'unicastConfig', 'inUnicast', 'rdmaEnabled', 'rdtConnProtocol', 'serverClusters');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanNetworkHealthResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanNetworkHealthResult', 'VsanNetworkHealthResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanNetworkHealthResult', 'VsanNetworkHealthResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanNetworkLoadTestResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hostname', undef, undef, 1],
   ['status', undef, undef, 0],
   ['client', 'boolean', undef, 1],
   ['bandwidthBps', undef, undef, 1],
   ['totalBytes', undef, undef, 1],
   ['lostDatagrams', undef, undef, 0],
   ['lossPct', undef, undef, 0],
   ['sentDatagrams', undef, undef, 0],
   ['jitterMs', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanNetworkLoadTestResult', 'hostname', 'status', 'client', 'bandwidthBps', 'totalBytes', 'lostDatagrams', 'lossPct', 'sentDatagrams', 'jitterMs');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanNetworkLoadTestResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanNetworkLoadTestResult', 'VsanNetworkLoadTestResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanNetworkLoadTestResult', 'VsanNetworkLoadTestResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanNetworkPeerHealthResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['peer', undef, undef, 0],
   ['peerHostname', undef, undef, 0],
   ['peerVmknicName', undef, undef, 0],
   ['smallPingTestSuccessPct', undef, undef, 0],
   ['largePingTestSuccessPct', undef, undef, 0],
   ['maxLatencyUs', undef, undef, 0],
   ['onSameIpSubnet', 'boolean', undef, 0],
   ['sourceVmknicName', undef, undef, 0],
   ['connectivityHealthState', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanNetworkPeerHealthResult', 'peer', 'peerHostname', 'peerVmknicName', 'smallPingTestSuccessPct', 'largePingTestSuccessPct', 'maxLatencyUs', 'onSameIpSubnet', 'sourceVmknicName', 'connectivityHealthState');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanNetworkPeerHealthResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanNetworkPeerHealthResult', 'VsanNetworkPeerHealthResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanNetworkPeerHealthResult', 'VsanNetworkPeerHealthResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanNicRdmaInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['rdmaCapable', 'boolean', undef, 0],
   ['rdmaProtocolCapable', undef, undef, 0],
   ['dcbEnabled', 'boolean', undef, 0],
   ['dcbMode', undef, undef, 0],
   ['pfcEnabled', 'boolean', undef, 0],
   ['pfcConfig', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanNicRdmaInfo', 'rdmaCapable', 'rdmaProtocolCapable', 'dcbEnabled', 'dcbMode', 'pfcEnabled', 'pfcConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanObjectHealth;
our @ISA = qw(DynamicData);

our @property_list = (
   ['numObjects', undef, undef, 1],
   ['health', undef, undef, 0],
   ['objUuids', undef, 1, 0],
   ['vsanClusterUuid', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanObjectHealth', 'numObjects', 'health', 'objUuids', 'vsanClusterUuid');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanObjectHealth;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanObjectHealth', 'VsanObjectHealth', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanObjectHealth', 'VsanObjectHealth');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanObjectOverallHealth;
our @ISA = qw(DynamicData);

our @property_list = (
   ['objectHealthDetail', 'VsanObjectHealth', 1, 0],
   ['objectsComplianceDetail', 'VsanStorageComplianceResult', 1, 0],
   ['objectVersionCompliance', 'boolean', undef, 0],
   ['objectFormatChangeRequiredUuids', undef, 1, 0],
   ['objectsRelayoutBytes', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanObjectOverallHealth', 'objectHealthDetail', 'objectsComplianceDetail', 'objectVersionCompliance', 'objectFormatChangeRequiredUuids', 'objectsRelayoutBytes');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanPhysicalDiskHealth;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['uuid', undef, undef, 1],
   ['inCmmds', 'boolean', undef, 1],
   ['inVsi', 'boolean', undef, 1],
   ['dedupScope', undef, undef, 0],
   ['formatVersion', undef, undef, 0],
   ['isAllFlash', undef, undef, 0],
   ['congestionValue', undef, undef, 0],
   ['congestionArea', undef, undef, 0],
   ['congestionHealth', undef, undef, 0],
   ['metadataHealth', undef, undef, 0],
   ['operationalHealthDescription', undef, undef, 0],
   ['operationalHealth', undef, undef, 0],
   ['dedupUsageHealth', undef, undef, 0],
   ['capacityHealth', undef, undef, 0],
   ['summaryHealth', undef, undef, 1],
   ['capacity', undef, undef, 0],
   ['usedCapacity', undef, undef, 0],
   ['reservedCapacity', undef, undef, 0],
   ['totalBytes', undef, undef, 0],
   ['freeBytes', undef, undef, 0],
   ['hashedBytes', undef, undef, 0],
   ['dedupedBytes', undef, undef, 0],
   ['scsiDisk', 'HostScsiDisk', undef, 0],
   ['usedComponents', undef, undef, 0],
   ['maxComponents', undef, undef, 0],
   ['compLimitHealth', undef, undef, 0],
   ['encryptionEnabled', 'boolean', undef, 0],
   ['kmsProviderId', undef, undef, 0],
   ['kekId', undef, undef, 0],
   ['dekGenerationId', undef, undef, 0],
   ['encryptedUnlocked', 'boolean', undef, 0],
   ['rebalanceResult', 'VsanDiskRebalanceResult', undef, 0],
   ['dekId', undef, undef, 0],
   ['kekVerifierHealth', 'boolean', undef, 0],
   ['dekVerifierHealth', 'boolean', undef, 0],
   ['logicalCapacity', undef, undef, 0],
   ['logicalCapacityUsed', undef, undef, 0],
   ['logicalCapacityHealth', undef, undef, 0],
   ['vsanDiskGroupUuid', undef, undef, 0],
   ['dgLayoutIssue', 'boolean', undef, 0],
   ['usedMetadataComponents', undef, undef, 0],
   ['maxMetadataComponents', undef, undef, 0],
   ['pendingClusterDekId', undef, undef, 0],
   ['dmekVerifierHealth', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanPhysicalDiskHealth', 'name', 'uuid', 'inCmmds', 'inVsi', 'dedupScope', 'formatVersion', 'isAllFlash', 'congestionValue', 'congestionArea', 'congestionHealth', 'metadataHealth', 'operationalHealthDescription', 'operationalHealth', 'dedupUsageHealth', 'capacityHealth', 'summaryHealth', 'capacity', 'usedCapacity', 'reservedCapacity', 'totalBytes', 'freeBytes', 'hashedBytes', 'dedupedBytes', 'scsiDisk', 'usedComponents', 'maxComponents', 'compLimitHealth', 'encryptionEnabled', 'kmsProviderId', 'kekId', 'dekGenerationId', 'encryptedUnlocked', 'rebalanceResult', 'dekId', 'kekVerifierHealth', 'dekVerifierHealth', 'logicalCapacity', 'logicalCapacityUsed', 'logicalCapacityHealth', 'vsanDiskGroupUuid', 'dgLayoutIssue', 'usedMetadataComponents', 'maxMetadataComponents', 'pendingClusterDekId', 'dmekVerifierHealth');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanPhysicalDiskHealth;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanPhysicalDiskHealth', 'VsanPhysicalDiskHealth', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanPhysicalDiskHealth', 'VsanPhysicalDiskHealth');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanPhysicalDiskHealthSummary;
our @ISA = qw(DynamicData);

our @property_list = (
   ['overallHealth', undef, undef, 1],
   ['heapsWithIssues', 'VsanResourceHealth', 1, 0],
   ['slabsWithIssues', 'VsanResourceHealth', 1, 0],
   ['disks', 'VsanPhysicalDiskHealth', 1, 0],
   ['componentsWithIssues', 'VsanResourceHealth', 1, 0],
   ['hostname', undef, undef, 0],
   ['hostDedupScope', undef, undef, 0],
   ['error', 'LocalizedMethodFault', undef, 0],
);


VIMRuntime::make_get_set('VsanPhysicalDiskHealthSummary', 'overallHealth', 'heapsWithIssues', 'slabsWithIssues', 'disks', 'componentsWithIssues', 'hostname', 'hostDedupScope', 'error');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanPhysicalDiskHealthSummary;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanPhysicalDiskHealthSummary', 'VsanPhysicalDiskHealthSummary', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanPhysicalDiskHealthSummary', 'VsanPhysicalDiskHealthSummary');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanProactiveRebalanceInfoEx;
our @ISA = qw(DynamicData);

our @property_list = (
   ['running', 'boolean', undef, 0],
   ['startTs', undef, undef, 0],
   ['stopTs', undef, undef, 0],
   ['varianceThreshold', undef, undef, 0],
   ['timeThreshold', undef, undef, 0],
   ['rateThreshold', undef, undef, 0],
   ['hostname', undef, undef, 0],
   ['error', 'LocalizedMethodFault', undef, 0],
);


VIMRuntime::make_get_set('VsanProactiveRebalanceInfoEx', 'running', 'startTs', 'stopTs', 'varianceThreshold', 'timeThreshold', 'rateThreshold', 'hostname', 'error');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanQueryResultHostInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['uuid', undef, undef, 0],
   ['hostnameInCmmds', undef, undef, 0],
   ['vsanIpv4Addresses', undef, 1, 0],
);


VIMRuntime::make_get_set('VsanQueryResultHostInfo', 'uuid', 'hostnameInCmmds', 'vsanIpv4Addresses');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanQueryResultHostInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanQueryResultHostInfo', 'VsanQueryResultHostInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanQueryResultHostInfo', 'VsanQueryResultHostInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanRepairObjectsResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['inQueueObjects', undef, 1, 0],
   ['failedRepairObjects', 'VsanFailedRepairObjectResult', 1, 0],
   ['notInQueueObjects', undef, 1, 0],
);


VIMRuntime::make_get_set('VsanRepairObjectsResult', 'inQueueObjects', 'failedRepairObjects', 'notInQueueObjects');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanResourceHealth;
our @ISA = qw(DynamicData);

our @property_list = (
   ['resource', undef, undef, 1],
   ['health', undef, undef, 1],
   ['description', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanResourceHealth', 'resource', 'health', 'description');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanResourceHealth;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanResourceHealth', 'VsanResourceHealth', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanResourceHealth', 'VsanResourceHealth');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanServerClusterInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['cluster', 'ManagedObjectReference', undef, 0],
   ['peerHealth', 'VsanNetworkPeerHealthResult', 1, 0],
   ['membership', 'VsanClusterMembershipInfo', undef, 0],
);


VIMRuntime::make_get_set('VsanServerClusterInfo', 'cluster', 'peerHealth', 'membership');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanServerClusterInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanServerClusterInfo', 'VsanServerClusterInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanServerClusterInfo', 'VsanServerClusterInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanSmartDiskStats;
our @ISA = qw(DynamicData);

our @property_list = (
   ['disk', undef, undef, 1],
   ['stats', 'VsanSmartParameter', 1, 0],
   ['error', 'LocalizedMethodFault', undef, 0],
);


VIMRuntime::make_get_set('VsanSmartDiskStats', 'disk', 'stats', 'error');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanSmartDiskStats;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanSmartDiskStats', 'VsanSmartDiskStats', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanSmartDiskStats', 'VsanSmartDiskStats');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanSmartParameter;
our @ISA = qw(DynamicData);

our @property_list = (
   ['parameter', undef, undef, 0],
   ['value', undef, undef, 0],
   ['threshold', undef, undef, 0],
   ['worst', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanSmartParameter', 'parameter', 'value', 'threshold', 'worst');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanSmartParameter;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanSmartParameter', 'VsanSmartParameter', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanSmartParameter', 'VsanSmartParameter');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanSmartStatsHostSummary;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hostname', undef, undef, 0],
   ['smartStats', 'VsanSmartDiskStats', 1, 0],
);


VIMRuntime::make_get_set('VsanSmartStatsHostSummary', 'hostname', 'smartStats');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanSmartStatsHostSummary;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanSmartStatsHostSummary', 'VsanSmartStatsHostSummary', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanSmartStatsHostSummary', 'VsanSmartStatsHostSummary');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanVcgDeviceInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vcgId', undef, undef, 1],
   ['vcgModelName', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanVcgDeviceInfo', 'vcgId', 'vcgModelName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanVcgDeviceInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanVcgDeviceInfo', 'VsanVcgDeviceInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanVcgDeviceInfo', 'VsanVcgDeviceInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanVmdkIOLoadSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['readPct', undef, undef, 1],
   ['oio', undef, undef, 1],
   ['iosizeB', undef, undef, 1],
   ['dataSizeMb', undef, undef, 1],
   ['random', 'boolean', undef, 1],
   ['startOffsetB', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanVmdkIOLoadSpec', 'readPct', 'oio', 'iosizeB', 'dataSizeMb', 'random', 'startOffsetB');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanVmdkIOLoadSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanVmdkIOLoadSpec', 'VsanVmdkIOLoadSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanVmdkIOLoadSpec', 'VsanVmdkIOLoadSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanVmdkLoadTestResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['success', 'boolean', undef, 1],
   ['faultMessage', undef, undef, 0],
   ['spec', 'VsanVmdkLoadTestSpec', undef, 1],
   ['actualDurationSec', undef, undef, 0],
   ['totalBytes', undef, undef, 0],
   ['iops', undef, undef, 0],
   ['tputBps', undef, undef, 0],
   ['avgLatencyUs', undef, undef, 0],
   ['maxLatencyUs', undef, undef, 0],
   ['numIoAboveLatencyThreshold', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanVmdkLoadTestResult', 'success', 'faultMessage', 'spec', 'actualDurationSec', 'totalBytes', 'iops', 'tputBps', 'avgLatencyUs', 'maxLatencyUs', 'numIoAboveLatencyThreshold');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanVmdkLoadTestResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanVmdkLoadTestResult', 'VsanVmdkLoadTestResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanVmdkLoadTestResult', 'VsanVmdkLoadTestResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanVmdkLoadTestSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vmdkCreateSpec', 'FileBackedVirtualDiskSpec', undef, 0],
   ['vmdkIOSpec', 'VsanVmdkIOLoadSpec', undef, 0],
   ['vmdkIOSpecSequence', 'VsanVmdkIOLoadSpec', 1, 0],
   ['stepDurationSec', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanVmdkLoadTestSpec', 'vmdkCreateSpec', 'vmdkIOSpec', 'vmdkIOSpecSequence', 'stepDurationSec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanVmdkLoadTestSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanVmdkLoadTestSpec', 'VsanVmdkLoadTestSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanVmdkLoadTestSpec', 'VsanVmdkLoadTestSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanVsanPcapResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['calltime', undef, undef, 1],
   ['vmknic', undef, undef, 1],
   ['tcpdumpFilter', undef, undef, 1],
   ['snaplen', undef, undef, 1],
   ['pkts', undef, 1, 0],
   ['pcap', undef, undef, 0],
   ['error', 'LocalizedMethodFault', undef, 0],
   ['hostname', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanVsanPcapResult', 'calltime', 'vmknic', 'tcpdumpFilter', 'snaplen', 'pkts', 'pcap', 'error', 'hostname');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanVsanPcapResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanVsanPcapResult', 'VsanVsanPcapResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanVsanPcapResult', 'VsanVsanPcapResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ActiveVsanDirectoryServerConfig;
our @ISA = qw(VsanDirectoryServerConfig);

our @property_list = (
   ['activeDirectoryDomainName', undef, undef, 0],
   ['username', undef, undef, 0],
   ['password', undef, undef, 0],
   ['organizationalUnit', undef, undef, 0],
   ['preferredADServers', undef, 1, 0],
);


VIMRuntime::make_get_set('ActiveVsanDirectoryServerConfig', 'activeDirectoryDomainName', 'username', 'password', 'organizationalUnit', 'preferredADServers');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanAdvancedDatastoreConfig;
our @ISA = qw(VsanDatastoreConfig);

our @property_list = (
   ['remoteDatastores', 'ManagedObjectReference', 1, 0],
);


VIMRuntime::make_get_set('VsanAdvancedDatastoreConfig', 'remoteDatastores');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanCapacityReservationInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hostRebuildThreshold', undef, undef, 0],
   ['vsanOpSpaceThreshold', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanCapacityReservationInfo', 'hostRebuildThreshold', 'vsanOpSpaceThreshold');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClientDatastoreConfig;
our @ISA = qw(VsanDatastoreSpec);

our @property_list = (
   ['clusters', 'ManagedObjectReference', 1, 1],
);


VIMRuntime::make_get_set('VsanClientDatastoreConfig', 'clusters');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterConfigPrecheckItem;
our @ISA = qw(ClusterComputeResourceValidationResultBase);

our @property_list = (
   ['status', undef, undef, 1],
   ['description', 'LocalizableMessage', undef, 0],
);


VIMRuntime::make_get_set('VsanClusterConfigPrecheckItem', 'status', 'description');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterRuntimeInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['clusterUuid', undef, undef, 1],
   ['totalComponentsCount', undef, undef, 1],
   ['cluster', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('ClusterRuntimeInfo', 'clusterUuid', 'totalComponentsCount', 'cluster');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterRuntimeInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterRuntimeInfo', 'ClusterRuntimeInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterRuntimeInfo', 'ClusterRuntimeInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanCompatibilityCheckResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['status', undef, undef, 1],
   ['message', 'LocalizableMessage', undef, 0],
);


VIMRuntime::make_get_set('VsanCompatibilityCheckResult', 'status', 'message');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanConfigInfoEx;
our @ISA = qw(VsanClusterConfigInfo);

our @property_list = (
   ['dataEfficiencyConfig', 'VsanDataEfficiencyConfig', undef, 0],
   ['resyncIopsLimitConfig', 'ResyncIopsInfo', undef, 0],
   ['iscsiConfig', 'VsanIscsiTargetServiceConfig', undef, 0],
   ['dataEncryptionConfig', 'VsanDataEncryptionConfig', undef, 0],
   ['extendedConfig', 'VsanExtendedConfig', undef, 0],
   ['datastoreConfig', 'VsanDatastoreConfig', undef, 0],
   ['perfsvcConfig', 'VsanPerfsvcConfig', undef, 0],
   ['unmapConfig', 'VsanUnmapConfig', undef, 0],
   ['vumConfig', 'VsanVumConfig', undef, 0],
   ['fileServiceConfig', 'VsanFileServiceConfig', undef, 0],
   ['metricsConfig', 'VsanMetricsConfig', undef, 0],
   ['rdmaConfig', 'VsanRdmaConfig', undef, 0],
   ['dataInTransitEncryptionConfig', 'VsanDataInTransitEncryptionConfig', undef, 0],
   ['vsanHealthConfig', 'VsanHealthConfigSpec', undef, 0],
   ['mode', undef, undef, 0],
   ['vsanPMemConfig', 'VimVsanVsanPMemConfig', undef, 0],
   ['vsanEsaConfigInfo', 'VsanEsaConfigInfo', undef, 0],
   ['xvcDatastoreConfig', 'VsanXVCDatastoreConfig', undef, 0],
   ['serverClusterConfig', 'VcRemoteVsanServerClusterConfig', undef, 0],
   ['datastoreDefaultPolicySelectionConfig', 'VsanDatastoreDefaultPolicySelectionConfig', undef, 0],
);


VIMRuntime::make_get_set('VsanConfigInfoEx', 'dataEfficiencyConfig', 'resyncIopsLimitConfig', 'iscsiConfig', 'dataEncryptionConfig', 'extendedConfig', 'datastoreConfig', 'perfsvcConfig', 'unmapConfig', 'vumConfig', 'fileServiceConfig', 'metricsConfig', 'rdmaConfig', 'dataInTransitEncryptionConfig', 'vsanHealthConfig', 'mode', 'vsanPMemConfig', 'vsanEsaConfigInfo', 'xvcDatastoreConfig', 'serverClusterConfig', 'datastoreDefaultPolicySelectionConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VimVsanDataEfficiencyCapacityState;
our @ISA = qw(DynamicData);

our @property_list = (
   ['logicalCapacity', undef, undef, 0],
   ['logicalCapacityUsed', undef, undef, 0],
   ['physicalCapacity', undef, undef, 0],
   ['physicalCapacityUsed', undef, undef, 0],
   ['dedupMetadataSize', undef, undef, 0],
   ['spaceEfficiencyMetadataSize', 'VsanSpaceEfficiencyMetadataSize', undef, 0],
);


VIMRuntime::make_get_set('VimVsanDataEfficiencyCapacityState', 'logicalCapacity', 'logicalCapacityUsed', 'physicalCapacity', 'physicalCapacityUsed', 'dedupMetadataSize', 'spaceEfficiencyMetadataSize');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanDataEfficiencyConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['dedupEnabled', 'boolean', undef, 1],
   ['compressionEnabled', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanDataEfficiencyConfig', 'dedupEnabled', 'compressionEnabled');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanDataEncryptionConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['encryptionEnabled', 'boolean', undef, 1],
   ['kmsProviderId', 'KeyProviderId', undef, 0],
   ['kekId', undef, undef, 0],
   ['hostKeyId', undef, undef, 0],
   ['dekGenerationId', undef, undef, 0],
   ['changing', 'boolean', undef, 0],
   ['eraseDisksBeforeUse', 'boolean', undef, 0],
   ['wrappedDek', undef, undef, 0],
   ['dekId', undef, undef, 0],
   ['oldWrappedDek', undef, undef, 0],
   ['oldDekId', undef, undef, 0],
   ['kekVerifier', undef, undef, 0],
   ['dekVerifier', undef, undef, 0],
   ['oldDekVerifier', undef, undef, 0],
   ['iv', undef, undef, 0],
   ['syncing', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanDataEncryptionConfig', 'encryptionEnabled', 'kmsProviderId', 'kekId', 'hostKeyId', 'dekGenerationId', 'changing', 'eraseDisksBeforeUse', 'wrappedDek', 'dekId', 'oldWrappedDek', 'oldDekId', 'kekVerifier', 'dekVerifier', 'oldDekVerifier', 'iv', 'syncing');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanDataInTransitEncryptionConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['enabled', 'boolean', undef, 0],
   ['rekeyInterval', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanDataInTransitEncryptionConfig', 'enabled', 'rekeyInterval');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanDatastoreConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['datastores', 'VsanDatastoreSpec', 1, 0],
);


VIMRuntime::make_get_set('VsanDatastoreConfig', 'datastores');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanDatastoreSourcePrecheckItem;
our @ISA = qw(VsanMountPrecheckItem);

our @property_list = (
);


VIMRuntime::make_get_set('VsanDatastoreSourcePrecheckItem');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanDatastoreSourcePrecheckResult;
our @ISA = qw(VsanMountPrecheckResult);

our @property_list = (
);


VIMRuntime::make_get_set('VsanDatastoreSourcePrecheckResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanDatastoreSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['uuid', undef, undef, 1],
   ['name', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanDatastoreSpec', 'uuid', 'name');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanDatastoreSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanDatastoreSpec', 'VsanDatastoreSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanDatastoreSpec', 'VsanDatastoreSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DefaultDatastorePolicySelectionInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['enabled', 'boolean', undef, 1],
   ['defaultPolicyId', undef, undef, 0],
   ['lastPolicySelectionTime', undef, undef, 0],
);


VIMRuntime::make_get_set('DefaultDatastorePolicySelectionInfo', 'enabled', 'defaultPolicyId', 'lastPolicySelectionTime');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanDirectoryServerConfig;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('VsanDirectoryServerConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DiskClaimConfiguration;
our @ISA = qw(DynamicData);

our @property_list = (
   ['diskType', undef, undef, 1],
   ['diskNamePrefix', undef, undef, 0],
   ['numberOfDisks', undef, undef, 0],
   ['diskModel', undef, undef, 0],
   ['vendor', undef, undef, 0],
   ['diskCapacity', undef, undef, 0],
);


VIMRuntime::make_get_set('DiskClaimConfiguration', 'diskType', 'diskNamePrefix', 'numberOfDisks', 'diskModel', 'vendor', 'diskCapacity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDiskClaimConfiguration;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DiskClaimConfiguration', 'DiskClaimConfiguration', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDiskClaimConfiguration', 'DiskClaimConfiguration');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanDiskDataEvacuationResourceCheckTaskDetails;
our @ISA = qw(VsanResourceCheckTaskDetails);

our @property_list = (
   ['diskUuid', undef, undef, 0],
   ['isCapacityTier', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanDiskDataEvacuationResourceCheckTaskDetails', 'diskUuid', 'isCapacityTier');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanDiskGroupResourceCheckResult;
our @ISA = qw(EntityResourceCheckDetails);

our @property_list = (
   ['cacheTierDisk', 'VsanDiskResourceCheckResult', undef, 0],
   ['capacityTierDisks', 'VsanDiskResourceCheckResult', 1, 0],
);


VIMRuntime::make_get_set('VsanDiskGroupResourceCheckResult', 'cacheTierDisk', 'capacityTierDisks');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanDiskGroupResourceCheckResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanDiskGroupResourceCheckResult', 'VsanDiskGroupResourceCheckResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanDiskGroupResourceCheckResult', 'VsanDiskGroupResourceCheckResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanDiskResourceCheckResult;
our @ISA = qw(EntityResourceCheckDetails);

our @property_list = (
);


VIMRuntime::make_get_set('VsanDiskResourceCheckResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanDiskResourceCheckResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanDiskResourceCheckResult', 'VsanDiskResourceCheckResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanDiskResourceCheckResult', 'VsanDiskResourceCheckResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VSANEntityCompatibilityResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entity', 'ManagedObjectReference', undef, 1],
   ['compatible', 'boolean', undef, 1],
   ['incompatibleReasons', 'LocalizableMessage', 1, 0],
   ['extendedAttributes', 'KeyAnyValue', 1, 0],
);


VIMRuntime::make_get_set('VSANEntityCompatibilityResult', 'entity', 'compatible', 'incompatibleReasons', 'extendedAttributes');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVSANEntityCompatibilityResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VSANEntityCompatibilityResult', 'VSANEntityCompatibilityResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVSANEntityCompatibilityResult', 'VSANEntityCompatibilityResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EntityResourceCheckDetails;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 0],
   ['uuid', undef, undef, 0],
   ['isNew', 'boolean', undef, 0],
   ['capacity', undef, undef, 0],
   ['postOperationCapacity', undef, undef, 0],
   ['usedCapacity', undef, undef, 0],
   ['postOperationUsedCapacity', undef, undef, 0],
   ['additionalRequiredCapacity', undef, undef, 0],
   ['maxComponents', undef, undef, 0],
   ['components', undef, undef, 0],
);


VIMRuntime::make_get_set('EntityResourceCheckDetails', 'name', 'uuid', 'isNew', 'capacity', 'postOperationCapacity', 'usedCapacity', 'postOperationUsedCapacity', 'additionalRequiredCapacity', 'maxComponents', 'components');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanFaultDomainResourceCheckResult;
our @ISA = qw(EntityResourceCheckDetails);

our @property_list = (
   ['hosts', 'VsanHostResourceCheckResult', 1, 0],
);


VIMRuntime::make_get_set('VsanFaultDomainResourceCheckResult', 'hosts');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanFaultDomainResourceCheckResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanFaultDomainResourceCheckResult', 'VsanFaultDomainResourceCheckResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanFaultDomainResourceCheckResult', 'VsanFaultDomainResourceCheckResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanFileServiceConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['enabled', 'boolean', undef, 1],
   ['fileServerMemoryMB', undef, undef, 0],
   ['fileServerCPUMhz', undef, undef, 0],
   ['fsvmMemoryMB', undef, undef, 0],
   ['fsvmCPU', undef, undef, 0],
   ['network', 'ManagedObjectReference', undef, 0],
   ['domains', 'VsanFileServiceDomainConfig', 1, 0],
   ['fileAnalyticsEnabled', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanFileServiceConfig', 'enabled', 'fileServerMemoryMB', 'fileServerCPUMhz', 'fsvmMemoryMB', 'fsvmCPU', 'network', 'domains', 'fileAnalyticsEnabled');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanFileServiceDomain;
our @ISA = qw(DynamicData);

our @property_list = (
   ['uuid', undef, undef, 1],
   ['config', 'VsanFileServiceDomainConfig', undef, 0],
);


VIMRuntime::make_get_set('VsanFileServiceDomain', 'uuid', 'config');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanFileServiceDomain;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanFileServiceDomain', 'VsanFileServiceDomain', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanFileServiceDomain', 'VsanFileServiceDomain');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanFileServiceDomainConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 0],
   ['dnsServerAddresses', undef, 1, 0],
   ['dnsSuffixes', undef, 1, 0],
   ['fileServerIpConfig', 'VsanFileServiceIpConfig', 1, 0],
   ['directoryServerConfig', 'VsanDirectoryServerConfig', undef, 0],
   ['version', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanFileServiceDomainConfig', 'name', 'dnsServerAddresses', 'dnsSuffixes', 'fileServerIpConfig', 'directoryServerConfig', 'version');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanFileServiceDomainConfig;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanFileServiceDomainConfig', 'VsanFileServiceDomainConfig', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanFileServiceDomainConfig', 'VsanFileServiceDomainConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanFileServiceDomainQuerySpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['uuids', undef, 1, 0],
   ['names', undef, 1, 0],
);


VIMRuntime::make_get_set('VsanFileServiceDomainQuerySpec', 'uuids', 'names');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanFileServiceIpConfig;
our @ISA = qw(HostIpConfig);

our @property_list = (
   ['fqdn', undef, undef, 0],
   ['isPrimary', 'boolean', undef, 0],
   ['gateway', undef, undef, 1],
   ['affinityLocation', undef, undef, 0],
   ['ipv6Gateway', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanFileServiceIpConfig', 'fqdn', 'isPrimary', 'gateway', 'affinityLocation', 'ipv6Gateway');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanFileServiceIpConfig;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanFileServiceIpConfig', 'VsanFileServiceIpConfig', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanFileServiceIpConfig', 'VsanFileServiceIpConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanFileShare;
our @ISA = qw(DynamicData);

our @property_list = (
   ['uuid', undef, undef, 1],
   ['config', 'VsanFileShareConfig', undef, 0],
   ['runtime', 'VsanFileShareRuntimeInfo', undef, 0],
);


VIMRuntime::make_get_set('VsanFileShare', 'uuid', 'config', 'runtime');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanFileShare;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanFileShare', 'VsanFileShare', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanFileShare', 'VsanFileShare');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanFileShareConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 0],
   ['domainName', undef, undef, 0],
   ['quota', undef, undef, 0],
   ['softQuota', undef, undef, 0],
   ['labels', 'KeyValue', 1, 0],
   ['storagePolicy', 'VirtualMachineProfileSpec', undef, 0],
   ['permission', 'VsanFileShareNetPermission', 1, 0],
   ['protocols', undef, 1, 0],
   ['smbOptions', 'VsanFileShareSmbOptions', undef, 0],
   ['nfsSecType', undef, undef, 0],
   ['affinityLocation', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanFileShareConfig', 'name', 'domainName', 'quota', 'softQuota', 'labels', 'storagePolicy', 'permission', 'protocols', 'smbOptions', 'nfsSecType', 'affinityLocation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanFileShareNetPermission;
our @ISA = qw(DynamicData);

our @property_list = (
   ['ips', undef, undef, 1],
   ['permissions', undef, undef, 0],
   ['allowRoot', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanFileShareNetPermission', 'ips', 'permissions', 'allowRoot');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanFileShareNetPermission;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanFileShareNetPermission', 'VsanFileShareNetPermission', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanFileShareNetPermission', 'VsanFileShareNetPermission');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanFileShareQueryProperties;
our @ISA = qw(DynamicData);

our @property_list = (
   ['includeBasic', 'boolean', undef, 0],
   ['includeUsedCapacity', 'boolean', undef, 0],
   ['includeVsanObjectUuids', 'boolean', undef, 0],
   ['includeAllLabels', 'boolean', undef, 0],
   ['labelKeys', undef, 1, 0],
);


VIMRuntime::make_get_set('VsanFileShareQueryProperties', 'includeBasic', 'includeUsedCapacity', 'includeVsanObjectUuids', 'includeAllLabels', 'labelKeys');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FileShareQueryResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['fileShares', 'VsanFileShare', 1, 0],
   ['nextOffset', undef, undef, 0],
   ['totalShareCount', undef, undef, 0],
);


VIMRuntime::make_get_set('FileShareQueryResult', 'fileShares', 'nextOffset', 'totalShareCount');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanFileShareQuerySpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['domainName', undef, undef, 0],
   ['uuids', undef, 1, 0],
   ['names', undef, 1, 0],
   ['offset', undef, undef, 0],
   ['limit', undef, undef, 0],
   ['managedBy', undef, 1, 0],
   ['protocols', undef, 1, 0],
   ['pageNumber', undef, undef, 0],
   ['properties', 'VsanFileShareQueryProperties', undef, 0],
);


VIMRuntime::make_get_set('VsanFileShareQuerySpec', 'domainName', 'uuids', 'names', 'offset', 'limit', 'managedBy', 'protocols', 'pageNumber', 'properties');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanFileShareRuntimeInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['usedCapacity', undef, undef, 0],
   ['hostname', undef, undef, 0],
   ['address', undef, undef, 0],
   ['vsanObjectUuids', undef, 1, 0],
   ['accessPoints', 'KeyValue', 1, 0],
   ['managedBy', undef, undef, 0],
   ['fileServerFQDN', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanFileShareRuntimeInfo', 'usedCapacity', 'hostname', 'address', 'vsanObjectUuids', 'accessPoints', 'managedBy', 'fileServerFQDN');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanFileShareSmbOptions;
our @ISA = qw(DynamicData);

our @property_list = (
   ['encryption', undef, undef, 0],
   ['accessBasedEnumeration', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanFileShareSmbOptions', 'encryption', 'accessBasedEnumeration');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanFileShareSnapshot;
our @ISA = qw(DynamicData);

our @property_list = (
   ['config', 'VsanFileShareSnapshotConfig', undef, 0],
   ['creationTime', undef, undef, 0],
   ['usedCapacity', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanFileShareSnapshot', 'config', 'creationTime', 'usedCapacity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanFileShareSnapshot;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanFileShareSnapshot', 'VsanFileShareSnapshot', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanFileShareSnapshot', 'VsanFileShareSnapshot');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanFileShareSnapshotConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['shareUuid', undef, undef, 0],
   ['name', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanFileShareSnapshotConfig', 'shareUuid', 'name');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanFileShareSnapshotQueryResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['snapshots', 'VsanFileShareSnapshot', 1, 0],
   ['totalCount', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanFileShareSnapshotQueryResult', 'snapshots', 'totalCount');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanFileShareSnapshotQuerySpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['shareUuid', undef, undef, 1],
   ['snapshotNames', undef, 1, 0],
   ['startTime', undef, undef, 0],
   ['endTime', undef, undef, 0],
   ['pageSize', undef, undef, 0],
   ['pageNumber', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanFileShareSnapshotQuerySpec', 'shareUuid', 'snapshotNames', 'startTime', 'endTime', 'pageSize', 'pageNumber');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHciMeshDatastoreSource;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vcInfo', 'VsanRemoteVcInfo', undef, 1],
);


VIMRuntime::make_get_set('VsanHciMeshDatastoreSource', 'vcInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanHciMeshDatastoreSource;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanHciMeshDatastoreSource', 'VsanHciMeshDatastoreSource', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanHciMeshDatastoreSource', 'VsanHciMeshDatastoreSource');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHciMeshServerConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['unicastInfo', 'VsanHostServerClusterUnicastInfo', undef, 1],
);


VIMRuntime::make_get_set('VsanHciMeshServerConfig', 'unicastInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostResourceCheckResult;
our @ISA = qw(EntityResourceCheckDetails);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 0],
   ['diskGroups', 'VsanDiskGroupResourceCheckResult', 1, 0],
   ['storagePools', 'VsanStoragePoolResourceCheckResult', 1, 0],
);


VIMRuntime::make_get_set('VsanHostResourceCheckResult', 'host', 'diskGroups', 'storagePools');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanHostResourceCheckResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanHostResourceCheckResult', 'VsanHostResourceCheckResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanHostResourceCheckResult', 'VsanHostResourceCheckResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanIODiagnosticsFailedCheck;
our @ISA = qw(DynamicData);

our @property_list = (
   ['unsupportedType', undef, undef, 1],
   ['reason', 'LocalizableMessage', undef, 1],
);


VIMRuntime::make_get_set('VsanIODiagnosticsFailedCheck', 'unsupportedType', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanIODiagnosticsFailedCheck;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanIODiagnosticsFailedCheck', 'VsanIODiagnosticsFailedCheck', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanIODiagnosticsFailedCheck', 'VsanIODiagnosticsFailedCheck');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanIODiagnosticsInstance;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['state', undef, undef, 1],
   ['events', 'VsanIODiagnosticsInstanceEvent', 1, 0],
   ['targets', 'VsanIODiagnosticsTarget', 1, 0],
   ['startTime', undef, undef, 1],
   ['endTime', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanIODiagnosticsInstance', 'name', 'state', 'events', 'targets', 'startTime', 'endTime');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanIODiagnosticsInstance;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanIODiagnosticsInstance', 'VsanIODiagnosticsInstance', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanIODiagnosticsInstance', 'VsanIODiagnosticsInstance');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanIODiagnosticsInstanceEvent;
our @ISA = qw(DynamicData);

our @property_list = (
   ['eventType', undef, undef, 1],
   ['eventTime', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanIODiagnosticsInstanceEvent', 'eventType', 'eventTime');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanIODiagnosticsInstanceEvent;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanIODiagnosticsInstanceEvent', 'VsanIODiagnosticsInstanceEvent', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanIODiagnosticsInstanceEvent', 'VsanIODiagnosticsInstanceEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanIODiagnosticsInstanceQuerySpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['targets', 'VsanIODiagnosticsTarget', 1, 0],
   ['startTime', undef, undef, 1],
   ['endTime', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanIODiagnosticsInstanceQuerySpec', 'targets', 'startTime', 'endTime');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanIODiagnosticsObjectLayout;
our @ISA = qw(DynamicData);

our @property_list = (
   ['layout', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanIODiagnosticsObjectLayout', 'layout');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanIODiagnosticsPrecheckResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['supported', 'boolean', undef, 1],
   ['failedChecks', 'VsanIODiagnosticsFailedCheck', 1, 0],
);


VIMRuntime::make_get_set('VsanIODiagnosticsPrecheckResult', 'supported', 'failedChecks');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanIODiagnosticsStats;
our @ISA = qw(DynamicData);

our @property_list = (
   ['objectsIOStats', 'VsanObjectIOStats', 1, 0],
   ['startTime', undef, undef, 1],
   ['endTime', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanIODiagnosticsStats', 'objectsIOStats', 'startTime', 'endTime');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanIODiagnosticsStats;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanIODiagnosticsStats', 'VsanIODiagnosticsStats', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanIODiagnosticsStats', 'VsanIODiagnosticsStats');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanIODiagnosticsTarget;
our @ISA = qw(DynamicData);

our @property_list = (
   ['type', undef, undef, 1],
   ['entityId', undef, undef, 1],
   ['objUuids', undef, 1, 0],
);


VIMRuntime::make_get_set('VsanIODiagnosticsTarget', 'type', 'entityId', 'objUuids');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanIODiagnosticsTarget;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanIODiagnosticsTarget', 'VsanIODiagnosticsTarget', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanIODiagnosticsTarget', 'VsanIODiagnosticsTarget');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanIODiagnosticsTargetStats;
our @ISA = qw(DynamicData);

our @property_list = (
   ['target', 'VsanIODiagnosticsTarget', undef, 1],
   ['objectsIODiagnosticsStats', 'VsanIODiagnosticsStats', 1, 0],
);


VIMRuntime::make_get_set('VsanIODiagnosticsTargetStats', 'target', 'objectsIODiagnosticsStats');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanIODiagnosticsTargetStats;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanIODiagnosticsTargetStats', 'VsanIODiagnosticsTargetStats', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanIODiagnosticsTargetStats', 'VsanIODiagnosticsTargetStats');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanIOLatency;
our @ISA = qw(DynamicData);

our @property_list = (
   ['latencyType', undef, undef, 1],
   ['sourceEntityUuid', undef, undef, 1],
   ['destEntityUuid', undef, undef, 1],
   ['readLatencyStats', 'VsanIOLatencyMetrics', undef, 1],
   ['writeLatencyStats', 'VsanIOLatencyMetrics', undef, 1],
   ['detailedInfo', 'KeyAnyValue', 1, 0],
);


VIMRuntime::make_get_set('VsanIOLatency', 'latencyType', 'sourceEntityUuid', 'destEntityUuid', 'readLatencyStats', 'writeLatencyStats', 'detailedInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanIOLatency;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanIOLatency', 'VsanIOLatency', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanIOLatency', 'VsanIOLatency');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanIOLatencyMetrics;
our @ISA = qw(DynamicData);

our @property_list = (
   ['totalCount', undef, undef, 1],
   ['averageLatency', undef, undef, 1],
   ['stddevLatency', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanIOLatencyMetrics', 'totalCount', 'averageLatency', 'stddevLatency');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LifecycleConfigDetails;
our @ISA = qw(DynamicData);

our @property_list = (
   ['clusterType', undef, undef, 1],
   ['faultDomainsDetails', 'LifecycleFaultDomainDetails', 1, 0],
   ['witnessHostsDetails', 'LifecycleWitnessDetails', 1, 0],
);


VIMRuntime::make_get_set('LifecycleConfigDetails', 'clusterType', 'faultDomainsDetails', 'witnessHostsDetails');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LifecycleFaultDomainDetails;
our @ISA = qw(DynamicData);

our @property_list = (
   ['isPreferredFaultDomain', 'boolean', undef, 0],
   ['name', undef, undef, 0],
   ['hosts', 'ManagedObjectReference', 1, 0],
);


VIMRuntime::make_get_set('LifecycleFaultDomainDetails', 'isPreferredFaultDomain', 'name', 'hosts');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfLifecycleFaultDomainDetails;
our @ISA = qw(ComplexType);

our @property_list = (
   ['LifecycleFaultDomainDetails', 'LifecycleFaultDomainDetails', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfLifecycleFaultDomainDetails', 'LifecycleFaultDomainDetails');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LifecyclePreCheckResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['type', undef, undef, 0],
   ['description', 'LocalizableMessage', undef, 0],
   ['status', undef, undef, 1],
   ['reason', 'LocalizableMessage', undef, 0],
);


VIMRuntime::make_get_set('LifecyclePreCheckResult', 'type', 'description', 'status', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfLifecyclePreCheckResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['LifecyclePreCheckResult', 'LifecyclePreCheckResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfLifecyclePreCheckResult', 'LifecyclePreCheckResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LifecycleWitnessDetails;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['isVirtualAppliance', 'boolean', undef, 1],
   ['sharedClusters', 'ManagedObjectReference', 1, 0],
);


VIMRuntime::make_get_set('LifecycleWitnessDetails', 'host', 'isVirtualAppliance', 'sharedClusters');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfLifecycleWitnessDetails;
our @ISA = qw(ComplexType);

our @property_list = (
   ['LifecycleWitnessDetails', 'LifecycleWitnessDetails', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfLifecycleWitnessDetails', 'LifecycleWitnessDetails');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanMetricProfile;
our @ISA = qw(DynamicData);

our @property_list = (
   ['authToken', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanMetricProfile', 'authToken');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanMetricProfile;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanMetricProfile', 'VsanMetricProfile', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanMetricProfile', 'VsanMetricProfile');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanMetricsConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['profiles', 'VsanMetricProfile', 1, 0],
);


VIMRuntime::make_get_set('VsanMetricsConfig', 'profiles');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanMountPrecheckItem;
our @ISA = qw(DynamicData);

our @property_list = (
   ['type', undef, undef, 1],
   ['description', 'LocalizableMessage', undef, 1],
   ['status', undef, undef, 1],
   ['reason', 'LocalizableMessage', 1, 0],
   ['ignoreMessage', 'LocalizableMessage', 1, 0],
);


VIMRuntime::make_get_set('VsanMountPrecheckItem', 'type', 'description', 'status', 'reason', 'ignoreMessage');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanMountPrecheckItem;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanMountPrecheckItem', 'VsanMountPrecheckItem', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanMountPrecheckItem', 'VsanMountPrecheckItem');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanMountPrecheckNetworkConnectivity;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['smallPingTestSuccessPct', undef, undef, 1],
   ['largePingTestSuccessPct', undef, undef, 1],
   ['status', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanMountPrecheckNetworkConnectivity', 'host', 'smallPingTestSuccessPct', 'largePingTestSuccessPct', 'status');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanMountPrecheckNetworkConnectivity;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanMountPrecheckNetworkConnectivity', 'VsanMountPrecheckNetworkConnectivity', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanMountPrecheckNetworkConnectivity', 'VsanMountPrecheckNetworkConnectivity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanMountPrecheckNetworkConnectivityDetail;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['networkConnectivity', 'VsanMountPrecheckNetworkConnectivity', 1, 0],
);


VIMRuntime::make_get_set('VsanMountPrecheckNetworkConnectivityDetail', 'host', 'networkConnectivity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanMountPrecheckNetworkConnectivityDetail;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanMountPrecheckNetworkConnectivityDetail', 'VsanMountPrecheckNetworkConnectivityDetail', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanMountPrecheckNetworkConnectivityDetail', 'VsanMountPrecheckNetworkConnectivityDetail');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanMountPrecheckNetworkConnectivityResult;
our @ISA = qw(VsanMountPrecheckItem);

our @property_list = (
   ['details', 'VsanMountPrecheckNetworkConnectivityDetail', 1, 0],
);


VIMRuntime::make_get_set('VsanMountPrecheckNetworkConnectivityResult', 'details');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanMountPrecheckNetworkLatency;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['networkLatency', undef, undef, 1],
   ['status', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanMountPrecheckNetworkLatency', 'host', 'networkLatency', 'status');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanMountPrecheckNetworkLatency;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanMountPrecheckNetworkLatency', 'VsanMountPrecheckNetworkLatency', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanMountPrecheckNetworkLatency', 'VsanMountPrecheckNetworkLatency');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanMountPrecheckNetworkLatencyDetail;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['networkLatencies', 'VsanMountPrecheckNetworkLatency', 1, 0],
);


VIMRuntime::make_get_set('VsanMountPrecheckNetworkLatencyDetail', 'host', 'networkLatencies');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanMountPrecheckNetworkLatencyDetail;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanMountPrecheckNetworkLatencyDetail', 'VsanMountPrecheckNetworkLatencyDetail', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanMountPrecheckNetworkLatencyDetail', 'VsanMountPrecheckNetworkLatencyDetail');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanMountPrecheckNetworkLatencyResult;
our @ISA = qw(VsanMountPrecheckItem);

our @property_list = (
   ['details', 'VsanMountPrecheckNetworkLatencyDetail', 1, 1],
);


VIMRuntime::make_get_set('VsanMountPrecheckNetworkLatencyResult', 'details');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanMountPrecheckResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['result', 'VsanMountPrecheckItem', 1, 0],
);


VIMRuntime::make_get_set('VsanMountPrecheckResult', 'result');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanObjectIOStats;
our @ISA = qw(DynamicData);

our @property_list = (
   ['backingObjectId', undef, undef, 1],
   ['ioLatencyStats', 'VsanIOLatency', 1, 0],
   ['objectLayout', 'VsanIODiagnosticsObjectLayout', undef, 1],
);


VIMRuntime::make_get_set('VsanObjectIOStats', 'backingObjectId', 'ioLatencyStats', 'objectLayout');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanObjectIOStats;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanObjectIOStats', 'VsanObjectIOStats', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanObjectIOStats', 'VsanObjectIOStats');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanProactiveRebalanceInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['enabled', 'boolean', undef, 0],
   ['threshold', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanProactiveRebalanceInfo', 'enabled', 'threshold');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanRdmaConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['rdmaEnabled', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('VsanRdmaConfig', 'rdmaEnabled');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VimVsanReconfigSpec;
our @ISA = qw(SDDCBase);

our @property_list = (
   ['vsanClusterConfig', 'VsanClusterConfigInfo', undef, 0],
   ['dataEfficiencyConfig', 'VsanDataEfficiencyConfig', undef, 0],
   ['diskMappingSpec', 'VimClusterVsanDiskMappingsConfigSpec', undef, 0],
   ['faultDomainsSpec', 'VimClusterVsanFaultDomainsConfigSpec', undef, 0],
   ['modify', 'boolean', undef, 1],
   ['allowReducedRedundancy', 'boolean', undef, 0],
   ['resyncIopsLimitConfig', 'ResyncIopsInfo', undef, 0],
   ['iscsiSpec', 'VsanIscsiTargetServiceSpec', undef, 0],
   ['dataEncryptionConfig', 'VsanDataEncryptionConfig', undef, 0],
   ['extendedConfig', 'VsanExtendedConfig', undef, 0],
   ['datastoreConfig', 'VsanDatastoreConfig', undef, 0],
   ['perfsvcConfig', 'VsanPerfsvcConfig', undef, 0],
   ['unmapConfig', 'VsanUnmapConfig', undef, 0],
   ['vumConfig', 'VsanVumConfig', undef, 0],
   ['metricsConfig', 'VsanMetricsConfig', undef, 0],
   ['fileServiceConfig', 'VsanFileServiceConfig', undef, 0],
   ['rdmaConfig', 'VsanRdmaConfig', undef, 0],
   ['dataInTransitEncryptionConfig', 'VsanDataInTransitEncryptionConfig', undef, 0],
   ['mode', undef, undef, 0],
   ['vsanHealthConfig', 'VsanHealthConfigSpec', undef, 0],
   ['vsanEsaConfig', 'VsanEsaConfig', undef, 0],
   ['xvcDatastoreConfig', 'VsanXVCDatastoreConfig', undef, 0],
   ['serverClusterConfig', 'VcRemoteVsanServerClusterConfig', undef, 0],
);


VIMRuntime::make_get_set('VimVsanReconfigSpec', 'vsanClusterConfig', 'dataEfficiencyConfig', 'diskMappingSpec', 'faultDomainsSpec', 'modify', 'allowReducedRedundancy', 'resyncIopsLimitConfig', 'iscsiSpec', 'dataEncryptionConfig', 'extendedConfig', 'datastoreConfig', 'perfsvcConfig', 'unmapConfig', 'vumConfig', 'metricsConfig', 'fileServiceConfig', 'rdmaConfig', 'dataInTransitEncryptionConfig', 'mode', 'vsanHealthConfig', 'vsanEsaConfig', 'xvcDatastoreConfig', 'serverClusterConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanRemoteVcInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['linkType', undef, undef, 0],
   ['vcHost', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanRemoteVcInfo', 'linkType', 'vcHost');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanRemoteVcInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanRemoteVcInfo', 'VsanRemoteVcInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanRemoteVcInfo', 'VsanRemoteVcInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanRemoteVcInfoStandalone;
our @ISA = qw(VsanRemoteVcInfo);

our @property_list = (
   ['user', undef, undef, 0],
   ['password', undef, undef, 0],
   ['cert', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanRemoteVcInfoStandalone', 'user', 'password', 'cert');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package RemoteVsanSite;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
);


VIMRuntime::make_get_set('RemoteVsanSite', 'name');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package RemoteVsanSiteAffinity;
our @ISA = qw(DynamicData);

our @property_list = (
   ['clientSite', 'RemoteVsanSite', undef, 0],
   ['serverSite', 'RemoteVsanSite', undef, 1],
);


VIMRuntime::make_get_set('RemoteVsanSiteAffinity', 'clientSite', 'serverSite');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfRemoteVsanSiteAffinity;
our @ISA = qw(ComplexType);

our @property_list = (
   ['RemoteVsanSiteAffinity', 'RemoteVsanSiteAffinity', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfRemoteVsanSiteAffinity', 'RemoteVsanSiteAffinity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package RepairTimerInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['maxTimeToRepair', undef, undef, 1],
   ['minTimeToRepair', undef, undef, 1],
   ['objectCount', undef, undef, 1],
   ['objectCountWithRepairTimer', undef, undef, 0],
);


VIMRuntime::make_get_set('RepairTimerInfo', 'maxTimeToRepair', 'minTimeToRepair', 'objectCount', 'objectCountWithRepairTimer');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanResourceCheckComponentResult;
our @ISA = qw(VsanResourceCheckResult);

our @property_list = (
   ['type', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanResourceCheckComponentResult', 'type');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanResourceCheckComponentResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanResourceCheckComponentResult', 'VsanResourceCheckComponentResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanResourceCheckComponentResult', 'VsanResourceCheckComponentResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanResourceCheckDataPersistenceResult;
our @ISA = qw(VsanResourceCheckComponentResult);

our @property_list = (
   ['dataToRebuild', undef, undef, 0],
   ['inaccessibleInstances', undef, 1, 0],
   ['reducedAvailabilityInstances', undef, 1, 0],
   ['rebuildInstances', undef, 1, 0],
);


VIMRuntime::make_get_set('VsanResourceCheckDataPersistenceResult', 'dataToRebuild', 'inaccessibleInstances', 'reducedAvailabilityInstances', 'rebuildInstances');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanResourceCheckResult;
our @ISA = qw(EntityResourceCheckDetails);

our @property_list = (
   ['timestamp', undef, undef, 1],
   ['status', undef, undef, 1],
   ['messages', 'LocalizableMessage', 1, 0],
   ['faultDomains', 'VsanFaultDomainResourceCheckResult', 1, 0],
   ['dataToMove', undef, undef, 0],
   ['nonCompliantObjects', undef, 1, 0],
   ['inaccessibleObjects', undef, 1, 0],
   ['capacityThreshold', 'VsanHealthThreshold', undef, 0],
   ['health', 'VsanClusterHealthSummary', undef, 0],
   ['dataToResync', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanResourceCheckResult', 'timestamp', 'status', 'messages', 'faultDomains', 'dataToMove', 'nonCompliantObjects', 'inaccessibleObjects', 'capacityThreshold', 'health', 'dataToResync');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanResourceCheckSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['operation', undef, undef, 1],
   ['entities', undef, 1, 0],
   ['maintenanceSpec', 'HostMaintenanceSpec', undef, 0],
   ['parent', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('VsanResourceCheckSpec', 'operation', 'entities', 'maintenanceSpec', 'parent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanResourceCheckStatus;
our @ISA = qw(DynamicData);

our @property_list = (
   ['status', undef, undef, 1],
   ['result', 'VsanResourceCheckResult', undef, 0],
   ['task', 'VsanResourceCheckTaskDetails', undef, 0],
   ['parentTask', 'VsanResourceCheckTaskDetails', undef, 0],
   ['componentResults', 'VsanResourceCheckComponentResult', 1, 0],
);


VIMRuntime::make_get_set('VsanResourceCheckStatus', 'status', 'result', 'task', 'parentTask', 'componentResults');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanResourceCheckTaskDetails;
our @ISA = qw(DynamicData);

our @property_list = (
   ['task', 'ManagedObjectReference', undef, 1],
   ['host', 'ManagedObjectReference', undef, 0],
   ['hostUuid', undef, undef, 0],
   ['maintenanceSpec', 'HostMaintenanceSpec', undef, 0],
);


VIMRuntime::make_get_set('VsanResourceCheckTaskDetails', 'task', 'host', 'hostUuid', 'maintenanceSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanResourceCheckVsanResult;
our @ISA = qw(VsanResourceCheckComponentResult);

our @property_list = (
);


VIMRuntime::make_get_set('VsanResourceCheckVsanResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ResyncIopsInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['resyncIops', undef, undef, 1],
);


VIMRuntime::make_get_set('ResyncIopsInfo', 'resyncIops');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanRuntimeStatsHostMap;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['stats', 'VsanHostRuntimeStats', undef, 0],
);


VIMRuntime::make_get_set('VsanRuntimeStatsHostMap', 'host', 'stats');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanRuntimeStatsHostMap;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanRuntimeStatsHostMap', 'VsanRuntimeStatsHostMap', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanRuntimeStatsHostMap', 'VsanRuntimeStatsHostMap');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanServerHostUnicastInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hostUuid', undef, undef, 1],
   ['nodeType', undef, undef, 0],
   ['unicastSpec', 'VsanUnicastAddressInfo', 1, 0],
);


VIMRuntime::make_get_set('VsanServerHostUnicastInfo', 'hostUuid', 'nodeType', 'unicastSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanServerHostUnicastInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanServerHostUnicastInfo', 'VsanServerHostUnicastInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanServerHostUnicastInfo', 'VsanServerHostUnicastInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VSANSharedWitnessCompatibilityResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['witnessHostCompatibility', 'VSANEntityCompatibilityResult', undef, 1],
   ['roboClusterCompatibility', 'VSANEntityCompatibilityResult', 1, 0],
);


VIMRuntime::make_get_set('VSANSharedWitnessCompatibilityResult', 'witnessHostCompatibility', 'roboClusterCompatibility');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanStoragePoolDiskResourceCheckResult;
our @ISA = qw(VsanDiskResourceCheckResult);

our @property_list = (
   ['diskType', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanStoragePoolDiskResourceCheckResult', 'diskType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanStoragePoolDiskResourceCheckResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanStoragePoolDiskResourceCheckResult', 'VsanStoragePoolDiskResourceCheckResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanStoragePoolDiskResourceCheckResult', 'VsanStoragePoolDiskResourceCheckResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanStoragePoolResourceCheckResult;
our @ISA = qw(EntityResourceCheckDetails);

our @property_list = (
   ['disks', 'VsanStoragePoolDiskResourceCheckResult', 1, 0],
);


VIMRuntime::make_get_set('VsanStoragePoolResourceCheckResult', 'disks');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanStoragePoolResourceCheckResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanStoragePoolResourceCheckResult', 'VsanStoragePoolResourceCheckResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanStoragePoolResourceCheckResult', 'VsanStoragePoolResourceCheckResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VcRemoteVsanServerClusterConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['serverClusters', 'VcRemoteVsanServerClusterInfo', 1, 0],
);


VIMRuntime::make_get_set('VcRemoteVsanServerClusterConfig', 'serverClusters');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VcRemoteVsanServerClusterInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['clusterUuid', undef, undef, 1],
   ['networkTopology', undef, undef, 1],
   ['siteAffinity', 'RemoteVsanSiteAffinity', 1, 0],
);


VIMRuntime::make_get_set('VcRemoteVsanServerClusterInfo', 'clusterUuid', 'networkTopology', 'siteAffinity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVcRemoteVsanServerClusterInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VcRemoteVsanServerClusterInfo', 'VcRemoteVsanServerClusterInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVcRemoteVsanServerClusterInfo', 'VcRemoteVsanServerClusterInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanBurnInTest;
our @ISA = qw(DynamicData);

our @property_list = (
   ['testname', undef, undef, 1],
   ['workload', undef, undef, 0],
   ['duration', undef, undef, 1],
   ['result', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanBurnInTest', 'testname', 'workload', 'duration', 'result');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanBurnInTest;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanBurnInTest', 'VsanBurnInTest', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanBurnInTest', 'VsanBurnInTest');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanBurnInTestCheckResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['passedTests', 'VsanBurnInTest', 1, 0],
   ['notPerformedTests', 'VsanBurnInTest', 1, 0],
   ['failedTests', 'VsanBurnInTest', 1, 0],
);


VIMRuntime::make_get_set('VsanBurnInTestCheckResult', 'passedTests', 'notPerformedTests', 'failedTests');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanCloudHealthStatus;
our @ISA = qw(DynamicData);

our @property_list = (
   ['collectorRunning', 'boolean', undef, 0],
   ['lastSentTimestamp', undef, undef, 0],
   ['internetConnectivity', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanCloudHealthStatus', 'collectorRunning', 'lastSentTimestamp', 'internetConnectivity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterBurnInTestResultList;
our @ISA = qw(DynamicData);

our @property_list = (
   ['items', 'VsanBurnInTest', 1, 0],
   ['hosts', undef, 1, 0],
);


VIMRuntime::make_get_set('VsanClusterBurnInTestResultList', 'items', 'hosts');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanCompliantDriver;
our @ISA = qw(DynamicData);

our @property_list = (
   ['driverName', undef, undef, 1],
   ['driverVersion', undef, undef, 1],
   ['supportedFeatures', undef, 1, 0],
);


VIMRuntime::make_get_set('VsanCompliantDriver', 'driverName', 'driverVersion', 'supportedFeatures');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanCompliantDriver;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanCompliantDriver', 'VsanCompliantDriver', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanCompliantDriver', 'VsanCompliantDriver');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanCompliantFirmware;
our @ISA = qw(DynamicData);

our @property_list = (
   ['firmwareVersion', undef, undef, 1],
   ['compliantDrivers', 'VsanCompliantDriver', 1, 1],
);


VIMRuntime::make_get_set('VsanCompliantFirmware', 'firmwareVersion', 'compliantDrivers');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanCompliantFirmware;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanCompliantFirmware', 'VsanCompliantFirmware', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanCompliantFirmware', 'VsanCompliantFirmware');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanConfigBaseIssue;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('VsanConfigBaseIssue');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanConfigBaseIssue;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanConfigBaseIssue', 'VsanConfigBaseIssue', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanConfigBaseIssue', 'VsanConfigBaseIssue');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanConfigCheckResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vsanEnabled', 'boolean', undef, 1],
   ['issues', 'VsanConfigBaseIssue', 1, 0],
);


VIMRuntime::make_get_set('VsanConfigCheckResult', 'vsanEnabled', 'issues');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanConfigNotAllDisksClaimedIssue;
our @ISA = qw(VsanConfigBaseIssue);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['disks', undef, 1, 1],
);


VIMRuntime::make_get_set('VsanConfigNotAllDisksClaimedIssue', 'host', 'disks');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanDatastoreDefaultPolicySelectionConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['enabled', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('VsanDatastoreDefaultPolicySelectionConfig', 'enabled');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanDiskModelInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['productId', undef, undef, 1],
   ['vendor', undef, undef, 1],
   ['partNumber', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanDiskModelInfo', 'productId', 'vendor', 'partNumber');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanDiskModelInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanDiskModelInfo', 'VsanDiskModelInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanDiskModelInfo', 'VsanDiskModelInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanDownloadItem;
our @ISA = qw(DynamicData);

our @property_list = (
   ['url', undef, undef, 1],
   ['sha1sum', undef, undef, 1],
   ['formatType', undef, undef, 0],
   ['itemId', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanDownloadItem', 'url', 'sha1sum', 'formatType', 'itemId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanDownloadItem;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanDownloadItem', 'VsanDownloadItem', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanDownloadItem', 'VsanDownloadItem');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanEsaConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['storagePoolSpecs', 'VsanAddStoragePoolDiskSpec', 1, 0],
   ['hclDiskClaimEnabled', 'boolean', undef, 0],
   ['datastoreDefaultPolicySelectionConfig', 'VsanDatastoreDefaultPolicySelectionConfig', undef, 0],
   ['diskConfiguration', 'VsanEsaDiskConfiguration', undef, 0],
);


VIMRuntime::make_get_set('VsanEsaConfig', 'storagePoolSpecs', 'hclDiskClaimEnabled', 'datastoreDefaultPolicySelectionConfig', 'diskConfiguration');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanEsaConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hclDiskClaimEnabled', 'boolean', undef, 0],
   ['datastoreDefaultPolicySelectionConfig', 'VsanDatastoreDefaultPolicySelectionConfig', undef, 0],
   ['diskConfiguration', 'VsanEsaDiskConfiguration', undef, 0],
);


VIMRuntime::make_get_set('VsanEsaConfigInfo', 'hclDiskClaimEnabled', 'datastoreDefaultPolicySelectionConfig', 'diskConfiguration');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanEsaDiskConfiguration;
our @ISA = qw(DynamicData);

our @property_list = (
   ['diskClaimConfiguration', 'DiskClaimConfiguration', 1, 0],
);


VIMRuntime::make_get_set('VsanEsaDiskConfiguration', 'diskClaimConfiguration');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanExtendedConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['objectRepairTimer', undef, undef, 0],
   ['disableSiteReadLocality', 'boolean', undef, 0],
   ['enableCustomizedSwapObject', 'boolean', undef, 0],
   ['largeScaleClusterSupport', 'boolean', undef, 0],
   ['proactiveRebalanceInfo', 'VsanProactiveRebalanceInfo', undef, 0],
   ['capacityReservationInfo', 'VsanCapacityReservationInfo', undef, 0],
);


VIMRuntime::make_get_set('VsanExtendedConfig', 'objectRepairTimer', 'disableSiteReadLocality', 'enableCustomizedSwapObject', 'largeScaleClusterSupport', 'proactiveRebalanceInfo', 'capacityReservationInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanFileServiceOvfSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['version', undef, undef, 0],
   ['updateTime', undef, undef, 0],
   ['task', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('VsanFileServiceOvfSpec', 'version', 'updateTime', 'task');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanFileServiceOvfSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanFileServiceOvfSpec', 'VsanFileServiceOvfSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanFileServiceOvfSpec', 'VsanFileServiceOvfSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanFileServicePreflightCheckResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['ovfInstalled', undef, undef, 0],
   ['fsvmVersion', undef, undef, 0],
   ['lastUpgradeDate', undef, undef, 0],
   ['ovfMixedModeIssue', undef, undef, 0],
   ['hostVersion', undef, undef, 0],
   ['mixedModeIssue', undef, undef, 0],
   ['networkPartitionIssue', undef, undef, 0],
   ['vsanDatastoreIssue', undef, undef, 0],
   ['domainConfigIssue', undef, undef, 0],
   ['fileServiceVersion', undef, undef, 0],
   ['dvsConfigIssue', undef, undef, 0],
   ['domainConfigWarning', undef, undef, 0],
   ['ntpConfigWarning', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanFileServicePreflightCheckResult', 'ovfInstalled', 'fsvmVersion', 'lastUpgradeDate', 'ovfMixedModeIssue', 'hostVersion', 'mixedModeIssue', 'networkPartitionIssue', 'vsanDatastoreIssue', 'domainConfigIssue', 'fileServiceVersion', 'dvsConfigIssue', 'domainConfigWarning', 'ntpConfigWarning');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanGenericClusterBaseIssue;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('VsanGenericClusterBaseIssue');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanGenericClusterBaseIssue;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanGenericClusterBaseIssue', 'VsanGenericClusterBaseIssue', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanGenericClusterBaseIssue', 'VsanGenericClusterBaseIssue');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanGenericClusterBestPracticeHealth;
our @ISA = qw(DynamicData);

our @property_list = (
   ['drsEnabled', 'boolean', undef, 1],
   ['haEnabled', 'boolean', undef, 1],
   ['issues', 'VsanGenericClusterBaseIssue', 1, 0],
);


VIMRuntime::make_get_set('VsanGenericClusterBestPracticeHealth', 'drsEnabled', 'haEnabled', 'issues');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHclDeviceConstraint;
our @ISA = qw(DynamicData);

our @property_list = (
   ['pciId', undef, undef, 1],
   ['vcgLink', undef, undef, 0],
   ['similarVcgLinks', undef, 1, 0],
   ['compliantFirmwares', 'VsanCompliantFirmware', 1, 0],
   ['vcgId', undef, undef, 0],
   ['model', undef, undef, 0],
   ['partner', undef, undef, 0],
   ['partNumber', undef, undef, 0],
   ['release', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanHclDeviceConstraint', 'pciId', 'vcgLink', 'similarVcgLinks', 'compliantFirmwares', 'vcgId', 'model', 'partner', 'partNumber', 'release');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanHclDeviceConstraint;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanHclDeviceConstraint', 'VsanHclDeviceConstraint', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanHclDeviceConstraint', 'VsanHclDeviceConstraint');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHclDiskConstraint;
our @ISA = qw(DynamicData);

our @property_list = (
   ['productId', undef, undef, 1],
   ['vendor', undef, undef, 1],
   ['constraints', 'VsanHclMinFwConstraint', 1, 0],
   ['pcieConstraints', 'VsanHclDeviceConstraint', 1, 0],
   ['partNumber', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanHclDiskConstraint', 'productId', 'vendor', 'constraints', 'pcieConstraints', 'partNumber');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanHclDiskConstraint;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanHclDiskConstraint', 'VsanHclDiskConstraint', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanHclDiskConstraint', 'VsanHclDiskConstraint');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHclDriverInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['driverVersion', undef, undef, 0],
   ['driverLink', 'VsanDownloadItem', undef, 0],
   ['fwVersion', undef, undef, 0],
   ['fwLinks', 'VsanDownloadItem', 1, 0],
   ['toolsLinks', 'VsanDownloadItem', 1, 0],
   ['eula', undef, undef, 0],
   ['driverType', undef, undef, 0],
   ['driverName', undef, undef, 0],
   ['diskModes', undef, 1, 0],
   ['supportedFeatures', undef, 1, 0],
);


VIMRuntime::make_get_set('VsanHclDriverInfo', 'driverVersion', 'driverLink', 'fwVersion', 'fwLinks', 'toolsLinks', 'eula', 'driverType', 'driverName', 'diskModes', 'supportedFeatures');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanHclDriverInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanHclDriverInfo', 'VsanHclDriverInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanHclDriverInfo', 'VsanHclDriverInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHclMinFwConstraint;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vcgId', undef, undef, 1],
   ['vcgLink', undef, undef, 1],
   ['model', undef, undef, 1],
   ['partner', undef, undef, 1],
   ['partNumber', undef, undef, 0],
   ['release', undef, undef, 1],
   ['firmware', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanHclMinFwConstraint', 'vcgId', 'vcgLink', 'model', 'partner', 'partNumber', 'release', 'firmware');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanHclMinFwConstraint;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanHclMinFwConstraint', 'VsanHclMinFwConstraint', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanHclMinFwConstraint', 'VsanHclMinFwConstraint');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHclQuerySpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['includeOnlyVsanControllers', 'boolean', undef, 0],
   ['cluster', 'ManagedObjectReference', undef, 0],
   ['hosts', 'ManagedObjectReference', 1, 0],
   ['vsanStoragePoolEligibleDisksOnly', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanHclQuerySpec', 'includeOnlyVsanControllers', 'cluster', 'hosts', 'vsanStoragePoolEligibleDisksOnly');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHclReleaseConstraint;
our @ISA = qw(DynamicData);

our @property_list = (
   ['cluster', 'ManagedObjectReference', undef, 1],
   ['release', undef, undef, 1],
   ['hostDevices', 'VsanHostDeviceInfo', 1, 0],
   ['constraints', 'VsanHclDeviceConstraint', 1, 0],
);


VIMRuntime::make_get_set('VsanHclReleaseConstraint', 'cluster', 'release', 'hostDevices', 'constraints');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanHclReleaseConstraint;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanHclReleaseConstraint', 'VsanHclReleaseConstraint', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanHclReleaseConstraint', 'VsanHclReleaseConstraint');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHealthConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['healthCheckThresholdSpec', 'VsanHealthThreshold', 1, 0],
   ['historicalHealthConfig', 'VsanHistoricalHealthConfig', undef, 0],
);


VIMRuntime::make_get_set('VsanHealthConfigSpec', 'healthCheckThresholdSpec', 'historicalHealthConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHealthThreshold;
our @ISA = qw(DynamicData);

our @property_list = (
   ['yellowValue', undef, undef, 1],
   ['redValue', undef, undef, 1],
   ['target', undef, undef, 0],
   ['enabled', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanHealthThreshold', 'yellowValue', 'redValue', 'target', 'enabled');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanHealthThreshold;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanHealthThreshold', 'VsanHealthThreshold', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanHealthThreshold', 'VsanHealthThreshold');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHistoricalHealthConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['enabled', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('VsanHistoricalHealthConfig', 'enabled');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostDeviceInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hostname', undef, undef, 1],
   ['devices', 'VsanBasicDeviceInfo', 1, 0],
);


VIMRuntime::make_get_set('VsanHostDeviceInfo', 'hostname', 'devices');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanHostDeviceInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanHostDeviceInfo', 'VsanHostDeviceInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanHostDeviceInfo', 'VsanHostDeviceInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHwToVcgInfoMappingSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entity', undef, undef, 1],
   ['vsanHwToVcgInfoMappings', 'VsanHwToVcgInfoMapping', 1, 1],
);


VIMRuntime::make_get_set('VsanHwToVcgInfoMappingSpec', 'entity', 'vsanHwToVcgInfoMappings');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanIOTripAnalyzerConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['recurrences', 'VsanIOTripAnalyzerRecurrence', 1, 0],
);


VIMRuntime::make_get_set('VsanIOTripAnalyzerConfig', 'recurrences');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanIOTripAnalyzerRecurrence;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 0],
   ['targets', 'VsanIODiagnosticsTarget', 1, 1],
   ['startTime', undef, undef, 1],
   ['endTime', undef, undef, 0],
   ['duration', undef, undef, 1],
   ['interval', undef, undef, 1],
   ['status', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanIOTripAnalyzerRecurrence', 'name', 'targets', 'startTime', 'endTime', 'duration', 'interval', 'status');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanIOTripAnalyzerRecurrence;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanIOTripAnalyzerRecurrence', 'VsanIOTripAnalyzerRecurrence', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanIOTripAnalyzerRecurrence', 'VsanIOTripAnalyzerRecurrence');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanInternalExtendedConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vcMaxDiskVersion', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanInternalExtendedConfig', 'vcMaxDiskVersion');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanNetworkConfigBaseIssue;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('VsanNetworkConfigBaseIssue');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanNetworkConfigBaseIssue;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanNetworkConfigBaseIssue', 'VsanNetworkConfigBaseIssue', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanNetworkConfigBaseIssue', 'VsanNetworkConfigBaseIssue');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanNetworkConfigBestPracticeHealth;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vdsPresent', 'boolean', undef, 1],
   ['issues', 'VsanNetworkConfigBaseIssue', 1, 0],
);


VIMRuntime::make_get_set('VsanNetworkConfigBestPracticeHealth', 'vdsPresent', 'issues');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanNetworkConfigPnicSpeedInconsistencyIssue;
our @ISA = qw(VsanNetworkConfigBaseIssue);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['vswitchName', undef, undef, 0],
   ['vds', 'ManagedObjectReference', undef, 0],
   ['speedsMb', undef, 1, 1],
);


VIMRuntime::make_get_set('VsanNetworkConfigPnicSpeedInconsistencyIssue', 'host', 'vswitchName', 'vds', 'speedsMb');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanNetworkConfigPortgroupWithNoRedundancyIssue;
our @ISA = qw(VsanNetworkConfigBaseIssue);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['portgroupName', undef, undef, 0],
   ['vds', 'ManagedObjectReference', undef, 0],
   ['pg', 'ManagedObjectReference', undef, 0],
   ['numPnics', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanNetworkConfigPortgroupWithNoRedundancyIssue', 'host', 'portgroupName', 'vds', 'pg', 'numPnics');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanNetworkConfigVdsScopeIssue;
our @ISA = qw(VsanNetworkConfigBaseIssue);

our @property_list = (
   ['vds', 'ManagedObjectReference', undef, 1],
   ['memberHosts', 'ManagedObjectReference', 1, 1],
   ['nonMemberHosts', 'ManagedObjectReference', 1, 1],
);


VIMRuntime::make_get_set('VsanNetworkConfigVdsScopeIssue', 'vds', 'memberHosts', 'nonMemberHosts');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanNetworkConfigVsanNotOnVdsIssue;
our @ISA = qw(VsanNetworkConfigBaseIssue);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['vmknic', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanNetworkConfigVsanNotOnVdsIssue', 'host', 'vmknic');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanNetworkConfigVswitchWithNoRedundancyIssue;
our @ISA = qw(VsanNetworkConfigBaseIssue);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['vswitchName', undef, undef, 0],
   ['vds', 'ManagedObjectReference', undef, 0],
   ['numPnics', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanNetworkConfigVswitchWithNoRedundancyIssue', 'host', 'vswitchName', 'vds', 'numPnics');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanNetworkVMotionVmknicNotFountIssue;
our @ISA = qw(VsanNetworkConfigBaseIssue);

our @property_list = (
   ['hostWithoutVmotionVmknic', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('VsanNetworkVMotionVmknicNotFountIssue', 'hostWithoutVmotionVmknic');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VimVsanVsanPMemConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['enabled', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('VimVsanVsanPMemConfig', 'enabled');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanPerfsvcHealthResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['statsObjectInfo', 'VsanObjectInformation', undef, 0],
   ['statsObjectConsistent', 'boolean', undef, 0],
   ['statsObjectPolicyConsistent', 'boolean', undef, 0],
   ['datastoreCompatible', 'boolean', undef, 0],
   ['enoughFreeSpace', 'boolean', undef, 0],
   ['remediateAction', undef, undef, 0],
   ['hostResults', 'VsanPerfNodeInformation', 1, 0],
   ['verboseModeStatus', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanPerfsvcHealthResult', 'statsObjectInfo', 'statsObjectConsistent', 'statsObjectPolicyConsistent', 'datastoreCompatible', 'enoughFreeSpace', 'remediateAction', 'hostResults', 'verboseModeStatus');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanPrepareVsanForVcsaSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vsanDiskMappingCreationSpec', 'VimVsanHostDiskMappingCreationSpec', undef, 0],
   ['vsanDataEfficiencyConfig', 'VsanDataEfficiencyConfig', undef, 0],
   ['taskId', undef, undef, 0],
   ['vsanDataEncryptionConfig', 'VsanHostEncryptionInfo', undef, 0],
   ['vsanAddStoragePoolDiskSpec', 'VsanAddStoragePoolDiskSpec', undef, 0],
   ['createNativeKeyProviderSpec', 'VsanHostCreateNativeKeyProviderSpec', undef, 0],
);


VIMRuntime::make_get_set('VsanPrepareVsanForVcsaSpec', 'vsanDiskMappingCreationSpec', 'vsanDataEfficiencyConfig', 'taskId', 'vsanDataEncryptionConfig', 'vsanAddStoragePoolDiskSpec', 'createNativeKeyProviderSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanSpaceEfficiencyMetadataSize;
our @ISA = qw(DynamicData);

our @property_list = (
   ['dedupMetadataSize', undef, undef, 0],
   ['compressionMetadataSize', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanSpaceEfficiencyMetadataSize', 'dedupMetadataSize', 'compressionMetadataSize');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanUnmapConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['enable', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('VsanUnmapConfig', 'enable');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanUpdateItem;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['type', undef, undef, 1],
   ['name', undef, undef, 1],
   ['version', undef, undef, 1],
   ['existingVersion', undef, undef, 0],
   ['present', 'boolean', undef, 1],
   ['vibSpec', 'VsanVibSpec', 1, 0],
   ['vibType', undef, undef, 0],
   ['firmwareSpec', 'VsanHclFirmwareUpdateSpec', undef, 0],
   ['downloadInfo', 'VsanDownloadItem', 1, 0],
   ['eula', undef, undef, 0],
   ['adapter', undef, undef, 0],
   ['key', undef, undef, 0],
   ['impact', undef, undef, 0],
   ['firmwareUnknown', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanUpdateItem', 'host', 'type', 'name', 'version', 'existingVersion', 'present', 'vibSpec', 'vibType', 'firmwareSpec', 'downloadInfo', 'eula', 'adapter', 'key', 'impact', 'firmwareUnknown');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanUpdateItem;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanUpdateItem', 'VsanUpdateItem', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanUpdateItem', 'VsanUpdateItem');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanVcPostDeployConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['dcName', undef, undef, 0],
   ['clusterName', undef, undef, 0],
   ['firstHost', 'HostConnectSpec', undef, 0],
   ['hostsToAdd', 'HostConnectSpec', 1, 0],
   ['vsanDataEfficiencyConfig', 'VsanDataEfficiencyConfig', undef, 0],
   ['vsanLicenseKey', undef, undef, 0],
   ['hostLicenseKey', undef, undef, 0],
   ['taskId', undef, undef, 0],
   ['vsanDataEncryptionConfig', 'VsanHostEncryptionInfo', undef, 0],
   ['createNativeKeyProviderSpec', 'VsanHostCreateNativeKeyProviderSpec', undef, 0],
);


VIMRuntime::make_get_set('VsanVcPostDeployConfigSpec', 'dcName', 'clusterName', 'firstHost', 'hostsToAdd', 'vsanDataEfficiencyConfig', 'vsanLicenseKey', 'hostLicenseKey', 'taskId', 'vsanDataEncryptionConfig', 'createNativeKeyProviderSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanVcStretchedClusterConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['witnessHost', 'ManagedObjectReference', undef, 1],
   ['clusters', 'VsanStretchedClusterConfig', 1, 1],
   ['witnessDiskMappings', 'VsanHostDiskMapping', 1, 0],
   ['witnessStoragePoolSpecs', 'VsanAddStoragePoolDiskSpec', 1, 0],
);


VIMRuntime::make_get_set('VsanVcStretchedClusterConfigSpec', 'witnessHost', 'clusters', 'witnessDiskMappings', 'witnessStoragePoolSpecs');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanVcsaDeploymentProgress;
our @ISA = qw(DynamicData);

our @property_list = (
   ['phase', undef, undef, 1],
   ['progressPct', undef, undef, 1],
   ['message', undef, undef, 1],
   ['success', 'boolean', undef, 1],
   ['error', 'LocalizedMethodFault', undef, 0],
   ['updateCounter', undef, undef, 1],
   ['taskId', undef, undef, 0],
   ['vm', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('VsanVcsaDeploymentProgress', 'phase', 'progressPct', 'message', 'success', 'error', 'updateCounter', 'taskId', 'vm');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanVcsaDeploymentProgress;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanVcsaDeploymentProgress', 'VsanVcsaDeploymentProgress', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanVcsaDeploymentProgress', 'VsanVcsaDeploymentProgress');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanVdsMigrationPlan;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vdsSpec', 'DVSCreateSpec', undef, 1],
   ['pgs', 'VsanVdsPgMigrationSpec', 1, 0],
   ['inaccessibleVms', 'ManagedObjectReference', 1, 0],
   ['infraVms', 'ManagedObjectReference', 1, 0],
);


VIMRuntime::make_get_set('VsanVdsMigrationPlan', 'vdsSpec', 'pgs', 'inaccessibleVms', 'infraVms');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanVdsPgMigrationHostInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['hostname', undef, undef, 1],
   ['vmknicDevices', undef, 1, 0],
   ['vmVnics', 'VsanVdsPgMigrationVmInfo', 1, 0],
);


VIMRuntime::make_get_set('VsanVdsPgMigrationHostInfo', 'host', 'hostname', 'vmknicDevices', 'vmVnics');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanVdsPgMigrationHostInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanVdsPgMigrationHostInfo', 'VsanVdsPgMigrationHostInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanVdsPgMigrationHostInfo', 'VsanVdsPgMigrationHostInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanVdsPgMigrationSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vssPgName', undef, undef, 1],
   ['dvPgName', undef, undef, 1],
   ['vdsPgSetting', 'VMwareDVSPortSetting', undef, 1],
   ['vdsPgType', undef, undef, 1],
   ['hosts', 'VsanVdsPgMigrationHostInfo', 1, 0],
   ['collisionRename', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('VsanVdsPgMigrationSpec', 'vssPgName', 'dvPgName', 'vdsPgSetting', 'vdsPgType', 'hosts', 'collisionRename');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanVdsPgMigrationSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanVdsPgMigrationSpec', 'VsanVdsPgMigrationSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanVdsPgMigrationSpec', 'VsanVdsPgMigrationSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanVdsPgMigrationVmInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vm', 'ManagedObjectReference', undef, 1],
   ['vnicLabel', undef, 1, 1],
);


VIMRuntime::make_get_set('VsanVdsPgMigrationVmInfo', 'vm', 'vnicLabel');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanVdsPgMigrationVmInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanVdsPgMigrationVmInfo', 'VsanVdsPgMigrationVmInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanVdsPgMigrationVmInfo', 'VsanVdsPgMigrationVmInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanVibInstallPreflightStatus;
our @ISA = qw(DynamicData);

our @property_list = (
   ['manualVmotionRequired', 'boolean', undef, 1],
   ['rollingRequired', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('VsanVibInstallPreflightStatus', 'manualVmotionRequired', 'rollingRequired');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanVibScanResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['vibName', undef, undef, 1],
   ['vibVersion', undef, undef, 1],
   ['existingVersion', undef, undef, 0],
   ['maintenanceModeRequired', 'boolean', undef, 1],
   ['rebootRequired', 'boolean', undef, 1],
   ['meetsSystemReq', 'boolean', undef, 1],
   ['pkgDepsMetByHost', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('VsanVibScanResult', 'host', 'vibName', 'vibVersion', 'existingVersion', 'maintenanceModeRequired', 'rebootRequired', 'meetsSystemReq', 'pkgDepsMetByHost');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanVibScanResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanVibScanResult', 'VsanVibScanResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanVibScanResult', 'VsanVibScanResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanVibSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['metaUrl', undef, undef, 0],
   ['metaSha1Sum', undef, undef, 0],
   ['vibUrl', undef, undef, 1],
   ['vibSha1Sum', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanVibSpec', 'host', 'metaUrl', 'metaSha1Sum', 'vibUrl', 'vibSha1Sum');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanVibSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanVibSpec', 'VsanVibSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanVibSpec', 'VsanVibSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanVmVdsMigrationSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vmInstanceUuid', undef, undef, 1],
   ['vnics', 'VsanVnicVdsMigrationSpec', 1, 1],
);


VIMRuntime::make_get_set('VsanVmVdsMigrationSpec', 'vmInstanceUuid', 'vnics');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanVmVdsMigrationSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanVmVdsMigrationSpec', 'VsanVmVdsMigrationSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanVmVdsMigrationSpec', 'VsanVmVdsMigrationSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanVnicVdsMigrationSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['vdsBacking', 'VirtualDeviceBackingInfo', undef, 1],
);


VIMRuntime::make_get_set('VsanVnicVdsMigrationSpec', 'key', 'vdsBacking');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanVnicVdsMigrationSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanVnicVdsMigrationSpec', 'VsanVnicVdsMigrationSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanVnicVdsMigrationSpec', 'VsanVnicVdsMigrationSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanVumConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['baselinePreferenceType', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanVumConfig', 'baselinePreferenceType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanWitnessHostConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['subClusterUuid', undef, undef, 1],
   ['preferredFaultDomainName', undef, undef, 1],
   ['metadataMode', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanWitnessHostConfig', 'subClusterUuid', 'preferredFaultDomainName', 'metadataMode');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanWitnessHostConfig;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanWitnessHostConfig', 'VsanWitnessHostConfig', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanWitnessHostConfig', 'VsanWitnessHostConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanXVCClientInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['cluster', 'ManagedObjectReference', undef, 1],
   ['clusterName', undef, undef, 1],
   ['clusterUuid', undef, undef, 0],
   ['vsanFormatVersion', undef, undef, 1],
   ['ownerVc', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanXVCClientInfo', 'cluster', 'clusterName', 'clusterUuid', 'vsanFormatVersion', 'ownerVc');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanXVCClientInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanXVCClientInfo', 'VsanXVCClientInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanXVCClientInfo', 'VsanXVCClientInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanXVCDatastoreConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['xvcDatastores', 'VsanXVCDatastoreInfo', 1, 0],
);


VIMRuntime::make_get_set('VsanXVCDatastoreConfig', 'xvcDatastores');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanXVCDatastoreInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['datastore', 'ManagedObjectReference', undef, 1],
   ['ownerVc', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanXVCDatastoreInfo', 'datastore', 'ownerVc');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanXVCDatastoreInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanXVCDatastoreInfo', 'VsanXVCDatastoreInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanXVCDatastoreInfo', 'VsanXVCDatastoreInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanXvcClientConfig;
our @ISA = qw(VsanDatastoreSpec);

our @property_list = (
   ['xvcClusters', 'VsanXVCClientInfo', 1, 0],
);


VIMRuntime::make_get_set('VsanXvcClientConfig', 'xvcClusters');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanXvcClientInfoSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['clientVc', undef, undef, 1],
   ['vcUuid', undef, undef, 0],
   ['vcVersion', undef, undef, 0],
   ['cluster', 'ManagedObjectReference', undef, 0],
   ['clusterName', undef, undef, 0],
   ['clusterUuid', undef, undef, 0],
   ['vsanFormatVersion', undef, undef, 0],
   ['minVsanFormatVersion', undef, undef, 0],
   ['datastore', 'ManagedObjectReference', 1, 0],
);


VIMRuntime::make_get_set('VsanXvcClientInfoSpec', 'clientVc', 'vcUuid', 'vcVersion', 'cluster', 'clusterName', 'clusterUuid', 'vsanFormatVersion', 'minVsanFormatVersion', 'datastore');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanXvcQueryCriteria;
our @ISA = qw(DynamicData);

our @property_list = (
   ['property', undef, undef, 1],
   ['operator', undef, undef, 0],
   ['comparableValue', 'anyType', undef, 0],
   ['comparableList', 'DynamicArray', undef, 0],
   ['ignoreCase', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanXvcQueryCriteria', 'property', 'operator', 'comparableValue', 'comparableList', 'ignoreCase');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanXvcQueryCriteria;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanXvcQueryCriteria', 'VsanXvcQueryCriteria', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanXvcQueryCriteria', 'VsanXvcQueryCriteria');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanXvcQueryFilter;
our @ISA = qw(DynamicData);

our @property_list = (
   ['criterias', 'VsanXvcQueryCriteria', 1, 0],
   ['operator', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanXvcQueryFilter', 'criterias', 'operator');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanXvcQueryPropertyValue;
our @ISA = qw(DynamicData);

our @property_list = (
   ['value', 'anyType', undef, 0],
);


VIMRuntime::make_get_set('VsanXvcQueryPropertyValue', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanXvcQueryPropertyValue;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanXvcQueryPropertyValue', 'VsanXvcQueryPropertyValue', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanXvcQueryPropertyValue', 'VsanXvcQueryPropertyValue');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanXvcQueryResultSet;
our @ISA = qw(DynamicData);

our @property_list = (
   ['properties', undef, 1, 0],
   ['resultItems', 'VsanXvcResultItem', 1, 0],
   ['totalCount', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanXvcQueryResultSet', 'properties', 'resultItems', 'totalCount');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanXvcQueryResultSet;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanXvcQueryResultSet', 'VsanXvcQueryResultSet', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanXvcQueryResultSet', 'VsanXvcQueryResultSet');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanXvcQuerySpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['objectModel', undef, undef, 0],
   ['properties', undef, 1, 0],
   ['filter', 'VsanXvcQueryFilter', undef, 0],
   ['offset', undef, undef, 0],
   ['limit', undef, undef, 0],
   ['returnTotalCount', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanXvcQuerySpec', 'objectModel', 'properties', 'filter', 'offset', 'limit', 'returnTotalCount');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanXvcQuerySpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanXvcQuerySpec', 'VsanXvcQuerySpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanXvcQuerySpec', 'VsanXvcQuerySpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanXvcResultItem;
our @ISA = qw(DynamicData);

our @property_list = (
   ['propertyValues', 'VsanXvcQueryPropertyValue', 1, 0],
);


VIMRuntime::make_get_set('VsanXvcResultItem', 'propertyValues');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanXvcResultItem;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanXvcResultItem', 'VsanXvcResultItem', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanXvcResultItem', 'VsanXvcResultItem');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostAbortWipeDiskStatus;
our @ISA = qw(DynamicData);

our @property_list = (
   ['disk', undef, undef, 1],
   ['success', 'boolean', undef, 1],
   ['reason', 'LocalizableMessage', 1, 0],
);


VIMRuntime::make_get_set('VsanHostAbortWipeDiskStatus', 'disk', 'success', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanHostAbortWipeDiskStatus;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanHostAbortWipeDiskStatus', 'VsanHostAbortWipeDiskStatus', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanHostAbortWipeDiskStatus', 'VsanHostAbortWipeDiskStatus');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostAboutInfoEx;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 0],
   ['version', undef, undef, 0],
   ['build', undef, undef, 0],
   ['buildType', undef, undef, 0],
   ['apiVersion', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanHostAboutInfoEx', 'name', 'version', 'build', 'buildType', 'apiVersion');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanAddStoragePoolDiskSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['disks', 'VsanStoragePoolDisk', 1, 1],
);


VIMRuntime::make_get_set('VsanAddStoragePoolDiskSpec', 'host', 'disks');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanAddStoragePoolDiskSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanAddStoragePoolDiskSpec', 'VsanAddStoragePoolDiskSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanAddStoragePoolDiskSpec', 'VsanAddStoragePoolDiskSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanComplianceDetail;
our @ISA = qw(DynamicData);

our @property_list = (
   ['objectUUID', undef, undef, 1],
   ['complianceStatus', undef, undef, 1],
   ['objectHealth', undef, undef, 1],
   ['violatedPolicies', 'VsanPolicyStatus', 1, 0],
);


VIMRuntime::make_get_set('VsanComplianceDetail', 'objectUUID', 'complianceStatus', 'objectHealth', 'violatedPolicies');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanComplianceDetail;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanComplianceDetail', 'VsanComplianceDetail', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanComplianceDetail', 'VsanComplianceDetail');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanComplianceResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['checkTime', undef, undef, 1],
   ['policyId', undef, undef, 0],
   ['policyGen', undef, undef, 0],
   ['objComplianceDetail', 'VsanComplianceDetail', 1, 0],
);


VIMRuntime::make_get_set('VsanComplianceResult', 'checkTime', 'policyId', 'policyGen', 'objComplianceDetail');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostConfigInfoEx;
our @ISA = qw(VsanHostConfigInfo);

our @property_list = (
   ['encryptionInfo', 'VsanHostEncryptionInfo', undef, 0],
   ['dataEfficiencyInfo', 'VsanDataEfficiencyConfig', undef, 0],
   ['resyncIopsLimitInfo', 'ResyncIopsInfo', undef, 0],
   ['extendedConfig', 'VsanExtendedConfig', undef, 0],
   ['datastoreInfo', 'VsanDatastoreConfig', undef, 0],
   ['unmapConfig', 'VsanUnmapConfig', undef, 0],
   ['witnessHostConfig', 'VsanWitnessHostConfig', 1, 0],
   ['internalExtendedConfig', 'VsanInternalExtendedConfig', undef, 0],
   ['metricsConfig', 'VsanMetricsConfig', undef, 0],
   ['unicastConfig', 'VsanHostServerClusterUnicastConfig', undef, 0],
   ['rdmaConfig', 'VsanRdmaConfig', undef, 0],
   ['dataInTransitEncryptionInfo', 'VsanInTransitEncryptionInfo', undef, 0],
   ['mode', undef, undef, 0],
   ['serverClusterConfigs', 'RemoteVsanServerClusterConfig', 1, 0],
);


VIMRuntime::make_get_set('VsanHostConfigInfoEx', 'encryptionInfo', 'dataEfficiencyInfo', 'resyncIopsLimitInfo', 'extendedConfig', 'datastoreInfo', 'unmapConfig', 'witnessHostConfig', 'internalExtendedConfig', 'metricsConfig', 'unicastConfig', 'rdmaConfig', 'dataInTransitEncryptionInfo', 'mode', 'serverClusterConfigs');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostCreateNativeKeyProviderSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['provider', undef, undef, 1],
   ['keyId', undef, undef, 0],
   ['keyDerivationKey', undef, undef, 0],
   ['tpmRequired', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanHostCreateNativeKeyProviderSpec', 'provider', 'keyId', 'keyDerivationKey', 'tpmRequired');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanInTransitEncryptionInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['enabled', 'boolean', undef, 0],
   ['rekeyInterval', undef, undef, 0],
   ['transitionState', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanInTransitEncryptionInfo', 'enabled', 'rekeyInterval', 'transitionState');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanDeleteStoragePoolDiskSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['diskUuids', undef, 1, 1],
   ['maintenanceSpec', 'HostMaintenanceSpec', undef, 1],
);


VIMRuntime::make_get_set('VsanDeleteStoragePoolDiskSpec', 'diskUuids', 'maintenanceSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VimVsanHostDiskMapInfoEx;
our @ISA = qw(DynamicData);

our @property_list = (
   ['mapping', 'VsanHostDiskMapping', undef, 1],
   ['isMounted', 'boolean', undef, 1],
   ['unlockedEncrypted', 'boolean', undef, 0],
   ['isAllFlash', 'boolean', undef, 1],
   ['isDataEfficiency', 'boolean', undef, 0],
   ['encryptionInfo', 'VsanDataEncryptionConfig', undef, 0],
   ['dataEfficiencyConfig', 'VsanDataEfficiencyConfig', undef, 0],
   ['diskgroupCapability', undef, 1, 0],
);


VIMRuntime::make_get_set('VimVsanHostDiskMapInfoEx', 'mapping', 'isMounted', 'unlockedEncrypted', 'isAllFlash', 'isDataEfficiency', 'encryptionInfo', 'dataEfficiencyConfig', 'diskgroupCapability');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVimVsanHostDiskMapInfoEx;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VimVsanHostDiskMapInfoEx', 'VimVsanHostDiskMapInfoEx', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVimVsanHostDiskMapInfoEx', 'VimVsanHostDiskMapInfoEx');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VimVsanHostDiskMappingCreationSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['cacheDisks', 'HostScsiDisk', 1, 0],
   ['capacityDisks', 'HostScsiDisk', 1, 0],
   ['creationType', undef, undef, 1],
);


VIMRuntime::make_get_set('VimVsanHostDiskMappingCreationSpec', 'host', 'cacheDisks', 'capacityDisks', 'creationType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VimVsanHostDiskResultEx;
our @ISA = qw(VsanHostDiskResult);

our @property_list = (
   ['vsanDirectTagged', 'boolean', undef, 1],
   ['storagePoolDiskState', undef, undef, 0],
   ['storagePoolDiskError', 'LocalizedMethodFault', undef, 0],
   ['isCapacityFlash', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VimVsanHostDiskResultEx', 'vsanDirectTagged', 'storagePoolDiskState', 'storagePoolDiskError', 'isCapacityFlash');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostDrsStats;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['stats', undef, undef, 1],
   ['readLocalityPresented', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanHostDrsStats', 'host', 'stats', 'readLocalityPresented');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanHostDrsStats;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanHostDrsStats', 'VsanHostDrsStats', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanHostDrsStats', 'VsanHostDrsStats');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostEncryptionInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['enabled', 'boolean', undef, 0],
   ['kekId', undef, undef, 0],
   ['hostKeyId', undef, undef, 0],
   ['kmipServers', 'KmipServerSpec', 1, 0],
   ['kmsServerCerts', undef, 1, 0],
   ['clientKey', undef, undef, 0],
   ['clientCert', undef, undef, 0],
   ['dekGenerationId', undef, undef, 0],
   ['changing', 'boolean', undef, 0],
   ['eraseDisksBeforeUse', 'boolean', undef, 0],
   ['wrappedDek', undef, undef, 0],
   ['dekId', undef, undef, 0],
   ['oldWrappedDek', undef, undef, 0],
   ['oldDekId', undef, undef, 0],
   ['kekVerifier', undef, undef, 0],
   ['dekVerifier', undef, undef, 0],
   ['oldDekVerifier', undef, undef, 0],
   ['iv', undef, undef, 0],
   ['syncing', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanHostEncryptionInfo', 'enabled', 'kekId', 'hostKeyId', 'kmipServers', 'kmsServerCerts', 'clientKey', 'clientCert', 'dekGenerationId', 'changing', 'eraseDisksBeforeUse', 'wrappedDek', 'dekId', 'oldWrappedDek', 'oldDekId', 'kekVerifier', 'dekVerifier', 'oldDekVerifier', 'iv', 'syncing');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostIpConfigEx;
our @ISA = qw(VsanHostIpConfig);

our @property_list = (
   ['upstreamIpV6Address', undef, undef, 0],
   ['downstreamIpV6Address', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanHostIpConfigEx', 'upstreamIpV6Address', 'downstreamIpV6Address');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanPolicyStatus;
our @ISA = qw(DynamicData);

our @property_list = (
   ['id', undef, undef, 1],
   ['expectedValue', undef, undef, 1],
   ['currentValue', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanPolicyStatus', 'id', 'expectedValue', 'currentValue');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanPolicyStatus;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanPolicyStatus', 'VsanPolicyStatus', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanPolicyStatus', 'VsanPolicyStatus');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostPortConfigEx;
our @ISA = qw(VsanHostConfigInfoNetworkInfoPortConfig);

our @property_list = (
   ['trafficTypes', undef, 1, 0],
);


VIMRuntime::make_get_set('VsanHostPortConfigEx', 'trafficTypes');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VimVsanHostQueryVsanDisksSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['diskName', undef, undef, 0],
   ['vsanDiskType', undef, undef, 0],
);


VIMRuntime::make_get_set('VimVsanHostQueryVsanDisksSpec', 'diskName', 'vsanDiskType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package RemoteVsanServerClusterConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['clusterUuid', undef, undef, 1],
   ['siteAffinity', 'SiteAffinityInfo', undef, 0],
);


VIMRuntime::make_get_set('RemoteVsanServerClusterConfig', 'clusterUuid', 'siteAffinity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfRemoteVsanServerClusterConfig;
our @ISA = qw(ComplexType);

our @property_list = (
   ['RemoteVsanServerClusterConfig', 'RemoteVsanServerClusterConfig', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfRemoteVsanServerClusterConfig', 'RemoteVsanServerClusterConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostRuntimeStats;
our @ISA = qw(DynamicData);

our @property_list = (
   ['resyncIopsInfo', 'ResyncIopsInfo', undef, 0],
   ['configGeneration', 'VsanConfigGeneration', undef, 0],
   ['supportedClusterSize', undef, undef, 0],
   ['repairTimerInfo', 'RepairTimerInfo', undef, 0],
   ['componentLimitPerCluster', undef, undef, 0],
   ['maxWitnessClusters', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanHostRuntimeStats', 'resyncIopsInfo', 'configGeneration', 'supportedClusterSize', 'repairTimerInfo', 'componentLimitPerCluster', 'maxWitnessClusters');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostServerClusterUnicastConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['remoteUnicastConfig', 'VsanHostServerClusterUnicastInfo', 1, 0],
);


VIMRuntime::make_get_set('VsanHostServerClusterUnicastConfig', 'remoteUnicastConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostServerClusterUnicastInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['clusterUuid', undef, undef, 1],
   ['unicastInfo', 'VsanServerHostUnicastInfo', 1, 0],
);


VIMRuntime::make_get_set('VsanHostServerClusterUnicastInfo', 'clusterUuid', 'unicastInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanHostServerClusterUnicastInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanHostServerClusterUnicastInfo', 'VsanHostServerClusterUnicastInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanHostServerClusterUnicastInfo', 'VsanHostServerClusterUnicastInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SiteAffinityInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['siteId', undef, undef, 0],
);


VIMRuntime::make_get_set('SiteAffinityInfo', 'name', 'siteId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanStoragePoolDisk;
our @ISA = qw(DynamicData);

our @property_list = (
   ['diskName', undef, undef, 1],
   ['diskType', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanStoragePoolDisk', 'diskName', 'diskType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanStoragePoolDisk;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanStoragePoolDisk', 'VsanStoragePoolDisk', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanStoragePoolDisk', 'VsanStoragePoolDisk');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VimVsanHostStoragePoolDiskInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['disk', 'HostScsiDisk', undef, 1],
   ['vsanUuid', undef, undef, 0],
   ['error', 'LocalizedMethodFault', undef, 0],
   ['isMounted', 'boolean', undef, 0],
   ['isEncrypted', 'boolean', undef, 0],
   ['dekId', undef, undef, 0],
   ['diskType', undef, undef, 0],
);


VIMRuntime::make_get_set('VimVsanHostStoragePoolDiskInfo', 'disk', 'vsanUuid', 'error', 'isMounted', 'isEncrypted', 'dekId', 'diskType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVimVsanHostStoragePoolDiskInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VimVsanHostStoragePoolDiskInfo', 'VimVsanHostStoragePoolDiskInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVimVsanHostStoragePoolDiskInfo', 'VimVsanHostStoragePoolDiskInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VimVsanHostStoragePoolInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['storagePoolDisks', 'VimVsanHostStoragePoolDiskInfo', 1, 0],
);


VIMRuntime::make_get_set('VimVsanHostStoragePoolInfo', 'storagePoolDisks');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVimVsanHostStoragePoolInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VimVsanHostStoragePoolInfo', 'VimVsanHostStoragePoolInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVimVsanHostStoragePoolInfo', 'VimVsanHostStoragePoolInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VimVsanHostTrimDiskEntry;
our @ISA = qw(DynamicData);

our @property_list = (
   ['diskName', undef, undef, 1],
   ['diskType', undef, undef, 0],
);


VIMRuntime::make_get_set('VimVsanHostTrimDiskEntry', 'diskName', 'diskType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVimVsanHostTrimDiskEntry;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VimVsanHostTrimDiskEntry', 'VimVsanHostTrimDiskEntry', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVimVsanHostTrimDiskEntry', 'VimVsanHostTrimDiskEntry');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VimVsanHostTrimDiskSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['disks', 'VimVsanHostTrimDiskEntry', 1, 0],
);


VIMRuntime::make_get_set('VimVsanHostTrimDiskSpec', 'disks');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VimVsanHostUpdateStoragePoolDiskSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['diskUuids', undef, 1, 0],
   ['diskFormatVersion', undef, undef, 0],
);


VIMRuntime::make_get_set('VimVsanHostUpdateStoragePoolDiskSpec', 'diskUuids', 'diskFormatVersion');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostAssociatedObjects;
our @ISA = qw(DynamicData);

our @property_list = (
   ['spbmProfileId', undef, undef, 1],
   ['spbmProfileGenerationNum', undef, undef, 1],
   ['vsanObjects', undef, 1, 0],
);


VIMRuntime::make_get_set('VsanHostAssociatedObjects', 'spbmProfileId', 'spbmProfileGenerationNum', 'vsanObjects');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanHostAssociatedObjects;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanHostAssociatedObjects', 'VsanHostAssociatedObjects', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanHostAssociatedObjects', 'VsanHostAssociatedObjects');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostAssociatedObjectsResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['data', 'VsanHostAssociatedObjects', 1, 1],
   ['offset', undef, undef, 1],
   ['limit', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanHostAssociatedObjectsResult', 'data', 'offset', 'limit');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanComplianceQuerySpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['uuids', undef, 1, 0],
   ['spbmProfileId', undef, undef, 0],
   ['spbmProfileGenerationId', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanComplianceQuerySpec', 'uuids', 'spbmProfileId', 'spbmProfileGenerationId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostComponentSyncState;
our @ISA = qw(DynamicData);

our @property_list = (
   ['uuid', undef, undef, 1],
   ['diskUuid', undef, undef, 1],
   ['hostUuid', undef, undef, 1],
   ['bytesToSync', undef, undef, 1],
   ['recoveryETA', undef, undef, 0],
   ['reasons', undef, 1, 0],
);


VIMRuntime::make_get_set('VsanHostComponentSyncState', 'uuid', 'diskUuid', 'hostUuid', 'bytesToSync', 'recoveryETA', 'reasons');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanHostComponentSyncState;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanHostComponentSyncState', 'VsanHostComponentSyncState', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanHostComponentSyncState', 'VsanHostComponentSyncState');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VimVsanHostVsanDirectStorage;
our @ISA = qw(DynamicData);

our @property_list = (
   ['scsiDisks', 'VimVsanHostVsanScsiDisk', 1, 0],
   ['tier', undef, undef, 0],
);


VIMRuntime::make_get_set('VimVsanHostVsanDirectStorage', 'scsiDisks', 'tier');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVimVsanHostVsanDirectStorage;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VimVsanHostVsanDirectStorage', 'VimVsanHostVsanDirectStorage', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVimVsanHostVsanDirectStorage', 'VimVsanHostVsanDirectStorage');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VimVsanHostVsanDiskManagementSystemCapability;
our @ISA = qw(DynamicData);

our @property_list = (
   ['version', undef, undef, 1],
);


VIMRuntime::make_get_set('VimVsanHostVsanDiskManagementSystemCapability', 'version');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VimVsanHostVsanHostCapability;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['isSupported', 'boolean', undef, 1],
   ['isLicensed', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('VimVsanHostVsanHostCapability', 'host', 'isSupported', 'isLicensed');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVimVsanHostVsanHostCapability;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VimVsanHostVsanHostCapability', 'VimVsanHostVsanHostCapability', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVimVsanHostVsanHostCapability', 'VimVsanHostVsanHostCapability');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VimVsanHostVsanManagedDisksInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vSANDirectDisks', 'VimVsanHostVsanDirectStorage', 1, 0],
   ['vSANDiskMapInfo', 'VimVsanHostDiskMapInfoEx', 1, 0],
   ['vSANPMemInfo', 'VimVsanHostVsanManagedPMemInfo', undef, 0],
   ['storagePools', 'VimVsanHostStoragePoolInfo', 1, 0],
);


VIMRuntime::make_get_set('VimVsanHostVsanManagedDisksInfo', 'vSANDirectDisks', 'vSANDiskMapInfo', 'vSANPMemInfo', 'storagePools');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VimVsanHostVsanManagedPMemInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['localPMemDatastores', 'ManagedObjectReference', 1, 0],
);


VIMRuntime::make_get_set('VimVsanHostVsanManagedPMemInfo', 'localPMemDatastores');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanObjectProfileInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vsanObjectUuid', undef, undef, 1],
   ['spbmProfileId', undef, undef, 1],
   ['spbmProfileGenerationNum', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanObjectProfileInfo', 'vsanObjectUuid', 'spbmProfileId', 'spbmProfileGenerationNum');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostVsanObjectSyncState;
our @ISA = qw(DynamicData);

our @property_list = (
   ['uuid', undef, undef, 1],
   ['components', 'VsanHostComponentSyncState', 1, 1],
);


VIMRuntime::make_get_set('VsanHostVsanObjectSyncState', 'uuid', 'components');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanHostVsanObjectSyncState;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanHostVsanObjectSyncState', 'VsanHostVsanObjectSyncState', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanHostVsanObjectSyncState', 'VsanHostVsanObjectSyncState');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VimVsanHostVsanScsiDisk;
our @ISA = qw(DynamicData);

our @property_list = (
   ['capacity', 'HostDiskDimensionsLba', undef, 1],
   ['usedCapacity', undef, undef, 0],
   ['devicePath', undef, undef, 1],
   ['ssd', 'boolean', undef, 0],
   ['localDisk', 'boolean', undef, 0],
   ['scsiDiskType', undef, undef, 0],
   ['uuid', undef, undef, 1],
   ['operationalState', undef, 1, 0],
   ['canonicalName', undef, undef, 0],
   ['displayName', undef, undef, 0],
   ['lunType', undef, undef, 1],
   ['vendor', undef, undef, 0],
   ['model', undef, undef, 0],
   ['mountInfo', 'HostMountInfo', undef, 0],
);


VIMRuntime::make_get_set('VimVsanHostVsanScsiDisk', 'capacity', 'usedCapacity', 'devicePath', 'ssd', 'localDisk', 'scsiDiskType', 'uuid', 'operationalState', 'canonicalName', 'displayName', 'lunType', 'vendor', 'model', 'mountInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVimVsanHostVsanScsiDisk;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VimVsanHostVsanScsiDisk', 'VimVsanHostVsanScsiDisk', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVimVsanHostVsanScsiDisk', 'VimVsanHostVsanScsiDisk');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostVsanObjectSyncQueryResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['totalObjectsToSync', undef, undef, 0],
   ['totalBytesToSync', undef, undef, 0],
   ['totalRecoveryETA', undef, undef, 0],
   ['objects', 'VsanHostVsanObjectSyncState', 1, 0],
   ['syncingObjectRecoveryDetails', 'VsanSyncingObjectRecoveryDetails', undef, 0],
);


VIMRuntime::make_get_set('VsanHostVsanObjectSyncQueryResult', 'totalObjectsToSync', 'totalBytesToSync', 'totalRecoveryETA', 'objects', 'syncingObjectRecoveryDetails');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanSyncingObjectRecoveryDetails;
our @ISA = qw(DynamicData);

our @property_list = (
   ['activelySyncingObjectRecoveryETA', undef, undef, 0],
   ['queuedForSyncObjectRecoveryETA', undef, undef, 0],
   ['suspendedObjectRecoveryETA', undef, undef, 0],
   ['activeObjectsToSync', undef, undef, 0],
   ['queuedObjectsToSync', undef, undef, 0],
   ['suspendedObjectsToSync', undef, undef, 0],
   ['bytesToSyncForActiveObjects', undef, undef, 0],
   ['bytesToSyncForQueuedObjects', undef, undef, 0],
   ['bytesToSyncForSuspendedObjects', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanSyncingObjectRecoveryDetails', 'activelySyncingObjectRecoveryETA', 'queuedForSyncObjectRecoveryETA', 'suspendedObjectRecoveryETA', 'activeObjectsToSync', 'queuedObjectsToSync', 'suspendedObjectsToSync', 'bytesToSyncForActiveObjects', 'bytesToSyncForQueuedObjects', 'bytesToSyncForSuspendedObjects');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanWhatIfEvacDetail;
our @ISA = qw(DynamicData);

our @property_list = (
   ['success', 'boolean', undef, 0],
   ['bytesToSync', undef, undef, 0],
   ['inaccessibleObjects', undef, 1, 0],
   ['incompliantObjects', undef, 1, 0],
   ['extraSpaceNeeded', undef, undef, 0],
   ['failedDueToInaccessibleObjects', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VsanWhatIfEvacDetail', 'success', 'bytesToSync', 'inaccessibleObjects', 'incompliantObjects', 'extraSpaceNeeded', 'failedDueToInaccessibleObjects');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanWhatIfEvacResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['noAction', 'VsanWhatIfEvacDetail', undef, 1],
   ['ensureAccess', 'VsanWhatIfEvacDetail', undef, 1],
   ['evacAllData', 'VsanWhatIfEvacDetail', undef, 1],
);


VIMRuntime::make_get_set('VsanWhatIfEvacResult', 'noAction', 'ensureAccess', 'evacAllData');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostWipeDiskStatus;
our @ISA = qw(DynamicData);

our @property_list = (
   ['disk', undef, undef, 1],
   ['eligible', undef, undef, 1],
   ['ineligibleReason', 'LocalizableMessage', 1, 0],
   ['wipeState', undef, undef, 0],
   ['percentageCompleted', undef, undef, 0],
   ['estimatedTime', undef, undef, 0],
   ['wipeStartTime', undef, undef, 0],
   ['wipeCompleteTime', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanHostWipeDiskStatus', 'disk', 'eligible', 'ineligibleReason', 'wipeState', 'percentageCompleted', 'estimatedTime', 'wipeStartTime', 'wipeCompleteTime');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanHostWipeDiskStatus;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanHostWipeDiskStatus', 'VsanHostWipeDiskStatus', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanHostWipeDiskStatus', 'VsanHostWipeDiskStatus');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanBrokenDiskChainIssue;
our @ISA = qw(VsanUpgradeSystemPreflightCheckIssue);

our @property_list = (
   ['uuids', undef, 1, 1],
);


VIMRuntime::make_get_set('VsanBrokenDiskChainIssue', 'uuids');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanDisallowDataMovementIssue;
our @ISA = qw(VsanUpgradeSystemPreflightCheckIssue);

our @property_list = (
);


VIMRuntime::make_get_set('VsanDisallowDataMovementIssue');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanDisallowEvacuateDataIssue;
our @ISA = qw(VsanUpgradeSystemPreflightCheckIssue);

our @property_list = (
   ['hosts', 'ManagedObjectReference', 1, 0],
);


VIMRuntime::make_get_set('VsanDisallowEvacuateDataIssue', 'hosts');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanDiskUnhealthIssue;
our @ISA = qw(VsanUpgradeSystemPreflightCheckIssue);

our @property_list = (
   ['uuids', undef, 1, 1],
);


VIMRuntime::make_get_set('VsanDiskUnhealthIssue', 'uuids');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHigherObjectsPresentDuringDowngradeIssue;
our @ISA = qw(VsanUpgradeSystemPreflightCheckIssue);

our @property_list = (
   ['uuids', undef, 1, 1],
);


VIMRuntime::make_get_set('VsanHigherObjectsPresentDuringDowngradeIssue', 'uuids');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostPropertyRetrieveIssue;
our @ISA = qw(VsanUpgradeSystemPreflightCheckIssue);

our @property_list = (
   ['hosts', 'ManagedObjectReference', 1, 1],
);


VIMRuntime::make_get_set('VsanHostPropertyRetrieveIssue', 'hosts');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostWithHybridDiskgroupIssue;
our @ISA = qw(VsanUpgradeSystemPreflightCheckIssue);

our @property_list = (
   ['hosts', 'ManagedObjectReference', 1, 1],
);


VIMRuntime::make_get_set('VsanHostWithHybridDiskgroupIssue', 'hosts');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanHostsCompressionOnlyNotSupported;
our @ISA = qw(VsanUpgradeSystemPreflightCheckIssue);

our @property_list = (
   ['hosts', 'ManagedObjectReference', 1, 1],
);


VIMRuntime::make_get_set('VsanHostsCompressionOnlyNotSupported', 'hosts');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanMixedEsxVersionInClientIssue;
our @ISA = qw(VsanUpgradeSystemPreflightCheckIssue);

our @property_list = (
   ['clusterName', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanMixedEsxVersionInClientIssue', 'clusterName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanMixedEsxVersionIssue;
our @ISA = qw(VsanUpgradeSystemPreflightCheckIssue);

our @property_list = (
);


VIMRuntime::make_get_set('VsanMixedEsxVersionIssue');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanObjectInaccessibleIssue;
our @ISA = qw(VsanUpgradeSystemPreflightCheckIssue);

our @property_list = (
   ['uuids', undef, 1, 1],
);


VIMRuntime::make_get_set('VsanObjectInaccessibleIssue', 'uuids');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanObjectPolicyIssue;
our @ISA = qw(VsanUpgradeSystemPreflightCheckIssue);

our @property_list = (
   ['uuids', undef, 1, 1],
);


VIMRuntime::make_get_set('VsanObjectPolicyIssue', 'uuids');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanRemoteClusterNotCompatible;
our @ISA = qw(VsanUpgradeSystemPreflightCheckIssue);

our @property_list = (
   ['compatibilityInfo', 'KeyAnyValue', 1, 1],
);


VIMRuntime::make_get_set('VsanRemoteClusterNotCompatible', 'compatibilityInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanUnknownScanIssue;
our @ISA = qw(VsanUpgradeSystemPreflightCheckIssue);

our @property_list = (
   ['uuids', undef, 1, 1],
);


VIMRuntime::make_get_set('VsanUnknownScanIssue', 'uuids');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanUnsupportedHighDiskVersionIssue;
our @ISA = qw(VsanUpgradeSystemPreflightCheckIssue);

our @property_list = (
   ['hosts', 'ManagedObjectReference', 1, 1],
);


VIMRuntime::make_get_set('VsanUnsupportedHighDiskVersionIssue', 'hosts');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AboutInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['fullName', undef, undef, 1],
   ['vendor', undef, undef, 1],
   ['version', undef, undef, 1],
   ['patchLevel', undef, undef, 0],
   ['build', undef, undef, 1],
   ['localeVersion', undef, undef, 0],
   ['localeBuild', undef, undef, 0],
   ['osType', undef, undef, 1],
   ['productLineId', undef, undef, 1],
   ['apiType', undef, undef, 1],
   ['apiVersion', undef, undef, 1],
   ['instanceUuid', undef, undef, 0],
   ['licenseProductName', undef, undef, 0],
   ['licenseProductVersion', undef, undef, 0],
);


VIMRuntime::make_get_set('AboutInfo', 'name', 'fullName', 'vendor', 'version', 'patchLevel', 'build', 'localeVersion', 'localeBuild', 'osType', 'productLineId', 'apiType', 'apiVersion', 'instanceUuid', 'licenseProductName', 'licenseProductVersion');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AuthorizationDescription;
our @ISA = qw(DynamicData);

our @property_list = (
   ['privilege', 'ElementDescription', 1, 1],
   ['privilegeGroup', 'ElementDescription', 1, 1],
);


VIMRuntime::make_get_set('AuthorizationDescription', 'privilege', 'privilegeGroup');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package Permission;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entity', 'ManagedObjectReference', undef, 0],
   ['principal', undef, undef, 1],
   ['group', 'boolean', undef, 1],
   ['roleId', undef, undef, 1],
   ['propagate', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('Permission', 'entity', 'principal', 'group', 'roleId', 'propagate');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfPermission;
our @ISA = qw(ComplexType);

our @property_list = (
   ['Permission', 'Permission', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfPermission', 'Permission');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AuthorizationRole;
our @ISA = qw(DynamicData);

our @property_list = (
   ['roleId', undef, undef, 1],
   ['system', 'boolean', undef, 1],
   ['name', undef, undef, 1],
   ['info', 'Description', undef, 1],
   ['privilege', undef, 1, 0],
);


VIMRuntime::make_get_set('AuthorizationRole', 'roleId', 'system', 'name', 'info', 'privilege');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfAuthorizationRole;
our @ISA = qw(ComplexType);

our @property_list = (
   ['AuthorizationRole', 'AuthorizationRole', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfAuthorizationRole', 'AuthorizationRole');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AuthorizationPrivilege;
our @ISA = qw(DynamicData);

our @property_list = (
   ['privId', undef, undef, 1],
   ['onParent', 'boolean', undef, 1],
   ['name', undef, undef, 1],
   ['privGroupName', undef, undef, 1],
);


VIMRuntime::make_get_set('AuthorizationPrivilege', 'privId', 'onParent', 'name', 'privGroupName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfAuthorizationPrivilege;
our @ISA = qw(ComplexType);

our @property_list = (
   ['AuthorizationPrivilege', 'AuthorizationPrivilege', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfAuthorizationPrivilege', 'AuthorizationPrivilege');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PrivilegeAvailability;
our @ISA = qw(DynamicData);

our @property_list = (
   ['privId', undef, undef, 1],
   ['isGranted', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('PrivilegeAvailability', 'privId', 'isGranted');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfPrivilegeAvailability;
our @ISA = qw(ComplexType);

our @property_list = (
   ['PrivilegeAvailability', 'PrivilegeAvailability', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfPrivilegeAvailability', 'PrivilegeAvailability');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EntityPrivilege;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entity', 'ManagedObjectReference', undef, 1],
   ['privAvailability', 'PrivilegeAvailability', 1, 1],
);


VIMRuntime::make_get_set('EntityPrivilege', 'entity', 'privAvailability');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfEntityPrivilege;
our @ISA = qw(ComplexType);

our @property_list = (
   ['EntityPrivilege', 'EntityPrivilege', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfEntityPrivilege', 'EntityPrivilege');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UserPrivilegeResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entity', 'ManagedObjectReference', undef, 1],
   ['privileges', undef, 1, 0],
);


VIMRuntime::make_get_set('UserPrivilegeResult', 'entity', 'privileges');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfUserPrivilegeResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['UserPrivilegeResult', 'UserPrivilegeResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfUserPrivilegeResult', 'UserPrivilegeResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package BatchResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['result', undef, undef, 1],
   ['hostKey', undef, undef, 1],
   ['ds', 'ManagedObjectReference', undef, 0],
   ['fault', 'LocalizedMethodFault', undef, 0],
);


VIMRuntime::make_get_set('BatchResult', 'result', 'hostKey', 'ds', 'fault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package BoolPolicy;
our @ISA = qw(InheritablePolicy);

our @property_list = (
   ['value', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('BoolPolicy', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package Capability;
our @ISA = qw(DynamicData);

our @property_list = (
   ['provisioningSupported', 'boolean', undef, 1],
   ['multiHostSupported', 'boolean', undef, 1],
   ['userShellAccessSupported', 'boolean', undef, 1],
   ['supportedEVCMode', 'EVCMode', 1, 0],
   ['supportedEVCGraphicsMode', 'FeatureEVCMode', 1, 0],
   ['networkBackupAndRestoreSupported', 'boolean', undef, 0],
   ['ftDrsWithoutEvcSupported', 'boolean', undef, 0],
   ['hciWorkflowSupported', 'boolean', undef, 0],
   ['computePolicyVersion', undef, undef, 0],
   ['clusterPlacementSupported', 'boolean', undef, 0],
   ['lifecycleManagementSupported', 'boolean', undef, 0],
   ['hostSeedingSupported', 'boolean', undef, 0],
   ['scalableSharesSupported', 'boolean', undef, 0],
   ['hadcsSupported', 'boolean', undef, 0],
   ['configMgmtSupported', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('Capability', 'provisioningSupported', 'multiHostSupported', 'userShellAccessSupported', 'supportedEVCMode', 'supportedEVCGraphicsMode', 'networkBackupAndRestoreSupported', 'ftDrsWithoutEvcSupported', 'hciWorkflowSupported', 'computePolicyVersion', 'clusterPlacementSupported', 'lifecycleManagementSupported', 'hostSeedingSupported', 'scalableSharesSupported', 'hadcsSupported', 'configMgmtSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterComputeResourceSummary;
our @ISA = qw(ComputeResourceSummary);

our @property_list = (
   ['currentFailoverLevel', undef, undef, 1],
   ['admissionControlInfo', 'ClusterDasAdmissionControlInfo', undef, 0],
   ['numVmotions', undef, undef, 1],
   ['targetBalance', undef, undef, 0],
   ['currentBalance', undef, undef, 0],
   ['drsScore', undef, undef, 0],
   ['numVmsPerDrsScoreBucket', undef, 1, 0],
   ['usageSummary', 'ClusterUsageSummary', undef, 0],
   ['currentEVCModeKey', undef, undef, 0],
   ['currentEVCGraphicsModeKey', undef, undef, 0],
   ['dasData', 'ClusterDasData', undef, 0],
   ['clusterMaintenanceModeStatus', undef, undef, 0],
   ['vcsHealthStatus', undef, undef, 0],
   ['vcsSlots', 'ClusterComputeResourceVcsSlots', 1, 0],
);


VIMRuntime::make_get_set('ClusterComputeResourceSummary', 'currentFailoverLevel', 'admissionControlInfo', 'numVmotions', 'targetBalance', 'currentBalance', 'drsScore', 'numVmsPerDrsScoreBucket', 'usageSummary', 'currentEVCModeKey', 'currentEVCGraphicsModeKey', 'dasData', 'clusterMaintenanceModeStatus', 'vcsHealthStatus', 'vcsSlots');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterComputeResourceDVSSetting;
our @ISA = qw(DynamicData);

our @property_list = (
   ['dvSwitch', 'ManagedObjectReference', undef, 1],
   ['pnicDevices', undef, 1, 0],
   ['dvPortgroupSetting', 'ClusterComputeResourceDVSSettingDVPortgroupToServiceMapping', 1, 0],
);


VIMRuntime::make_get_set('ClusterComputeResourceDVSSetting', 'dvSwitch', 'pnicDevices', 'dvPortgroupSetting');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterComputeResourceDVSSetting;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterComputeResourceDVSSetting', 'ClusterComputeResourceDVSSetting', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterComputeResourceDVSSetting', 'ClusterComputeResourceDVSSetting');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterComputeResourceDVSSettingDVPortgroupToServiceMapping;
our @ISA = qw(DynamicData);

our @property_list = (
   ['dvPortgroup', 'ManagedObjectReference', undef, 1],
   ['service', undef, undef, 1],
);


VIMRuntime::make_get_set('ClusterComputeResourceDVSSettingDVPortgroupToServiceMapping', 'dvPortgroup', 'service');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterComputeResourceDVSSettingDVPortgroupToServiceMapping;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterComputeResourceDVSSettingDVPortgroupToServiceMapping', 'ClusterComputeResourceDVSSettingDVPortgroupToServiceMapping', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterComputeResourceDVSSettingDVPortgroupToServiceMapping', 'ClusterComputeResourceDVSSettingDVPortgroupToServiceMapping');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterComputeResourceHostConfigurationProfile;
our @ISA = qw(DynamicData);

our @property_list = (
   ['dateTimeConfig', 'HostDateTimeConfig', undef, 0],
   ['lockdownMode', 'HostLockdownMode', undef, 0],
);


VIMRuntime::make_get_set('ClusterComputeResourceHostConfigurationProfile', 'dateTimeConfig', 'lockdownMode');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterComputeResourceHCIConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['workflowState', undef, undef, 1],
   ['dvsSetting', 'ClusterComputeResourceDVSSetting', 1, 0],
   ['configuredHosts', 'ManagedObjectReference', 1, 0],
   ['hostConfigProfile', 'ClusterComputeResourceHostConfigurationProfile', undef, 0],
);


VIMRuntime::make_get_set('ClusterComputeResourceHCIConfigInfo', 'workflowState', 'dvsSetting', 'configuredHosts', 'hostConfigProfile');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterComputeResourceClusterConfigResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['failedHosts', 'FolderFailedHostResult', 1, 0],
   ['configuredHosts', 'ManagedObjectReference', 1, 0],
);


VIMRuntime::make_get_set('ClusterComputeResourceClusterConfigResult', 'failedHosts', 'configuredHosts');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterComputeResourceDvsProfile;
our @ISA = qw(DynamicData);

our @property_list = (
   ['dvsName', undef, undef, 0],
   ['dvSwitch', 'ManagedObjectReference', undef, 0],
   ['pnicDevices', undef, 1, 0],
   ['dvPortgroupMapping', 'ClusterComputeResourceDvsProfileDVPortgroupSpecToServiceMapping', 1, 0],
);


VIMRuntime::make_get_set('ClusterComputeResourceDvsProfile', 'dvsName', 'dvSwitch', 'pnicDevices', 'dvPortgroupMapping');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterComputeResourceDvsProfile;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterComputeResourceDvsProfile', 'ClusterComputeResourceDvsProfile', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterComputeResourceDvsProfile', 'ClusterComputeResourceDvsProfile');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterComputeResourceDvsProfileDVPortgroupSpecToServiceMapping;
our @ISA = qw(DynamicData);

our @property_list = (
   ['dvPortgroupSpec', 'DVPortgroupConfigSpec', undef, 0],
   ['dvPortgroup', 'ManagedObjectReference', undef, 0],
   ['service', undef, undef, 1],
);


VIMRuntime::make_get_set('ClusterComputeResourceDvsProfileDVPortgroupSpecToServiceMapping', 'dvPortgroupSpec', 'dvPortgroup', 'service');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterComputeResourceDvsProfileDVPortgroupSpecToServiceMapping;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterComputeResourceDvsProfileDVPortgroupSpecToServiceMapping', 'ClusterComputeResourceDvsProfileDVPortgroupSpecToServiceMapping', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterComputeResourceDvsProfileDVPortgroupSpecToServiceMapping', 'ClusterComputeResourceDvsProfileDVPortgroupSpecToServiceMapping');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterComputeResourceVCProfile;
our @ISA = qw(DynamicData);

our @property_list = (
   ['clusterSpec', 'ClusterConfigSpecEx', undef, 0],
   ['evcModeKey', undef, undef, 0],
   ['evcGraphicsModeKey', undef, undef, 0],
);


VIMRuntime::make_get_set('ClusterComputeResourceVCProfile', 'clusterSpec', 'evcModeKey', 'evcGraphicsModeKey');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterComputeResourceHCIConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['dvsProf', 'ClusterComputeResourceDvsProfile', 1, 0],
   ['hostConfigProfile', 'ClusterComputeResourceHostConfigurationProfile', undef, 0],
   ['vSanConfigSpec', 'SDDCBase', undef, 0],
   ['vcProf', 'ClusterComputeResourceVCProfile', undef, 0],
);


VIMRuntime::make_get_set('ClusterComputeResourceHCIConfigSpec', 'dvsProf', 'hostConfigProfile', 'vSanConfigSpec', 'vcProf');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterComputeResourceHostVmkNicInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['nicSpec', 'HostVirtualNicSpec', undef, 1],
   ['service', undef, undef, 1],
);


VIMRuntime::make_get_set('ClusterComputeResourceHostVmkNicInfo', 'nicSpec', 'service');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterComputeResourceHostVmkNicInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterComputeResourceHostVmkNicInfo', 'ClusterComputeResourceHostVmkNicInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterComputeResourceHostVmkNicInfo', 'ClusterComputeResourceHostVmkNicInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterComputeResourceHostConfigurationInput;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['hostVmkNics', 'ClusterComputeResourceHostVmkNicInfo', 1, 0],
   ['allowedInNonMaintenanceMode', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('ClusterComputeResourceHostConfigurationInput', 'host', 'hostVmkNics', 'allowedInNonMaintenanceMode');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterComputeResourceHostConfigurationInput;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterComputeResourceHostConfigurationInput', 'ClusterComputeResourceHostConfigurationInput', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterComputeResourceHostConfigurationInput', 'ClusterComputeResourceHostConfigurationInput');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterComputeResourceValidationResultBase;
our @ISA = qw(DynamicData);

our @property_list = (
   ['info', 'LocalizableMessage', 1, 0],
);


VIMRuntime::make_get_set('ClusterComputeResourceValidationResultBase', 'info');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterComputeResourceValidationResultBase;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterComputeResourceValidationResultBase', 'ClusterComputeResourceValidationResultBase', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterComputeResourceValidationResultBase', 'ClusterComputeResourceValidationResultBase');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterComputeResourceHostConfigurationValidation;
our @ISA = qw(ClusterComputeResourceValidationResultBase);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['isDvsSettingValid', 'boolean', undef, 0],
   ['isVmknicSettingValid', 'boolean', undef, 0],
   ['isNtpSettingValid', 'boolean', undef, 0],
   ['isLockdownModeValid', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('ClusterComputeResourceHostConfigurationValidation', 'host', 'isDvsSettingValid', 'isVmknicSettingValid', 'isNtpSettingValid', 'isLockdownModeValid');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterComputeResourceDVSConfigurationValidation;
our @ISA = qw(ClusterComputeResourceValidationResultBase);

our @property_list = (
   ['isDvsValid', 'boolean', undef, 1],
   ['isDvpgValid', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('ClusterComputeResourceDVSConfigurationValidation', 'isDvsValid', 'isDvpgValid');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterComputeResourceVcsSlots;
our @ISA = qw(DynamicData);

our @property_list = (
   ['systemId', undef, undef, 0],
   ['host', 'ManagedObjectReference', undef, 1],
   ['datastore', 'ManagedObjectReference', 1, 0],
   ['totalSlots', undef, undef, 1],
);


VIMRuntime::make_get_set('ClusterComputeResourceVcsSlots', 'systemId', 'host', 'datastore', 'totalSlots');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterComputeResourceVcsSlots;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterComputeResourceVcsSlots', 'ClusterComputeResourceVcsSlots', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterComputeResourceVcsSlots', 'ClusterComputeResourceVcsSlots');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ComputeResourceSummary;
our @ISA = qw(DynamicData);

our @property_list = (
   ['totalCpu', undef, undef, 1],
   ['totalMemory', undef, undef, 1],
   ['numCpuCores', undef, undef, 1],
   ['numCpuThreads', undef, undef, 1],
   ['effectiveCpu', undef, undef, 1],
   ['effectiveMemory', undef, undef, 1],
   ['numHosts', undef, undef, 1],
   ['numEffectiveHosts', undef, undef, 1],
   ['overallStatus', 'ManagedEntityStatus', undef, 1],
);


VIMRuntime::make_get_set('ComputeResourceSummary', 'totalCpu', 'totalMemory', 'numCpuCores', 'numCpuThreads', 'effectiveCpu', 'effectiveMemory', 'numHosts', 'numEffectiveHosts', 'overallStatus');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ComputeResourceConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vmSwapPlacement', undef, undef, 1],
   ['spbmEnabled', 'boolean', undef, 0],
   ['defaultHardwareVersionKey', undef, undef, 0],
   ['maximumHardwareVersionKey', undef, undef, 0],
);


VIMRuntime::make_get_set('ComputeResourceConfigInfo', 'vmSwapPlacement', 'spbmEnabled', 'defaultHardwareVersionKey', 'maximumHardwareVersionKey');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ComputeResourceHostSPBMLicenseInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['licenseState', 'ComputeResourceHostSPBMLicenseInfoHostSPBMLicenseState', undef, 1],
);


VIMRuntime::make_get_set('ComputeResourceHostSPBMLicenseInfo', 'host', 'licenseState');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfComputeResourceHostSPBMLicenseInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ComputeResourceHostSPBMLicenseInfo', 'ComputeResourceHostSPBMLicenseInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfComputeResourceHostSPBMLicenseInfo', 'ComputeResourceHostSPBMLicenseInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ComputeResourceHostSeedSpecSingleHostSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['newHostCnxSpec', 'HostConnectSpec', undef, 0],
   ['existingHost', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('ComputeResourceHostSeedSpecSingleHostSpec', 'newHostCnxSpec', 'existingHost');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ComputeResourceConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vmSwapPlacement', undef, undef, 0],
   ['spbmEnabled', 'boolean', undef, 0],
   ['defaultHardwareVersionKey', undef, undef, 0],
   ['desiredSoftwareSpec', 'DesiredSoftwareSpec', undef, 0],
   ['maximumHardwareVersionKey', undef, undef, 0],
   ['enableConfigManager', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('ComputeResourceConfigSpec', 'vmSwapPlacement', 'spbmEnabled', 'defaultHardwareVersionKey', 'desiredSoftwareSpec', 'maximumHardwareVersionKey', 'enableConfigManager');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CustomFieldDef;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['name', undef, undef, 1],
   ['type', undef, undef, 1],
   ['managedObjectType', undef, undef, 0],
   ['fieldDefPrivileges', 'PrivilegePolicyDef', undef, 0],
   ['fieldInstancePrivileges', 'PrivilegePolicyDef', undef, 0],
);


VIMRuntime::make_get_set('CustomFieldDef', 'key', 'name', 'type', 'managedObjectType', 'fieldDefPrivileges', 'fieldInstancePrivileges');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfCustomFieldDef;
our @ISA = qw(ComplexType);

our @property_list = (
   ['CustomFieldDef', 'CustomFieldDef', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfCustomFieldDef', 'CustomFieldDef');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CustomFieldValue;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
);


VIMRuntime::make_get_set('CustomFieldValue', 'key');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfCustomFieldValue;
our @ISA = qw(ComplexType);

our @property_list = (
   ['CustomFieldValue', 'CustomFieldValue', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfCustomFieldValue', 'CustomFieldValue');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CustomFieldStringValue;
our @ISA = qw(CustomFieldValue);

our @property_list = (
   ['value', undef, undef, 1],
);


VIMRuntime::make_get_set('CustomFieldStringValue', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CustomizationSpecInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['description', undef, undef, 1],
   ['type', undef, undef, 1],
   ['changeVersion', undef, undef, 0],
   ['lastUpdateTime', undef, undef, 0],
);


VIMRuntime::make_get_set('CustomizationSpecInfo', 'name', 'description', 'type', 'changeVersion', 'lastUpdateTime');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfCustomizationSpecInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['CustomizationSpecInfo', 'CustomizationSpecInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfCustomizationSpecInfo', 'CustomizationSpecInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CustomizationSpecItem;
our @ISA = qw(DynamicData);

our @property_list = (
   ['info', 'CustomizationSpecInfo', undef, 1],
   ['spec', 'CustomizationSpec', undef, 1],
);


VIMRuntime::make_get_set('CustomizationSpecItem', 'info', 'spec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatacenterBasicConnectInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hostname', undef, undef, 0],
   ['error', 'LocalizedMethodFault', undef, 0],
   ['serverIp', undef, undef, 0],
   ['numVm', undef, undef, 0],
   ['numPoweredOnVm', undef, undef, 0],
   ['hostProductInfo', 'AboutInfo', undef, 0],
   ['hardwareVendor', undef, undef, 0],
   ['hardwareModel', undef, undef, 0],
);


VIMRuntime::make_get_set('DatacenterBasicConnectInfo', 'hostname', 'error', 'serverIp', 'numVm', 'numPoweredOnVm', 'hostProductInfo', 'hardwareVendor', 'hardwareModel');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDatacenterBasicConnectInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DatacenterBasicConnectInfo', 'DatacenterBasicConnectInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDatacenterBasicConnectInfo', 'DatacenterBasicConnectInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatacenterConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['defaultHardwareVersionKey', undef, undef, 0],
   ['maximumHardwareVersionKey', undef, undef, 0],
);


VIMRuntime::make_get_set('DatacenterConfigInfo', 'defaultHardwareVersionKey', 'maximumHardwareVersionKey');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatacenterConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['defaultHardwareVersionKey', undef, undef, 0],
   ['maximumHardwareVersionKey', undef, undef, 0],
);


VIMRuntime::make_get_set('DatacenterConfigSpec', 'defaultHardwareVersionKey', 'maximumHardwareVersionKey');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatastoreSummary;
our @ISA = qw(DynamicData);

our @property_list = (
   ['datastore', 'ManagedObjectReference', undef, 0],
   ['name', undef, undef, 1],
   ['url', undef, undef, 1],
   ['capacity', undef, undef, 1],
   ['freeSpace', undef, undef, 1],
   ['uncommitted', undef, undef, 0],
   ['accessible', 'boolean', undef, 1],
   ['multipleHostAccess', 'boolean', undef, 0],
   ['type', undef, undef, 1],
   ['maintenanceMode', undef, undef, 0],
);


VIMRuntime::make_get_set('DatastoreSummary', 'datastore', 'name', 'url', 'capacity', 'freeSpace', 'uncommitted', 'accessible', 'multipleHostAccess', 'type', 'maintenanceMode');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatastoreInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['url', undef, undef, 1],
   ['freeSpace', undef, undef, 1],
   ['maxFileSize', undef, undef, 1],
   ['maxVirtualDiskCapacity', undef, undef, 0],
   ['maxMemoryFileSize', undef, undef, 1],
   ['timestamp', undef, undef, 0],
   ['containerId', undef, undef, 0],
   ['aliasOf', undef, undef, 0],
);


VIMRuntime::make_get_set('DatastoreInfo', 'name', 'url', 'freeSpace', 'maxFileSize', 'maxVirtualDiskCapacity', 'maxMemoryFileSize', 'timestamp', 'containerId', 'aliasOf');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatastoreCapability;
our @ISA = qw(DynamicData);

our @property_list = (
   ['directoryHierarchySupported', 'boolean', undef, 1],
   ['rawDiskMappingsSupported', 'boolean', undef, 1],
   ['perFileThinProvisioningSupported', 'boolean', undef, 1],
   ['storageIORMSupported', 'boolean', undef, 1],
   ['nativeSnapshotSupported', 'boolean', undef, 1],
   ['topLevelDirectoryCreateSupported', 'boolean', undef, 0],
   ['seSparseSupported', 'boolean', undef, 0],
   ['vmfsSparseSupported', 'boolean', undef, 0],
   ['vsanSparseSupported', 'boolean', undef, 0],
   ['upitSupported', 'boolean', undef, 0],
   ['vmdkExpandSupported', 'boolean', undef, 0],
   ['clusteredVmdkSupported', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('DatastoreCapability', 'directoryHierarchySupported', 'rawDiskMappingsSupported', 'perFileThinProvisioningSupported', 'storageIORMSupported', 'nativeSnapshotSupported', 'topLevelDirectoryCreateSupported', 'seSparseSupported', 'vmfsSparseSupported', 'vsanSparseSupported', 'upitSupported', 'vmdkExpandSupported', 'clusteredVmdkSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatastoreHostMount;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', 'ManagedObjectReference', undef, 1],
   ['mountInfo', 'HostMountInfo', undef, 1],
);


VIMRuntime::make_get_set('DatastoreHostMount', 'key', 'mountInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDatastoreHostMount;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DatastoreHostMount', 'DatastoreHostMount', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDatastoreHostMount', 'DatastoreHostMount');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatastoreMountPathDatastorePair;
our @ISA = qw(DynamicData);

our @property_list = (
   ['oldMountPath', undef, undef, 1],
   ['datastore', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('DatastoreMountPathDatastorePair', 'oldMountPath', 'datastore');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDatastoreMountPathDatastorePair;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DatastoreMountPathDatastorePair', 'DatastoreMountPathDatastorePair', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDatastoreMountPathDatastorePair', 'DatastoreMountPathDatastorePair');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatastoreVVolContainerFailoverPair;
our @ISA = qw(DynamicData);

our @property_list = (
   ['srcContainer', undef, undef, 0],
   ['tgtContainer', undef, undef, 1],
   ['vvolMapping', 'KeyValue', 1, 0],
);


VIMRuntime::make_get_set('DatastoreVVolContainerFailoverPair', 'srcContainer', 'tgtContainer', 'vvolMapping');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDatastoreVVolContainerFailoverPair;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DatastoreVVolContainerFailoverPair', 'DatastoreVVolContainerFailoverPair', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDatastoreVVolContainerFailoverPair', 'DatastoreVVolContainerFailoverPair');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package Description;
our @ISA = qw(DynamicData);

our @property_list = (
   ['label', undef, undef, 1],
   ['summary', undef, undef, 1],
);


VIMRuntime::make_get_set('Description', 'label', 'summary');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DesiredSoftwareSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['baseImageSpec', 'DesiredSoftwareSpecBaseImageSpec', undef, 1],
   ['vendorAddOnSpec', 'DesiredSoftwareSpecVendorAddOnSpec', undef, 0],
   ['components', 'DesiredSoftwareSpecComponentSpec', 1, 0],
);


VIMRuntime::make_get_set('DesiredSoftwareSpec', 'baseImageSpec', 'vendorAddOnSpec', 'components');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DesiredSoftwareSpecBaseImageSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['version', undef, undef, 1],
);


VIMRuntime::make_get_set('DesiredSoftwareSpecBaseImageSpec', 'version');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DesiredSoftwareSpecVendorAddOnSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['version', undef, undef, 1],
);


VIMRuntime::make_get_set('DesiredSoftwareSpecVendorAddOnSpec', 'name', 'version');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DesiredSoftwareSpecComponentSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['version', undef, undef, 0],
);


VIMRuntime::make_get_set('DesiredSoftwareSpecComponentSpec', 'name', 'version');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDesiredSoftwareSpecComponentSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DesiredSoftwareSpecComponentSpec', 'DesiredSoftwareSpecComponentSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDesiredSoftwareSpecComponentSpec', 'DesiredSoftwareSpecComponentSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DiagnosticManagerLogDescriptor;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['fileName', undef, undef, 1],
   ['creator', undef, undef, 1],
   ['format', undef, undef, 1],
   ['mimeType', undef, undef, 1],
   ['info', 'Description', undef, 1],
);


VIMRuntime::make_get_set('DiagnosticManagerLogDescriptor', 'key', 'fileName', 'creator', 'format', 'mimeType', 'info');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDiagnosticManagerLogDescriptor;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DiagnosticManagerLogDescriptor', 'DiagnosticManagerLogDescriptor', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDiagnosticManagerLogDescriptor', 'DiagnosticManagerLogDescriptor');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DiagnosticManagerLogHeader;
our @ISA = qw(DynamicData);

our @property_list = (
   ['lineStart', undef, undef, 1],
   ['lineEnd', undef, undef, 1],
   ['lineText', undef, 1, 0],
);


VIMRuntime::make_get_set('DiagnosticManagerLogHeader', 'lineStart', 'lineEnd', 'lineText');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DiagnosticManagerBundleInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['system', 'ManagedObjectReference', undef, 0],
   ['url', undef, undef, 1],
);


VIMRuntime::make_get_set('DiagnosticManagerBundleInfo', 'system', 'url');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDiagnosticManagerBundleInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DiagnosticManagerBundleInfo', 'DiagnosticManagerBundleInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDiagnosticManagerBundleInfo', 'DiagnosticManagerBundleInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DiagnosticManagerAuditRecordResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['records', undef, 1, 0],
   ['nextToken', undef, undef, 1],
);


VIMRuntime::make_get_set('DiagnosticManagerAuditRecordResult', 'records', 'nextToken');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSContactInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 0],
   ['contact', undef, undef, 0],
);


VIMRuntime::make_get_set('DVSContactInfo', 'name', 'contact');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSNetworkResourceManagementCapability;
our @ISA = qw(DynamicData);

our @property_list = (
   ['networkResourceManagementSupported', 'boolean', undef, 1],
   ['networkResourcePoolHighShareValue', undef, undef, 1],
   ['qosSupported', 'boolean', undef, 1],
   ['userDefinedNetworkResourcePoolsSupported', 'boolean', undef, 1],
   ['networkResourceControlVersion3Supported', 'boolean', undef, 0],
   ['userDefinedInfraTrafficPoolSupported', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('DVSNetworkResourceManagementCapability', 'networkResourceManagementSupported', 'networkResourcePoolHighShareValue', 'qosSupported', 'userDefinedNetworkResourcePoolsSupported', 'networkResourceControlVersion3Supported', 'userDefinedInfraTrafficPoolSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSRollbackCapability;
our @ISA = qw(DynamicData);

our @property_list = (
   ['rollbackSupported', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('DVSRollbackCapability', 'rollbackSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSBackupRestoreCapability;
our @ISA = qw(DynamicData);

our @property_list = (
   ['backupRestoreSupported', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('DVSBackupRestoreCapability', 'backupRestoreSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSFeatureCapability;
our @ISA = qw(DynamicData);

our @property_list = (
   ['networkResourceManagementSupported', 'boolean', undef, 1],
   ['vmDirectPathGen2Supported', 'boolean', undef, 0],
   ['nicTeamingPolicy', undef, 1, 0],
   ['networkResourcePoolHighShareValue', undef, undef, 0],
   ['networkResourceManagementCapability', 'DVSNetworkResourceManagementCapability', undef, 0],
   ['healthCheckCapability', 'DVSHealthCheckCapability', undef, 0],
   ['rollbackCapability', 'DVSRollbackCapability', undef, 0],
   ['backupRestoreCapability', 'DVSBackupRestoreCapability', undef, 0],
   ['networkFilterSupported', 'boolean', undef, 0],
   ['macLearningSupported', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('DVSFeatureCapability', 'networkResourceManagementSupported', 'vmDirectPathGen2Supported', 'nicTeamingPolicy', 'networkResourcePoolHighShareValue', 'networkResourceManagementCapability', 'healthCheckCapability', 'rollbackCapability', 'backupRestoreCapability', 'networkFilterSupported', 'macLearningSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSHealthCheckCapability;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('DVSHealthCheckCapability');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSCapability;
our @ISA = qw(DynamicData);

our @property_list = (
   ['dvsOperationSupported', 'boolean', undef, 0],
   ['dvPortGroupOperationSupported', 'boolean', undef, 0],
   ['dvPortOperationSupported', 'boolean', undef, 0],
   ['compatibleHostComponentProductInfo', 'DistributedVirtualSwitchHostProductSpec', 1, 0],
   ['featuresSupported', 'DVSFeatureCapability', undef, 0],
);


VIMRuntime::make_get_set('DVSCapability', 'dvsOperationSupported', 'dvPortGroupOperationSupported', 'dvPortOperationSupported', 'compatibleHostComponentProductInfo', 'featuresSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSSummary;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['uuid', undef, undef, 1],
   ['numPorts', undef, undef, 1],
   ['productInfo', 'DistributedVirtualSwitchProductSpec', undef, 0],
   ['hostMember', 'ManagedObjectReference', 1, 0],
   ['vm', 'ManagedObjectReference', 1, 0],
   ['host', 'ManagedObjectReference', 1, 0],
   ['portgroupName', undef, 1, 0],
   ['description', undef, undef, 0],
   ['contact', 'DVSContactInfo', undef, 0],
   ['numHosts', undef, undef, 0],
);


VIMRuntime::make_get_set('DVSSummary', 'name', 'uuid', 'numPorts', 'productInfo', 'hostMember', 'vm', 'host', 'portgroupName', 'description', 'contact', 'numHosts');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSPolicy;
our @ISA = qw(DynamicData);

our @property_list = (
   ['autoPreInstallAllowed', 'boolean', undef, 0],
   ['autoUpgradeAllowed', 'boolean', undef, 0],
   ['partialUpgradeAllowed', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('DVSPolicy', 'autoPreInstallAllowed', 'autoUpgradeAllowed', 'partialUpgradeAllowed');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSUplinkPortPolicy;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('DVSUplinkPortPolicy');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSNameArrayUplinkPortPolicy;
our @ISA = qw(DVSUplinkPortPolicy);

our @property_list = (
   ['uplinkPortName', undef, 1, 1],
);


VIMRuntime::make_get_set('DVSNameArrayUplinkPortPolicy', 'uplinkPortName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['configVersion', undef, undef, 0],
   ['name', undef, undef, 0],
   ['numStandalonePorts', undef, undef, 0],
   ['maxPorts', undef, undef, 0],
   ['uplinkPortPolicy', 'DVSUplinkPortPolicy', undef, 0],
   ['uplinkPortgroup', 'ManagedObjectReference', 1, 0],
   ['defaultPortConfig', 'DVPortSetting', undef, 0],
   ['host', 'DistributedVirtualSwitchHostMemberConfigSpec', 1, 0],
   ['extensionKey', undef, undef, 0],
   ['description', undef, undef, 0],
   ['policy', 'DVSPolicy', undef, 0],
   ['vendorSpecificConfig', 'DistributedVirtualSwitchKeyedOpaqueBlob', 1, 0],
   ['contact', 'DVSContactInfo', undef, 0],
   ['switchIpAddress', undef, undef, 0],
   ['defaultProxySwitchMaxNumPorts', undef, undef, 0],
   ['infrastructureTrafficResourceConfig', 'DvsHostInfrastructureTrafficResource', 1, 0],
   ['netResourcePoolTrafficResourceConfig', 'DvsHostInfrastructureTrafficResource', 1, 0],
   ['networkResourceControlVersion', undef, undef, 0],
);


VIMRuntime::make_get_set('DVSConfigSpec', 'configVersion', 'name', 'numStandalonePorts', 'maxPorts', 'uplinkPortPolicy', 'uplinkPortgroup', 'defaultPortConfig', 'host', 'extensionKey', 'description', 'policy', 'vendorSpecificConfig', 'contact', 'switchIpAddress', 'defaultProxySwitchMaxNumPorts', 'infrastructureTrafficResourceConfig', 'netResourcePoolTrafficResourceConfig', 'networkResourceControlVersion');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSCreateSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['configSpec', 'DVSConfigSpec', undef, 1],
   ['productInfo', 'DistributedVirtualSwitchProductSpec', undef, 0],
   ['capability', 'DVSCapability', undef, 0],
);


VIMRuntime::make_get_set('DVSCreateSpec', 'configSpec', 'productInfo', 'capability');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['uuid', undef, undef, 1],
   ['name', undef, undef, 1],
   ['numStandalonePorts', undef, undef, 1],
   ['numPorts', undef, undef, 1],
   ['maxPorts', undef, undef, 1],
   ['uplinkPortPolicy', 'DVSUplinkPortPolicy', undef, 1],
   ['uplinkPortgroup', 'ManagedObjectReference', 1, 0],
   ['defaultPortConfig', 'DVPortSetting', undef, 1],
   ['host', 'DistributedVirtualSwitchHostMember', 1, 0],
   ['productInfo', 'DistributedVirtualSwitchProductSpec', undef, 1],
   ['targetInfo', 'DistributedVirtualSwitchProductSpec', undef, 0],
   ['extensionKey', undef, undef, 0],
   ['vendorSpecificConfig', 'DistributedVirtualSwitchKeyedOpaqueBlob', 1, 0],
   ['policy', 'DVSPolicy', undef, 0],
   ['description', undef, undef, 0],
   ['configVersion', undef, undef, 1],
   ['contact', 'DVSContactInfo', undef, 1],
   ['switchIpAddress', undef, undef, 0],
   ['createTime', undef, undef, 1],
   ['networkResourceManagementEnabled', 'boolean', undef, 1],
   ['defaultProxySwitchMaxNumPorts', undef, undef, 0],
   ['healthCheckConfig', 'DVSHealthCheckConfig', 1, 0],
   ['infrastructureTrafficResourceConfig', 'DvsHostInfrastructureTrafficResource', 1, 0],
   ['netResourcePoolTrafficResourceConfig', 'DvsHostInfrastructureTrafficResource', 1, 0],
   ['networkResourceControlVersion', undef, undef, 0],
   ['vmVnicNetworkResourcePool', 'DVSVmVnicNetworkResourcePool', 1, 0],
   ['pnicCapacityRatioForReservation', undef, undef, 0],
);


VIMRuntime::make_get_set('DVSConfigInfo', 'uuid', 'name', 'numStandalonePorts', 'numPorts', 'maxPorts', 'uplinkPortPolicy', 'uplinkPortgroup', 'defaultPortConfig', 'host', 'productInfo', 'targetInfo', 'extensionKey', 'vendorSpecificConfig', 'policy', 'description', 'configVersion', 'contact', 'switchIpAddress', 'createTime', 'networkResourceManagementEnabled', 'defaultProxySwitchMaxNumPorts', 'healthCheckConfig', 'infrastructureTrafficResourceConfig', 'netResourcePoolTrafficResourceConfig', 'networkResourceControlVersion', 'vmVnicNetworkResourcePool', 'pnicCapacityRatioForReservation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsHostInfrastructureTrafficResource;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['description', undef, undef, 0],
   ['allocationInfo', 'DvsHostInfrastructureTrafficResourceAllocation', undef, 1],
);


VIMRuntime::make_get_set('DvsHostInfrastructureTrafficResource', 'key', 'description', 'allocationInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDvsHostInfrastructureTrafficResource;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DvsHostInfrastructureTrafficResource', 'DvsHostInfrastructureTrafficResource', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDvsHostInfrastructureTrafficResource', 'DvsHostInfrastructureTrafficResource');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsHostInfrastructureTrafficResourceAllocation;
our @ISA = qw(DynamicData);

our @property_list = (
   ['limit', undef, undef, 0],
   ['shares', 'SharesInfo', undef, 0],
   ['reservation', undef, undef, 0],
);


VIMRuntime::make_get_set('DvsHostInfrastructureTrafficResourceAllocation', 'limit', 'shares', 'reservation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSHealthCheckConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['enable', 'boolean', undef, 0],
   ['interval', undef, undef, 0],
);


VIMRuntime::make_get_set('DVSHealthCheckConfig', 'enable', 'interval');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDVSHealthCheckConfig;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DVSHealthCheckConfig', 'DVSHealthCheckConfig', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDVSHealthCheckConfig', 'DVSHealthCheckConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsResourceRuntimeInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['capacity', undef, undef, 0],
   ['usage', undef, undef, 0],
   ['available', undef, undef, 0],
   ['allocatedResource', 'DvsVnicAllocatedResource', 1, 0],
   ['vmVnicNetworkResourcePoolRuntime', 'DvsVmVnicNetworkResourcePoolRuntimeInfo', 1, 0],
);


VIMRuntime::make_get_set('DvsResourceRuntimeInfo', 'capacity', 'usage', 'available', 'allocatedResource', 'vmVnicNetworkResourcePoolRuntime');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSRuntimeInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hostMemberRuntime', 'HostMemberRuntimeInfo', 1, 0],
   ['resourceRuntimeInfo', 'DvsResourceRuntimeInfo', undef, 0],
);


VIMRuntime::make_get_set('DVSRuntimeInfo', 'hostMemberRuntime', 'resourceRuntimeInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EVCMode;
our @ISA = qw(ElementDescription);

our @property_list = (
   ['guaranteedCPUFeatures', 'HostCpuIdInfo', 1, 0],
   ['featureCapability', 'HostFeatureCapability', 1, 0],
   ['featureMask', 'HostFeatureMask', 1, 0],
   ['featureRequirement', 'VirtualMachineFeatureRequirement', 1, 0],
   ['vendor', undef, undef, 1],
   ['track', undef, 1, 1],
   ['vendorTier', undef, undef, 1],
);


VIMRuntime::make_get_set('EVCMode', 'guaranteedCPUFeatures', 'featureCapability', 'featureMask', 'featureRequirement', 'vendor', 'track', 'vendorTier');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfEVCMode;
our @ISA = qw(ComplexType);

our @property_list = (
   ['EVCMode', 'EVCMode', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfEVCMode', 'EVCMode');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ElementDescription;
our @ISA = qw(Description);

our @property_list = (
   ['key', undef, undef, 1],
);


VIMRuntime::make_get_set('ElementDescription', 'key');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfElementDescription;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ElementDescription', 'ElementDescription', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfElementDescription', 'ElementDescription');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EnumDescription;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['tags', 'ElementDescription', 1, 1],
);


VIMRuntime::make_get_set('EnumDescription', 'key', 'tags');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfEnumDescription;
our @ISA = qw(ComplexType);

our @property_list = (
   ['EnumDescription', 'EnumDescription', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfEnumDescription', 'EnumDescription');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EnvironmentBrowserConfigOptionQuerySpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 0],
   ['host', 'ManagedObjectReference', undef, 0],
   ['guestId', undef, 1, 0],
);


VIMRuntime::make_get_set('EnvironmentBrowserConfigOptionQuerySpec', 'key', 'host', 'guestId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExtendedDescription;
our @ISA = qw(Description);

our @property_list = (
   ['messageCatalogKeyPrefix', undef, undef, 1],
   ['messageArg', 'KeyAnyValue', 1, 0],
);


VIMRuntime::make_get_set('ExtendedDescription', 'messageCatalogKeyPrefix', 'messageArg');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExtendedElementDescription;
our @ISA = qw(ElementDescription);

our @property_list = (
   ['messageCatalogKeyPrefix', undef, undef, 1],
   ['messageArg', 'KeyAnyValue', 1, 0],
);


VIMRuntime::make_get_set('ExtendedElementDescription', 'messageCatalogKeyPrefix', 'messageArg');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package Extension;
our @ISA = qw(DynamicData);

our @property_list = (
   ['description', 'Description', undef, 1],
   ['key', undef, undef, 1],
   ['company', undef, undef, 0],
   ['type', undef, undef, 0],
   ['version', undef, undef, 1],
   ['subjectName', undef, undef, 0],
   ['server', 'ExtensionServerInfo', 1, 0],
   ['client', 'ExtensionClientInfo', 1, 0],
   ['taskList', 'ExtensionTaskTypeInfo', 1, 0],
   ['eventList', 'ExtensionEventTypeInfo', 1, 0],
   ['faultList', 'ExtensionFaultTypeInfo', 1, 0],
   ['privilegeList', 'ExtensionPrivilegeInfo', 1, 0],
   ['resourceList', 'ExtensionResourceInfo', 1, 0],
   ['lastHeartbeatTime', undef, undef, 1],
   ['healthInfo', 'ExtensionHealthInfo', undef, 0],
   ['ovfConsumerInfo', 'ExtensionOvfConsumerInfo', undef, 0],
   ['extendedProductInfo', 'ExtExtendedProductInfo', undef, 0],
   ['managedEntityInfo', 'ExtManagedEntityInfo', 1, 0],
   ['shownInSolutionManager', 'boolean', undef, 0],
   ['solutionManagerInfo', 'ExtSolutionManagerInfo', undef, 0],
);


VIMRuntime::make_get_set('Extension', 'description', 'key', 'company', 'type', 'version', 'subjectName', 'server', 'client', 'taskList', 'eventList', 'faultList', 'privilegeList', 'resourceList', 'lastHeartbeatTime', 'healthInfo', 'ovfConsumerInfo', 'extendedProductInfo', 'managedEntityInfo', 'shownInSolutionManager', 'solutionManagerInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfExtension;
our @ISA = qw(ComplexType);

our @property_list = (
   ['Extension', 'Extension', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfExtension', 'Extension');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExtensionServerInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['url', undef, undef, 1],
   ['description', 'Description', undef, 1],
   ['company', undef, undef, 1],
   ['type', undef, undef, 1],
   ['adminEmail', undef, 1, 1],
   ['serverThumbprint', undef, undef, 0],
);


VIMRuntime::make_get_set('ExtensionServerInfo', 'url', 'description', 'company', 'type', 'adminEmail', 'serverThumbprint');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfExtensionServerInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ExtensionServerInfo', 'ExtensionServerInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfExtensionServerInfo', 'ExtensionServerInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExtensionClientInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['version', undef, undef, 1],
   ['description', 'Description', undef, 1],
   ['company', undef, undef, 1],
   ['type', undef, undef, 1],
   ['url', undef, undef, 1],
);


VIMRuntime::make_get_set('ExtensionClientInfo', 'version', 'description', 'company', 'type', 'url');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfExtensionClientInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ExtensionClientInfo', 'ExtensionClientInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfExtensionClientInfo', 'ExtensionClientInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExtensionTaskTypeInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['taskID', undef, undef, 1],
);


VIMRuntime::make_get_set('ExtensionTaskTypeInfo', 'taskID');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfExtensionTaskTypeInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ExtensionTaskTypeInfo', 'ExtensionTaskTypeInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfExtensionTaskTypeInfo', 'ExtensionTaskTypeInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExtensionEventTypeInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['eventID', undef, undef, 1],
   ['eventTypeSchema', undef, undef, 0],
);


VIMRuntime::make_get_set('ExtensionEventTypeInfo', 'eventID', 'eventTypeSchema');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfExtensionEventTypeInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ExtensionEventTypeInfo', 'ExtensionEventTypeInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfExtensionEventTypeInfo', 'ExtensionEventTypeInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExtensionFaultTypeInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['faultID', undef, undef, 1],
);


VIMRuntime::make_get_set('ExtensionFaultTypeInfo', 'faultID');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfExtensionFaultTypeInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ExtensionFaultTypeInfo', 'ExtensionFaultTypeInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfExtensionFaultTypeInfo', 'ExtensionFaultTypeInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExtensionPrivilegeInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['privID', undef, undef, 1],
   ['privGroupName', undef, undef, 1],
);


VIMRuntime::make_get_set('ExtensionPrivilegeInfo', 'privID', 'privGroupName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfExtensionPrivilegeInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ExtensionPrivilegeInfo', 'ExtensionPrivilegeInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfExtensionPrivilegeInfo', 'ExtensionPrivilegeInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExtensionResourceInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['locale', undef, undef, 1],
   ['module', undef, undef, 1],
   ['data', 'KeyValue', 1, 1],
);


VIMRuntime::make_get_set('ExtensionResourceInfo', 'locale', 'module', 'data');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfExtensionResourceInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ExtensionResourceInfo', 'ExtensionResourceInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfExtensionResourceInfo', 'ExtensionResourceInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExtensionHealthInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['url', undef, undef, 1],
);


VIMRuntime::make_get_set('ExtensionHealthInfo', 'url');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExtensionOvfConsumerInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['callbackUrl', undef, undef, 1],
   ['sectionType', undef, 1, 1],
);


VIMRuntime::make_get_set('ExtensionOvfConsumerInfo', 'callbackUrl', 'sectionType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExtensionManagerIpAllocationUsage;
our @ISA = qw(DynamicData);

our @property_list = (
   ['extensionKey', undef, undef, 1],
   ['numAddresses', undef, undef, 1],
);


VIMRuntime::make_get_set('ExtensionManagerIpAllocationUsage', 'extensionKey', 'numAddresses');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfExtensionManagerIpAllocationUsage;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ExtensionManagerIpAllocationUsage', 'ExtensionManagerIpAllocationUsage', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfExtensionManagerIpAllocationUsage', 'ExtensionManagerIpAllocationUsage');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FaultsByHost;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['faults', 'LocalizedMethodFault', 1, 0],
);


VIMRuntime::make_get_set('FaultsByHost', 'host', 'faults');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfFaultsByHost;
our @ISA = qw(ComplexType);

our @property_list = (
   ['FaultsByHost', 'FaultsByHost', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfFaultsByHost', 'FaultsByHost');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FaultsByVM;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vm', 'ManagedObjectReference', undef, 1],
   ['faults', 'LocalizedMethodFault', 1, 0],
);


VIMRuntime::make_get_set('FaultsByVM', 'vm', 'faults');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfFaultsByVM;
our @ISA = qw(ComplexType);

our @property_list = (
   ['FaultsByVM', 'FaultsByVM', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfFaultsByVM', 'FaultsByVM');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FeatureEVCMode;
our @ISA = qw(ElementDescription);

our @property_list = (
   ['mask', 'HostFeatureMask', 1, 0],
   ['capability', 'HostFeatureCapability', 1, 0],
   ['requirement', 'VirtualMachineFeatureRequirement', 1, 0],
);


VIMRuntime::make_get_set('FeatureEVCMode', 'mask', 'capability', 'requirement');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfFeatureEVCMode;
our @ISA = qw(ComplexType);

our @property_list = (
   ['FeatureEVCMode', 'FeatureEVCMode', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfFeatureEVCMode', 'FeatureEVCMode');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FolderNewHostSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hostCnxSpec', 'HostConnectSpec', undef, 1],
   ['esxLicense', undef, undef, 0],
);


VIMRuntime::make_get_set('FolderNewHostSpec', 'hostCnxSpec', 'esxLicense');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfFolderNewHostSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['FolderNewHostSpec', 'FolderNewHostSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfFolderNewHostSpec', 'FolderNewHostSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FolderFailedHostResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hostName', undef, undef, 0],
   ['host', 'ManagedObjectReference', undef, 0],
   ['context', 'LocalizableMessage', undef, 1],
   ['fault', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('FolderFailedHostResult', 'hostName', 'host', 'context', 'fault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfFolderFailedHostResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['FolderFailedHostResult', 'FolderFailedHostResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfFolderFailedHostResult', 'FolderFailedHostResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FolderBatchAddStandaloneHostsResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['addedHosts', 'ManagedObjectReference', 1, 0],
   ['hostsFailedInventoryAdd', 'FolderFailedHostResult', 1, 0],
);


VIMRuntime::make_get_set('FolderBatchAddStandaloneHostsResult', 'addedHosts', 'hostsFailedInventoryAdd');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FolderBatchAddHostsToClusterResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hostsAddedToCluster', 'ManagedObjectReference', 1, 0],
   ['hostsFailedInventoryAdd', 'FolderFailedHostResult', 1, 0],
   ['hostsFailedMoveToCluster', 'FolderFailedHostResult', 1, 0],
);


VIMRuntime::make_get_set('FolderBatchAddHostsToClusterResult', 'hostsAddedToCluster', 'hostsFailedInventoryAdd', 'hostsFailedMoveToCluster');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HbrManagerReplicationVmInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['state', undef, undef, 1],
   ['progressInfo', 'ReplicationVmProgressInfo', undef, 0],
   ['imageId', undef, undef, 0],
   ['lastError', 'LocalizedMethodFault', undef, 0],
);


VIMRuntime::make_get_set('HbrManagerReplicationVmInfo', 'state', 'progressInfo', 'imageId', 'lastError');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ReplicationVmProgressInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['progress', undef, undef, 1],
   ['bytesTransferred', undef, undef, 1],
   ['bytesToTransfer', undef, undef, 1],
   ['checksumTotalBytes', undef, undef, 0],
   ['checksumComparedBytes', undef, undef, 0],
);


VIMRuntime::make_get_set('ReplicationVmProgressInfo', 'progress', 'bytesTransferred', 'bytesToTransfer', 'checksumTotalBytes', 'checksumComparedBytes');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HbrManagerVmReplicationCapability;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vm', 'ManagedObjectReference', undef, 1],
   ['supportedQuiesceMode', undef, undef, 1],
   ['compressionSupported', 'boolean', undef, 1],
   ['maxSupportedSourceDiskCapacity', undef, undef, 1],
   ['minRpo', undef, undef, 0],
   ['fault', 'LocalizedMethodFault', undef, 0],
);


VIMRuntime::make_get_set('HbrManagerVmReplicationCapability', 'vm', 'supportedQuiesceMode', 'compressionSupported', 'maxSupportedSourceDiskCapacity', 'minRpo', 'fault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHbrManagerVmReplicationCapability;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HbrManagerVmReplicationCapability', 'HbrManagerVmReplicationCapability', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHbrManagerVmReplicationCapability', 'HbrManagerVmReplicationCapability');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HealthUpdateInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['id', undef, undef, 1],
   ['componentType', undef, undef, 1],
   ['description', undef, undef, 1],
);


VIMRuntime::make_get_set('HealthUpdateInfo', 'id', 'componentType', 'description');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHealthUpdateInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HealthUpdateInfo', 'HealthUpdateInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHealthUpdateInfo', 'HealthUpdateInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HealthUpdate;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entity', 'ManagedObjectReference', undef, 1],
   ['healthUpdateInfoId', undef, undef, 1],
   ['id', undef, undef, 1],
   ['status', 'ManagedEntityStatus', undef, 1],
   ['remediation', undef, undef, 1],
);


VIMRuntime::make_get_set('HealthUpdate', 'entity', 'healthUpdateInfoId', 'id', 'status', 'remediation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHealthUpdate;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HealthUpdate', 'HealthUpdate', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHealthUpdate', 'HealthUpdate');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostServiceTicket;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', undef, undef, 0],
   ['port', undef, undef, 0],
   ['sslThumbprint', undef, undef, 0],
   ['service', undef, undef, 1],
   ['serviceVersion', undef, undef, 1],
   ['sessionId', undef, undef, 1],
);


VIMRuntime::make_get_set('HostServiceTicket', 'host', 'port', 'sslThumbprint', 'service', 'serviceVersion', 'sessionId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostSystemRemediationState;
our @ISA = qw(DynamicData);

our @property_list = (
   ['state', undef, undef, 1],
   ['operationTime', undef, undef, 1],
);


VIMRuntime::make_get_set('HostSystemRemediationState', 'state', 'operationTime');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostSystemComplianceCheckState;
our @ISA = qw(DynamicData);

our @property_list = (
   ['state', undef, undef, 1],
   ['checkTime', undef, undef, 1],
);


VIMRuntime::make_get_set('HostSystemComplianceCheckState', 'state', 'checkTime');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostSystemReconnectSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['syncState', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('HostSystemReconnectSpec', 'syncState');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HttpNfcLeaseDatastoreLeaseInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['datastoreKey', undef, undef, 1],
   ['hosts', 'HttpNfcLeaseHostInfo', 1, 1],
);


VIMRuntime::make_get_set('HttpNfcLeaseDatastoreLeaseInfo', 'datastoreKey', 'hosts');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHttpNfcLeaseDatastoreLeaseInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HttpNfcLeaseDatastoreLeaseInfo', 'HttpNfcLeaseDatastoreLeaseInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHttpNfcLeaseDatastoreLeaseInfo', 'HttpNfcLeaseDatastoreLeaseInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HttpNfcLeaseHostInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['url', undef, undef, 1],
   ['sslThumbprint', undef, undef, 1],
);


VIMRuntime::make_get_set('HttpNfcLeaseHostInfo', 'url', 'sslThumbprint');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHttpNfcLeaseHostInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HttpNfcLeaseHostInfo', 'HttpNfcLeaseHostInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHttpNfcLeaseHostInfo', 'HttpNfcLeaseHostInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HttpNfcLeaseInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['lease', 'ManagedObjectReference', undef, 1],
   ['entity', 'ManagedObjectReference', undef, 1],
   ['deviceUrl', 'HttpNfcLeaseDeviceUrl', 1, 0],
   ['totalDiskCapacityInKB', undef, undef, 1],
   ['leaseTimeout', undef, undef, 1],
   ['hostMap', 'HttpNfcLeaseDatastoreLeaseInfo', 1, 0],
);


VIMRuntime::make_get_set('HttpNfcLeaseInfo', 'lease', 'entity', 'deviceUrl', 'totalDiskCapacityInKB', 'leaseTimeout', 'hostMap');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HttpNfcLeaseDeviceUrl;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['importKey', undef, undef, 1],
   ['url', undef, undef, 1],
   ['sslThumbprint', undef, undef, 1],
   ['disk', 'boolean', undef, 0],
   ['targetId', undef, undef, 0],
   ['datastoreKey', undef, undef, 0],
   ['fileSize', undef, undef, 0],
);


VIMRuntime::make_get_set('HttpNfcLeaseDeviceUrl', 'key', 'importKey', 'url', 'sslThumbprint', 'disk', 'targetId', 'datastoreKey', 'fileSize');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHttpNfcLeaseDeviceUrl;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HttpNfcLeaseDeviceUrl', 'HttpNfcLeaseDeviceUrl', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHttpNfcLeaseDeviceUrl', 'HttpNfcLeaseDeviceUrl');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HttpNfcLeaseManifestEntry;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['sha1', undef, undef, 1],
   ['checksum', undef, undef, 0],
   ['checksumType', undef, undef, 0],
   ['size', undef, undef, 1],
   ['disk', 'boolean', undef, 1],
   ['capacity', undef, undef, 0],
   ['populatedSize', undef, undef, 0],
);


VIMRuntime::make_get_set('HttpNfcLeaseManifestEntry', 'key', 'sha1', 'checksum', 'checksumType', 'size', 'disk', 'capacity', 'populatedSize');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHttpNfcLeaseManifestEntry;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HttpNfcLeaseManifestEntry', 'HttpNfcLeaseManifestEntry', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHttpNfcLeaseManifestEntry', 'HttpNfcLeaseManifestEntry');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HttpNfcLeaseSourceFile;
our @ISA = qw(DynamicData);

our @property_list = (
   ['targetDeviceId', undef, undef, 1],
   ['url', undef, undef, 1],
   ['memberName', undef, undef, 0],
   ['create', 'boolean', undef, 1],
   ['sslThumbprint', undef, undef, 0],
   ['httpHeaders', 'KeyValue', 1, 0],
   ['size', undef, undef, 0],
);


VIMRuntime::make_get_set('HttpNfcLeaseSourceFile', 'targetDeviceId', 'url', 'memberName', 'create', 'sslThumbprint', 'httpHeaders', 'size');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHttpNfcLeaseSourceFile;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HttpNfcLeaseSourceFile', 'HttpNfcLeaseSourceFile', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHttpNfcLeaseSourceFile', 'HttpNfcLeaseSourceFile');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HttpNfcLeaseCapabilities;
our @ISA = qw(DynamicData);

our @property_list = (
   ['pullModeSupported', 'boolean', undef, 1],
   ['corsSupported', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('HttpNfcLeaseCapabilities', 'pullModeSupported', 'corsSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HttpNfcLeaseProbeResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['serverAccessible', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('HttpNfcLeaseProbeResult', 'serverAccessible');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHttpNfcLeaseProbeResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HttpNfcLeaseProbeResult', 'HttpNfcLeaseProbeResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHttpNfcLeaseProbeResult', 'HttpNfcLeaseProbeResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ImportSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entityConfig', 'VAppEntityConfigInfo', undef, 0],
   ['instantiationOst', 'OvfConsumerOstNode', undef, 0],
);


VIMRuntime::make_get_set('ImportSpec', 'entityConfig', 'instantiationOst');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfImportSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ImportSpec', 'ImportSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfImportSpec', 'ImportSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InheritablePolicy;
our @ISA = qw(DynamicData);

our @property_list = (
   ['inherited', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('InheritablePolicy', 'inherited');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IntExpression;
our @ISA = qw(NegatableExpression);

our @property_list = (
   ['value', undef, undef, 0],
);


VIMRuntime::make_get_set('IntExpression', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IntPolicy;
our @ISA = qw(InheritablePolicy);

our @property_list = (
   ['value', undef, undef, 0],
);


VIMRuntime::make_get_set('IntPolicy', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IoFilterInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['id', undef, undef, 1],
   ['name', undef, undef, 1],
   ['vendor', undef, undef, 1],
   ['version', undef, undef, 1],
   ['type', undef, undef, 0],
   ['summary', undef, undef, 0],
   ['releaseDate', undef, undef, 0],
);


VIMRuntime::make_get_set('IoFilterInfo', 'id', 'name', 'vendor', 'version', 'type', 'summary', 'releaseDate');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostIoFilterInfo;
our @ISA = qw(IoFilterInfo);

our @property_list = (
   ['available', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('HostIoFilterInfo', 'available');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHostIoFilterInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HostIoFilterInfo', 'HostIoFilterInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHostIoFilterInfo', 'HostIoFilterInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterIoFilterInfo;
our @ISA = qw(IoFilterInfo);

our @property_list = (
   ['opType', undef, undef, 1],
   ['vibUrl', undef, undef, 0],
);


VIMRuntime::make_get_set('ClusterIoFilterInfo', 'opType', 'vibUrl');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterIoFilterInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterIoFilterInfo', 'ClusterIoFilterInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterIoFilterInfo', 'ClusterIoFilterInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IoFilterQueryIssueResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['opType', undef, undef, 1],
   ['hostIssue', 'IoFilterHostIssue', 1, 0],
);


VIMRuntime::make_get_set('IoFilterQueryIssueResult', 'opType', 'hostIssue');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IoFilterHostIssue;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['issue', 'LocalizedMethodFault', 1, 1],
);


VIMRuntime::make_get_set('IoFilterHostIssue', 'host', 'issue');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfIoFilterHostIssue;
our @ISA = qw(ComplexType);

our @property_list = (
   ['IoFilterHostIssue', 'IoFilterHostIssue', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfIoFilterHostIssue', 'IoFilterHostIssue');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IpAddress;
our @ISA = qw(NegatableExpression);

our @property_list = (
);


VIMRuntime::make_get_set('IpAddress');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IpPoolManagerIpAllocation;
our @ISA = qw(DynamicData);

our @property_list = (
   ['ipAddress', undef, undef, 1],
   ['allocationId', undef, undef, 1],
);


VIMRuntime::make_get_set('IpPoolManagerIpAllocation', 'ipAddress', 'allocationId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfIpPoolManagerIpAllocation;
our @ISA = qw(ComplexType);

our @property_list = (
   ['IpPoolManagerIpAllocation', 'IpPoolManagerIpAllocation', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfIpPoolManagerIpAllocation', 'IpPoolManagerIpAllocation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IpRange;
our @ISA = qw(IpAddress);

our @property_list = (
   ['addressPrefix', undef, undef, 1],
   ['prefixLength', undef, undef, 0],
);


VIMRuntime::make_get_set('IpRange', 'addressPrefix', 'prefixLength');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package KeyValue;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['value', undef, undef, 1],
);


VIMRuntime::make_get_set('KeyValue', 'key', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfKeyValue;
our @ISA = qw(ComplexType);

our @property_list = (
   ['KeyValue', 'KeyValue', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfKeyValue', 'KeyValue');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LatencySensitivity;
our @ISA = qw(DynamicData);

our @property_list = (
   ['level', 'LatencySensitivitySensitivityLevel', undef, 1],
   ['sensitivity', undef, undef, 0],
);


VIMRuntime::make_get_set('LatencySensitivity', 'level', 'sensitivity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseAssignmentManagerLicenseAssignment;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entityId', undef, undef, 1],
   ['scope', undef, undef, 0],
   ['entityDisplayName', undef, undef, 0],
   ['assignedLicense', 'LicenseManagerLicenseInfo', undef, 1],
   ['properties', 'KeyAnyValue', 1, 0],
);


VIMRuntime::make_get_set('LicenseAssignmentManagerLicenseAssignment', 'entityId', 'scope', 'entityDisplayName', 'assignedLicense', 'properties');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfLicenseAssignmentManagerLicenseAssignment;
our @ISA = qw(ComplexType);

our @property_list = (
   ['LicenseAssignmentManagerLicenseAssignment', 'LicenseAssignmentManagerLicenseAssignment', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfLicenseAssignmentManagerLicenseAssignment', 'LicenseAssignmentManagerLicenseAssignment');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseSource;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('LicenseSource');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseServerSource;
our @ISA = qw(LicenseSource);

our @property_list = (
   ['licenseServer', undef, undef, 1],
);


VIMRuntime::make_get_set('LicenseServerSource', 'licenseServer');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LocalLicenseSource;
our @ISA = qw(LicenseSource);

our @property_list = (
   ['licenseKeys', undef, undef, 1],
);


VIMRuntime::make_get_set('LocalLicenseSource', 'licenseKeys');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EvaluationLicenseSource;
our @ISA = qw(LicenseSource);

our @property_list = (
   ['remainingHours', undef, undef, 0],
);


VIMRuntime::make_get_set('EvaluationLicenseSource', 'remainingHours');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseFeatureInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['featureName', undef, undef, 1],
   ['featureDescription', undef, undef, 0],
   ['state', 'LicenseFeatureInfoState', undef, 0],
   ['costUnit', undef, undef, 1],
   ['sourceRestriction', undef, undef, 0],
   ['dependentKey', undef, 1, 0],
   ['edition', 'boolean', undef, 0],
   ['expiresOn', undef, undef, 0],
);


VIMRuntime::make_get_set('LicenseFeatureInfo', 'key', 'featureName', 'featureDescription', 'state', 'costUnit', 'sourceRestriction', 'dependentKey', 'edition', 'expiresOn');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfLicenseFeatureInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['LicenseFeatureInfo', 'LicenseFeatureInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfLicenseFeatureInfo', 'LicenseFeatureInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseReservationInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['state', 'LicenseReservationInfoState', undef, 1],
   ['required', undef, undef, 1],
);


VIMRuntime::make_get_set('LicenseReservationInfo', 'key', 'state', 'required');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfLicenseReservationInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['LicenseReservationInfo', 'LicenseReservationInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfLicenseReservationInfo', 'LicenseReservationInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseAvailabilityInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['feature', 'LicenseFeatureInfo', undef, 1],
   ['total', undef, undef, 1],
   ['available', undef, undef, 1],
);


VIMRuntime::make_get_set('LicenseAvailabilityInfo', 'feature', 'total', 'available');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfLicenseAvailabilityInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['LicenseAvailabilityInfo', 'LicenseAvailabilityInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfLicenseAvailabilityInfo', 'LicenseAvailabilityInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseDiagnostics;
our @ISA = qw(DynamicData);

our @property_list = (
   ['sourceLastChanged', undef, undef, 1],
   ['sourceLost', undef, undef, 1],
   ['sourceLatency', undef, undef, 1],
   ['licenseRequests', undef, undef, 1],
   ['licenseRequestFailures', undef, undef, 1],
   ['licenseFeatureUnknowns', undef, undef, 1],
   ['opState', 'LicenseManagerState', undef, 1],
   ['lastStatusUpdate', undef, undef, 1],
   ['opFailureMessage', undef, undef, 1],
);


VIMRuntime::make_get_set('LicenseDiagnostics', 'sourceLastChanged', 'sourceLost', 'sourceLatency', 'licenseRequests', 'licenseRequestFailures', 'licenseFeatureUnknowns', 'opState', 'lastStatusUpdate', 'opFailureMessage');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseUsageInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['source', 'LicenseSource', undef, 1],
   ['sourceAvailable', 'boolean', undef, 1],
   ['reservationInfo', 'LicenseReservationInfo', 1, 0],
   ['featureInfo', 'LicenseFeatureInfo', 1, 0],
);


VIMRuntime::make_get_set('LicenseUsageInfo', 'source', 'sourceAvailable', 'reservationInfo', 'featureInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseManagerEvaluationInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['properties', 'KeyAnyValue', 1, 1],
);


VIMRuntime::make_get_set('LicenseManagerEvaluationInfo', 'properties');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostLicensableResourceInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['resource', 'KeyAnyValue', 1, 1],
);


VIMRuntime::make_get_set('HostLicensableResourceInfo', 'resource');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseManagerLicenseInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['licenseKey', undef, undef, 1],
   ['editionKey', undef, undef, 1],
   ['name', undef, undef, 1],
   ['total', undef, undef, 1],
   ['used', undef, undef, 0],
   ['costUnit', undef, undef, 1],
   ['properties', 'KeyAnyValue', 1, 0],
   ['labels', 'KeyValue', 1, 0],
);


VIMRuntime::make_get_set('LicenseManagerLicenseInfo', 'licenseKey', 'editionKey', 'name', 'total', 'used', 'costUnit', 'properties', 'labels');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfLicenseManagerLicenseInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['LicenseManagerLicenseInfo', 'LicenseManagerLicenseInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfLicenseManagerLicenseInfo', 'LicenseManagerLicenseInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LocalizationManagerMessageCatalog;
our @ISA = qw(DynamicData);

our @property_list = (
   ['moduleName', undef, undef, 1],
   ['catalogName', undef, undef, 1],
   ['locale', undef, undef, 1],
   ['catalogUri', undef, undef, 1],
   ['lastModified', undef, undef, 0],
   ['md5sum', undef, undef, 0],
   ['version', undef, undef, 0],
);


VIMRuntime::make_get_set('LocalizationManagerMessageCatalog', 'moduleName', 'catalogName', 'locale', 'catalogUri', 'lastModified', 'md5sum', 'version');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfLocalizationManagerMessageCatalog;
our @ISA = qw(ComplexType);

our @property_list = (
   ['LocalizationManagerMessageCatalog', 'LocalizationManagerMessageCatalog', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfLocalizationManagerMessageCatalog', 'LocalizationManagerMessageCatalog');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LongPolicy;
our @ISA = qw(InheritablePolicy);

our @property_list = (
   ['value', undef, undef, 0],
);


VIMRuntime::make_get_set('LongPolicy', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MacAddress;
our @ISA = qw(NegatableExpression);

our @property_list = (
);


VIMRuntime::make_get_set('MacAddress');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MacRange;
our @ISA = qw(MacAddress);

our @property_list = (
   ['address', undef, undef, 1],
   ['mask', undef, undef, 1],
);


VIMRuntime::make_get_set('MacRange', 'address', 'mask');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfManagedEntityStatus;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ManagedEntityStatus', 'ManagedEntityStatus', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfManagedEntityStatus', 'ManagedEntityStatus');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MethodDescription;
our @ISA = qw(Description);

our @property_list = (
   ['key', undef, undef, 1],
);


VIMRuntime::make_get_set('MethodDescription', 'key');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NegatableExpression;
our @ISA = qw(DynamicData);

our @property_list = (
   ['negate', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('NegatableExpression', 'negate');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NetworkSummary;
our @ISA = qw(DynamicData);

our @property_list = (
   ['network', 'ManagedObjectReference', undef, 0],
   ['name', undef, undef, 1],
   ['accessible', 'boolean', undef, 1],
   ['ipPoolName', undef, undef, 1],
   ['ipPoolId', undef, undef, 0],
);


VIMRuntime::make_get_set('NetworkSummary', 'network', 'name', 'accessible', 'ipPoolName', 'ipPoolId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NumericRange;
our @ISA = qw(DynamicData);

our @property_list = (
   ['start', undef, undef, 1],
   ['end', undef, undef, 1],
);


VIMRuntime::make_get_set('NumericRange', 'start', 'end');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfNumericRange;
our @ISA = qw(ComplexType);

our @property_list = (
   ['NumericRange', 'NumericRange', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfNumericRange', 'NumericRange');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OpaqueNetworkSummary;
our @ISA = qw(NetworkSummary);

our @property_list = (
   ['opaqueNetworkId', undef, undef, 1],
   ['opaqueNetworkType', undef, undef, 1],
);


VIMRuntime::make_get_set('OpaqueNetworkSummary', 'opaqueNetworkId', 'opaqueNetworkType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OpaqueNetworkCapability;
our @ISA = qw(DynamicData);

our @property_list = (
   ['networkReservationSupported', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('OpaqueNetworkCapability', 'networkReservationSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfConsumerOvfSection;
our @ISA = qw(DynamicData);

our @property_list = (
   ['lineNumber', undef, undef, 1],
   ['xml', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfConsumerOvfSection', 'lineNumber', 'xml');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfOvfConsumerOvfSection;
our @ISA = qw(ComplexType);

our @property_list = (
   ['OvfConsumerOvfSection', 'OvfConsumerOvfSection', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfOvfConsumerOvfSection', 'OvfConsumerOvfSection');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfConsumerOstNode;
our @ISA = qw(DynamicData);

our @property_list = (
   ['id', undef, undef, 1],
   ['type', undef, undef, 1],
   ['section', 'OvfConsumerOvfSection', 1, 0],
   ['child', 'OvfConsumerOstNode', 1, 0],
   ['entity', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('OvfConsumerOstNode', 'id', 'type', 'section', 'child', 'entity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfOvfConsumerOstNode;
our @ISA = qw(ComplexType);

our @property_list = (
   ['OvfConsumerOstNode', 'OvfConsumerOstNode', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfOvfConsumerOstNode', 'OvfConsumerOstNode');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfOptionInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['option', undef, undef, 1],
   ['description', 'LocalizableMessage', undef, 1],
);


VIMRuntime::make_get_set('OvfOptionInfo', 'option', 'description');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfOvfOptionInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['OvfOptionInfo', 'OvfOptionInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfOvfOptionInfo', 'OvfOptionInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfDeploymentOption;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['label', undef, undef, 1],
   ['description', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfDeploymentOption', 'key', 'label', 'description');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfOvfDeploymentOption;
our @ISA = qw(ComplexType);

our @property_list = (
   ['OvfDeploymentOption', 'OvfDeploymentOption', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfOvfDeploymentOption', 'OvfDeploymentOption');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfManagerCommonParams;
our @ISA = qw(DynamicData);

our @property_list = (
   ['locale', undef, undef, 1],
   ['deploymentOption', undef, undef, 1],
   ['msgBundle', 'KeyValue', 1, 0],
   ['importOption', undef, 1, 0],
);


VIMRuntime::make_get_set('OvfManagerCommonParams', 'locale', 'deploymentOption', 'msgBundle', 'importOption');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfValidateHostParams;
our @ISA = qw(OvfManagerCommonParams);

our @property_list = (
);


VIMRuntime::make_get_set('OvfValidateHostParams');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfValidateHostResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['downloadSize', undef, undef, 0],
   ['flatDeploymentSize', undef, undef, 0],
   ['sparseDeploymentSize', undef, undef, 0],
   ['error', 'LocalizedMethodFault', 1, 0],
   ['warning', 'LocalizedMethodFault', 1, 0],
   ['supportedDiskProvisioning', undef, 1, 0],
);


VIMRuntime::make_get_set('OvfValidateHostResult', 'downloadSize', 'flatDeploymentSize', 'sparseDeploymentSize', 'error', 'warning', 'supportedDiskProvisioning');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfParseDescriptorParams;
our @ISA = qw(OvfManagerCommonParams);

our @property_list = (
);


VIMRuntime::make_get_set('OvfParseDescriptorParams');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfParseDescriptorResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['eula', undef, 1, 0],
   ['network', 'OvfNetworkInfo', 1, 0],
   ['ipAllocationScheme', undef, 1, 0],
   ['ipProtocols', undef, 1, 0],
   ['property', 'VAppPropertyInfo', 1, 0],
   ['productInfo', 'VAppProductInfo', undef, 0],
   ['annotation', undef, undef, 1],
   ['approximateDownloadSize', undef, undef, 0],
   ['approximateFlatDeploymentSize', undef, undef, 0],
   ['approximateSparseDeploymentSize', undef, undef, 0],
   ['defaultEntityName', undef, undef, 1],
   ['virtualApp', 'boolean', undef, 1],
   ['deploymentOption', 'OvfDeploymentOption', 1, 0],
   ['defaultDeploymentOption', undef, undef, 1],
   ['entityName', 'KeyValue', 1, 0],
   ['annotatedOst', 'OvfConsumerOstNode', undef, 0],
   ['error', 'LocalizedMethodFault', 1, 0],
   ['warning', 'LocalizedMethodFault', 1, 0],
);


VIMRuntime::make_get_set('OvfParseDescriptorResult', 'eula', 'network', 'ipAllocationScheme', 'ipProtocols', 'property', 'productInfo', 'annotation', 'approximateDownloadSize', 'approximateFlatDeploymentSize', 'approximateSparseDeploymentSize', 'defaultEntityName', 'virtualApp', 'deploymentOption', 'defaultDeploymentOption', 'entityName', 'annotatedOst', 'error', 'warning');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfNetworkInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['description', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfNetworkInfo', 'name', 'description');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfOvfNetworkInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['OvfNetworkInfo', 'OvfNetworkInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfOvfNetworkInfo', 'OvfNetworkInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfCreateImportSpecParams;
our @ISA = qw(OvfManagerCommonParams);

our @property_list = (
   ['entityName', undef, undef, 1],
   ['hostSystem', 'ManagedObjectReference', undef, 0],
   ['networkMapping', 'OvfNetworkMapping', 1, 0],
   ['ipAllocationPolicy', undef, undef, 0],
   ['ipProtocol', undef, undef, 0],
   ['propertyMapping', 'KeyValue', 1, 0],
   ['resourceMapping', 'OvfResourceMap', 1, 0],
   ['diskProvisioning', undef, undef, 0],
   ['instantiationOst', 'OvfConsumerOstNode', undef, 0],
);


VIMRuntime::make_get_set('OvfCreateImportSpecParams', 'entityName', 'hostSystem', 'networkMapping', 'ipAllocationPolicy', 'ipProtocol', 'propertyMapping', 'resourceMapping', 'diskProvisioning', 'instantiationOst');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfResourceMap;
our @ISA = qw(DynamicData);

our @property_list = (
   ['source', undef, undef, 1],
   ['parent', 'ManagedObjectReference', undef, 0],
   ['resourceSpec', 'ResourceConfigSpec', undef, 0],
   ['datastore', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('OvfResourceMap', 'source', 'parent', 'resourceSpec', 'datastore');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfOvfResourceMap;
our @ISA = qw(ComplexType);

our @property_list = (
   ['OvfResourceMap', 'OvfResourceMap', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfOvfResourceMap', 'OvfResourceMap');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfNetworkMapping;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['network', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('OvfNetworkMapping', 'name', 'network');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfOvfNetworkMapping;
our @ISA = qw(ComplexType);

our @property_list = (
   ['OvfNetworkMapping', 'OvfNetworkMapping', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfOvfNetworkMapping', 'OvfNetworkMapping');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfCreateImportSpecResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['importSpec', 'ImportSpec', undef, 0],
   ['fileItem', 'OvfFileItem', 1, 0],
   ['warning', 'LocalizedMethodFault', 1, 0],
   ['error', 'LocalizedMethodFault', 1, 0],
);


VIMRuntime::make_get_set('OvfCreateImportSpecResult', 'importSpec', 'fileItem', 'warning', 'error');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfFileItem;
our @ISA = qw(DynamicData);

our @property_list = (
   ['deviceId', undef, undef, 1],
   ['path', undef, undef, 1],
   ['compressionMethod', undef, undef, 0],
   ['chunkSize', undef, undef, 0],
   ['size', undef, undef, 0],
   ['cimType', undef, undef, 1],
   ['create', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('OvfFileItem', 'deviceId', 'path', 'compressionMethod', 'chunkSize', 'size', 'cimType', 'create');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfOvfFileItem;
our @ISA = qw(ComplexType);

our @property_list = (
   ['OvfFileItem', 'OvfFileItem', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfOvfFileItem', 'OvfFileItem');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfCreateDescriptorParams;
our @ISA = qw(DynamicData);

our @property_list = (
   ['ovfFiles', 'OvfFile', 1, 0],
   ['name', undef, undef, 0],
   ['description', undef, undef, 0],
   ['includeImageFiles', 'boolean', undef, 0],
   ['exportOption', undef, 1, 0],
   ['snapshot', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('OvfCreateDescriptorParams', 'ovfFiles', 'name', 'description', 'includeImageFiles', 'exportOption', 'snapshot');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfCreateDescriptorResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['ovfDescriptor', undef, undef, 1],
   ['error', 'LocalizedMethodFault', 1, 0],
   ['warning', 'LocalizedMethodFault', 1, 0],
   ['includeImageFiles', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('OvfCreateDescriptorResult', 'ovfDescriptor', 'error', 'warning', 'includeImageFiles');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfFile;
our @ISA = qw(DynamicData);

our @property_list = (
   ['deviceId', undef, undef, 1],
   ['path', undef, undef, 1],
   ['compressionMethod', undef, undef, 0],
   ['chunkSize', undef, undef, 0],
   ['size', undef, undef, 1],
   ['capacity', undef, undef, 0],
   ['populatedSize', undef, undef, 0],
);


VIMRuntime::make_get_set('OvfFile', 'deviceId', 'path', 'compressionMethod', 'chunkSize', 'size', 'capacity', 'populatedSize');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfOvfFile;
our @ISA = qw(ComplexType);

our @property_list = (
   ['OvfFile', 'OvfFile', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfOvfFile', 'OvfFile');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PasswordField;
our @ISA = qw(DynamicData);

our @property_list = (
   ['value', undef, undef, 1],
);


VIMRuntime::make_get_set('PasswordField', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PerformanceDescription;
our @ISA = qw(DynamicData);

our @property_list = (
   ['counterType', 'ElementDescription', 1, 1],
   ['statsType', 'ElementDescription', 1, 1],
);


VIMRuntime::make_get_set('PerformanceDescription', 'counterType', 'statsType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PerfProviderSummary;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entity', 'ManagedObjectReference', undef, 1],
   ['currentSupported', 'boolean', undef, 1],
   ['summarySupported', 'boolean', undef, 1],
   ['refreshRate', undef, undef, 0],
);


VIMRuntime::make_get_set('PerfProviderSummary', 'entity', 'currentSupported', 'summarySupported', 'refreshRate');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PerfCounterInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['nameInfo', 'ElementDescription', undef, 1],
   ['groupInfo', 'ElementDescription', undef, 1],
   ['unitInfo', 'ElementDescription', undef, 1],
   ['rollupType', 'PerfSummaryType', undef, 1],
   ['statsType', 'PerfStatsType', undef, 1],
   ['level', undef, undef, 0],
   ['perDeviceLevel', undef, undef, 0],
   ['associatedCounterId', undef, 1, 0],
);


VIMRuntime::make_get_set('PerfCounterInfo', 'key', 'nameInfo', 'groupInfo', 'unitInfo', 'rollupType', 'statsType', 'level', 'perDeviceLevel', 'associatedCounterId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfPerfCounterInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['PerfCounterInfo', 'PerfCounterInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfPerfCounterInfo', 'PerfCounterInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PerfMetricId;
our @ISA = qw(DynamicData);

our @property_list = (
   ['counterId', undef, undef, 1],
   ['instance', undef, undef, 1],
);


VIMRuntime::make_get_set('PerfMetricId', 'counterId', 'instance');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfPerfMetricId;
our @ISA = qw(ComplexType);

our @property_list = (
   ['PerfMetricId', 'PerfMetricId', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfPerfMetricId', 'PerfMetricId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PerfQuerySpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entity', 'ManagedObjectReference', undef, 1],
   ['startTime', undef, undef, 0],
   ['endTime', undef, undef, 0],
   ['maxSample', undef, undef, 0],
   ['metricId', 'PerfMetricId', 1, 0],
   ['intervalId', undef, undef, 0],
   ['format', undef, undef, 0],
);


VIMRuntime::make_get_set('PerfQuerySpec', 'entity', 'startTime', 'endTime', 'maxSample', 'metricId', 'intervalId', 'format');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfPerfQuerySpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['PerfQuerySpec', 'PerfQuerySpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfPerfQuerySpec', 'PerfQuerySpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PerfSampleInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['timestamp', undef, undef, 1],
   ['interval', undef, undef, 1],
);


VIMRuntime::make_get_set('PerfSampleInfo', 'timestamp', 'interval');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfPerfSampleInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['PerfSampleInfo', 'PerfSampleInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfPerfSampleInfo', 'PerfSampleInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PerfMetricSeries;
our @ISA = qw(DynamicData);

our @property_list = (
   ['id', 'PerfMetricId', undef, 1],
);


VIMRuntime::make_get_set('PerfMetricSeries', 'id');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfPerfMetricSeries;
our @ISA = qw(ComplexType);

our @property_list = (
   ['PerfMetricSeries', 'PerfMetricSeries', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfPerfMetricSeries', 'PerfMetricSeries');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PerfMetricIntSeries;
our @ISA = qw(PerfMetricSeries);

our @property_list = (
   ['value', undef, 1, 0],
);


VIMRuntime::make_get_set('PerfMetricIntSeries', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PerfMetricSeriesCSV;
our @ISA = qw(PerfMetricSeries);

our @property_list = (
   ['value', undef, undef, 0],
);


VIMRuntime::make_get_set('PerfMetricSeriesCSV', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfPerfMetricSeriesCSV;
our @ISA = qw(ComplexType);

our @property_list = (
   ['PerfMetricSeriesCSV', 'PerfMetricSeriesCSV', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfPerfMetricSeriesCSV', 'PerfMetricSeriesCSV');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PerfEntityMetricBase;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entity', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('PerfEntityMetricBase', 'entity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfPerfEntityMetricBase;
our @ISA = qw(ComplexType);

our @property_list = (
   ['PerfEntityMetricBase', 'PerfEntityMetricBase', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfPerfEntityMetricBase', 'PerfEntityMetricBase');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PerfEntityMetric;
our @ISA = qw(PerfEntityMetricBase);

our @property_list = (
   ['sampleInfo', 'PerfSampleInfo', 1, 0],
   ['value', 'PerfMetricSeries', 1, 0],
);


VIMRuntime::make_get_set('PerfEntityMetric', 'sampleInfo', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PerfEntityMetricCSV;
our @ISA = qw(PerfEntityMetricBase);

our @property_list = (
   ['sampleInfoCSV', undef, undef, 1],
   ['value', 'PerfMetricSeriesCSV', 1, 0],
);


VIMRuntime::make_get_set('PerfEntityMetricCSV', 'sampleInfoCSV', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PerfCompositeMetric;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entity', 'PerfEntityMetricBase', undef, 0],
   ['childEntity', 'PerfEntityMetricBase', 1, 0],
);


VIMRuntime::make_get_set('PerfCompositeMetric', 'entity', 'childEntity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PerformanceManagerCounterLevelMapping;
our @ISA = qw(DynamicData);

our @property_list = (
   ['counterId', undef, undef, 1],
   ['aggregateLevel', undef, undef, 0],
   ['perDeviceLevel', undef, undef, 0],
);


VIMRuntime::make_get_set('PerformanceManagerCounterLevelMapping', 'counterId', 'aggregateLevel', 'perDeviceLevel');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfPerformanceManagerCounterLevelMapping;
our @ISA = qw(ComplexType);

our @property_list = (
   ['PerformanceManagerCounterLevelMapping', 'PerformanceManagerCounterLevelMapping', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfPerformanceManagerCounterLevelMapping', 'PerformanceManagerCounterLevelMapping');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PerfInterval;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['samplingPeriod', undef, undef, 1],
   ['name', undef, undef, 1],
   ['length', undef, undef, 1],
   ['level', undef, undef, 0],
   ['enabled', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('PerfInterval', 'key', 'samplingPeriod', 'name', 'length', 'level', 'enabled');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfPerfInterval;
our @ISA = qw(ComplexType);

our @property_list = (
   ['PerfInterval', 'PerfInterval', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfPerfInterval', 'PerfInterval');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PosixUserSearchResult;
our @ISA = qw(UserSearchResult);

our @property_list = (
   ['id', undef, undef, 1],
   ['shellAccess', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('PosixUserSearchResult', 'id', 'shellAccess');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PrivilegePolicyDef;
our @ISA = qw(DynamicData);

our @property_list = (
   ['createPrivilege', undef, undef, 1],
   ['readPrivilege', undef, undef, 1],
   ['updatePrivilege', undef, undef, 1],
   ['deletePrivilege', undef, undef, 1],
);


VIMRuntime::make_get_set('PrivilegePolicyDef', 'createPrivilege', 'readPrivilege', 'updatePrivilege', 'deletePrivilege');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ResourceAllocationInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['reservation', undef, undef, 0],
   ['expandableReservation', 'boolean', undef, 0],
   ['limit', undef, undef, 0],
   ['shares', 'SharesInfo', undef, 0],
   ['overheadLimit', undef, undef, 0],
);


VIMRuntime::make_get_set('ResourceAllocationInfo', 'reservation', 'expandableReservation', 'limit', 'shares', 'overheadLimit');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ResourceAllocationOption;
our @ISA = qw(DynamicData);

our @property_list = (
   ['sharesOption', 'SharesOption', undef, 1],
);


VIMRuntime::make_get_set('ResourceAllocationOption', 'sharesOption');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ResourceConfigOption;
our @ISA = qw(DynamicData);

our @property_list = (
   ['cpuAllocationOption', 'ResourceAllocationOption', undef, 1],
   ['memoryAllocationOption', 'ResourceAllocationOption', undef, 1],
);


VIMRuntime::make_get_set('ResourceConfigOption', 'cpuAllocationOption', 'memoryAllocationOption');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ResourceConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entity', 'ManagedObjectReference', undef, 0],
   ['changeVersion', undef, undef, 0],
   ['lastModified', undef, undef, 0],
   ['cpuAllocation', 'ResourceAllocationInfo', undef, 1],
   ['memoryAllocation', 'ResourceAllocationInfo', undef, 1],
   ['scaleDescendantsShares', undef, undef, 0],
);


VIMRuntime::make_get_set('ResourceConfigSpec', 'entity', 'changeVersion', 'lastModified', 'cpuAllocation', 'memoryAllocation', 'scaleDescendantsShares');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfResourceConfigSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ResourceConfigSpec', 'ResourceConfigSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfResourceConfigSpec', 'ResourceConfigSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatabaseSizeParam;
our @ISA = qw(DynamicData);

our @property_list = (
   ['inventoryDesc', 'InventoryDescription', undef, 1],
   ['perfStatsDesc', 'PerformanceStatisticsDescription', undef, 0],
);


VIMRuntime::make_get_set('DatabaseSizeParam', 'inventoryDesc', 'perfStatsDesc');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InventoryDescription;
our @ISA = qw(DynamicData);

our @property_list = (
   ['numHosts', undef, undef, 1],
   ['numVirtualMachines', undef, undef, 1],
   ['numResourcePools', undef, undef, 0],
   ['numClusters', undef, undef, 0],
   ['numCpuDev', undef, undef, 0],
   ['numNetDev', undef, undef, 0],
   ['numDiskDev', undef, undef, 0],
   ['numvCpuDev', undef, undef, 0],
   ['numvNetDev', undef, undef, 0],
   ['numvDiskDev', undef, undef, 0],
);


VIMRuntime::make_get_set('InventoryDescription', 'numHosts', 'numVirtualMachines', 'numResourcePools', 'numClusters', 'numCpuDev', 'numNetDev', 'numDiskDev', 'numvCpuDev', 'numvNetDev', 'numvDiskDev');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PerformanceStatisticsDescription;
our @ISA = qw(DynamicData);

our @property_list = (
   ['intervals', 'PerfInterval', 1, 0],
);


VIMRuntime::make_get_set('PerformanceStatisticsDescription', 'intervals');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatabaseSizeEstimate;
our @ISA = qw(DynamicData);

our @property_list = (
   ['size', undef, undef, 1],
);


VIMRuntime::make_get_set('DatabaseSizeEstimate', 'size');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ResourcePoolResourceUsage;
our @ISA = qw(DynamicData);

our @property_list = (
   ['reservationUsed', undef, undef, 1],
   ['reservationUsedForVm', undef, undef, 1],
   ['unreservedForPool', undef, undef, 1],
   ['unreservedForVm', undef, undef, 1],
   ['overallUsage', undef, undef, 1],
   ['maxUsage', undef, undef, 1],
);


VIMRuntime::make_get_set('ResourcePoolResourceUsage', 'reservationUsed', 'reservationUsedForVm', 'unreservedForPool', 'unreservedForVm', 'overallUsage', 'maxUsage');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ResourcePoolRuntimeInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['memory', 'ResourcePoolResourceUsage', undef, 1],
   ['cpu', 'ResourcePoolResourceUsage', undef, 1],
   ['overallStatus', 'ManagedEntityStatus', undef, 1],
   ['sharesScalable', undef, undef, 0],
);


VIMRuntime::make_get_set('ResourcePoolRuntimeInfo', 'memory', 'cpu', 'overallStatus', 'sharesScalable');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ResourcePoolSummary;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['config', 'ResourceConfigSpec', undef, 1],
   ['runtime', 'ResourcePoolRuntimeInfo', undef, 1],
   ['quickStats', 'ResourcePoolQuickStats', undef, 0],
   ['configuredMemoryMB', undef, undef, 0],
);


VIMRuntime::make_get_set('ResourcePoolSummary', 'name', 'config', 'runtime', 'quickStats', 'configuredMemoryMB');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ResourcePoolQuickStats;
our @ISA = qw(DynamicData);

our @property_list = (
   ['overallCpuUsage', undef, undef, 0],
   ['overallCpuDemand', undef, undef, 0],
   ['guestMemoryUsage', undef, undef, 0],
   ['hostMemoryUsage', undef, undef, 0],
   ['distributedCpuEntitlement', undef, undef, 0],
   ['distributedMemoryEntitlement', undef, undef, 0],
   ['staticCpuEntitlement', undef, undef, 0],
   ['staticMemoryEntitlement', undef, undef, 0],
   ['privateMemory', undef, undef, 0],
   ['sharedMemory', undef, undef, 0],
   ['swappedMemory', undef, undef, 0],
   ['balloonedMemory', undef, undef, 0],
   ['overheadMemory', undef, undef, 0],
   ['consumedOverheadMemory', undef, undef, 0],
   ['compressedMemory', undef, undef, 0],
);


VIMRuntime::make_get_set('ResourcePoolQuickStats', 'overallCpuUsage', 'overallCpuDemand', 'guestMemoryUsage', 'hostMemoryUsage', 'distributedCpuEntitlement', 'distributedMemoryEntitlement', 'staticCpuEntitlement', 'staticMemoryEntitlement', 'privateMemory', 'sharedMemory', 'swappedMemory', 'balloonedMemory', 'overheadMemory', 'consumedOverheadMemory', 'compressedMemory');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SDDCBase;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('SDDCBase');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SelectionSet;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('SelectionSet');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfSelectionSet;
our @ISA = qw(ComplexType);

our @property_list = (
   ['SelectionSet', 'SelectionSet', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfSelectionSet', 'SelectionSet');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostVMotionCompatibility;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['compatibility', undef, 1, 0],
);


VIMRuntime::make_get_set('HostVMotionCompatibility', 'host', 'compatibility');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHostVMotionCompatibility;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HostVMotionCompatibility', 'HostVMotionCompatibility', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHostVMotionCompatibility', 'HostVMotionCompatibility');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ProductComponentInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['id', undef, undef, 1],
   ['name', undef, undef, 1],
   ['version', undef, undef, 1],
   ['release', undef, undef, 1],
);


VIMRuntime::make_get_set('ProductComponentInfo', 'id', 'name', 'version', 'release');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfProductComponentInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ProductComponentInfo', 'ProductComponentInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfProductComponentInfo', 'ProductComponentInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ServiceContent;
our @ISA = qw(DynamicData);

our @property_list = (
   ['rootFolder', 'ManagedObjectReference', undef, 1],
   ['propertyCollector', 'ManagedObjectReference', undef, 1],
   ['viewManager', 'ManagedObjectReference', undef, 0],
   ['about', 'AboutInfo', undef, 1],
   ['setting', 'ManagedObjectReference', undef, 0],
   ['userDirectory', 'ManagedObjectReference', undef, 0],
   ['sessionManager', 'ManagedObjectReference', undef, 0],
   ['authorizationManager', 'ManagedObjectReference', undef, 0],
   ['serviceManager', 'ManagedObjectReference', undef, 0],
   ['perfManager', 'ManagedObjectReference', undef, 0],
   ['scheduledTaskManager', 'ManagedObjectReference', undef, 0],
   ['alarmManager', 'ManagedObjectReference', undef, 0],
   ['eventManager', 'ManagedObjectReference', undef, 0],
   ['taskManager', 'ManagedObjectReference', undef, 0],
   ['extensionManager', 'ManagedObjectReference', undef, 0],
   ['customizationSpecManager', 'ManagedObjectReference', undef, 0],
   ['guestCustomizationManager', 'ManagedObjectReference', undef, 0],
   ['customFieldsManager', 'ManagedObjectReference', undef, 0],
   ['accountManager', 'ManagedObjectReference', undef, 0],
   ['diagnosticManager', 'ManagedObjectReference', undef, 0],
   ['licenseManager', 'ManagedObjectReference', undef, 0],
   ['searchIndex', 'ManagedObjectReference', undef, 0],
   ['fileManager', 'ManagedObjectReference', undef, 0],
   ['datastoreNamespaceManager', 'ManagedObjectReference', undef, 0],
   ['virtualDiskManager', 'ManagedObjectReference', undef, 0],
   ['virtualizationManager', 'ManagedObjectReference', undef, 0],
   ['snmpSystem', 'ManagedObjectReference', undef, 0],
   ['vmProvisioningChecker', 'ManagedObjectReference', undef, 0],
   ['vmCompatibilityChecker', 'ManagedObjectReference', undef, 0],
   ['ovfManager', 'ManagedObjectReference', undef, 0],
   ['ipPoolManager', 'ManagedObjectReference', undef, 0],
   ['dvSwitchManager', 'ManagedObjectReference', undef, 0],
   ['hostProfileManager', 'ManagedObjectReference', undef, 0],
   ['clusterProfileManager', 'ManagedObjectReference', undef, 0],
   ['complianceManager', 'ManagedObjectReference', undef, 0],
   ['localizationManager', 'ManagedObjectReference', undef, 0],
   ['storageResourceManager', 'ManagedObjectReference', undef, 0],
   ['guestOperationsManager', 'ManagedObjectReference', undef, 0],
   ['overheadMemoryManager', 'ManagedObjectReference', undef, 0],
   ['certificateManager', 'ManagedObjectReference', undef, 0],
   ['ioFilterManager', 'ManagedObjectReference', undef, 0],
   ['vStorageObjectManager', 'ManagedObjectReference', undef, 0],
   ['hostSpecManager', 'ManagedObjectReference', undef, 0],
   ['cryptoManager', 'ManagedObjectReference', undef, 0],
   ['healthUpdateManager', 'ManagedObjectReference', undef, 0],
   ['failoverClusterConfigurator', 'ManagedObjectReference', undef, 0],
   ['failoverClusterManager', 'ManagedObjectReference', undef, 0],
   ['tenantManager', 'ManagedObjectReference', undef, 0],
   ['siteInfoManager', 'ManagedObjectReference', undef, 0],
   ['storageQueryManager', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('ServiceContent', 'rootFolder', 'propertyCollector', 'viewManager', 'about', 'setting', 'userDirectory', 'sessionManager', 'authorizationManager', 'serviceManager', 'perfManager', 'scheduledTaskManager', 'alarmManager', 'eventManager', 'taskManager', 'extensionManager', 'customizationSpecManager', 'guestCustomizationManager', 'customFieldsManager', 'accountManager', 'diagnosticManager', 'licenseManager', 'searchIndex', 'fileManager', 'datastoreNamespaceManager', 'virtualDiskManager', 'virtualizationManager', 'snmpSystem', 'vmProvisioningChecker', 'vmCompatibilityChecker', 'ovfManager', 'ipPoolManager', 'dvSwitchManager', 'hostProfileManager', 'clusterProfileManager', 'complianceManager', 'localizationManager', 'storageResourceManager', 'guestOperationsManager', 'overheadMemoryManager', 'certificateManager', 'ioFilterManager', 'vStorageObjectManager', 'hostSpecManager', 'cryptoManager', 'healthUpdateManager', 'failoverClusterConfigurator', 'failoverClusterManager', 'tenantManager', 'siteInfoManager', 'storageQueryManager');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ServiceLocator;
our @ISA = qw(DynamicData);

our @property_list = (
   ['instanceUuid', undef, undef, 1],
   ['url', undef, undef, 1],
   ['credential', 'ServiceLocatorCredential', undef, 1],
   ['sslThumbprint', undef, undef, 0],
);


VIMRuntime::make_get_set('ServiceLocator', 'instanceUuid', 'url', 'credential', 'sslThumbprint');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfServiceLocator;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ServiceLocator', 'ServiceLocator', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfServiceLocator', 'ServiceLocator');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ServiceLocatorCredential;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('ServiceLocatorCredential');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ServiceLocatorNamePassword;
our @ISA = qw(ServiceLocatorCredential);

our @property_list = (
   ['username', undef, undef, 1],
   ['password', undef, undef, 1],
);


VIMRuntime::make_get_set('ServiceLocatorNamePassword', 'username', 'password');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ServiceLocatorSAMLCredential;
our @ISA = qw(ServiceLocatorCredential);

our @property_list = (
   ['token', undef, undef, 0],
);


VIMRuntime::make_get_set('ServiceLocatorSAMLCredential', 'token');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ServiceManagerServiceInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['serviceName', undef, undef, 1],
   ['location', undef, 1, 0],
   ['service', 'ManagedObjectReference', undef, 1],
   ['description', undef, undef, 1],
);


VIMRuntime::make_get_set('ServiceManagerServiceInfo', 'serviceName', 'location', 'service', 'description');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfServiceManagerServiceInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ServiceManagerServiceInfo', 'ServiceManagerServiceInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfServiceManagerServiceInfo', 'ServiceManagerServiceInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SessionManagerLocalTicket;
our @ISA = qw(DynamicData);

our @property_list = (
   ['userName', undef, undef, 1],
   ['passwordFilePath', undef, undef, 1],
);


VIMRuntime::make_get_set('SessionManagerLocalTicket', 'userName', 'passwordFilePath');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SessionManagerGenericServiceTicket;
our @ISA = qw(DynamicData);

our @property_list = (
   ['id', undef, undef, 1],
   ['hostName', undef, undef, 0],
   ['sslThumbprint', undef, undef, 0],
   ['certThumbprintList', 'VirtualMachineCertThumbprint', 1, 0],
   ['ticketType', undef, undef, 0],
);


VIMRuntime::make_get_set('SessionManagerGenericServiceTicket', 'id', 'hostName', 'sslThumbprint', 'certThumbprintList', 'ticketType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SessionManagerServiceRequestSpec;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('SessionManagerServiceRequestSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SessionManagerVmomiServiceRequestSpec;
our @ISA = qw(SessionManagerServiceRequestSpec);

our @property_list = (
   ['method', undef, undef, 1],
);


VIMRuntime::make_get_set('SessionManagerVmomiServiceRequestSpec', 'method');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SessionManagerHttpServiceRequestSpec;
our @ISA = qw(SessionManagerServiceRequestSpec);

our @property_list = (
   ['method', undef, undef, 0],
   ['url', undef, undef, 1],
);


VIMRuntime::make_get_set('SessionManagerHttpServiceRequestSpec', 'method', 'url');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SharesInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['shares', undef, undef, 1],
   ['level', 'SharesLevel', undef, 1],
);


VIMRuntime::make_get_set('SharesInfo', 'shares', 'level');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SharesOption;
our @ISA = qw(DynamicData);

our @property_list = (
   ['sharesOption', 'IntOption', undef, 1],
   ['defaultLevel', 'SharesLevel', undef, 1],
);


VIMRuntime::make_get_set('SharesOption', 'sharesOption', 'defaultLevel');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SingleIp;
our @ISA = qw(IpAddress);

our @property_list = (
   ['address', undef, undef, 1],
);


VIMRuntime::make_get_set('SingleIp', 'address');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SingleMac;
our @ISA = qw(MacAddress);

our @property_list = (
   ['address', undef, undef, 1],
);


VIMRuntime::make_get_set('SingleMac', 'address');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SiteInfo;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('SiteInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StoragePodSummary;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['capacity', undef, undef, 1],
   ['freeSpace', undef, undef, 1],
);


VIMRuntime::make_get_set('StoragePodSummary', 'name', 'capacity', 'freeSpace');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StorageIOAllocationInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['limit', undef, undef, 0],
   ['shares', 'SharesInfo', undef, 0],
   ['reservation', undef, undef, 0],
);


VIMRuntime::make_get_set('StorageIOAllocationInfo', 'limit', 'shares', 'reservation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StorageIOAllocationOption;
our @ISA = qw(DynamicData);

our @property_list = (
   ['limitOption', 'LongOption', undef, 1],
   ['sharesOption', 'SharesOption', undef, 1],
);


VIMRuntime::make_get_set('StorageIOAllocationOption', 'limitOption', 'sharesOption');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StorageIORMInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['enabled', 'boolean', undef, 1],
   ['congestionThresholdMode', undef, undef, 1],
   ['congestionThreshold', undef, undef, 1],
   ['percentOfPeakThroughput', undef, undef, 0],
   ['statsCollectionEnabled', 'boolean', undef, 1],
   ['reservationEnabled', 'boolean', undef, 1],
   ['statsAggregationDisabled', 'boolean', undef, 0],
   ['reservableIopsThreshold', undef, undef, 0],
);


VIMRuntime::make_get_set('StorageIORMInfo', 'enabled', 'congestionThresholdMode', 'congestionThreshold', 'percentOfPeakThroughput', 'statsCollectionEnabled', 'reservationEnabled', 'statsAggregationDisabled', 'reservableIopsThreshold');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StorageIORMConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['enabled', 'boolean', undef, 0],
   ['congestionThresholdMode', undef, undef, 0],
   ['congestionThreshold', undef, undef, 0],
   ['percentOfPeakThroughput', undef, undef, 0],
   ['statsCollectionEnabled', 'boolean', undef, 0],
   ['reservationEnabled', 'boolean', undef, 0],
   ['statsAggregationDisabled', 'boolean', undef, 0],
   ['reservableIopsThreshold', undef, undef, 0],
);


VIMRuntime::make_get_set('StorageIORMConfigSpec', 'enabled', 'congestionThresholdMode', 'congestionThreshold', 'percentOfPeakThroughput', 'statsCollectionEnabled', 'reservationEnabled', 'statsAggregationDisabled', 'reservableIopsThreshold');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StorageIORMConfigOption;
our @ISA = qw(DynamicData);

our @property_list = (
   ['enabledOption', 'BoolOption', undef, 1],
   ['congestionThresholdOption', 'IntOption', undef, 1],
   ['statsCollectionEnabledOption', 'BoolOption', undef, 1],
   ['reservationEnabledOption', 'BoolOption', undef, 1],
);


VIMRuntime::make_get_set('StorageIORMConfigOption', 'enabledOption', 'congestionThresholdOption', 'statsCollectionEnabledOption', 'reservationEnabledOption');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StoragePerformanceSummary;
our @ISA = qw(DynamicData);

our @property_list = (
   ['interval', undef, undef, 1],
   ['percentile', undef, 1, 1],
   ['datastoreReadLatency', undef, 1, 1],
   ['datastoreWriteLatency', undef, 1, 1],
   ['datastoreVmLatency', undef, 1, 1],
   ['datastoreReadIops', undef, 1, 1],
   ['datastoreWriteIops', undef, 1, 1],
   ['siocActivityDuration', undef, undef, 1],
);


VIMRuntime::make_get_set('StoragePerformanceSummary', 'interval', 'percentile', 'datastoreReadLatency', 'datastoreWriteLatency', 'datastoreVmLatency', 'datastoreReadIops', 'datastoreWriteIops', 'siocActivityDuration');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfStoragePerformanceSummary;
our @ISA = qw(ComplexType);

our @property_list = (
   ['StoragePerformanceSummary', 'StoragePerformanceSummary', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfStoragePerformanceSummary', 'StoragePerformanceSummary');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PodStorageDrsEntry;
our @ISA = qw(DynamicData);

our @property_list = (
   ['storageDrsConfig', 'StorageDrsConfigInfo', undef, 1],
   ['recommendation', 'ClusterRecommendation', 1, 0],
   ['drsFault', 'ClusterDrsFaults', 1, 0],
   ['actionHistory', 'ClusterActionHistory', 1, 0],
);


VIMRuntime::make_get_set('PodStorageDrsEntry', 'storageDrsConfig', 'recommendation', 'drsFault', 'actionHistory');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StorageResourceManagerStorageProfileStatistics;
our @ISA = qw(DynamicData);

our @property_list = (
   ['profileId', undef, undef, 1],
   ['totalSpaceMB', undef, undef, 1],
   ['usedSpaceMB', undef, undef, 1],
);


VIMRuntime::make_get_set('StorageResourceManagerStorageProfileStatistics', 'profileId', 'totalSpaceMB', 'usedSpaceMB');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StringExpression;
our @ISA = qw(NegatableExpression);

our @property_list = (
   ['value', undef, undef, 0],
);


VIMRuntime::make_get_set('StringExpression', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StringPolicy;
our @ISA = qw(InheritablePolicy);

our @property_list = (
   ['value', undef, undef, 0],
);


VIMRuntime::make_get_set('StringPolicy', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package Tag;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
);


VIMRuntime::make_get_set('Tag', 'key');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfTag;
our @ISA = qw(ComplexType);

our @property_list = (
   ['Tag', 'Tag', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfTag', 'Tag');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TaskDescription;
our @ISA = qw(DynamicData);

our @property_list = (
   ['methodInfo', 'ElementDescription', 1, 1],
   ['state', 'ElementDescription', 1, 1],
   ['reason', 'TypeDescription', 1, 1],
);


VIMRuntime::make_get_set('TaskDescription', 'methodInfo', 'state', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TaskFilterSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entity', 'TaskFilterSpecByEntity', undef, 0],
   ['time', 'TaskFilterSpecByTime', undef, 0],
   ['userName', 'TaskFilterSpecByUsername', undef, 0],
   ['activationId', undef, 1, 0],
   ['state', 'TaskInfoState', 1, 0],
   ['alarm', 'ManagedObjectReference', undef, 0],
   ['scheduledTask', 'ManagedObjectReference', undef, 0],
   ['eventChainId', undef, 1, 0],
   ['tag', undef, 1, 0],
   ['parentTaskKey', undef, 1, 0],
   ['rootTaskKey', undef, 1, 0],
);


VIMRuntime::make_get_set('TaskFilterSpec', 'entity', 'time', 'userName', 'activationId', 'state', 'alarm', 'scheduledTask', 'eventChainId', 'tag', 'parentTaskKey', 'rootTaskKey');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TaskFilterSpecByEntity;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entity', 'ManagedObjectReference', undef, 1],
   ['recursion', 'TaskFilterSpecRecursionOption', undef, 1],
);


VIMRuntime::make_get_set('TaskFilterSpecByEntity', 'entity', 'recursion');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TaskFilterSpecByTime;
our @ISA = qw(DynamicData);

our @property_list = (
   ['timeType', 'TaskFilterSpecTimeOption', undef, 1],
   ['beginTime', undef, undef, 0],
   ['endTime', undef, undef, 0],
);


VIMRuntime::make_get_set('TaskFilterSpecByTime', 'timeType', 'beginTime', 'endTime');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TaskFilterSpecByUsername;
our @ISA = qw(DynamicData);

our @property_list = (
   ['systemUser', 'boolean', undef, 1],
   ['userList', undef, 1, 0],
);


VIMRuntime::make_get_set('TaskFilterSpecByUsername', 'systemUser', 'userList');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TaskInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['task', 'ManagedObjectReference', undef, 1],
   ['description', 'LocalizableMessage', undef, 0],
   ['name', undef, undef, 0],
   ['descriptionId', undef, undef, 1],
   ['entity', 'ManagedObjectReference', undef, 0],
   ['entityName', undef, undef, 0],
   ['locked', 'ManagedObjectReference', 1, 0],
   ['state', 'TaskInfoState', undef, 1],
   ['cancelled', 'boolean', undef, 1],
   ['cancelable', 'boolean', undef, 1],
   ['error', 'LocalizedMethodFault', undef, 0],
   ['result', 'anyType', undef, 0],
   ['progress', undef, undef, 0],
   ['reason', 'TaskReason', undef, 1],
   ['queueTime', undef, undef, 1],
   ['startTime', undef, undef, 0],
   ['completeTime', undef, undef, 0],
   ['eventChainId', undef, undef, 1],
   ['changeTag', undef, undef, 0],
   ['parentTaskKey', undef, undef, 0],
   ['rootTaskKey', undef, undef, 0],
   ['activationId', undef, undef, 0],
);


VIMRuntime::make_get_set('TaskInfo', 'key', 'task', 'description', 'name', 'descriptionId', 'entity', 'entityName', 'locked', 'state', 'cancelled', 'cancelable', 'error', 'result', 'progress', 'reason', 'queueTime', 'startTime', 'completeTime', 'eventChainId', 'changeTag', 'parentTaskKey', 'rootTaskKey', 'activationId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfTaskInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['TaskInfo', 'TaskInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfTaskInfo', 'TaskInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfTaskInfoState;
our @ISA = qw(ComplexType);

our @property_list = (
   ['TaskInfoState', 'TaskInfoState', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfTaskInfoState', 'TaskInfoState');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TaskReason;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('TaskReason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TaskReasonSystem;
our @ISA = qw(TaskReason);

our @property_list = (
);


VIMRuntime::make_get_set('TaskReasonSystem');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TaskReasonUser;
our @ISA = qw(TaskReason);

our @property_list = (
   ['userName', undef, undef, 1],
);


VIMRuntime::make_get_set('TaskReasonUser', 'userName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TaskReasonAlarm;
our @ISA = qw(TaskReason);

our @property_list = (
   ['alarmName', undef, undef, 1],
   ['alarm', 'ManagedObjectReference', undef, 1],
   ['entityName', undef, undef, 1],
   ['entity', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('TaskReasonAlarm', 'alarmName', 'alarm', 'entityName', 'entity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TaskReasonSchedule;
our @ISA = qw(TaskReason);

our @property_list = (
   ['name', undef, undef, 1],
   ['scheduledTask', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('TaskReasonSchedule', 'name', 'scheduledTask');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TypeDescription;
our @ISA = qw(Description);

our @property_list = (
   ['key', undef, undef, 1],
);


VIMRuntime::make_get_set('TypeDescription', 'key');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfTypeDescription;
our @ISA = qw(ComplexType);

our @property_list = (
   ['TypeDescription', 'TypeDescription', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfTypeDescription', 'TypeDescription');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UpdateVirtualMachineFilesResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['failedVmFile', 'UpdateVirtualMachineFilesResultFailedVmFileInfo', 1, 0],
);


VIMRuntime::make_get_set('UpdateVirtualMachineFilesResult', 'failedVmFile');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UpdateVirtualMachineFilesResultFailedVmFileInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vmFile', undef, undef, 1],
   ['fault', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('UpdateVirtualMachineFilesResultFailedVmFileInfo', 'vmFile', 'fault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfUpdateVirtualMachineFilesResultFailedVmFileInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['UpdateVirtualMachineFilesResultFailedVmFileInfo', 'UpdateVirtualMachineFilesResultFailedVmFileInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfUpdateVirtualMachineFilesResultFailedVmFileInfo', 'UpdateVirtualMachineFilesResultFailedVmFileInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UserSearchResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['principal', undef, undef, 1],
   ['fullName', undef, undef, 0],
   ['group', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('UserSearchResult', 'principal', 'fullName', 'group');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfUserSearchResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['UserSearchResult', 'UserSearchResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfUserSearchResult', 'UserSearchResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UserSession;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['userName', undef, undef, 1],
   ['fullName', undef, undef, 1],
   ['loginTime', undef, undef, 1],
   ['lastActiveTime', undef, undef, 1],
   ['locale', undef, undef, 1],
   ['messageLocale', undef, undef, 1],
   ['extensionSession', 'boolean', undef, 1],
   ['ipAddress', undef, undef, 1],
   ['userAgent', undef, undef, 1],
   ['callCount', undef, undef, 1],
);


VIMRuntime::make_get_set('UserSession', 'key', 'userName', 'fullName', 'loginTime', 'lastActiveTime', 'locale', 'messageLocale', 'extensionSession', 'ipAddress', 'userAgent', 'callCount');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfUserSession;
our @ISA = qw(ComplexType);

our @property_list = (
   ['UserSession', 'UserSession', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfUserSession', 'UserSession');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VVolVmConfigFileUpdateResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['succeededVmConfigFile', 'KeyValue', 1, 0],
   ['failedVmConfigFile', 'VVolVmConfigFileUpdateResultFailedVmConfigFileInfo', 1, 0],
);


VIMRuntime::make_get_set('VVolVmConfigFileUpdateResult', 'succeededVmConfigFile', 'failedVmConfigFile');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VVolVmConfigFileUpdateResultFailedVmConfigFileInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['targetConfigVVolId', undef, undef, 1],
   ['dsPath', undef, undef, 0],
   ['fault', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('VVolVmConfigFileUpdateResultFailedVmConfigFileInfo', 'targetConfigVVolId', 'dsPath', 'fault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVVolVmConfigFileUpdateResultFailedVmConfigFileInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VVolVmConfigFileUpdateResultFailedVmConfigFileInfo', 'VVolVmConfigFileUpdateResultFailedVmConfigFileInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVVolVmConfigFileUpdateResultFailedVmConfigFileInfo', 'VVolVmConfigFileUpdateResultFailedVmConfigFileInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VASAStorageArray;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['uuid', undef, undef, 1],
   ['vendorId', undef, undef, 1],
   ['modelId', undef, undef, 1],
   ['discoverySvcInfo', 'VASAStorageArrayDiscoverySvcInfo', 1, 0],
);


VIMRuntime::make_get_set('VASAStorageArray', 'name', 'uuid', 'vendorId', 'modelId', 'discoverySvcInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVASAStorageArray;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VASAStorageArray', 'VASAStorageArray', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVASAStorageArray', 'VASAStorageArray');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VASAStorageArrayDiscoverySvcInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['portType', undef, undef, 1],
   ['svcNqn', undef, undef, 1],
   ['ipInfo', 'VASAStorageArrayDiscoveryIpTransport', undef, 0],
   ['fcInfo', 'VASAStorageArrayDiscoveryFcTransport', undef, 0],
);


VIMRuntime::make_get_set('VASAStorageArrayDiscoverySvcInfo', 'portType', 'svcNqn', 'ipInfo', 'fcInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVASAStorageArrayDiscoverySvcInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VASAStorageArrayDiscoverySvcInfo', 'VASAStorageArrayDiscoverySvcInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVASAStorageArrayDiscoverySvcInfo', 'VASAStorageArrayDiscoverySvcInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VASAStorageArrayDiscoveryFcTransport;
our @ISA = qw(DynamicData);

our @property_list = (
   ['nodeWwn', undef, undef, 1],
   ['portWwn', undef, undef, 1],
);


VIMRuntime::make_get_set('VASAStorageArrayDiscoveryFcTransport', 'nodeWwn', 'portWwn');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VASAStorageArrayDiscoveryIpTransport;
our @ISA = qw(DynamicData);

our @property_list = (
   ['ipAddress', undef, undef, 1],
   ['portNumber', undef, undef, 0],
);


VIMRuntime::make_get_set('VASAStorageArrayDiscoveryIpTransport', 'ipAddress', 'portNumber');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VasaProviderContainerSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vasaProviderInfo', 'VimVasaProviderInfo', 1, 0],
   ['scId', undef, undef, 1],
   ['deleted', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('VasaProviderContainerSpec', 'vasaProviderInfo', 'scId', 'deleted');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VimVasaProvider;
our @ISA = qw(DynamicData);

our @property_list = (
   ['uid', undef, undef, 0],
   ['url', undef, undef, 1],
   ['name', undef, undef, 0],
   ['selfSignedCertificate', undef, undef, 0],
);


VIMRuntime::make_get_set('VimVasaProvider', 'uid', 'url', 'name', 'selfSignedCertificate');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VimVasaProviderStatePerArray;
our @ISA = qw(DynamicData);

our @property_list = (
   ['priority', undef, undef, 1],
   ['arrayId', undef, undef, 1],
   ['active', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('VimVasaProviderStatePerArray', 'priority', 'arrayId', 'active');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVimVasaProviderStatePerArray;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VimVasaProviderStatePerArray', 'VimVasaProviderStatePerArray', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVimVasaProviderStatePerArray', 'VimVasaProviderStatePerArray');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VimVasaProviderInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['provider', 'VimVasaProvider', undef, 1],
   ['arrayState', 'VimVasaProviderStatePerArray', 1, 0],
);


VIMRuntime::make_get_set('VimVasaProviderInfo', 'provider', 'arrayState');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVimVasaProviderInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VimVasaProviderInfo', 'VimVasaProviderInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVimVasaProviderInfo', 'VimVasaProviderInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VirtualAppSummary;
our @ISA = qw(ResourcePoolSummary);

our @property_list = (
   ['product', 'VAppProductInfo', undef, 0],
   ['vAppState', 'VirtualAppVAppState', undef, 0],
   ['suspended', 'boolean', undef, 0],
   ['installBootRequired', 'boolean', undef, 0],
   ['instanceUuid', undef, undef, 0],
);


VIMRuntime::make_get_set('VirtualAppSummary', 'product', 'vAppState', 'suspended', 'installBootRequired', 'instanceUuid');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VirtualAppLinkInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', 'ManagedObjectReference', undef, 1],
   ['destroyWithParent', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VirtualAppLinkInfo', 'key', 'destroyWithParent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVirtualAppLinkInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VirtualAppLinkInfo', 'VirtualAppLinkInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVirtualAppLinkInfo', 'VirtualAppLinkInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VirtualDiskSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['diskType', undef, undef, 1],
   ['adapterType', undef, undef, 1],
);


VIMRuntime::make_get_set('VirtualDiskSpec', 'diskType', 'adapterType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FileBackedVirtualDiskSpec;
our @ISA = qw(VirtualDiskSpec);

our @property_list = (
   ['capacityKb', undef, undef, 1],
   ['profile', 'VirtualMachineProfileSpec', 1, 0],
   ['crypto', 'CryptoSpec', undef, 0],
);


VIMRuntime::make_get_set('FileBackedVirtualDiskSpec', 'capacityKb', 'profile', 'crypto');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SeSparseVirtualDiskSpec;
our @ISA = qw(FileBackedVirtualDiskSpec);

our @property_list = (
   ['grainSizeKb', undef, undef, 0],
);


VIMRuntime::make_get_set('SeSparseVirtualDiskSpec', 'grainSizeKb');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DeviceBackedVirtualDiskSpec;
our @ISA = qw(VirtualDiskSpec);

our @property_list = (
   ['device', undef, undef, 1],
);


VIMRuntime::make_get_set('DeviceBackedVirtualDiskSpec', 'device');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StorageRequirement;
our @ISA = qw(DynamicData);

our @property_list = (
   ['datastore', 'ManagedObjectReference', undef, 1],
   ['freeSpaceRequiredInKb', undef, undef, 1],
);


VIMRuntime::make_get_set('StorageRequirement', 'datastore', 'freeSpaceRequiredInKb');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfStorageRequirement;
our @ISA = qw(ComplexType);

our @property_list = (
   ['StorageRequirement', 'StorageRequirement', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfStorageRequirement', 'StorageRequirement');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VirtualMachineTicket;
our @ISA = qw(DynamicData);

our @property_list = (
   ['ticket', undef, undef, 1],
   ['cfgFile', undef, undef, 1],
   ['host', undef, undef, 0],
   ['port', undef, undef, 0],
   ['sslThumbprint', undef, undef, 0],
   ['certThumbprintList', 'VirtualMachineCertThumbprint', 1, 0],
   ['url', undef, undef, 0],
);


VIMRuntime::make_get_set('VirtualMachineTicket', 'ticket', 'cfgFile', 'host', 'port', 'sslThumbprint', 'certThumbprintList', 'url');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VirtualMachineMksTicket;
our @ISA = qw(DynamicData);

our @property_list = (
   ['ticket', undef, undef, 1],
   ['cfgFile', undef, undef, 1],
   ['host', undef, undef, 0],
   ['port', undef, undef, 0],
   ['sslThumbprint', undef, undef, 0],
);


VIMRuntime::make_get_set('VirtualMachineMksTicket', 'ticket', 'cfgFile', 'host', 'port', 'sslThumbprint');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VirtualMachineConnection;
our @ISA = qw(DynamicData);

our @property_list = (
   ['label', undef, undef, 1],
   ['client', undef, undef, 1],
   ['userName', undef, undef, 1],
);


VIMRuntime::make_get_set('VirtualMachineConnection', 'label', 'client', 'userName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVirtualMachineConnection;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VirtualMachineConnection', 'VirtualMachineConnection', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVirtualMachineConnection', 'VirtualMachineConnection');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VirtualMachineMksConnection;
our @ISA = qw(VirtualMachineConnection);

our @property_list = (
);


VIMRuntime::make_get_set('VirtualMachineMksConnection');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VirtualMachineDisplayTopology;
our @ISA = qw(DynamicData);

our @property_list = (
   ['x', undef, undef, 1],
   ['y', undef, undef, 1],
   ['width', undef, undef, 1],
   ['height', undef, undef, 1],
);


VIMRuntime::make_get_set('VirtualMachineDisplayTopology', 'x', 'y', 'width', 'height');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVirtualMachineDisplayTopology;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VirtualMachineDisplayTopology', 'VirtualMachineDisplayTopology', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVirtualMachineDisplayTopology', 'VirtualMachineDisplayTopology');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DiskChangeInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['startOffset', undef, undef, 1],
   ['length', undef, undef, 1],
   ['changedArea', 'DiskChangeExtent', 1, 0],
);


VIMRuntime::make_get_set('DiskChangeInfo', 'startOffset', 'length', 'changedArea');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DiskChangeExtent;
our @ISA = qw(DynamicData);

our @property_list = (
   ['start', undef, undef, 1],
   ['length', undef, undef, 1],
);


VIMRuntime::make_get_set('DiskChangeExtent', 'start', 'length');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDiskChangeExtent;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DiskChangeExtent', 'DiskChangeExtent', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDiskChangeExtent', 'DiskChangeExtent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VirtualMachineWipeResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['diskId', undef, undef, 1],
   ['shrinkableDiskSpace', undef, undef, 1],
);


VIMRuntime::make_get_set('VirtualMachineWipeResult', 'diskId', 'shrinkableDiskSpace');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanUpgradeSystemPreflightCheckIssue;
our @ISA = qw(DynamicData);

our @property_list = (
   ['msg', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanUpgradeSystemPreflightCheckIssue', 'msg');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanUpgradeSystemPreflightCheckIssue;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanUpgradeSystemPreflightCheckIssue', 'VsanUpgradeSystemPreflightCheckIssue', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanUpgradeSystemPreflightCheckIssue', 'VsanUpgradeSystemPreflightCheckIssue');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanUpgradeSystemHostsDisconnectedIssue;
our @ISA = qw(VsanUpgradeSystemPreflightCheckIssue);

our @property_list = (
   ['hosts', 'ManagedObjectReference', 1, 1],
);


VIMRuntime::make_get_set('VsanUpgradeSystemHostsDisconnectedIssue', 'hosts');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanUpgradeSystemMissingHostsInClusterIssue;
our @ISA = qw(VsanUpgradeSystemPreflightCheckIssue);

our @property_list = (
   ['hosts', 'ManagedObjectReference', 1, 1],
);


VIMRuntime::make_get_set('VsanUpgradeSystemMissingHostsInClusterIssue', 'hosts');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanUpgradeSystemRogueHostsInClusterIssue;
our @ISA = qw(VsanUpgradeSystemPreflightCheckIssue);

our @property_list = (
   ['uuids', undef, 1, 1],
);


VIMRuntime::make_get_set('VsanUpgradeSystemRogueHostsInClusterIssue', 'uuids');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanUpgradeSystemWrongEsxVersionIssue;
our @ISA = qw(VsanUpgradeSystemPreflightCheckIssue);

our @property_list = (
   ['hosts', 'ManagedObjectReference', 1, 1],
);


VIMRuntime::make_get_set('VsanUpgradeSystemWrongEsxVersionIssue', 'hosts');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanUpgradeSystemAutoClaimEnabledOnHostsIssue;
our @ISA = qw(VsanUpgradeSystemPreflightCheckIssue);

our @property_list = (
   ['hosts', 'ManagedObjectReference', 1, 1],
);


VIMRuntime::make_get_set('VsanUpgradeSystemAutoClaimEnabledOnHostsIssue', 'hosts');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanUpgradeSystemAPIBrokenIssue;
our @ISA = qw(VsanUpgradeSystemPreflightCheckIssue);

our @property_list = (
   ['hosts', 'ManagedObjectReference', 1, 1],
);


VIMRuntime::make_get_set('VsanUpgradeSystemAPIBrokenIssue', 'hosts');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanUpgradeSystemV2ObjectsPresentDuringDowngradeIssue;
our @ISA = qw(VsanUpgradeSystemPreflightCheckIssue);

our @property_list = (
   ['uuids', undef, 1, 1],
);


VIMRuntime::make_get_set('VsanUpgradeSystemV2ObjectsPresentDuringDowngradeIssue', 'uuids');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanUpgradeSystemNotEnoughFreeCapacityIssue;
our @ISA = qw(VsanUpgradeSystemPreflightCheckIssue);

our @property_list = (
   ['reducedRedundancyUpgradePossible', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('VsanUpgradeSystemNotEnoughFreeCapacityIssue', 'reducedRedundancyUpgradePossible');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanUpgradeSystemNetworkPartitionInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hosts', 'ManagedObjectReference', 1, 1],
);


VIMRuntime::make_get_set('VsanUpgradeSystemNetworkPartitionInfo', 'hosts');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanUpgradeSystemNetworkPartitionInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanUpgradeSystemNetworkPartitionInfo', 'VsanUpgradeSystemNetworkPartitionInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanUpgradeSystemNetworkPartitionInfo', 'VsanUpgradeSystemNetworkPartitionInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanUpgradeSystemNetworkPartitionIssue;
our @ISA = qw(VsanUpgradeSystemPreflightCheckIssue);

our @property_list = (
   ['partitions', 'VsanUpgradeSystemNetworkPartitionInfo', 1, 1],
);


VIMRuntime::make_get_set('VsanUpgradeSystemNetworkPartitionIssue', 'partitions');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanUpgradeSystemPreflightCheckResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['issues', 'VsanUpgradeSystemPreflightCheckIssue', 1, 0],
   ['diskMappingToRestore', 'VsanHostDiskMapping', undef, 0],
);


VIMRuntime::make_get_set('VsanUpgradeSystemPreflightCheckResult', 'issues', 'diskMappingToRestore');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanUpgradeSystemUpgradeHistoryItem;
our @ISA = qw(DynamicData);

our @property_list = (
   ['timestamp', undef, undef, 1],
   ['host', 'ManagedObjectReference', undef, 0],
   ['message', undef, undef, 1],
   ['task', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('VsanUpgradeSystemUpgradeHistoryItem', 'timestamp', 'host', 'message', 'task');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVsanUpgradeSystemUpgradeHistoryItem;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VsanUpgradeSystemUpgradeHistoryItem', 'VsanUpgradeSystemUpgradeHistoryItem', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVsanUpgradeSystemUpgradeHistoryItem', 'VsanUpgradeSystemUpgradeHistoryItem');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanUpgradeSystemUpgradeHistoryDiskGroupOp;
our @ISA = qw(VsanUpgradeSystemUpgradeHistoryItem);

our @property_list = (
   ['operation', undef, undef, 1],
   ['diskMapping', 'VsanHostDiskMapping', undef, 1],
);


VIMRuntime::make_get_set('VsanUpgradeSystemUpgradeHistoryDiskGroupOp', 'operation', 'diskMapping');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanUpgradeSystemUpgradeHistoryPreflightFail;
our @ISA = qw(VsanUpgradeSystemUpgradeHistoryItem);

our @property_list = (
   ['preflightResult', 'VsanUpgradeSystemPreflightCheckResult', undef, 1],
);


VIMRuntime::make_get_set('VsanUpgradeSystemUpgradeHistoryPreflightFail', 'preflightResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanUpgradeSystemUpgradeStatus;
our @ISA = qw(DynamicData);

our @property_list = (
   ['inProgress', 'boolean', undef, 1],
   ['history', 'VsanUpgradeSystemUpgradeHistoryItem', 1, 0],
   ['aborted', 'boolean', undef, 0],
   ['completed', 'boolean', undef, 0],
   ['progress', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanUpgradeSystemUpgradeStatus', 'inProgress', 'history', 'aborted', 'completed', 'progress');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package Action;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('Action');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MethodActionArgument;
our @ISA = qw(DynamicData);

our @property_list = (
   ['value', 'anyType', undef, 0],
);


VIMRuntime::make_get_set('MethodActionArgument', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfMethodActionArgument;
our @ISA = qw(ComplexType);

our @property_list = (
   ['MethodActionArgument', 'MethodActionArgument', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfMethodActionArgument', 'MethodActionArgument');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MethodAction;
our @ISA = qw(Action);

our @property_list = (
   ['name', undef, undef, 1],
   ['argument', 'MethodActionArgument', 1, 0],
);


VIMRuntime::make_get_set('MethodAction', 'name', 'argument');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SendEmailAction;
our @ISA = qw(Action);

our @property_list = (
   ['toList', undef, undef, 1],
   ['ccList', undef, undef, 1],
   ['subject', undef, undef, 1],
   ['body', undef, undef, 1],
);


VIMRuntime::make_get_set('SendEmailAction', 'toList', 'ccList', 'subject', 'body');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SendSNMPAction;
our @ISA = qw(Action);

our @property_list = (
);


VIMRuntime::make_get_set('SendSNMPAction');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package RunScriptAction;
our @ISA = qw(Action);

our @property_list = (
   ['script', undef, undef, 1],
);


VIMRuntime::make_get_set('RunScriptAction', 'script');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CreateTaskAction;
our @ISA = qw(Action);

our @property_list = (
   ['taskTypeId', undef, undef, 1],
   ['cancelable', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('CreateTaskAction', 'taskTypeId', 'cancelable');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmAction;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('AlarmAction');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfAlarmAction;
our @ISA = qw(ComplexType);

our @property_list = (
   ['AlarmAction', 'AlarmAction', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfAlarmAction', 'AlarmAction');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmTriggeringAction;
our @ISA = qw(AlarmAction);

our @property_list = (
   ['action', 'Action', undef, 1],
   ['transitionSpecs', 'AlarmTriggeringActionTransitionSpec', 1, 0],
   ['green2yellow', 'boolean', undef, 1],
   ['yellow2red', 'boolean', undef, 1],
   ['red2yellow', 'boolean', undef, 1],
   ['yellow2green', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('AlarmTriggeringAction', 'action', 'transitionSpecs', 'green2yellow', 'yellow2red', 'red2yellow', 'yellow2green');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmTriggeringActionTransitionSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['startState', 'ManagedEntityStatus', undef, 1],
   ['finalState', 'ManagedEntityStatus', undef, 1],
   ['repeats', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('AlarmTriggeringActionTransitionSpec', 'startState', 'finalState', 'repeats');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfAlarmTriggeringActionTransitionSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['AlarmTriggeringActionTransitionSpec', 'AlarmTriggeringActionTransitionSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfAlarmTriggeringActionTransitionSpec', 'AlarmTriggeringActionTransitionSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package GroupAlarmAction;
our @ISA = qw(AlarmAction);

our @property_list = (
   ['action', 'AlarmAction', 1, 1],
);


VIMRuntime::make_get_set('GroupAlarmAction', 'action');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmDescription;
our @ISA = qw(DynamicData);

our @property_list = (
   ['expr', 'TypeDescription', 1, 1],
   ['stateOperator', 'ElementDescription', 1, 1],
   ['metricOperator', 'ElementDescription', 1, 1],
   ['hostSystemConnectionState', 'ElementDescription', 1, 1],
   ['virtualMachinePowerState', 'ElementDescription', 1, 1],
   ['datastoreConnectionState', 'ElementDescription', 1, 1],
   ['hostSystemPowerState', 'ElementDescription', 1, 1],
   ['virtualMachineGuestHeartbeatStatus', 'ElementDescription', 1, 1],
   ['entityStatus', 'ElementDescription', 1, 1],
   ['action', 'TypeDescription', 1, 1],
);


VIMRuntime::make_get_set('AlarmDescription', 'expr', 'stateOperator', 'metricOperator', 'hostSystemConnectionState', 'virtualMachinePowerState', 'datastoreConnectionState', 'hostSystemPowerState', 'virtualMachineGuestHeartbeatStatus', 'entityStatus', 'action');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmExpression;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('AlarmExpression');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfAlarmExpression;
our @ISA = qw(ComplexType);

our @property_list = (
   ['AlarmExpression', 'AlarmExpression', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfAlarmExpression', 'AlarmExpression');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AndAlarmExpression;
our @ISA = qw(AlarmExpression);

our @property_list = (
   ['expression', 'AlarmExpression', 1, 1],
);


VIMRuntime::make_get_set('AndAlarmExpression', 'expression');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OrAlarmExpression;
our @ISA = qw(AlarmExpression);

our @property_list = (
   ['expression', 'AlarmExpression', 1, 1],
);


VIMRuntime::make_get_set('OrAlarmExpression', 'expression');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StateAlarmExpression;
our @ISA = qw(AlarmExpression);

our @property_list = (
   ['operator', 'StateAlarmOperator', undef, 1],
   ['type', undef, undef, 1],
   ['statePath', undef, undef, 1],
   ['yellow', undef, undef, 0],
   ['red', undef, undef, 0],
);


VIMRuntime::make_get_set('StateAlarmExpression', 'operator', 'type', 'statePath', 'yellow', 'red');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MetricAlarmExpression;
our @ISA = qw(AlarmExpression);

our @property_list = (
   ['operator', 'MetricAlarmOperator', undef, 1],
   ['type', undef, undef, 1],
   ['metric', 'PerfMetricId', undef, 1],
   ['yellow', undef, undef, 0],
   ['yellowInterval', undef, undef, 0],
   ['red', undef, undef, 0],
   ['redInterval', undef, undef, 0],
);


VIMRuntime::make_get_set('MetricAlarmExpression', 'operator', 'type', 'metric', 'yellow', 'yellowInterval', 'red', 'redInterval');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmFilterSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['status', 'ManagedEntityStatus', 1, 0],
   ['typeEntity', undef, undef, 0],
   ['typeTrigger', undef, undef, 0],
);


VIMRuntime::make_get_set('AlarmFilterSpec', 'status', 'typeEntity', 'typeTrigger');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmInfo;
our @ISA = qw(AlarmSpec);

our @property_list = (
   ['key', undef, undef, 1],
   ['alarm', 'ManagedObjectReference', undef, 1],
   ['entity', 'ManagedObjectReference', undef, 1],
   ['lastModifiedTime', undef, undef, 1],
   ['lastModifiedUser', undef, undef, 1],
   ['creationEventId', undef, undef, 1],
);


VIMRuntime::make_get_set('AlarmInfo', 'key', 'alarm', 'entity', 'lastModifiedTime', 'lastModifiedUser', 'creationEventId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmSetting;
our @ISA = qw(DynamicData);

our @property_list = (
   ['toleranceRange', undef, undef, 1],
   ['reportingFrequency', undef, undef, 1],
);


VIMRuntime::make_get_set('AlarmSetting', 'toleranceRange', 'reportingFrequency');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['systemName', undef, undef, 0],
   ['description', undef, undef, 1],
   ['enabled', 'boolean', undef, 1],
   ['expression', 'AlarmExpression', undef, 1],
   ['action', 'AlarmAction', undef, 0],
   ['actionFrequency', undef, undef, 0],
   ['setting', 'AlarmSetting', undef, 0],
);


VIMRuntime::make_get_set('AlarmSpec', 'name', 'systemName', 'description', 'enabled', 'expression', 'action', 'actionFrequency', 'setting');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmState;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['entity', 'ManagedObjectReference', undef, 1],
   ['alarm', 'ManagedObjectReference', undef, 1],
   ['overallStatus', 'ManagedEntityStatus', undef, 1],
   ['time', undef, undef, 1],
   ['acknowledged', 'boolean', undef, 0],
   ['acknowledgedByUser', undef, undef, 0],
   ['acknowledgedTime', undef, undef, 0],
   ['eventKey', undef, undef, 0],
   ['disabled', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('AlarmState', 'key', 'entity', 'alarm', 'overallStatus', 'time', 'acknowledged', 'acknowledgedByUser', 'acknowledgedTime', 'eventKey', 'disabled');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfAlarmState;
our @ISA = qw(ComplexType);

our @property_list = (
   ['AlarmState', 'AlarmState', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfAlarmState', 'AlarmState');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EventAlarmExpression;
our @ISA = qw(AlarmExpression);

our @property_list = (
   ['comparisons', 'EventAlarmExpressionComparison', 1, 0],
   ['eventType', undef, undef, 1],
   ['eventTypeId', undef, undef, 0],
   ['objectType', undef, undef, 0],
   ['status', 'ManagedEntityStatus', undef, 0],
);


VIMRuntime::make_get_set('EventAlarmExpression', 'comparisons', 'eventType', 'eventTypeId', 'objectType', 'status');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EventAlarmExpressionComparison;
our @ISA = qw(DynamicData);

our @property_list = (
   ['attributeName', undef, undef, 1],
   ['operator', undef, undef, 1],
   ['value', undef, undef, 1],
);


VIMRuntime::make_get_set('EventAlarmExpressionComparison', 'attributeName', 'operator', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfEventAlarmExpressionComparison;
our @ISA = qw(ComplexType);

our @property_list = (
   ['EventAlarmExpressionComparison', 'EventAlarmExpressionComparison', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfEventAlarmExpressionComparison', 'EventAlarmExpressionComparison');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterAction;
our @ISA = qw(DynamicData);

our @property_list = (
   ['type', undef, undef, 1],
   ['target', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('ClusterAction', 'type', 'target');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterAction;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterAction', 'ClusterAction', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterAction', 'ClusterAction');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterActionHistory;
our @ISA = qw(DynamicData);

our @property_list = (
   ['action', 'ClusterAction', undef, 1],
   ['time', undef, undef, 1],
);


VIMRuntime::make_get_set('ClusterActionHistory', 'action', 'time');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterActionHistory;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterActionHistory', 'ClusterActionHistory', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterActionHistory', 'ClusterActionHistory');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterAffinityRuleSpec;
our @ISA = qw(ClusterRuleInfo);

our @property_list = (
   ['vm', 'ManagedObjectReference', 1, 1],
);


VIMRuntime::make_get_set('ClusterAffinityRuleSpec', 'vm');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterAntiAffinityRuleSpec;
our @ISA = qw(ClusterRuleInfo);

our @property_list = (
   ['vm', 'ManagedObjectReference', 1, 1],
);


VIMRuntime::make_get_set('ClusterAntiAffinityRuleSpec', 'vm');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterAttemptedVmInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vm', 'ManagedObjectReference', undef, 1],
   ['task', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('ClusterAttemptedVmInfo', 'vm', 'task');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterAttemptedVmInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterAttemptedVmInfo', 'ClusterAttemptedVmInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterAttemptedVmInfo', 'ClusterAttemptedVmInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterClusterInitialPlacementAction;
our @ISA = qw(ClusterAction);

our @property_list = (
   ['targetHost', 'ManagedObjectReference', undef, 0],
   ['pool', 'ManagedObjectReference', undef, 1],
   ['configSpec', 'VirtualMachineConfigSpec', undef, 0],
);


VIMRuntime::make_get_set('ClusterClusterInitialPlacementAction', 'targetHost', 'pool', 'configSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['dasConfig', 'ClusterDasConfigInfo', undef, 1],
   ['dasVmConfig', 'ClusterDasVmConfigInfo', 1, 0],
   ['drsConfig', 'ClusterDrsConfigInfo', undef, 1],
   ['drsVmConfig', 'ClusterDrsVmConfigInfo', 1, 0],
   ['rule', 'ClusterRuleInfo', 1, 0],
);


VIMRuntime::make_get_set('ClusterConfigInfo', 'dasConfig', 'dasVmConfig', 'drsConfig', 'drsVmConfig', 'rule');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDrsVmConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', 'ManagedObjectReference', undef, 1],
   ['enabled', 'boolean', undef, 0],
   ['behavior', 'DrsBehavior', undef, 0],
);


VIMRuntime::make_get_set('ClusterDrsVmConfigInfo', 'key', 'enabled', 'behavior');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterDrsVmConfigInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterDrsVmConfigInfo', 'ClusterDrsVmConfigInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterDrsVmConfigInfo', 'ClusterDrsVmConfigInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterConfigInfoEx;
our @ISA = qw(ComputeResourceConfigInfo);

our @property_list = (
   ['systemVMsConfig', 'ClusterSystemVMsConfigInfo', undef, 0],
   ['dasConfig', 'ClusterDasConfigInfo', undef, 1],
   ['dasVmConfig', 'ClusterDasVmConfigInfo', 1, 0],
   ['drsConfig', 'ClusterDrsConfigInfo', undef, 1],
   ['drsVmConfig', 'ClusterDrsVmConfigInfo', 1, 0],
   ['rule', 'ClusterRuleInfo', 1, 0],
   ['orchestration', 'ClusterOrchestrationInfo', undef, 0],
   ['vmOrchestration', 'ClusterVmOrchestrationInfo', 1, 0],
   ['dpmConfigInfo', 'ClusterDpmConfigInfo', undef, 0],
   ['dpmHostConfig', 'ClusterDpmHostConfigInfo', 1, 0],
   ['vsanConfigInfo', 'VsanClusterConfigInfo', undef, 0],
   ['vsanHostConfig', 'VsanHostConfigInfo', 1, 0],
   ['group', 'ClusterGroupInfo', 1, 0],
   ['infraUpdateHaConfig', 'ClusterInfraUpdateHaConfigInfo', undef, 0],
   ['proactiveDrsConfig', 'ClusterProactiveDrsConfigInfo', undef, 0],
   ['cryptoConfig', 'ClusterCryptoConfigInfo', undef, 0],
);


VIMRuntime::make_get_set('ClusterConfigInfoEx', 'systemVMsConfig', 'dasConfig', 'dasVmConfig', 'drsConfig', 'drsVmConfig', 'rule', 'orchestration', 'vmOrchestration', 'dpmConfigInfo', 'dpmHostConfig', 'vsanConfigInfo', 'vsanHostConfig', 'group', 'infraUpdateHaConfig', 'proactiveDrsConfig', 'cryptoConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDpmConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['enabled', 'boolean', undef, 0],
   ['defaultDpmBehavior', 'DpmBehavior', undef, 0],
   ['hostPowerActionRate', undef, undef, 0],
   ['option', 'OptionValue', 1, 0],
);


VIMRuntime::make_get_set('ClusterDpmConfigInfo', 'enabled', 'defaultDpmBehavior', 'hostPowerActionRate', 'option');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDpmHostConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', 'ManagedObjectReference', undef, 1],
   ['enabled', 'boolean', undef, 0],
   ['behavior', 'DpmBehavior', undef, 0],
);


VIMRuntime::make_get_set('ClusterDpmHostConfigInfo', 'key', 'enabled', 'behavior');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterDpmHostConfigInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterDpmHostConfigInfo', 'ClusterDpmHostConfigInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterDpmHostConfigInfo', 'ClusterDpmHostConfigInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterProactiveDrsConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['enabled', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('ClusterProactiveDrsConfigInfo', 'enabled');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['dasConfig', 'ClusterDasConfigInfo', undef, 0],
   ['dasVmConfigSpec', 'ClusterDasVmConfigSpec', 1, 0],
   ['drsConfig', 'ClusterDrsConfigInfo', undef, 0],
   ['drsVmConfigSpec', 'ClusterDrsVmConfigSpec', 1, 0],
   ['rulesSpec', 'ClusterRuleSpec', 1, 0],
);


VIMRuntime::make_get_set('ClusterConfigSpec', 'dasConfig', 'dasVmConfigSpec', 'drsConfig', 'drsVmConfigSpec', 'rulesSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasVmConfigSpec;
our @ISA = qw(ArrayUpdateSpec);

our @property_list = (
   ['info', 'ClusterDasVmConfigInfo', undef, 0],
);


VIMRuntime::make_get_set('ClusterDasVmConfigSpec', 'info');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterDasVmConfigSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterDasVmConfigSpec', 'ClusterDasVmConfigSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterDasVmConfigSpec', 'ClusterDasVmConfigSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDrsVmConfigSpec;
our @ISA = qw(ArrayUpdateSpec);

our @property_list = (
   ['info', 'ClusterDrsVmConfigInfo', undef, 0],
);


VIMRuntime::make_get_set('ClusterDrsVmConfigSpec', 'info');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterDrsVmConfigSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterDrsVmConfigSpec', 'ClusterDrsVmConfigSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterDrsVmConfigSpec', 'ClusterDrsVmConfigSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterConfigSpecEx;
our @ISA = qw(ComputeResourceConfigSpec);

our @property_list = (
   ['systemVMsConfig', 'ClusterSystemVMsConfigSpec', undef, 0],
   ['dasConfig', 'ClusterDasConfigInfo', undef, 0],
   ['dasVmConfigSpec', 'ClusterDasVmConfigSpec', 1, 0],
   ['drsConfig', 'ClusterDrsConfigInfo', undef, 0],
   ['drsVmConfigSpec', 'ClusterDrsVmConfigSpec', 1, 0],
   ['rulesSpec', 'ClusterRuleSpec', 1, 0],
   ['orchestration', 'ClusterOrchestrationInfo', undef, 0],
   ['vmOrchestrationSpec', 'ClusterVmOrchestrationSpec', 1, 0],
   ['dpmConfig', 'ClusterDpmConfigInfo', undef, 0],
   ['dpmHostConfigSpec', 'ClusterDpmHostConfigSpec', 1, 0],
   ['vsanConfig', 'VsanClusterConfigInfo', undef, 0],
   ['vsanHostConfigSpec', 'VsanHostConfigInfo', 1, 0],
   ['groupSpec', 'ClusterGroupSpec', 1, 0],
   ['infraUpdateHaConfig', 'ClusterInfraUpdateHaConfigInfo', undef, 0],
   ['proactiveDrsConfig', 'ClusterProactiveDrsConfigInfo', undef, 0],
   ['inHciWorkflow', 'boolean', undef, 0],
   ['cryptoConfig', 'ClusterCryptoConfigInfo', undef, 0],
);


VIMRuntime::make_get_set('ClusterConfigSpecEx', 'systemVMsConfig', 'dasConfig', 'dasVmConfigSpec', 'drsConfig', 'drsVmConfigSpec', 'rulesSpec', 'orchestration', 'vmOrchestrationSpec', 'dpmConfig', 'dpmHostConfigSpec', 'vsanConfig', 'vsanHostConfigSpec', 'groupSpec', 'infraUpdateHaConfig', 'proactiveDrsConfig', 'inHciWorkflow', 'cryptoConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDpmHostConfigSpec;
our @ISA = qw(ArrayUpdateSpec);

our @property_list = (
   ['info', 'ClusterDpmHostConfigInfo', undef, 0],
);


VIMRuntime::make_get_set('ClusterDpmHostConfigSpec', 'info');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterDpmHostConfigSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterDpmHostConfigSpec', 'ClusterDpmHostConfigSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterDpmHostConfigSpec', 'ClusterDpmHostConfigSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterGroupSpec;
our @ISA = qw(ArrayUpdateSpec);

our @property_list = (
   ['info', 'ClusterGroupInfo', undef, 0],
);


VIMRuntime::make_get_set('ClusterGroupSpec', 'info');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterGroupSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterGroupSpec', 'ClusterGroupSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterGroupSpec', 'ClusterGroupSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterVmOrchestrationSpec;
our @ISA = qw(ArrayUpdateSpec);

our @property_list = (
   ['info', 'ClusterVmOrchestrationInfo', undef, 0],
);


VIMRuntime::make_get_set('ClusterVmOrchestrationSpec', 'info');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterVmOrchestrationSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterVmOrchestrationSpec', 'ClusterVmOrchestrationSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterVmOrchestrationSpec', 'ClusterVmOrchestrationSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterCryptoConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['cryptoMode', undef, undef, 0],
);


VIMRuntime::make_get_set('ClusterCryptoConfigInfo', 'cryptoMode');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasAamHostInfo;
our @ISA = qw(ClusterDasHostInfo);

our @property_list = (
   ['hostDasState', 'ClusterDasAamNodeState', 1, 0],
   ['primaryHosts', undef, 1, 0],
);


VIMRuntime::make_get_set('ClusterDasAamHostInfo', 'hostDasState', 'primaryHosts');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasAamNodeState;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['name', undef, undef, 1],
   ['configState', undef, undef, 1],
   ['runtimeState', undef, undef, 1],
);


VIMRuntime::make_get_set('ClusterDasAamNodeState', 'host', 'name', 'configState', 'runtimeState');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterDasAamNodeState;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterDasAamNodeState', 'ClusterDasAamNodeState', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterDasAamNodeState', 'ClusterDasAamNodeState');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasAdmissionControlInfo;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('ClusterDasAdmissionControlInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasAdmissionControlPolicy;
our @ISA = qw(DynamicData);

our @property_list = (
   ['resourceReductionToToleratePercent', undef, undef, 0],
   ['pMemAdmissionControlEnabled', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('ClusterDasAdmissionControlPolicy', 'resourceReductionToToleratePercent', 'pMemAdmissionControlEnabled');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasAdvancedRuntimeInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['dasHostInfo', 'ClusterDasHostInfo', undef, 0],
   ['vmcpSupported', 'ClusterDasAdvancedRuntimeInfoVmcpCapabilityInfo', undef, 0],
   ['heartbeatDatastoreInfo', 'DasHeartbeatDatastoreInfo', 1, 0],
);


VIMRuntime::make_get_set('ClusterDasAdvancedRuntimeInfo', 'dasHostInfo', 'vmcpSupported', 'heartbeatDatastoreInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasAdvancedRuntimeInfoVmcpCapabilityInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['storageAPDSupported', 'boolean', undef, 1],
   ['storagePDLSupported', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('ClusterDasAdvancedRuntimeInfoVmcpCapabilityInfo', 'storageAPDSupported', 'storagePDLSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DasHeartbeatDatastoreInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['datastore', 'ManagedObjectReference', undef, 1],
   ['hosts', 'ManagedObjectReference', 1, 1],
);


VIMRuntime::make_get_set('DasHeartbeatDatastoreInfo', 'datastore', 'hosts');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDasHeartbeatDatastoreInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DasHeartbeatDatastoreInfo', 'DasHeartbeatDatastoreInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDasHeartbeatDatastoreInfo', 'DasHeartbeatDatastoreInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['enabled', 'boolean', undef, 0],
   ['vmMonitoring', undef, undef, 0],
   ['hostMonitoring', undef, undef, 0],
   ['vmComponentProtecting', undef, undef, 0],
   ['failoverLevel', undef, undef, 0],
   ['admissionControlPolicy', 'ClusterDasAdmissionControlPolicy', undef, 0],
   ['admissionControlEnabled', 'boolean', undef, 0],
   ['defaultVmSettings', 'ClusterDasVmSettings', undef, 0],
   ['option', 'OptionValue', 1, 0],
   ['heartbeatDatastore', 'ManagedObjectReference', 1, 0],
   ['hBDatastoreCandidatePolicy', undef, undef, 0],
);


VIMRuntime::make_get_set('ClusterDasConfigInfo', 'enabled', 'vmMonitoring', 'hostMonitoring', 'vmComponentProtecting', 'failoverLevel', 'admissionControlPolicy', 'admissionControlEnabled', 'defaultVmSettings', 'option', 'heartbeatDatastore', 'hBDatastoreCandidatePolicy');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasData;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('ClusterDasData');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasDataSummary;
our @ISA = qw(ClusterDasData);

our @property_list = (
   ['hostListVersion', undef, undef, 1],
   ['clusterConfigVersion', undef, undef, 1],
   ['compatListVersion', undef, undef, 1],
);


VIMRuntime::make_get_set('ClusterDasDataSummary', 'hostListVersion', 'clusterConfigVersion', 'compatListVersion');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasFailoverLevelAdvancedRuntimeInfo;
our @ISA = qw(ClusterDasAdvancedRuntimeInfo);

our @property_list = (
   ['slotInfo', 'ClusterDasFailoverLevelAdvancedRuntimeInfoSlotInfo', undef, 1],
   ['totalSlots', undef, undef, 1],
   ['usedSlots', undef, undef, 1],
   ['unreservedSlots', undef, undef, 1],
   ['totalVms', undef, undef, 1],
   ['totalHosts', undef, undef, 1],
   ['totalGoodHosts', undef, undef, 1],
   ['hostSlots', 'ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots', 1, 0],
   ['vmsRequiringMultipleSlots', 'ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots', 1, 0],
);


VIMRuntime::make_get_set('ClusterDasFailoverLevelAdvancedRuntimeInfo', 'slotInfo', 'totalSlots', 'usedSlots', 'unreservedSlots', 'totalVms', 'totalHosts', 'totalGoodHosts', 'hostSlots', 'vmsRequiringMultipleSlots');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasFailoverLevelAdvancedRuntimeInfoSlotInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['numVcpus', undef, undef, 1],
   ['cpuMHz', undef, undef, 1],
   ['memoryMB', undef, undef, 1],
);


VIMRuntime::make_get_set('ClusterDasFailoverLevelAdvancedRuntimeInfoSlotInfo', 'numVcpus', 'cpuMHz', 'memoryMB');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['slots', undef, undef, 1],
);


VIMRuntime::make_get_set('ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots', 'host', 'slots');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots', 'ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots', 'ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vm', 'ManagedObjectReference', undef, 1],
   ['slots', undef, undef, 1],
);


VIMRuntime::make_get_set('ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots', 'vm', 'slots');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots', 'ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots', 'ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasFdmHostState;
our @ISA = qw(DynamicData);

our @property_list = (
   ['state', undef, undef, 1],
   ['stateReporter', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('ClusterDasFdmHostState', 'state', 'stateReporter');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasHostInfo;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('ClusterDasHostInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasHostRecommendation;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['drsRating', undef, undef, 0],
);


VIMRuntime::make_get_set('ClusterDasHostRecommendation', 'host', 'drsRating');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasVmConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', 'ManagedObjectReference', undef, 1],
   ['restartPriority', 'DasVmPriority', undef, 0],
   ['powerOffOnIsolation', 'boolean', undef, 0],
   ['dasSettings', 'ClusterDasVmSettings', undef, 0],
);


VIMRuntime::make_get_set('ClusterDasVmConfigInfo', 'key', 'restartPriority', 'powerOffOnIsolation', 'dasSettings');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterDasVmConfigInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterDasVmConfigInfo', 'ClusterDasVmConfigInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterDasVmConfigInfo', 'ClusterDasVmConfigInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasVmSettings;
our @ISA = qw(DynamicData);

our @property_list = (
   ['restartPriority', undef, undef, 0],
   ['restartPriorityTimeout', undef, undef, 0],
   ['isolationResponse', undef, undef, 0],
   ['vmToolsMonitoringSettings', 'ClusterVmToolsMonitoringSettings', undef, 0],
   ['vmComponentProtectionSettings', 'ClusterVmComponentProtectionSettings', undef, 0],
);


VIMRuntime::make_get_set('ClusterDasVmSettings', 'restartPriority', 'restartPriorityTimeout', 'isolationResponse', 'vmToolsMonitoringSettings', 'vmComponentProtectionSettings');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDependencyRuleInfo;
our @ISA = qw(ClusterRuleInfo);

our @property_list = (
   ['vmGroup', undef, undef, 1],
   ['dependsOnVmGroup', undef, undef, 1],
);


VIMRuntime::make_get_set('ClusterDependencyRuleInfo', 'vmGroup', 'dependsOnVmGroup');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDrsConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['enabled', 'boolean', undef, 0],
   ['enableVmBehaviorOverrides', 'boolean', undef, 0],
   ['defaultVmBehavior', 'DrsBehavior', undef, 0],
   ['vmotionRate', undef, undef, 0],
   ['scaleDescendantsShares', undef, undef, 0],
   ['option', 'OptionValue', 1, 0],
);


VIMRuntime::make_get_set('ClusterDrsConfigInfo', 'enabled', 'enableVmBehaviorOverrides', 'defaultVmBehavior', 'vmotionRate', 'scaleDescendantsShares', 'option');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDrsFaults;
our @ISA = qw(DynamicData);

our @property_list = (
   ['reason', undef, undef, 1],
   ['faultsByVm', 'ClusterDrsFaultsFaultsByVm', 1, 1],
);


VIMRuntime::make_get_set('ClusterDrsFaults', 'reason', 'faultsByVm');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterDrsFaults;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterDrsFaults', 'ClusterDrsFaults', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterDrsFaults', 'ClusterDrsFaults');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDrsFaultsFaultsByVm;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vm', 'ManagedObjectReference', undef, 0],
   ['fault', 'LocalizedMethodFault', 1, 1],
);


VIMRuntime::make_get_set('ClusterDrsFaultsFaultsByVm', 'vm', 'fault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterDrsFaultsFaultsByVm;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterDrsFaultsFaultsByVm', 'ClusterDrsFaultsFaultsByVm', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterDrsFaultsFaultsByVm', 'ClusterDrsFaultsFaultsByVm');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDrsFaultsFaultsByVirtualDisk;
our @ISA = qw(ClusterDrsFaultsFaultsByVm);

our @property_list = (
   ['disk', 'VirtualDiskId', undef, 0],
);


VIMRuntime::make_get_set('ClusterDrsFaultsFaultsByVirtualDisk', 'disk');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDrsMigration;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['time', undef, undef, 1],
   ['vm', 'ManagedObjectReference', undef, 1],
   ['cpuLoad', undef, undef, 0],
   ['memoryLoad', undef, undef, 0],
   ['source', 'ManagedObjectReference', undef, 1],
   ['sourceCpuLoad', undef, undef, 0],
   ['sourceMemoryLoad', undef, undef, 0],
   ['destination', 'ManagedObjectReference', undef, 1],
   ['destinationCpuLoad', undef, undef, 0],
   ['destinationMemoryLoad', undef, undef, 0],
);


VIMRuntime::make_get_set('ClusterDrsMigration', 'key', 'time', 'vm', 'cpuLoad', 'memoryLoad', 'source', 'sourceCpuLoad', 'sourceMemoryLoad', 'destination', 'destinationCpuLoad', 'destinationMemoryLoad');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterDrsMigration;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterDrsMigration', 'ClusterDrsMigration', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterDrsMigration', 'ClusterDrsMigration');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDrsRecommendation;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['rating', undef, undef, 1],
   ['reason', undef, undef, 1],
   ['reasonText', undef, undef, 1],
   ['migrationList', 'ClusterDrsMigration', 1, 1],
);


VIMRuntime::make_get_set('ClusterDrsRecommendation', 'key', 'rating', 'reason', 'reasonText', 'migrationList');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterDrsRecommendation;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterDrsRecommendation', 'ClusterDrsRecommendation', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterDrsRecommendation', 'ClusterDrsRecommendation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterEVCManagerEVCState;
our @ISA = qw(DynamicData);

our @property_list = (
   ['supportedEVCMode', 'EVCMode', 1, 1],
   ['currentEVCModeKey', undef, undef, 0],
   ['guaranteedCPUFeatures', 'HostCpuIdInfo', 1, 0],
   ['featureCapability', 'HostFeatureCapability', 1, 0],
   ['featureMask', 'HostFeatureMask', 1, 0],
   ['featureRequirement', 'VirtualMachineFeatureRequirement', 1, 0],
);


VIMRuntime::make_get_set('ClusterEVCManagerEVCState', 'supportedEVCMode', 'currentEVCModeKey', 'guaranteedCPUFeatures', 'featureCapability', 'featureMask', 'featureRequirement');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterEVCManagerCheckResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['evcModeKey', undef, undef, 1],
   ['error', 'LocalizedMethodFault', undef, 1],
   ['host', 'ManagedObjectReference', 1, 0],
);


VIMRuntime::make_get_set('ClusterEVCManagerCheckResult', 'evcModeKey', 'error', 'host');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterEVCManagerCheckResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterEVCManagerCheckResult', 'ClusterEVCManagerCheckResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterEVCManagerCheckResult', 'ClusterEVCManagerCheckResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterEnterMaintenanceResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['recommendations', 'ClusterRecommendation', 1, 0],
   ['fault', 'ClusterDrsFaults', undef, 0],
);


VIMRuntime::make_get_set('ClusterEnterMaintenanceResult', 'recommendations', 'fault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterFailoverHostAdmissionControlInfo;
our @ISA = qw(ClusterDasAdmissionControlInfo);

our @property_list = (
   ['hostStatus', 'ClusterFailoverHostAdmissionControlInfoHostStatus', 1, 0],
);


VIMRuntime::make_get_set('ClusterFailoverHostAdmissionControlInfo', 'hostStatus');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterFailoverHostAdmissionControlInfoHostStatus;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['status', 'ManagedEntityStatus', undef, 1],
);


VIMRuntime::make_get_set('ClusterFailoverHostAdmissionControlInfoHostStatus', 'host', 'status');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterFailoverHostAdmissionControlInfoHostStatus;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterFailoverHostAdmissionControlInfoHostStatus', 'ClusterFailoverHostAdmissionControlInfoHostStatus', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterFailoverHostAdmissionControlInfoHostStatus', 'ClusterFailoverHostAdmissionControlInfoHostStatus');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterFailoverHostAdmissionControlPolicy;
our @ISA = qw(ClusterDasAdmissionControlPolicy);

our @property_list = (
   ['failoverHosts', 'ManagedObjectReference', 1, 0],
   ['failoverLevel', undef, undef, 0],
);


VIMRuntime::make_get_set('ClusterFailoverHostAdmissionControlPolicy', 'failoverHosts', 'failoverLevel');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterFailoverLevelAdmissionControlInfo;
our @ISA = qw(ClusterDasAdmissionControlInfo);

our @property_list = (
   ['currentFailoverLevel', undef, undef, 1],
);


VIMRuntime::make_get_set('ClusterFailoverLevelAdmissionControlInfo', 'currentFailoverLevel');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterFailoverLevelAdmissionControlPolicy;
our @ISA = qw(ClusterDasAdmissionControlPolicy);

our @property_list = (
   ['failoverLevel', undef, undef, 1],
   ['slotPolicy', 'ClusterSlotPolicy', undef, 0],
);


VIMRuntime::make_get_set('ClusterFailoverLevelAdmissionControlPolicy', 'failoverLevel', 'slotPolicy');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterFailoverResourcesAdmissionControlInfo;
our @ISA = qw(ClusterDasAdmissionControlInfo);

our @property_list = (
   ['currentCpuFailoverResourcesPercent', undef, undef, 1],
   ['currentMemoryFailoverResourcesPercent', undef, undef, 1],
   ['currentPMemFailoverResourcesPercent', undef, undef, 0],
);


VIMRuntime::make_get_set('ClusterFailoverResourcesAdmissionControlInfo', 'currentCpuFailoverResourcesPercent', 'currentMemoryFailoverResourcesPercent', 'currentPMemFailoverResourcesPercent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterFailoverResourcesAdmissionControlPolicy;
our @ISA = qw(ClusterDasAdmissionControlPolicy);

our @property_list = (
   ['cpuFailoverResourcesPercent', undef, undef, 1],
   ['memoryFailoverResourcesPercent', undef, undef, 1],
   ['failoverLevel', undef, undef, 0],
   ['autoComputePercentages', 'boolean', undef, 0],
   ['pMemFailoverResourcesPercent', undef, undef, 0],
   ['autoComputePMemFailoverResourcesPercent', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('ClusterFailoverResourcesAdmissionControlPolicy', 'cpuFailoverResourcesPercent', 'memoryFailoverResourcesPercent', 'failoverLevel', 'autoComputePercentages', 'pMemFailoverResourcesPercent', 'autoComputePMemFailoverResourcesPercent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterGroupInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['userCreated', 'boolean', undef, 0],
   ['uniqueID', undef, undef, 0],
);


VIMRuntime::make_get_set('ClusterGroupInfo', 'name', 'userCreated', 'uniqueID');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterGroupInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterGroupInfo', 'ClusterGroupInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterGroupInfo', 'ClusterGroupInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterHostGroup;
our @ISA = qw(ClusterGroupInfo);

our @property_list = (
   ['host', 'ManagedObjectReference', 1, 0],
);


VIMRuntime::make_get_set('ClusterHostGroup', 'host');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterHostInfraUpdateHaModeAction;
our @ISA = qw(ClusterAction);

our @property_list = (
   ['operationType', undef, undef, 1],
);


VIMRuntime::make_get_set('ClusterHostInfraUpdateHaModeAction', 'operationType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterHostPowerAction;
our @ISA = qw(ClusterAction);

our @property_list = (
   ['operationType', 'HostPowerOperationType', undef, 1],
   ['powerConsumptionWatt', undef, undef, 0],
   ['cpuCapacityMHz', undef, undef, 0],
   ['memCapacityMB', undef, undef, 0],
);


VIMRuntime::make_get_set('ClusterHostPowerAction', 'operationType', 'powerConsumptionWatt', 'cpuCapacityMHz', 'memCapacityMB');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterHostRecommendation;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['rating', undef, undef, 1],
);


VIMRuntime::make_get_set('ClusterHostRecommendation', 'host', 'rating');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterHostRecommendation;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterHostRecommendation', 'ClusterHostRecommendation', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterHostRecommendation', 'ClusterHostRecommendation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterInfraUpdateHaConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['enabled', 'boolean', undef, 0],
   ['behavior', undef, undef, 0],
   ['moderateRemediation', undef, undef, 0],
   ['severeRemediation', undef, undef, 0],
   ['providers', undef, 1, 0],
);


VIMRuntime::make_get_set('ClusterInfraUpdateHaConfigInfo', 'enabled', 'behavior', 'moderateRemediation', 'severeRemediation', 'providers');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterInitialPlacementAction;
our @ISA = qw(ClusterAction);

our @property_list = (
   ['targetHost', 'ManagedObjectReference', undef, 1],
   ['pool', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('ClusterInitialPlacementAction', 'targetHost', 'pool');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterMigrationAction;
our @ISA = qw(ClusterAction);

our @property_list = (
   ['drsMigration', 'ClusterDrsMigration', undef, 0],
);


VIMRuntime::make_get_set('ClusterMigrationAction', 'drsMigration');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterNotAttemptedVmInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vm', 'ManagedObjectReference', undef, 1],
   ['fault', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('ClusterNotAttemptedVmInfo', 'vm', 'fault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterNotAttemptedVmInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterNotAttemptedVmInfo', 'ClusterNotAttemptedVmInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterNotAttemptedVmInfo', 'ClusterNotAttemptedVmInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterOrchestrationInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['defaultVmReadiness', 'ClusterVmReadiness', undef, 0],
);


VIMRuntime::make_get_set('ClusterOrchestrationInfo', 'defaultVmReadiness');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PlacementAction;
our @ISA = qw(ClusterAction);

our @property_list = (
   ['vm', 'ManagedObjectReference', undef, 0],
   ['targetHost', 'ManagedObjectReference', undef, 0],
   ['relocateSpec', 'VirtualMachineRelocateSpec', undef, 0],
);


VIMRuntime::make_get_set('PlacementAction', 'vm', 'targetHost', 'relocateSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PlacementResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['recommendations', 'ClusterRecommendation', 1, 0],
   ['drsFault', 'ClusterDrsFaults', undef, 0],
);


VIMRuntime::make_get_set('PlacementResult', 'recommendations', 'drsFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PlacementSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['priority', 'VirtualMachineMovePriority', undef, 0],
   ['vm', 'ManagedObjectReference', undef, 0],
   ['configSpec', 'VirtualMachineConfigSpec', undef, 0],
   ['relocateSpec', 'VirtualMachineRelocateSpec', undef, 0],
   ['hosts', 'ManagedObjectReference', 1, 0],
   ['datastores', 'ManagedObjectReference', 1, 0],
   ['storagePods', 'ManagedObjectReference', 1, 0],
   ['disallowPrerequisiteMoves', 'boolean', undef, 0],
   ['rules', 'ClusterRuleInfo', 1, 0],
   ['key', undef, undef, 0],
   ['placementType', undef, undef, 0],
   ['cloneSpec', 'VirtualMachineCloneSpec', undef, 0],
   ['cloneName', undef, undef, 0],
);


VIMRuntime::make_get_set('PlacementSpec', 'priority', 'vm', 'configSpec', 'relocateSpec', 'hosts', 'datastores', 'storagePods', 'disallowPrerequisiteMoves', 'rules', 'key', 'placementType', 'cloneSpec', 'cloneName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfPlacementSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['PlacementSpec', 'PlacementSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfPlacementSpec', 'PlacementSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterPowerOnVmResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['attempted', 'ClusterAttemptedVmInfo', 1, 0],
   ['notAttempted', 'ClusterNotAttemptedVmInfo', 1, 0],
   ['recommendations', 'ClusterRecommendation', 1, 0],
);


VIMRuntime::make_get_set('ClusterPowerOnVmResult', 'attempted', 'notAttempted', 'recommendations');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterPreemptibleVmPairInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['id', undef, undef, 0],
   ['monitoredVm', 'ManagedObjectReference', undef, 1],
   ['preemptibleVm', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('ClusterPreemptibleVmPairInfo', 'id', 'monitoredVm', 'preemptibleVm');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterPreemptibleVmPairSpec;
our @ISA = qw(ArrayUpdateSpec);

our @property_list = (
   ['info', 'ClusterPreemptibleVmPairInfo', undef, 0],
);


VIMRuntime::make_get_set('ClusterPreemptibleVmPairSpec', 'info');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterRecommendation;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['type', undef, undef, 1],
   ['time', undef, undef, 1],
   ['rating', undef, undef, 1],
   ['reason', undef, undef, 1],
   ['reasonText', undef, undef, 1],
   ['warningText', undef, undef, 0],
   ['warningDetails', 'LocalizableMessage', undef, 0],
   ['prerequisite', undef, 1, 0],
   ['action', 'ClusterAction', 1, 0],
   ['target', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('ClusterRecommendation', 'key', 'type', 'time', 'rating', 'reason', 'reasonText', 'warningText', 'warningDetails', 'prerequisite', 'action', 'target');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterRecommendation;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterRecommendation', 'ClusterRecommendation', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterRecommendation', 'ClusterRecommendation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterResourceUsageSummary;
our @ISA = qw(DynamicData);

our @property_list = (
   ['cpuUsedMHz', undef, undef, 1],
   ['cpuCapacityMHz', undef, undef, 1],
   ['memUsedMB', undef, undef, 1],
   ['memCapacityMB', undef, undef, 1],
   ['pMemAvailableMB', undef, undef, 0],
   ['pMemCapacityMB', undef, undef, 0],
   ['storageUsedMB', undef, undef, 1],
   ['storageCapacityMB', undef, undef, 1],
);


VIMRuntime::make_get_set('ClusterResourceUsageSummary', 'cpuUsedMHz', 'cpuCapacityMHz', 'memUsedMB', 'memCapacityMB', 'pMemAvailableMB', 'pMemCapacityMB', 'storageUsedMB', 'storageCapacityMB');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterRuleInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 0],
   ['status', 'ManagedEntityStatus', undef, 0],
   ['enabled', 'boolean', undef, 0],
   ['name', undef, undef, 0],
   ['mandatory', 'boolean', undef, 0],
   ['userCreated', 'boolean', undef, 0],
   ['inCompliance', 'boolean', undef, 0],
   ['ruleUuid', undef, undef, 0],
);


VIMRuntime::make_get_set('ClusterRuleInfo', 'key', 'status', 'enabled', 'name', 'mandatory', 'userCreated', 'inCompliance', 'ruleUuid');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterRuleInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterRuleInfo', 'ClusterRuleInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterRuleInfo', 'ClusterRuleInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterRuleSpec;
our @ISA = qw(ArrayUpdateSpec);

our @property_list = (
   ['info', 'ClusterRuleInfo', undef, 0],
);


VIMRuntime::make_get_set('ClusterRuleSpec', 'info');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterRuleSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterRuleSpec', 'ClusterRuleSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterRuleSpec', 'ClusterRuleSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterSlotPolicy;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('ClusterSlotPolicy');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterFixedSizeSlotPolicy;
our @ISA = qw(ClusterSlotPolicy);

our @property_list = (
   ['cpu', undef, undef, 1],
   ['memory', undef, undef, 1],
);


VIMRuntime::make_get_set('ClusterFixedSizeSlotPolicy', 'cpu', 'memory');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterSystemVMsConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['allowedDatastores', 'ManagedObjectReference', 1, 0],
   ['notAllowedDatastores', 'ManagedObjectReference', 1, 0],
   ['dsTagCategoriesToExclude', undef, 1, 0],
);


VIMRuntime::make_get_set('ClusterSystemVMsConfigInfo', 'allowedDatastores', 'notAllowedDatastores', 'dsTagCategoriesToExclude');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterSystemVMsConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['allowedDatastores', 'ClusterDatastoreUpdateSpec', 1, 0],
   ['notAllowedDatastores', 'ClusterDatastoreUpdateSpec', 1, 0],
   ['dsTagCategoriesToExclude', 'ClusterTagCategoryUpdateSpec', 1, 0],
);


VIMRuntime::make_get_set('ClusterSystemVMsConfigSpec', 'allowedDatastores', 'notAllowedDatastores', 'dsTagCategoriesToExclude');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDatastoreUpdateSpec;
our @ISA = qw(ArrayUpdateSpec);

our @property_list = (
   ['datastore', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('ClusterDatastoreUpdateSpec', 'datastore');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterDatastoreUpdateSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterDatastoreUpdateSpec', 'ClusterDatastoreUpdateSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterDatastoreUpdateSpec', 'ClusterDatastoreUpdateSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterTagCategoryUpdateSpec;
our @ISA = qw(ArrayUpdateSpec);

our @property_list = (
   ['category', undef, undef, 0],
);


VIMRuntime::make_get_set('ClusterTagCategoryUpdateSpec', 'category');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterTagCategoryUpdateSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterTagCategoryUpdateSpec', 'ClusterTagCategoryUpdateSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterTagCategoryUpdateSpec', 'ClusterTagCategoryUpdateSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterUsageSummary;
our @ISA = qw(DynamicData);

our @property_list = (
   ['totalCpuCapacityMhz', undef, undef, 1],
   ['totalMemCapacityMB', undef, undef, 1],
   ['cpuReservationMhz', undef, undef, 1],
   ['memReservationMB', undef, undef, 1],
   ['poweredOffCpuReservationMhz', undef, undef, 0],
   ['poweredOffMemReservationMB', undef, undef, 0],
   ['cpuDemandMhz', undef, undef, 1],
   ['memDemandMB', undef, undef, 1],
   ['statsGenNumber', undef, undef, 1],
   ['cpuEntitledMhz', undef, undef, 1],
   ['memEntitledMB', undef, undef, 1],
   ['poweredOffVmCount', undef, undef, 1],
   ['totalVmCount', undef, undef, 1],
);


VIMRuntime::make_get_set('ClusterUsageSummary', 'totalCpuCapacityMhz', 'totalMemCapacityMB', 'cpuReservationMhz', 'memReservationMB', 'poweredOffCpuReservationMhz', 'poweredOffMemReservationMB', 'cpuDemandMhz', 'memDemandMB', 'statsGenNumber', 'cpuEntitledMhz', 'memEntitledMB', 'poweredOffVmCount', 'totalVmCount');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterVmComponentProtectionSettings;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vmStorageProtectionForAPD', undef, undef, 0],
   ['enableAPDTimeoutForHosts', 'boolean', undef, 0],
   ['vmTerminateDelayForAPDSec', undef, undef, 0],
   ['vmReactionOnAPDCleared', undef, undef, 0],
   ['vmStorageProtectionForPDL', undef, undef, 0],
);


VIMRuntime::make_get_set('ClusterVmComponentProtectionSettings', 'vmStorageProtectionForAPD', 'enableAPDTimeoutForHosts', 'vmTerminateDelayForAPDSec', 'vmReactionOnAPDCleared', 'vmStorageProtectionForPDL');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterVmGroup;
our @ISA = qw(ClusterGroupInfo);

our @property_list = (
   ['vm', 'ManagedObjectReference', 1, 0],
);


VIMRuntime::make_get_set('ClusterVmGroup', 'vm');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterVmHostRuleInfo;
our @ISA = qw(ClusterRuleInfo);

our @property_list = (
   ['vmGroupName', undef, undef, 0],
   ['affineHostGroupName', undef, undef, 0],
   ['antiAffineHostGroupName', undef, undef, 0],
);


VIMRuntime::make_get_set('ClusterVmHostRuleInfo', 'vmGroupName', 'affineHostGroupName', 'antiAffineHostGroupName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterVmOrchestrationInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vm', 'ManagedObjectReference', undef, 1],
   ['vmReadiness', 'ClusterVmReadiness', undef, 1],
);


VIMRuntime::make_get_set('ClusterVmOrchestrationInfo', 'vm', 'vmReadiness');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterVmOrchestrationInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterVmOrchestrationInfo', 'ClusterVmOrchestrationInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterVmOrchestrationInfo', 'ClusterVmOrchestrationInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterVmReadiness;
our @ISA = qw(DynamicData);

our @property_list = (
   ['readyCondition', undef, undef, 0],
   ['postReadyDelay', undef, undef, 0],
);


VIMRuntime::make_get_set('ClusterVmReadiness', 'readyCondition', 'postReadyDelay');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterVmToolsMonitoringSettings;
our @ISA = qw(DynamicData);

our @property_list = (
   ['enabled', 'boolean', undef, 0],
   ['vmMonitoring', undef, undef, 0],
   ['clusterSettings', 'boolean', undef, 0],
   ['failureInterval', undef, undef, 0],
   ['minUpTime', undef, undef, 0],
   ['maxFailures', undef, undef, 0],
   ['maxFailureWindow', undef, undef, 0],
);


VIMRuntime::make_get_set('ClusterVmToolsMonitoringSettings', 'enabled', 'vmMonitoring', 'clusterSettings', 'failureInterval', 'minUpTime', 'maxFailures', 'maxFailureWindow');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualPort;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['config', 'DVPortConfigInfo', undef, 1],
   ['dvsUuid', undef, undef, 1],
   ['portgroupKey', undef, undef, 0],
   ['proxyHost', 'ManagedObjectReference', undef, 0],
   ['connectee', 'DistributedVirtualSwitchPortConnectee', undef, 0],
   ['conflict', 'boolean', undef, 1],
   ['conflictPortKey', undef, undef, 0],
   ['state', 'DVPortState', undef, 0],
   ['connectionCookie', undef, undef, 0],
   ['lastStatusChange', undef, undef, 1],
   ['hostLocalPort', 'boolean', undef, 0],
   ['externalId', undef, undef, 0],
   ['segmentPortId', undef, undef, 0],
);


VIMRuntime::make_get_set('DistributedVirtualPort', 'key', 'config', 'dvsUuid', 'portgroupKey', 'proxyHost', 'connectee', 'conflict', 'conflictPortKey', 'state', 'connectionCookie', 'lastStatusChange', 'hostLocalPort', 'externalId', 'segmentPortId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDistributedVirtualPort;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DistributedVirtualPort', 'DistributedVirtualPort', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDistributedVirtualPort', 'DistributedVirtualPort');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVPortConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['operation', undef, undef, 1],
   ['key', undef, undef, 0],
   ['name', undef, undef, 0],
   ['scope', 'ManagedObjectReference', 1, 0],
   ['description', undef, undef, 0],
   ['setting', 'DVPortSetting', undef, 0],
   ['configVersion', undef, undef, 0],
);


VIMRuntime::make_get_set('DVPortConfigSpec', 'operation', 'key', 'name', 'scope', 'description', 'setting', 'configVersion');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDVPortConfigSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DVPortConfigSpec', 'DVPortConfigSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDVPortConfigSpec', 'DVPortConfigSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVPortConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 0],
   ['scope', 'ManagedObjectReference', 1, 0],
   ['description', undef, undef, 0],
   ['setting', 'DVPortSetting', undef, 0],
   ['configVersion', undef, undef, 1],
);


VIMRuntime::make_get_set('DVPortConfigInfo', 'name', 'scope', 'description', 'setting', 'configVersion');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSTrafficShapingPolicy;
our @ISA = qw(InheritablePolicy);

our @property_list = (
   ['enabled', 'BoolPolicy', undef, 0],
   ['averageBandwidth', 'LongPolicy', undef, 0],
   ['peakBandwidth', 'LongPolicy', undef, 0],
   ['burstSize', 'LongPolicy', undef, 0],
);


VIMRuntime::make_get_set('DVSTrafficShapingPolicy', 'enabled', 'averageBandwidth', 'peakBandwidth', 'burstSize');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSHostLocalPortInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['switchUuid', undef, undef, 1],
   ['portKey', undef, undef, 1],
   ['setting', 'DVPortSetting', undef, 1],
   ['vnic', undef, undef, 1],
);


VIMRuntime::make_get_set('DVSHostLocalPortInfo', 'switchUuid', 'portKey', 'setting', 'vnic');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSVendorSpecificConfig;
our @ISA = qw(InheritablePolicy);

our @property_list = (
   ['keyValue', 'DistributedVirtualSwitchKeyedOpaqueBlob', 1, 0],
);


VIMRuntime::make_get_set('DVSVendorSpecificConfig', 'keyValue');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsFilterParameter;
our @ISA = qw(DynamicData);

our @property_list = (
   ['parameters', undef, 1, 0],
);


VIMRuntime::make_get_set('DvsFilterParameter', 'parameters');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsFilterConfig;
our @ISA = qw(InheritablePolicy);

our @property_list = (
   ['key', undef, undef, 0],
   ['agentName', undef, undef, 0],
   ['slotNumber', undef, undef, 0],
   ['parameters', 'DvsFilterParameter', undef, 0],
   ['onFailure', undef, undef, 0],
);


VIMRuntime::make_get_set('DvsFilterConfig', 'key', 'agentName', 'slotNumber', 'parameters', 'onFailure');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDvsFilterConfig;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DvsFilterConfig', 'DvsFilterConfig', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDvsFilterConfig', 'DvsFilterConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsTrafficFilterConfig;
our @ISA = qw(DvsFilterConfig);

our @property_list = (
   ['trafficRuleset', 'DvsTrafficRuleset', undef, 0],
);


VIMRuntime::make_get_set('DvsTrafficFilterConfig', 'trafficRuleset');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsFilterConfigSpec;
our @ISA = qw(DvsFilterConfig);

our @property_list = (
   ['operation', undef, undef, 1],
);


VIMRuntime::make_get_set('DvsFilterConfigSpec', 'operation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsTrafficFilterConfigSpec;
our @ISA = qw(DvsTrafficFilterConfig);

our @property_list = (
   ['operation', undef, undef, 1],
);


VIMRuntime::make_get_set('DvsTrafficFilterConfigSpec', 'operation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsFilterPolicy;
our @ISA = qw(InheritablePolicy);

our @property_list = (
   ['filterConfig', 'DvsFilterConfig', 1, 0],
);


VIMRuntime::make_get_set('DvsFilterPolicy', 'filterConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVPortSetting;
our @ISA = qw(DynamicData);

our @property_list = (
   ['blocked', 'BoolPolicy', undef, 0],
   ['vmDirectPathGen2Allowed', 'BoolPolicy', undef, 0],
   ['inShapingPolicy', 'DVSTrafficShapingPolicy', undef, 0],
   ['outShapingPolicy', 'DVSTrafficShapingPolicy', undef, 0],
   ['vendorSpecificConfig', 'DVSVendorSpecificConfig', undef, 0],
   ['networkResourcePoolKey', 'StringPolicy', undef, 0],
   ['filterPolicy', 'DvsFilterPolicy', undef, 0],
);


VIMRuntime::make_get_set('DVPortSetting', 'blocked', 'vmDirectPathGen2Allowed', 'inShapingPolicy', 'outShapingPolicy', 'vendorSpecificConfig', 'networkResourcePoolKey', 'filterPolicy');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVPortStatus;
our @ISA = qw(DynamicData);

our @property_list = (
   ['linkUp', 'boolean', undef, 1],
   ['blocked', 'boolean', undef, 1],
   ['vlanIds', 'NumericRange', 1, 0],
   ['trunkingMode', 'boolean', undef, 0],
   ['mtu', undef, undef, 0],
   ['linkPeer', undef, undef, 0],
   ['macAddress', undef, undef, 0],
   ['statusDetail', undef, undef, 0],
   ['vmDirectPathGen2Active', 'boolean', undef, 0],
   ['vmDirectPathGen2InactiveReasonNetwork', undef, 1, 0],
   ['vmDirectPathGen2InactiveReasonOther', undef, 1, 0],
   ['vmDirectPathGen2InactiveReasonExtended', undef, undef, 0],
);


VIMRuntime::make_get_set('DVPortStatus', 'linkUp', 'blocked', 'vlanIds', 'trunkingMode', 'mtu', 'linkPeer', 'macAddress', 'statusDetail', 'vmDirectPathGen2Active', 'vmDirectPathGen2InactiveReasonNetwork', 'vmDirectPathGen2InactiveReasonOther', 'vmDirectPathGen2InactiveReasonExtended');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVPortState;
our @ISA = qw(DynamicData);

our @property_list = (
   ['runtimeInfo', 'DVPortStatus', undef, 0],
   ['stats', 'DistributedVirtualSwitchPortStatistics', undef, 1],
   ['vendorSpecificState', 'DistributedVirtualSwitchKeyedOpaqueBlob', 1, 0],
);


VIMRuntime::make_get_set('DVPortState', 'runtimeInfo', 'stats', 'vendorSpecificState');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVPortgroupPolicy;
our @ISA = qw(DynamicData);

our @property_list = (
   ['blockOverrideAllowed', 'boolean', undef, 1],
   ['shapingOverrideAllowed', 'boolean', undef, 1],
   ['vendorConfigOverrideAllowed', 'boolean', undef, 1],
   ['livePortMovingAllowed', 'boolean', undef, 1],
   ['portConfigResetAtDisconnect', 'boolean', undef, 1],
   ['networkResourcePoolOverrideAllowed', 'boolean', undef, 0],
   ['trafficFilterOverrideAllowed', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('DVPortgroupPolicy', 'blockOverrideAllowed', 'shapingOverrideAllowed', 'vendorConfigOverrideAllowed', 'livePortMovingAllowed', 'portConfigResetAtDisconnect', 'networkResourcePoolOverrideAllowed', 'trafficFilterOverrideAllowed');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVPortgroupConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['configVersion', undef, undef, 0],
   ['name', undef, undef, 0],
   ['numPorts', undef, undef, 0],
   ['portNameFormat', undef, undef, 0],
   ['defaultPortConfig', 'DVPortSetting', undef, 0],
   ['description', undef, undef, 0],
   ['type', undef, undef, 0],
   ['backingType', undef, undef, 0],
   ['scope', 'ManagedObjectReference', 1, 0],
   ['policy', 'DVPortgroupPolicy', undef, 0],
   ['vendorSpecificConfig', 'DistributedVirtualSwitchKeyedOpaqueBlob', 1, 0],
   ['autoExpand', 'boolean', undef, 0],
   ['vmVnicNetworkResourcePoolKey', undef, undef, 0],
   ['transportZoneUuid', undef, undef, 0],
   ['transportZoneName', undef, undef, 0],
   ['logicalSwitchUuid', undef, undef, 0],
   ['segmentId', undef, undef, 0],
);


VIMRuntime::make_get_set('DVPortgroupConfigSpec', 'configVersion', 'name', 'numPorts', 'portNameFormat', 'defaultPortConfig', 'description', 'type', 'backingType', 'scope', 'policy', 'vendorSpecificConfig', 'autoExpand', 'vmVnicNetworkResourcePoolKey', 'transportZoneUuid', 'transportZoneName', 'logicalSwitchUuid', 'segmentId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDVPortgroupConfigSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DVPortgroupConfigSpec', 'DVPortgroupConfigSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDVPortgroupConfigSpec', 'DVPortgroupConfigSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVPortgroupConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['name', undef, undef, 1],
   ['numPorts', undef, undef, 1],
   ['distributedVirtualSwitch', 'ManagedObjectReference', undef, 0],
   ['defaultPortConfig', 'DVPortSetting', undef, 0],
   ['description', undef, undef, 0],
   ['type', undef, undef, 1],
   ['backingType', undef, undef, 0],
   ['policy', 'DVPortgroupPolicy', undef, 1],
   ['portNameFormat', undef, undef, 0],
   ['scope', 'ManagedObjectReference', 1, 0],
   ['vendorSpecificConfig', 'DistributedVirtualSwitchKeyedOpaqueBlob', 1, 0],
   ['configVersion', undef, undef, 0],
   ['autoExpand', 'boolean', undef, 0],
   ['vmVnicNetworkResourcePoolKey', undef, undef, 0],
   ['uplink', 'boolean', undef, 0],
   ['transportZoneUuid', undef, undef, 0],
   ['transportZoneName', undef, undef, 0],
   ['logicalSwitchUuid', undef, undef, 0],
   ['segmentId', undef, undef, 0],
);


VIMRuntime::make_get_set('DVPortgroupConfigInfo', 'key', 'name', 'numPorts', 'distributedVirtualSwitch', 'defaultPortConfig', 'description', 'type', 'backingType', 'policy', 'portNameFormat', 'scope', 'vendorSpecificConfig', 'configVersion', 'autoExpand', 'vmVnicNetworkResourcePoolKey', 'uplink', 'transportZoneUuid', 'transportZoneName', 'logicalSwitchUuid', 'segmentId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualPortgroupProblem;
our @ISA = qw(DynamicData);

our @property_list = (
   ['logicalSwitchUuid', undef, undef, 1],
   ['fault', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('DistributedVirtualPortgroupProblem', 'logicalSwitchUuid', 'fault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDistributedVirtualPortgroupProblem;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DistributedVirtualPortgroupProblem', 'DistributedVirtualPortgroupProblem', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDistributedVirtualPortgroupProblem', 'DistributedVirtualPortgroupProblem');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualPortgroupNsxPortgroupOperationResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['portgroups', 'ManagedObjectReference', 1, 0],
   ['problems', 'DistributedVirtualPortgroupProblem', 1, 0],
);


VIMRuntime::make_get_set('DistributedVirtualPortgroupNsxPortgroupOperationResult', 'portgroups', 'problems');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualPortgroupInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['switchName', undef, undef, 1],
   ['switchUuid', undef, undef, 1],
   ['portgroupName', undef, undef, 1],
   ['portgroupKey', undef, undef, 1],
   ['portgroupType', undef, undef, 1],
   ['uplinkPortgroup', 'boolean', undef, 1],
   ['portgroup', 'ManagedObjectReference', undef, 1],
   ['networkReservationSupported', 'boolean', undef, 0],
   ['backingType', undef, undef, 0],
   ['logicalSwitchUuid', undef, undef, 0],
   ['segmentId', undef, undef, 0],
);


VIMRuntime::make_get_set('DistributedVirtualPortgroupInfo', 'switchName', 'switchUuid', 'portgroupName', 'portgroupKey', 'portgroupType', 'uplinkPortgroup', 'portgroup', 'networkReservationSupported', 'backingType', 'logicalSwitchUuid', 'segmentId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDistributedVirtualPortgroupInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DistributedVirtualPortgroupInfo', 'DistributedVirtualPortgroupInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDistributedVirtualPortgroupInfo', 'DistributedVirtualPortgroupInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVPortgroupSelection;
our @ISA = qw(SelectionSet);

our @property_list = (
   ['dvsUuid', undef, undef, 1],
   ['portgroupKey', undef, 1, 1],
);


VIMRuntime::make_get_set('DVPortgroupSelection', 'dvsUuid', 'portgroupKey');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['switchName', undef, undef, 1],
   ['switchUuid', undef, undef, 1],
   ['distributedVirtualSwitch', 'ManagedObjectReference', undef, 1],
   ['networkReservationSupported', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchInfo', 'switchName', 'switchUuid', 'distributedVirtualSwitch', 'networkReservationSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDistributedVirtualSwitchInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DistributedVirtualSwitchInfo', 'DistributedVirtualSwitchInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDistributedVirtualSwitchInfo', 'DistributedVirtualSwitchInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSManagerPhysicalNicsList;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['physicalNics', 'PhysicalNic', 1, 0],
);


VIMRuntime::make_get_set('DVSManagerPhysicalNicsList', 'host', 'physicalNics');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDVSManagerPhysicalNicsList;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DVSManagerPhysicalNicsList', 'DVSManagerPhysicalNicsList', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDVSManagerPhysicalNicsList', 'DVSManagerPhysicalNicsList');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSManagerDvsConfigTarget;
our @ISA = qw(DynamicData);

our @property_list = (
   ['distributedVirtualPortgroup', 'DistributedVirtualPortgroupInfo', 1, 0],
   ['distributedVirtualSwitch', 'DistributedVirtualSwitchInfo', 1, 0],
);


VIMRuntime::make_get_set('DVSManagerDvsConfigTarget', 'distributedVirtualPortgroup', 'distributedVirtualSwitch');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchManagerCompatibilityResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['error', 'LocalizedMethodFault', 1, 0],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchManagerCompatibilityResult', 'host', 'error');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDistributedVirtualSwitchManagerCompatibilityResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DistributedVirtualSwitchManagerCompatibilityResult', 'DistributedVirtualSwitchManagerCompatibilityResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDistributedVirtualSwitchManagerCompatibilityResult', 'DistributedVirtualSwitchManagerCompatibilityResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchManagerHostContainer;
our @ISA = qw(DynamicData);

our @property_list = (
   ['container', 'ManagedObjectReference', undef, 1],
   ['recursive', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchManagerHostContainer', 'container', 'recursive');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchManagerHostDvsFilterSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['inclusive', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchManagerHostDvsFilterSpec', 'inclusive');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDistributedVirtualSwitchManagerHostDvsFilterSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DistributedVirtualSwitchManagerHostDvsFilterSpec', 'DistributedVirtualSwitchManagerHostDvsFilterSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDistributedVirtualSwitchManagerHostDvsFilterSpec', 'DistributedVirtualSwitchManagerHostDvsFilterSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchManagerHostArrayFilter;
our @ISA = qw(DistributedVirtualSwitchManagerHostDvsFilterSpec);

our @property_list = (
   ['host', 'ManagedObjectReference', 1, 1],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchManagerHostArrayFilter', 'host');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchManagerHostContainerFilter;
our @ISA = qw(DistributedVirtualSwitchManagerHostDvsFilterSpec);

our @property_list = (
   ['hostContainer', 'DistributedVirtualSwitchManagerHostContainer', undef, 1],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchManagerHostContainerFilter', 'hostContainer');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchManagerHostDvsMembershipFilter;
our @ISA = qw(DistributedVirtualSwitchManagerHostDvsFilterSpec);

our @property_list = (
   ['distributedVirtualSwitch', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchManagerHostDvsMembershipFilter', 'distributedVirtualSwitch');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchManagerDvsProductSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['newSwitchProductSpec', 'DistributedVirtualSwitchProductSpec', undef, 0],
   ['distributedVirtualSwitch', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchManagerDvsProductSpec', 'newSwitchProductSpec', 'distributedVirtualSwitch');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchManagerImportResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['distributedVirtualSwitch', 'ManagedObjectReference', 1, 0],
   ['distributedVirtualPortgroup', 'ManagedObjectReference', 1, 0],
   ['importFault', 'ImportOperationBulkFaultFaultOnImport', 1, 0],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchManagerImportResult', 'distributedVirtualSwitch', 'distributedVirtualPortgroup', 'importFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSSelection;
our @ISA = qw(SelectionSet);

our @property_list = (
   ['dvsUuid', undef, undef, 1],
);


VIMRuntime::make_get_set('DVSSelection', 'dvsUuid');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EntityBackup;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('EntityBackup');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EntityBackupConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entityType', undef, undef, 1],
   ['configBlob', undef, undef, 1],
   ['key', undef, undef, 0],
   ['name', undef, undef, 0],
   ['container', 'ManagedObjectReference', undef, 0],
   ['configVersion', undef, undef, 0],
);


VIMRuntime::make_get_set('EntityBackupConfig', 'entityType', 'configBlob', 'key', 'name', 'container', 'configVersion');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfEntityBackupConfig;
our @ISA = qw(ComplexType);

our @property_list = (
   ['EntityBackupConfig', 'EntityBackupConfig', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfEntityBackupConfig', 'EntityBackupConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchHostMember;
our @ISA = qw(DynamicData);

our @property_list = (
   ['runtimeState', 'DistributedVirtualSwitchHostMemberRuntimeState', undef, 0],
   ['config', 'DistributedVirtualSwitchHostMemberConfigInfo', undef, 1],
   ['productInfo', 'DistributedVirtualSwitchProductSpec', undef, 0],
   ['uplinkPortKey', undef, 1, 0],
   ['status', undef, undef, 1],
   ['statusDetail', undef, undef, 0],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchHostMember', 'runtimeState', 'config', 'productInfo', 'uplinkPortKey', 'status', 'statusDetail');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDistributedVirtualSwitchHostMember;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DistributedVirtualSwitchHostMember', 'DistributedVirtualSwitchHostMember', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDistributedVirtualSwitchHostMember', 'DistributedVirtualSwitchHostMember');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchHostMemberConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['operation', undef, undef, 1],
   ['host', 'ManagedObjectReference', undef, 1],
   ['backing', 'DistributedVirtualSwitchHostMemberBacking', undef, 0],
   ['maxProxySwitchPorts', undef, undef, 0],
   ['vendorSpecificConfig', 'DistributedVirtualSwitchKeyedOpaqueBlob', 1, 0],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchHostMemberConfigSpec', 'operation', 'host', 'backing', 'maxProxySwitchPorts', 'vendorSpecificConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDistributedVirtualSwitchHostMemberConfigSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DistributedVirtualSwitchHostMemberConfigSpec', 'DistributedVirtualSwitchHostMemberConfigSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDistributedVirtualSwitchHostMemberConfigSpec', 'DistributedVirtualSwitchHostMemberConfigSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchHostMemberPnicSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['pnicDevice', undef, undef, 1],
   ['uplinkPortKey', undef, undef, 0],
   ['uplinkPortgroupKey', undef, undef, 0],
   ['connectionCookie', undef, undef, 0],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchHostMemberPnicSpec', 'pnicDevice', 'uplinkPortKey', 'uplinkPortgroupKey', 'connectionCookie');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDistributedVirtualSwitchHostMemberPnicSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DistributedVirtualSwitchHostMemberPnicSpec', 'DistributedVirtualSwitchHostMemberPnicSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDistributedVirtualSwitchHostMemberPnicSpec', 'DistributedVirtualSwitchHostMemberPnicSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchHostMemberBacking;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('DistributedVirtualSwitchHostMemberBacking');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchHostMemberPnicBacking;
our @ISA = qw(DistributedVirtualSwitchHostMemberBacking);

our @property_list = (
   ['pnicSpec', 'DistributedVirtualSwitchHostMemberPnicSpec', 1, 0],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchHostMemberPnicBacking', 'pnicSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchHostMemberRuntimeState;
our @ISA = qw(DynamicData);

our @property_list = (
   ['currentMaxProxySwitchPorts', undef, undef, 1],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchHostMemberRuntimeState', 'currentMaxProxySwitchPorts');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchHostMemberTransportZoneInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['uuid', undef, undef, 1],
   ['type', undef, undef, 1],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchHostMemberTransportZoneInfo', 'uuid', 'type');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDistributedVirtualSwitchHostMemberTransportZoneInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DistributedVirtualSwitchHostMemberTransportZoneInfo', 'DistributedVirtualSwitchHostMemberTransportZoneInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDistributedVirtualSwitchHostMemberTransportZoneInfo', 'DistributedVirtualSwitchHostMemberTransportZoneInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchHostMemberConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 0],
   ['maxProxySwitchPorts', undef, undef, 1],
   ['vendorSpecificConfig', 'DistributedVirtualSwitchKeyedOpaqueBlob', 1, 0],
   ['backing', 'DistributedVirtualSwitchHostMemberBacking', undef, 1],
   ['nsxSwitch', 'boolean', undef, 0],
   ['ensEnabled', 'boolean', undef, 0],
   ['ensInterruptEnabled', 'boolean', undef, 0],
   ['transportZones', 'DistributedVirtualSwitchHostMemberTransportZoneInfo', 1, 0],
   ['nsxtUsedUplinkNames', undef, 1, 0],
   ['networkOffloadingEnabled', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchHostMemberConfigInfo', 'host', 'maxProxySwitchPorts', 'vendorSpecificConfig', 'backing', 'nsxSwitch', 'ensEnabled', 'ensInterruptEnabled', 'transportZones', 'nsxtUsedUplinkNames', 'networkOffloadingEnabled');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostMemberRuntimeInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['status', undef, undef, 0],
   ['statusDetail', undef, undef, 0],
   ['nsxtStatus', undef, undef, 0],
   ['nsxtStatusDetail', undef, undef, 0],
   ['healthCheckResult', 'HostMemberHealthCheckResult', 1, 0],
);


VIMRuntime::make_get_set('HostMemberRuntimeInfo', 'host', 'status', 'statusDetail', 'nsxtStatus', 'nsxtStatusDetail', 'healthCheckResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHostMemberRuntimeInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HostMemberRuntimeInfo', 'HostMemberRuntimeInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHostMemberRuntimeInfo', 'HostMemberRuntimeInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostMemberHealthCheckResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['summary', undef, undef, 0],
);


VIMRuntime::make_get_set('HostMemberHealthCheckResult', 'summary');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHostMemberHealthCheckResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HostMemberHealthCheckResult', 'HostMemberHealthCheckResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHostMemberHealthCheckResult', 'HostMemberHealthCheckResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostMemberUplinkHealthCheckResult;
our @ISA = qw(HostMemberHealthCheckResult);

our @property_list = (
   ['uplinkPortKey', undef, undef, 1],
);


VIMRuntime::make_get_set('HostMemberUplinkHealthCheckResult', 'uplinkPortKey');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchHostProductSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['productLineId', undef, undef, 0],
   ['version', undef, undef, 0],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchHostProductSpec', 'productLineId', 'version');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDistributedVirtualSwitchHostProductSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DistributedVirtualSwitchHostProductSpec', 'DistributedVirtualSwitchHostProductSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDistributedVirtualSwitchHostProductSpec', 'DistributedVirtualSwitchHostProductSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchKeyedOpaqueBlob;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['opaqueData', undef, undef, 1],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchKeyedOpaqueBlob', 'key', 'opaqueData');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDistributedVirtualSwitchKeyedOpaqueBlob;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DistributedVirtualSwitchKeyedOpaqueBlob', 'DistributedVirtualSwitchKeyedOpaqueBlob', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDistributedVirtualSwitchKeyedOpaqueBlob', 'DistributedVirtualSwitchKeyedOpaqueBlob');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchNetworkOffloadSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['id', undef, undef, 1],
   ['name', undef, undef, 0],
   ['types', undef, 1, 0],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchNetworkOffloadSpec', 'id', 'name', 'types');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDistributedVirtualSwitchNetworkOffloadSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DistributedVirtualSwitchNetworkOffloadSpec', 'DistributedVirtualSwitchNetworkOffloadSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDistributedVirtualSwitchNetworkOffloadSpec', 'DistributedVirtualSwitchNetworkOffloadSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSNetworkResourcePool;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['name', undef, undef, 0],
   ['description', undef, undef, 0],
   ['configVersion', undef, undef, 1],
   ['allocationInfo', 'DVSNetworkResourcePoolAllocationInfo', undef, 1],
);


VIMRuntime::make_get_set('DVSNetworkResourcePool', 'key', 'name', 'description', 'configVersion', 'allocationInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDVSNetworkResourcePool;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DVSNetworkResourcePool', 'DVSNetworkResourcePool', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDVSNetworkResourcePool', 'DVSNetworkResourcePool');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSNetworkResourcePoolAllocationInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['limit', undef, undef, 0],
   ['shares', 'SharesInfo', undef, 0],
   ['priorityTag', undef, undef, 0],
);


VIMRuntime::make_get_set('DVSNetworkResourcePoolAllocationInfo', 'limit', 'shares', 'priorityTag');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSNetworkResourcePoolConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['configVersion', undef, undef, 0],
   ['allocationInfo', 'DVSNetworkResourcePoolAllocationInfo', undef, 0],
   ['name', undef, undef, 0],
   ['description', undef, undef, 0],
);


VIMRuntime::make_get_set('DVSNetworkResourcePoolConfigSpec', 'key', 'configVersion', 'allocationInfo', 'name', 'description');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDVSNetworkResourcePoolConfigSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DVSNetworkResourcePoolConfigSpec', 'DVSNetworkResourcePoolConfigSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDVSNetworkResourcePoolConfigSpec', 'DVSNetworkResourcePoolConfigSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchPortConnectee;
our @ISA = qw(DynamicData);

our @property_list = (
   ['connectedEntity', 'ManagedObjectReference', undef, 0],
   ['nicKey', undef, undef, 0],
   ['type', undef, undef, 0],
   ['addressHint', undef, undef, 0],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchPortConnectee', 'connectedEntity', 'nicKey', 'type', 'addressHint');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchPortConnection;
our @ISA = qw(DynamicData);

our @property_list = (
   ['switchUuid', undef, undef, 1],
   ['portgroupKey', undef, undef, 0],
   ['portKey', undef, undef, 0],
   ['connectionCookie', undef, undef, 0],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchPortConnection', 'switchUuid', 'portgroupKey', 'portKey', 'connectionCookie');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchPortCriteria;
our @ISA = qw(DynamicData);

our @property_list = (
   ['connected', 'boolean', undef, 0],
   ['active', 'boolean', undef, 0],
   ['uplinkPort', 'boolean', undef, 0],
   ['nsxPort', 'boolean', undef, 0],
   ['scope', 'ManagedObjectReference', undef, 0],
   ['portgroupKey', undef, 1, 0],
   ['inside', 'boolean', undef, 0],
   ['portKey', undef, 1, 0],
   ['host', 'ManagedObjectReference', 1, 0],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchPortCriteria', 'connected', 'active', 'uplinkPort', 'nsxPort', 'scope', 'portgroupKey', 'inside', 'portKey', 'host');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchPortStatistics;
our @ISA = qw(DynamicData);

our @property_list = (
   ['packetsInMulticast', undef, undef, 1],
   ['packetsOutMulticast', undef, undef, 1],
   ['bytesInMulticast', undef, undef, 1],
   ['bytesOutMulticast', undef, undef, 1],
   ['packetsInUnicast', undef, undef, 1],
   ['packetsOutUnicast', undef, undef, 1],
   ['bytesInUnicast', undef, undef, 1],
   ['bytesOutUnicast', undef, undef, 1],
   ['packetsInBroadcast', undef, undef, 1],
   ['packetsOutBroadcast', undef, undef, 1],
   ['bytesInBroadcast', undef, undef, 1],
   ['bytesOutBroadcast', undef, undef, 1],
   ['packetsInDropped', undef, undef, 1],
   ['packetsOutDropped', undef, undef, 1],
   ['packetsInException', undef, undef, 1],
   ['packetsOutException', undef, undef, 1],
   ['bytesInFromPnic', undef, undef, 0],
   ['bytesOutToPnic', undef, undef, 0],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchPortStatistics', 'packetsInMulticast', 'packetsOutMulticast', 'bytesInMulticast', 'bytesOutMulticast', 'packetsInUnicast', 'packetsOutUnicast', 'bytesInUnicast', 'bytesOutUnicast', 'packetsInBroadcast', 'packetsOutBroadcast', 'bytesInBroadcast', 'bytesOutBroadcast', 'packetsInDropped', 'packetsOutDropped', 'packetsInException', 'packetsOutException', 'bytesInFromPnic', 'bytesOutToPnic');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchProductSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 0],
   ['vendor', undef, undef, 0],
   ['version', undef, undef, 0],
   ['build', undef, undef, 0],
   ['forwardingClass', undef, undef, 0],
   ['bundleId', undef, undef, 0],
   ['bundleUrl', undef, undef, 0],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchProductSpec', 'name', 'vendor', 'version', 'build', 'forwardingClass', 'bundleId', 'bundleUrl');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDistributedVirtualSwitchProductSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DistributedVirtualSwitchProductSpec', 'DistributedVirtualSwitchProductSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDistributedVirtualSwitchProductSpec', 'DistributedVirtualSwitchProductSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsTrafficRule;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 0],
   ['description', undef, undef, 0],
   ['sequence', undef, undef, 0],
   ['qualifier', 'DvsNetworkRuleQualifier', 1, 0],
   ['action', 'DvsNetworkRuleAction', undef, 0],
   ['direction', undef, undef, 0],
);


VIMRuntime::make_get_set('DvsTrafficRule', 'key', 'description', 'sequence', 'qualifier', 'action', 'direction');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDvsTrafficRule;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DvsTrafficRule', 'DvsTrafficRule', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDvsTrafficRule', 'DvsTrafficRule');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsNetworkRuleQualifier;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 0],
);


VIMRuntime::make_get_set('DvsNetworkRuleQualifier', 'key');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDvsNetworkRuleQualifier;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DvsNetworkRuleQualifier', 'DvsNetworkRuleQualifier', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDvsNetworkRuleQualifier', 'DvsNetworkRuleQualifier');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsNetworkRuleAction;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('DvsNetworkRuleAction');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsIpNetworkRuleQualifier;
our @ISA = qw(DvsNetworkRuleQualifier);

our @property_list = (
   ['sourceAddress', 'IpAddress', undef, 0],
   ['destinationAddress', 'IpAddress', undef, 0],
   ['protocol', 'IntExpression', undef, 0],
   ['sourceIpPort', 'DvsIpPort', undef, 0],
   ['destinationIpPort', 'DvsIpPort', undef, 0],
   ['tcpFlags', 'IntExpression', undef, 0],
);


VIMRuntime::make_get_set('DvsIpNetworkRuleQualifier', 'sourceAddress', 'destinationAddress', 'protocol', 'sourceIpPort', 'destinationIpPort', 'tcpFlags');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsIpPort;
our @ISA = qw(NegatableExpression);

our @property_list = (
);


VIMRuntime::make_get_set('DvsIpPort');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsSingleIpPort;
our @ISA = qw(DvsIpPort);

our @property_list = (
   ['portNumber', undef, undef, 1],
);


VIMRuntime::make_get_set('DvsSingleIpPort', 'portNumber');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsIpPortRange;
our @ISA = qw(DvsIpPort);

our @property_list = (
   ['startPortNumber', undef, undef, 1],
   ['endPortNumber', undef, undef, 1],
);


VIMRuntime::make_get_set('DvsIpPortRange', 'startPortNumber', 'endPortNumber');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsMacNetworkRuleQualifier;
our @ISA = qw(DvsNetworkRuleQualifier);

our @property_list = (
   ['sourceAddress', 'MacAddress', undef, 0],
   ['destinationAddress', 'MacAddress', undef, 0],
   ['protocol', 'IntExpression', undef, 0],
   ['vlanId', 'IntExpression', undef, 0],
);


VIMRuntime::make_get_set('DvsMacNetworkRuleQualifier', 'sourceAddress', 'destinationAddress', 'protocol', 'vlanId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsSystemTrafficNetworkRuleQualifier;
our @ISA = qw(DvsNetworkRuleQualifier);

our @property_list = (
   ['typeOfSystemTraffic', 'StringExpression', undef, 0],
);


VIMRuntime::make_get_set('DvsSystemTrafficNetworkRuleQualifier', 'typeOfSystemTraffic');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsDropNetworkRuleAction;
our @ISA = qw(DvsNetworkRuleAction);

our @property_list = (
);


VIMRuntime::make_get_set('DvsDropNetworkRuleAction');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsAcceptNetworkRuleAction;
our @ISA = qw(DvsNetworkRuleAction);

our @property_list = (
);


VIMRuntime::make_get_set('DvsAcceptNetworkRuleAction');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsUpdateTagNetworkRuleAction;
our @ISA = qw(DvsNetworkRuleAction);

our @property_list = (
   ['qosTag', undef, undef, 0],
   ['dscpTag', undef, undef, 0],
);


VIMRuntime::make_get_set('DvsUpdateTagNetworkRuleAction', 'qosTag', 'dscpTag');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsRateLimitNetworkRuleAction;
our @ISA = qw(DvsNetworkRuleAction);

our @property_list = (
   ['packetsPerSecond', undef, undef, 1],
);


VIMRuntime::make_get_set('DvsRateLimitNetworkRuleAction', 'packetsPerSecond');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsLogNetworkRuleAction;
our @ISA = qw(DvsNetworkRuleAction);

our @property_list = (
);


VIMRuntime::make_get_set('DvsLogNetworkRuleAction');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsGreEncapNetworkRuleAction;
our @ISA = qw(DvsNetworkRuleAction);

our @property_list = (
   ['encapsulationIp', 'SingleIp', undef, 1],
);


VIMRuntime::make_get_set('DvsGreEncapNetworkRuleAction', 'encapsulationIp');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsMacRewriteNetworkRuleAction;
our @ISA = qw(DvsNetworkRuleAction);

our @property_list = (
   ['rewriteMac', undef, undef, 1],
);


VIMRuntime::make_get_set('DvsMacRewriteNetworkRuleAction', 'rewriteMac');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsPuntNetworkRuleAction;
our @ISA = qw(DvsNetworkRuleAction);

our @property_list = (
);


VIMRuntime::make_get_set('DvsPuntNetworkRuleAction');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsCopyNetworkRuleAction;
our @ISA = qw(DvsNetworkRuleAction);

our @property_list = (
);


VIMRuntime::make_get_set('DvsCopyNetworkRuleAction');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsTrafficRuleset;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 0],
   ['enabled', 'boolean', undef, 0],
   ['precedence', undef, undef, 0],
   ['rules', 'DvsTrafficRule', 1, 0],
);


VIMRuntime::make_get_set('DvsTrafficRuleset', 'key', 'enabled', 'precedence', 'rules');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSVmVnicNetworkResourcePool;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['name', undef, undef, 0],
   ['description', undef, undef, 0],
   ['configVersion', undef, undef, 1],
   ['allocationInfo', 'DvsVmVnicResourceAllocation', undef, 0],
);


VIMRuntime::make_get_set('DVSVmVnicNetworkResourcePool', 'key', 'name', 'description', 'configVersion', 'allocationInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDVSVmVnicNetworkResourcePool;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DVSVmVnicNetworkResourcePool', 'DVSVmVnicNetworkResourcePool', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDVSVmVnicNetworkResourcePool', 'DVSVmVnicNetworkResourcePool');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsVmVnicResourceAllocation;
our @ISA = qw(DynamicData);

our @property_list = (
   ['reservationQuota', undef, undef, 0],
);


VIMRuntime::make_get_set('DvsVmVnicResourceAllocation', 'reservationQuota');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsVmVnicResourcePoolConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['operation', undef, undef, 1],
   ['key', undef, undef, 0],
   ['configVersion', undef, undef, 0],
   ['allocationInfo', 'DvsVmVnicResourceAllocation', undef, 0],
   ['name', undef, undef, 0],
   ['description', undef, undef, 0],
);


VIMRuntime::make_get_set('DvsVmVnicResourcePoolConfigSpec', 'operation', 'key', 'configVersion', 'allocationInfo', 'name', 'description');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDvsVmVnicResourcePoolConfigSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DvsVmVnicResourcePoolConfigSpec', 'DvsVmVnicResourcePoolConfigSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDvsVmVnicResourcePoolConfigSpec', 'DvsVmVnicResourcePoolConfigSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsVnicAllocatedResource;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vm', 'ManagedObjectReference', undef, 1],
   ['vnicKey', undef, undef, 1],
   ['reservation', undef, undef, 0],
);


VIMRuntime::make_get_set('DvsVnicAllocatedResource', 'vm', 'vnicKey', 'reservation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDvsVnicAllocatedResource;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DvsVnicAllocatedResource', 'DvsVnicAllocatedResource', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDvsVnicAllocatedResource', 'DvsVnicAllocatedResource');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsVmVnicNetworkResourcePoolRuntimeInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['name', undef, undef, 0],
   ['capacity', undef, undef, 0],
   ['usage', undef, undef, 0],
   ['available', undef, undef, 0],
   ['status', undef, undef, 1],
   ['allocatedResource', 'DvsVnicAllocatedResource', 1, 0],
);


VIMRuntime::make_get_set('DvsVmVnicNetworkResourcePoolRuntimeInfo', 'key', 'name', 'capacity', 'usage', 'available', 'status', 'allocatedResource');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDvsVmVnicNetworkResourcePoolRuntimeInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DvsVmVnicNetworkResourcePoolRuntimeInfo', 'DvsVmVnicNetworkResourcePoolRuntimeInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDvsVmVnicNetworkResourcePoolRuntimeInfo', 'DvsVmVnicNetworkResourcePoolRuntimeInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDVSFeatureCapability;
our @ISA = qw(DVSFeatureCapability);

our @property_list = (
   ['vspanSupported', 'boolean', undef, 0],
   ['lldpSupported', 'boolean', undef, 0],
   ['ipfixSupported', 'boolean', undef, 0],
   ['ipfixCapability', 'VMwareDvsIpfixCapability', undef, 0],
   ['multicastSnoopingSupported', 'boolean', undef, 0],
   ['vspanCapability', 'VMwareDVSVspanCapability', undef, 0],
   ['lacpCapability', 'VMwareDvsLacpCapability', undef, 0],
   ['dpuCapability', 'VMwareDvsDpuCapability', undef, 0],
   ['nsxSupported', 'boolean', undef, 0],
   ['mtuCapability', 'VMwareDvsMtuCapability', undef, 0],
);


VIMRuntime::make_get_set('VMwareDVSFeatureCapability', 'vspanSupported', 'lldpSupported', 'ipfixSupported', 'ipfixCapability', 'multicastSnoopingSupported', 'vspanCapability', 'lacpCapability', 'dpuCapability', 'nsxSupported', 'mtuCapability');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDvsIpfixCapability;
our @ISA = qw(DynamicData);

our @property_list = (
   ['ipfixSupported', 'boolean', undef, 0],
   ['ipv6ForIpfixSupported', 'boolean', undef, 0],
   ['observationDomainIdSupported', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VMwareDvsIpfixCapability', 'ipfixSupported', 'ipv6ForIpfixSupported', 'observationDomainIdSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDvsLacpCapability;
our @ISA = qw(DynamicData);

our @property_list = (
   ['lacpSupported', 'boolean', undef, 0],
   ['multiLacpGroupSupported', 'boolean', undef, 0],
   ['lacpFastModeSupported', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VMwareDvsLacpCapability', 'lacpSupported', 'multiLacpGroupSupported', 'lacpFastModeSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDvsDpuCapability;
our @ISA = qw(DynamicData);

our @property_list = (
   ['networkOffloadSupported', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VMwareDvsDpuCapability', 'networkOffloadSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDVSHealthCheckCapability;
our @ISA = qw(DVSHealthCheckCapability);

our @property_list = (
   ['vlanMtuSupported', 'boolean', undef, 1],
   ['teamingSupported', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('VMwareDVSHealthCheckCapability', 'vlanMtuSupported', 'teamingSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDVSVspanCapability;
our @ISA = qw(DynamicData);

our @property_list = (
   ['mixedDestSupported', 'boolean', undef, 1],
   ['dvportSupported', 'boolean', undef, 1],
   ['remoteSourceSupported', 'boolean', undef, 1],
   ['remoteDestSupported', 'boolean', undef, 1],
   ['encapRemoteSourceSupported', 'boolean', undef, 1],
   ['erspanProtocolSupported', 'boolean', undef, 0],
   ['mirrorNetstackSupported', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VMwareDVSVspanCapability', 'mixedDestSupported', 'dvportSupported', 'remoteSourceSupported', 'remoteDestSupported', 'encapRemoteSourceSupported', 'erspanProtocolSupported', 'mirrorNetstackSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDvsMtuCapability;
our @ISA = qw(DynamicData);

our @property_list = (
   ['minMtuSupported', undef, undef, 1],
   ['maxMtuSupported', undef, undef, 1],
);


VIMRuntime::make_get_set('VMwareDvsMtuCapability', 'minMtuSupported', 'maxMtuSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareVspanPort;
our @ISA = qw(DynamicData);

our @property_list = (
   ['portKey', undef, 1, 0],
   ['uplinkPortName', undef, 1, 0],
   ['wildcardPortConnecteeType', undef, 1, 0],
   ['vlans', undef, 1, 0],
   ['ipAddress', undef, 1, 0],
);


VIMRuntime::make_get_set('VMwareVspanPort', 'portKey', 'uplinkPortName', 'wildcardPortConnecteeType', 'vlans', 'ipAddress');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareVspanSession;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 0],
   ['name', undef, undef, 0],
   ['description', undef, undef, 0],
   ['enabled', 'boolean', undef, 1],
   ['sourcePortTransmitted', 'VMwareVspanPort', undef, 0],
   ['sourcePortReceived', 'VMwareVspanPort', undef, 0],
   ['destinationPort', 'VMwareVspanPort', undef, 0],
   ['encapsulationVlanId', undef, undef, 0],
   ['stripOriginalVlan', 'boolean', undef, 1],
   ['mirroredPacketLength', undef, undef, 0],
   ['normalTrafficAllowed', 'boolean', undef, 1],
   ['sessionType', undef, undef, 0],
   ['samplingRate', undef, undef, 0],
   ['encapType', undef, undef, 0],
   ['erspanId', undef, undef, 0],
   ['erspanCOS', undef, undef, 0],
   ['erspanGraNanosec', 'boolean', undef, 0],
   ['netstack', undef, undef, 0],
);


VIMRuntime::make_get_set('VMwareVspanSession', 'key', 'name', 'description', 'enabled', 'sourcePortTransmitted', 'sourcePortReceived', 'destinationPort', 'encapsulationVlanId', 'stripOriginalVlan', 'mirroredPacketLength', 'normalTrafficAllowed', 'sessionType', 'samplingRate', 'encapType', 'erspanId', 'erspanCOS', 'erspanGraNanosec', 'netstack');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVMwareVspanSession;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VMwareVspanSession', 'VMwareVspanSession', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVMwareVspanSession', 'VMwareVspanSession');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareIpfixConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['collectorIpAddress', undef, undef, 0],
   ['collectorPort', undef, undef, 0],
   ['observationDomainId', undef, undef, 0],
   ['activeFlowTimeout', undef, undef, 1],
   ['idleFlowTimeout', undef, undef, 1],
   ['samplingRate', undef, undef, 1],
   ['internalFlowsOnly', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('VMwareIpfixConfig', 'collectorIpAddress', 'collectorPort', 'observationDomainId', 'activeFlowTimeout', 'idleFlowTimeout', 'samplingRate', 'internalFlowsOnly');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDVSConfigInfo;
our @ISA = qw(DVSConfigInfo);

our @property_list = (
   ['vspanSession', 'VMwareVspanSession', 1, 0],
   ['pvlanConfig', 'VMwareDVSPvlanMapEntry', 1, 0],
   ['maxMtu', undef, undef, 1],
   ['linkDiscoveryProtocolConfig', 'LinkDiscoveryProtocolConfig', undef, 0],
   ['ipfixConfig', 'VMwareIpfixConfig', undef, 0],
   ['lacpGroupConfig', 'VMwareDvsLacpGroupConfig', 1, 0],
   ['lacpApiVersion', undef, undef, 0],
   ['multicastFilteringMode', undef, undef, 0],
   ['networkOffloadSpecId', undef, undef, 0],
);


VIMRuntime::make_get_set('VMwareDVSConfigInfo', 'vspanSession', 'pvlanConfig', 'maxMtu', 'linkDiscoveryProtocolConfig', 'ipfixConfig', 'lacpGroupConfig', 'lacpApiVersion', 'multicastFilteringMode', 'networkOffloadSpecId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDVSConfigSpec;
our @ISA = qw(DVSConfigSpec);

our @property_list = (
   ['pvlanConfigSpec', 'VMwareDVSPvlanConfigSpec', 1, 0],
   ['vspanConfigSpec', 'VMwareDVSVspanConfigSpec', 1, 0],
   ['maxMtu', undef, undef, 0],
   ['linkDiscoveryProtocolConfig', 'LinkDiscoveryProtocolConfig', undef, 0],
   ['ipfixConfig', 'VMwareIpfixConfig', undef, 0],
   ['lacpApiVersion', undef, undef, 0],
   ['multicastFilteringMode', undef, undef, 0],
   ['networkOffloadSpecId', undef, undef, 0],
);


VIMRuntime::make_get_set('VMwareDVSConfigSpec', 'pvlanConfigSpec', 'vspanConfigSpec', 'maxMtu', 'linkDiscoveryProtocolConfig', 'ipfixConfig', 'lacpApiVersion', 'multicastFilteringMode', 'networkOffloadSpecId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareUplinkPortOrderPolicy;
our @ISA = qw(InheritablePolicy);

our @property_list = (
   ['activeUplinkPort', undef, 1, 0],
   ['standbyUplinkPort', undef, 1, 0],
);


VIMRuntime::make_get_set('VMwareUplinkPortOrderPolicy', 'activeUplinkPort', 'standbyUplinkPort');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSFailureCriteria;
our @ISA = qw(InheritablePolicy);

our @property_list = (
   ['checkSpeed', 'StringPolicy', undef, 0],
   ['speed', 'IntPolicy', undef, 0],
   ['checkDuplex', 'BoolPolicy', undef, 0],
   ['fullDuplex', 'BoolPolicy', undef, 0],
   ['checkErrorPercent', 'BoolPolicy', undef, 0],
   ['percentage', 'IntPolicy', undef, 0],
   ['checkBeacon', 'BoolPolicy', undef, 0],
);


VIMRuntime::make_get_set('DVSFailureCriteria', 'checkSpeed', 'speed', 'checkDuplex', 'fullDuplex', 'checkErrorPercent', 'percentage', 'checkBeacon');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmwareUplinkPortTeamingPolicy;
our @ISA = qw(InheritablePolicy);

our @property_list = (
   ['policy', 'StringPolicy', undef, 0],
   ['reversePolicy', 'BoolPolicy', undef, 0],
   ['notifySwitches', 'BoolPolicy', undef, 0],
   ['rollingOrder', 'BoolPolicy', undef, 0],
   ['failureCriteria', 'DVSFailureCriteria', undef, 0],
   ['uplinkPortOrder', 'VMwareUplinkPortOrderPolicy', undef, 0],
);


VIMRuntime::make_get_set('VmwareUplinkPortTeamingPolicy', 'policy', 'reversePolicy', 'notifySwitches', 'rollingOrder', 'failureCriteria', 'uplinkPortOrder');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmwareDistributedVirtualSwitchVlanSpec;
our @ISA = qw(InheritablePolicy);

our @property_list = (
);


VIMRuntime::make_get_set('VmwareDistributedVirtualSwitchVlanSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmwareDistributedVirtualSwitchPvlanSpec;
our @ISA = qw(VmwareDistributedVirtualSwitchVlanSpec);

our @property_list = (
   ['pvlanId', undef, undef, 1],
);


VIMRuntime::make_get_set('VmwareDistributedVirtualSwitchPvlanSpec', 'pvlanId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmwareDistributedVirtualSwitchVlanIdSpec;
our @ISA = qw(VmwareDistributedVirtualSwitchVlanSpec);

our @property_list = (
   ['vlanId', undef, undef, 1],
);


VIMRuntime::make_get_set('VmwareDistributedVirtualSwitchVlanIdSpec', 'vlanId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmwareDistributedVirtualSwitchTrunkVlanSpec;
our @ISA = qw(VmwareDistributedVirtualSwitchVlanSpec);

our @property_list = (
   ['vlanId', 'NumericRange', 1, 0],
);


VIMRuntime::make_get_set('VmwareDistributedVirtualSwitchTrunkVlanSpec', 'vlanId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSSecurityPolicy;
our @ISA = qw(InheritablePolicy);

our @property_list = (
   ['allowPromiscuous', 'BoolPolicy', undef, 0],
   ['macChanges', 'BoolPolicy', undef, 0],
   ['forgedTransmits', 'BoolPolicy', undef, 0],
);


VIMRuntime::make_get_set('DVSSecurityPolicy', 'allowPromiscuous', 'macChanges', 'forgedTransmits');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSMacLearningPolicy;
our @ISA = qw(InheritablePolicy);

our @property_list = (
   ['enabled', 'boolean', undef, 1],
   ['allowUnicastFlooding', 'boolean', undef, 0],
   ['limit', undef, undef, 0],
   ['limitPolicy', undef, undef, 0],
);


VIMRuntime::make_get_set('DVSMacLearningPolicy', 'enabled', 'allowUnicastFlooding', 'limit', 'limitPolicy');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSMacManagementPolicy;
our @ISA = qw(InheritablePolicy);

our @property_list = (
   ['allowPromiscuous', 'boolean', undef, 0],
   ['macChanges', 'boolean', undef, 0],
   ['forgedTransmits', 'boolean', undef, 0],
   ['macLearningPolicy', 'DVSMacLearningPolicy', undef, 0],
);


VIMRuntime::make_get_set('DVSMacManagementPolicy', 'allowPromiscuous', 'macChanges', 'forgedTransmits', 'macLearningPolicy');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDVSPortSetting;
our @ISA = qw(DVPortSetting);

our @property_list = (
   ['vlan', 'VmwareDistributedVirtualSwitchVlanSpec', undef, 0],
   ['qosTag', 'IntPolicy', undef, 0],
   ['uplinkTeamingPolicy', 'VmwareUplinkPortTeamingPolicy', undef, 0],
   ['securityPolicy', 'DVSSecurityPolicy', undef, 0],
   ['ipfixEnabled', 'BoolPolicy', undef, 0],
   ['txUplink', 'BoolPolicy', undef, 0],
   ['lacpPolicy', 'VMwareUplinkLacpPolicy', undef, 0],
   ['macManagementPolicy', 'DVSMacManagementPolicy', undef, 0],
   ['VNI', 'IntPolicy', undef, 0],
);


VIMRuntime::make_get_set('VMwareDVSPortSetting', 'vlan', 'qosTag', 'uplinkTeamingPolicy', 'securityPolicy', 'ipfixEnabled', 'txUplink', 'lacpPolicy', 'macManagementPolicy', 'VNI');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDVSPortgroupPolicy;
our @ISA = qw(DVPortgroupPolicy);

our @property_list = (
   ['vlanOverrideAllowed', 'boolean', undef, 1],
   ['uplinkTeamingOverrideAllowed', 'boolean', undef, 1],
   ['securityPolicyOverrideAllowed', 'boolean', undef, 1],
   ['ipfixOverrideAllowed', 'boolean', undef, 0],
   ['macManagementOverrideAllowed', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VMwareDVSPortgroupPolicy', 'vlanOverrideAllowed', 'uplinkTeamingOverrideAllowed', 'securityPolicyOverrideAllowed', 'ipfixOverrideAllowed', 'macManagementOverrideAllowed');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDVSPvlanConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['pvlanEntry', 'VMwareDVSPvlanMapEntry', undef, 1],
   ['operation', undef, undef, 1],
);


VIMRuntime::make_get_set('VMwareDVSPvlanConfigSpec', 'pvlanEntry', 'operation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVMwareDVSPvlanConfigSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VMwareDVSPvlanConfigSpec', 'VMwareDVSPvlanConfigSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVMwareDVSPvlanConfigSpec', 'VMwareDVSPvlanConfigSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDVSPvlanMapEntry;
our @ISA = qw(DynamicData);

our @property_list = (
   ['primaryVlanId', undef, undef, 1],
   ['secondaryVlanId', undef, undef, 1],
   ['pvlanType', undef, undef, 1],
);


VIMRuntime::make_get_set('VMwareDVSPvlanMapEntry', 'primaryVlanId', 'secondaryVlanId', 'pvlanType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVMwareDVSPvlanMapEntry;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VMwareDVSPvlanMapEntry', 'VMwareDVSPvlanMapEntry', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVMwareDVSPvlanMapEntry', 'VMwareDVSPvlanMapEntry');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDVSVspanConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vspanSession', 'VMwareVspanSession', undef, 1],
   ['operation', undef, undef, 1],
);


VIMRuntime::make_get_set('VMwareDVSVspanConfigSpec', 'vspanSession', 'operation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVMwareDVSVspanConfigSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VMwareDVSVspanConfigSpec', 'VMwareDVSVspanConfigSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVMwareDVSVspanConfigSpec', 'VMwareDVSVspanConfigSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDVSHealthCheckConfig;
our @ISA = qw(DVSHealthCheckConfig);

our @property_list = (
);


VIMRuntime::make_get_set('VMwareDVSHealthCheckConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDVSVlanMtuHealthCheckConfig;
our @ISA = qw(VMwareDVSHealthCheckConfig);

our @property_list = (
);


VIMRuntime::make_get_set('VMwareDVSVlanMtuHealthCheckConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDVSTeamingHealthCheckConfig;
our @ISA = qw(VMwareDVSHealthCheckConfig);

our @property_list = (
);


VIMRuntime::make_get_set('VMwareDVSTeamingHealthCheckConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDVSVlanHealthCheckResult;
our @ISA = qw(HostMemberUplinkHealthCheckResult);

our @property_list = (
   ['trunkedVlan', 'NumericRange', 1, 0],
   ['untrunkedVlan', 'NumericRange', 1, 0],
);


VIMRuntime::make_get_set('VMwareDVSVlanHealthCheckResult', 'trunkedVlan', 'untrunkedVlan');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDVSMtuHealthCheckResult;
our @ISA = qw(HostMemberUplinkHealthCheckResult);

our @property_list = (
   ['mtuMismatch', 'boolean', undef, 1],
   ['vlanSupportSwitchMtu', 'NumericRange', 1, 0],
   ['vlanNotSupportSwitchMtu', 'NumericRange', 1, 0],
);


VIMRuntime::make_get_set('VMwareDVSMtuHealthCheckResult', 'mtuMismatch', 'vlanSupportSwitchMtu', 'vlanNotSupportSwitchMtu');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDVSTeamingHealthCheckResult;
our @ISA = qw(HostMemberHealthCheckResult);

our @property_list = (
   ['teamingStatus', undef, undef, 1],
);


VIMRuntime::make_get_set('VMwareDVSTeamingHealthCheckResult', 'teamingStatus');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareUplinkLacpPolicy;
our @ISA = qw(InheritablePolicy);

our @property_list = (
   ['enable', 'BoolPolicy', undef, 0],
   ['mode', 'StringPolicy', undef, 0],
);


VIMRuntime::make_get_set('VMwareUplinkLacpPolicy', 'enable', 'mode');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDvsLacpGroupConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 0],
   ['name', undef, undef, 0],
   ['mode', undef, undef, 0],
   ['uplinkNum', undef, undef, 0],
   ['loadbalanceAlgorithm', undef, undef, 0],
   ['vlan', 'VMwareDvsLagVlanConfig', undef, 0],
   ['ipfix', 'VMwareDvsLagIpfixConfig', undef, 0],
   ['uplinkName', undef, 1, 0],
   ['uplinkPortKey', undef, 1, 0],
   ['timeoutMode', undef, undef, 0],
);


VIMRuntime::make_get_set('VMwareDvsLacpGroupConfig', 'key', 'name', 'mode', 'uplinkNum', 'loadbalanceAlgorithm', 'vlan', 'ipfix', 'uplinkName', 'uplinkPortKey', 'timeoutMode');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVMwareDvsLacpGroupConfig;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VMwareDvsLacpGroupConfig', 'VMwareDvsLacpGroupConfig', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVMwareDvsLacpGroupConfig', 'VMwareDvsLacpGroupConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDvsLagVlanConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vlanId', 'NumericRange', 1, 0],
);


VIMRuntime::make_get_set('VMwareDvsLagVlanConfig', 'vlanId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDvsLagIpfixConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['ipfixEnabled', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VMwareDvsLagIpfixConfig', 'ipfixEnabled');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDvsLacpGroupSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['lacpGroupConfig', 'VMwareDvsLacpGroupConfig', undef, 1],
   ['operation', undef, undef, 1],
);


VIMRuntime::make_get_set('VMwareDvsLacpGroupSpec', 'lacpGroupConfig', 'operation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVMwareDvsLacpGroupSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VMwareDvsLacpGroupSpec', 'VMwareDvsLacpGroupSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVMwareDvsLacpGroupSpec', 'VMwareDvsLacpGroupSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CryptoKeyId;
our @ISA = qw(DynamicData);

our @property_list = (
   ['keyId', undef, undef, 1],
   ['providerId', 'KeyProviderId', undef, 0],
);


VIMRuntime::make_get_set('CryptoKeyId', 'keyId', 'providerId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfCryptoKeyId;
our @ISA = qw(ComplexType);

our @property_list = (
   ['CryptoKeyId', 'CryptoKeyId', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfCryptoKeyId', 'CryptoKeyId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CryptoKeyPlain;
our @ISA = qw(DynamicData);

our @property_list = (
   ['keyId', 'CryptoKeyId', undef, 1],
   ['algorithm', undef, undef, 1],
   ['keyData', undef, undef, 1],
);


VIMRuntime::make_get_set('CryptoKeyPlain', 'keyId', 'algorithm', 'keyData');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfCryptoKeyPlain;
our @ISA = qw(ComplexType);

our @property_list = (
   ['CryptoKeyPlain', 'CryptoKeyPlain', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfCryptoKeyPlain', 'CryptoKeyPlain');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CryptoKeyResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['keyId', 'CryptoKeyId', undef, 1],
   ['success', 'boolean', undef, 1],
   ['reason', undef, undef, 0],
   ['fault', 'LocalizedMethodFault', undef, 0],
);


VIMRuntime::make_get_set('CryptoKeyResult', 'keyId', 'success', 'reason', 'fault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfCryptoKeyResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['CryptoKeyResult', 'CryptoKeyResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfCryptoKeyResult', 'CryptoKeyResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CryptoManagerKmipCertificateInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['subject', undef, undef, 1],
   ['issuer', undef, undef, 1],
   ['serialNumber', undef, undef, 1],
   ['notBefore', undef, undef, 1],
   ['notAfter', undef, undef, 1],
   ['fingerprint', undef, undef, 1],
   ['checkTime', undef, undef, 1],
   ['secondsSinceValid', undef, undef, 0],
   ['secondsBeforeExpire', undef, undef, 0],
);


VIMRuntime::make_get_set('CryptoManagerKmipCertificateInfo', 'subject', 'issuer', 'serialNumber', 'notBefore', 'notAfter', 'fingerprint', 'checkTime', 'secondsSinceValid', 'secondsBeforeExpire');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CryptoManagerKmipServerStatus;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['status', 'ManagedEntityStatus', undef, 1],
   ['connectionStatus', undef, undef, 1],
   ['certInfo', 'CryptoManagerKmipCertificateInfo', undef, 0],
   ['clientTrustServer', 'boolean', undef, 0],
   ['serverTrustClient', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('CryptoManagerKmipServerStatus', 'name', 'status', 'connectionStatus', 'certInfo', 'clientTrustServer', 'serverTrustClient');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfCryptoManagerKmipServerStatus;
our @ISA = qw(ComplexType);

our @property_list = (
   ['CryptoManagerKmipServerStatus', 'CryptoManagerKmipServerStatus', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfCryptoManagerKmipServerStatus', 'CryptoManagerKmipServerStatus');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CryptoManagerKmipClusterStatus;
our @ISA = qw(DynamicData);

our @property_list = (
   ['clusterId', 'KeyProviderId', undef, 1],
   ['overallStatus', 'ManagedEntityStatus', undef, 0],
   ['managementType', undef, undef, 0],
   ['servers', 'CryptoManagerKmipServerStatus', 1, 1],
   ['clientCertInfo', 'CryptoManagerKmipCertificateInfo', undef, 0],
);


VIMRuntime::make_get_set('CryptoManagerKmipClusterStatus', 'clusterId', 'overallStatus', 'managementType', 'servers', 'clientCertInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfCryptoManagerKmipClusterStatus;
our @ISA = qw(ComplexType);

our @property_list = (
   ['CryptoManagerKmipClusterStatus', 'CryptoManagerKmipClusterStatus', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfCryptoManagerKmipClusterStatus', 'CryptoManagerKmipClusterStatus');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CryptoManagerKmipServerCertInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['certificate', undef, undef, 1],
   ['certInfo', 'CryptoManagerKmipCertificateInfo', undef, 0],
   ['clientTrustServer', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('CryptoManagerKmipServerCertInfo', 'certificate', 'certInfo', 'clientTrustServer');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CryptoManagerKmipCryptoKeyStatus;
our @ISA = qw(DynamicData);

our @property_list = (
   ['keyId', 'CryptoKeyId', undef, 1],
   ['keyAvailable', 'boolean', undef, 0],
   ['reason', undef, undef, 0],
   ['encryptedVMs', 'ManagedObjectReference', 1, 0],
   ['affectedHosts', 'ManagedObjectReference', 1, 0],
   ['referencedByTags', undef, 1, 0],
);


VIMRuntime::make_get_set('CryptoManagerKmipCryptoKeyStatus', 'keyId', 'keyAvailable', 'reason', 'encryptedVMs', 'affectedHosts', 'referencedByTags');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfCryptoManagerKmipCryptoKeyStatus;
our @ISA = qw(ComplexType);

our @property_list = (
   ['CryptoManagerKmipCryptoKeyStatus', 'CryptoManagerKmipCryptoKeyStatus', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfCryptoManagerKmipCryptoKeyStatus', 'CryptoManagerKmipCryptoKeyStatus');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CryptoSpec;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('CryptoSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CryptoSpecDecrypt;
our @ISA = qw(CryptoSpec);

our @property_list = (
);


VIMRuntime::make_get_set('CryptoSpecDecrypt');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CryptoSpecDeepRecrypt;
our @ISA = qw(CryptoSpec);

our @property_list = (
   ['newKeyId', 'CryptoKeyId', undef, 1],
);


VIMRuntime::make_get_set('CryptoSpecDeepRecrypt', 'newKeyId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CryptoSpecEncrypt;
our @ISA = qw(CryptoSpec);

our @property_list = (
   ['cryptoKeyId', 'CryptoKeyId', undef, 1],
);


VIMRuntime::make_get_set('CryptoSpecEncrypt', 'cryptoKeyId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CryptoSpecNoOp;
our @ISA = qw(CryptoSpec);

our @property_list = (
);


VIMRuntime::make_get_set('CryptoSpecNoOp');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CryptoSpecRegister;
our @ISA = qw(CryptoSpecNoOp);

our @property_list = (
   ['cryptoKeyId', 'CryptoKeyId', undef, 1],
);


VIMRuntime::make_get_set('CryptoSpecRegister', 'cryptoKeyId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CryptoSpecShallowRecrypt;
our @ISA = qw(CryptoSpec);

our @property_list = (
   ['newKeyId', 'CryptoKeyId', undef, 1],
);


VIMRuntime::make_get_set('CryptoSpecShallowRecrypt', 'newKeyId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package KeyProviderId;
our @ISA = qw(DynamicData);

our @property_list = (
   ['id', undef, undef, 1],
);


VIMRuntime::make_get_set('KeyProviderId', 'id');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package KmipClusterInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['clusterId', 'KeyProviderId', undef, 1],
   ['servers', 'KmipServerInfo', 1, 0],
   ['useAsDefault', 'boolean', undef, 1],
   ['managementType', undef, undef, 0],
   ['useAsEntityDefault', 'ManagedObjectReference', 1, 0],
   ['hasBackup', 'boolean', undef, 0],
   ['tpmRequired', 'boolean', undef, 0],
   ['keyId', undef, undef, 0],
);


VIMRuntime::make_get_set('KmipClusterInfo', 'clusterId', 'servers', 'useAsDefault', 'managementType', 'useAsEntityDefault', 'hasBackup', 'tpmRequired', 'keyId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfKmipClusterInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['KmipClusterInfo', 'KmipClusterInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfKmipClusterInfo', 'KmipClusterInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package KmipServerInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['address', undef, undef, 1],
   ['port', undef, undef, 1],
   ['proxyAddress', undef, undef, 0],
   ['proxyPort', undef, undef, 0],
   ['reconnect', undef, undef, 0],
   ['protocol', undef, undef, 0],
   ['nbio', undef, undef, 0],
   ['timeout', undef, undef, 0],
   ['userName', undef, undef, 0],
);


VIMRuntime::make_get_set('KmipServerInfo', 'name', 'address', 'port', 'proxyAddress', 'proxyPort', 'reconnect', 'protocol', 'nbio', 'timeout', 'userName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfKmipServerInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['KmipServerInfo', 'KmipServerInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfKmipServerInfo', 'KmipServerInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package KmipServerSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['clusterId', 'KeyProviderId', undef, 1],
   ['info', 'KmipServerInfo', undef, 1],
   ['password', undef, undef, 0],
);


VIMRuntime::make_get_set('KmipServerSpec', 'clusterId', 'info', 'password');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfKmipServerSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['KmipServerSpec', 'KmipServerSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfKmipServerSpec', 'KmipServerSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package KmipServerStatus;
our @ISA = qw(DynamicData);

our @property_list = (
   ['clusterId', 'KeyProviderId', undef, 1],
   ['name', undef, undef, 1],
   ['status', 'ManagedEntityStatus', undef, 1],
   ['description', undef, undef, 1],
);


VIMRuntime::make_get_set('KmipServerStatus', 'clusterId', 'name', 'status', 'description');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsUpgradeAvailableEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['productInfo', 'DistributedVirtualSwitchProductSpec', undef, 1],
);


VIMRuntime::make_get_set('DvsUpgradeAvailableEvent', 'productInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package Event;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['chainId', undef, undef, 1],
   ['createdTime', undef, undef, 1],
   ['userName', undef, undef, 1],
   ['datacenter', 'DatacenterEventArgument', undef, 0],
   ['computeResource', 'ComputeResourceEventArgument', undef, 0],
   ['host', 'HostEventArgument', undef, 0],
   ['vm', 'VmEventArgument', undef, 0],
   ['ds', 'DatastoreEventArgument', undef, 0],
   ['net', 'NetworkEventArgument', undef, 0],
   ['dvs', 'DvsEventArgument', undef, 0],
   ['fullFormattedMessage', undef, undef, 0],
   ['changeTag', undef, undef, 0],
);


VIMRuntime::make_get_set('Event', 'key', 'chainId', 'createdTime', 'userName', 'datacenter', 'computeResource', 'host', 'vm', 'ds', 'net', 'dvs', 'fullFormattedMessage', 'changeTag');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfEvent;
our @ISA = qw(ComplexType);

our @property_list = (
   ['Event', 'Event', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfEvent', 'Event');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package GeneralEvent;
our @ISA = qw(Event);

our @property_list = (
   ['message', undef, undef, 1],
);


VIMRuntime::make_get_set('GeneralEvent', 'message');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package GeneralHostInfoEvent;
our @ISA = qw(GeneralEvent);

our @property_list = (
);


VIMRuntime::make_get_set('GeneralHostInfoEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package GeneralHostWarningEvent;
our @ISA = qw(GeneralEvent);

our @property_list = (
);


VIMRuntime::make_get_set('GeneralHostWarningEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package GeneralHostErrorEvent;
our @ISA = qw(GeneralEvent);

our @property_list = (
);


VIMRuntime::make_get_set('GeneralHostErrorEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package GeneralVmInfoEvent;
our @ISA = qw(GeneralEvent);

our @property_list = (
);


VIMRuntime::make_get_set('GeneralVmInfoEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package GeneralVmWarningEvent;
our @ISA = qw(GeneralEvent);

our @property_list = (
);


VIMRuntime::make_get_set('GeneralVmWarningEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package GeneralVmErrorEvent;
our @ISA = qw(GeneralEvent);

our @property_list = (
);


VIMRuntime::make_get_set('GeneralVmErrorEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package GeneralUserEvent;
our @ISA = qw(GeneralEvent);

our @property_list = (
   ['entity', 'ManagedEntityEventArgument', undef, 0],
);


VIMRuntime::make_get_set('GeneralUserEvent', 'entity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HealthStatusChangedEvent;
our @ISA = qw(Event);

our @property_list = (
   ['componentId', undef, undef, 1],
   ['oldStatus', undef, undef, 1],
   ['newStatus', undef, undef, 1],
   ['componentName', undef, undef, 1],
   ['serviceId', undef, undef, 0],
);


VIMRuntime::make_get_set('HealthStatusChangedEvent', 'componentId', 'oldStatus', 'newStatus', 'componentName', 'serviceId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostInventoryUnreadableEvent;
our @ISA = qw(Event);

our @property_list = (
);


VIMRuntime::make_get_set('HostInventoryUnreadableEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatacenterEvent;
our @ISA = qw(Event);

our @property_list = (
);


VIMRuntime::make_get_set('DatacenterEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatacenterCreatedEvent;
our @ISA = qw(DatacenterEvent);

our @property_list = (
   ['parent', 'FolderEventArgument', undef, 1],
);


VIMRuntime::make_get_set('DatacenterCreatedEvent', 'parent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatacenterRenamedEvent;
our @ISA = qw(DatacenterEvent);

our @property_list = (
   ['oldName', undef, undef, 1],
   ['newName', undef, undef, 1],
);


VIMRuntime::make_get_set('DatacenterRenamedEvent', 'oldName', 'newName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SessionEvent;
our @ISA = qw(Event);

our @property_list = (
);


VIMRuntime::make_get_set('SessionEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ServerStartedSessionEvent;
our @ISA = qw(SessionEvent);

our @property_list = (
);


VIMRuntime::make_get_set('ServerStartedSessionEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UserLoginSessionEvent;
our @ISA = qw(SessionEvent);

our @property_list = (
   ['ipAddress', undef, undef, 1],
   ['userAgent', undef, undef, 0],
   ['locale', undef, undef, 1],
   ['sessionId', undef, undef, 1],
);


VIMRuntime::make_get_set('UserLoginSessionEvent', 'ipAddress', 'userAgent', 'locale', 'sessionId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UserLogoutSessionEvent;
our @ISA = qw(SessionEvent);

our @property_list = (
   ['ipAddress', undef, undef, 0],
   ['userAgent', undef, undef, 0],
   ['callCount', undef, undef, 0],
   ['sessionId', undef, undef, 0],
   ['loginTime', undef, undef, 0],
);


VIMRuntime::make_get_set('UserLogoutSessionEvent', 'ipAddress', 'userAgent', 'callCount', 'sessionId', 'loginTime');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package BadUsernameSessionEvent;
our @ISA = qw(SessionEvent);

our @property_list = (
   ['ipAddress', undef, undef, 1],
);


VIMRuntime::make_get_set('BadUsernameSessionEvent', 'ipAddress');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlreadyAuthenticatedSessionEvent;
our @ISA = qw(SessionEvent);

our @property_list = (
);


VIMRuntime::make_get_set('AlreadyAuthenticatedSessionEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NoAccessUserEvent;
our @ISA = qw(SessionEvent);

our @property_list = (
   ['ipAddress', undef, undef, 1],
);


VIMRuntime::make_get_set('NoAccessUserEvent', 'ipAddress');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SessionTerminatedEvent;
our @ISA = qw(SessionEvent);

our @property_list = (
   ['sessionId', undef, undef, 1],
   ['terminatedUsername', undef, undef, 1],
);


VIMRuntime::make_get_set('SessionTerminatedEvent', 'sessionId', 'terminatedUsername');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package GlobalMessageChangedEvent;
our @ISA = qw(SessionEvent);

our @property_list = (
   ['message', undef, undef, 1],
   ['prevMessage', undef, undef, 0],
);


VIMRuntime::make_get_set('GlobalMessageChangedEvent', 'message', 'prevMessage');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UpgradeEvent;
our @ISA = qw(Event);

our @property_list = (
   ['message', undef, undef, 1],
);


VIMRuntime::make_get_set('UpgradeEvent', 'message');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InfoUpgradeEvent;
our @ISA = qw(UpgradeEvent);

our @property_list = (
);


VIMRuntime::make_get_set('InfoUpgradeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package WarningUpgradeEvent;
our @ISA = qw(UpgradeEvent);

our @property_list = (
);


VIMRuntime::make_get_set('WarningUpgradeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ErrorUpgradeEvent;
our @ISA = qw(UpgradeEvent);

our @property_list = (
);


VIMRuntime::make_get_set('ErrorUpgradeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UserUpgradeEvent;
our @ISA = qw(UpgradeEvent);

our @property_list = (
);


VIMRuntime::make_get_set('UserUpgradeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostEvent;
our @ISA = qw(Event);

our @property_list = (
);


VIMRuntime::make_get_set('HostEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDasEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostDasEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostConnectedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostConnectedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDisconnectedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['reason', undef, undef, 0],
);


VIMRuntime::make_get_set('HostDisconnectedEvent', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostSyncFailedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['reason', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('HostSyncFailedEvent', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostConnectionLostEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostConnectionLostEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostReconnectionFailedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostReconnectionFailedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostCnxFailedNoConnectionEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostCnxFailedNoConnectionEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostCnxFailedBadUsernameEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostCnxFailedBadUsernameEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostCnxFailedBadVersionEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostCnxFailedBadVersionEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostCnxFailedAlreadyManagedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['serverName', undef, undef, 1],
);


VIMRuntime::make_get_set('HostCnxFailedAlreadyManagedEvent', 'serverName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostCnxFailedNoLicenseEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostCnxFailedNoLicenseEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostCnxFailedNetworkErrorEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostCnxFailedNetworkErrorEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostRemovedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostRemovedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostCnxFailedCcagentUpgradeEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostCnxFailedCcagentUpgradeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostCnxFailedBadCcagentEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostCnxFailedBadCcagentEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostCnxFailedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostCnxFailedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostCnxFailedAccountFailedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostCnxFailedAccountFailedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostCnxFailedNoAccessEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostCnxFailedNoAccessEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostShutdownEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['reason', undef, undef, 1],
);


VIMRuntime::make_get_set('HostShutdownEvent', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostCnxFailedNotFoundEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostCnxFailedNotFoundEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostCnxFailedTimeoutEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostCnxFailedTimeoutEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostUpgradeFailedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostUpgradeFailedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EnteringMaintenanceModeEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('EnteringMaintenanceModeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EnteredMaintenanceModeEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('EnteredMaintenanceModeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExitMaintenanceModeEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('ExitMaintenanceModeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CanceledHostOperationEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('CanceledHostOperationEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TimedOutHostOperationEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('TimedOutHostOperationEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDasEnabledEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostDasEnabledEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDasDisabledEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostDasDisabledEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDasEnablingEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostDasEnablingEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDasDisablingEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostDasDisablingEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDasErrorEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['message', undef, undef, 0],
   ['reason', undef, undef, 0],
);


VIMRuntime::make_get_set('HostDasErrorEvent', 'message', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDasOkEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostDasOkEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VcAgentUpgradedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VcAgentUpgradedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VcAgentUninstalledEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VcAgentUninstalledEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VcAgentUpgradeFailedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['reason', undef, undef, 0],
);


VIMRuntime::make_get_set('VcAgentUpgradeFailedEvent', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VcAgentUninstallFailedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['reason', undef, undef, 0],
);


VIMRuntime::make_get_set('VcAgentUninstallFailedEvent', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostAddedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostAddedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostAddFailedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['hostname', undef, undef, 1],
);


VIMRuntime::make_get_set('HostAddFailedEvent', 'hostname');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostIpChangedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['oldIP', undef, undef, 1],
   ['newIP', undef, undef, 1],
);


VIMRuntime::make_get_set('HostIpChangedEvent', 'oldIP', 'newIP');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EnteringStandbyModeEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('EnteringStandbyModeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DrsEnteringStandbyModeEvent;
our @ISA = qw(EnteringStandbyModeEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DrsEnteringStandbyModeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EnteredStandbyModeEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('EnteredStandbyModeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DrsEnteredStandbyModeEvent;
our @ISA = qw(EnteredStandbyModeEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DrsEnteredStandbyModeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExitingStandbyModeEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('ExitingStandbyModeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DrsExitingStandbyModeEvent;
our @ISA = qw(ExitingStandbyModeEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DrsExitingStandbyModeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExitedStandbyModeEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('ExitedStandbyModeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DrsExitedStandbyModeEvent;
our @ISA = qw(ExitedStandbyModeEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DrsExitedStandbyModeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExitStandbyModeFailedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('ExitStandbyModeFailedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DrsExitStandbyModeFailedEvent;
our @ISA = qw(ExitStandbyModeFailedEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DrsExitStandbyModeFailedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UpdatedAgentBeingRestartedEvent;
our @ISA = qw(HostEvent);

