/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.core;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ExecutionContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final transient SecurityContext securityContext;
    private final transient ApplicationData applicationData;

    public ExecutionContext() {
        this(null, null);
    }

    public ExecutionContext(SecurityContext securityContext) {
        this(null, securityContext);
    }

    public ExecutionContext(ApplicationData wireData, SecurityContext securityContext) {
        this.applicationData = wireData;
        this.securityContext = securityContext;
    }

    public ApplicationData retrieveApplicationData() {
        return this.applicationData;
    }

    public SecurityContext retrieveSecurityContext() {
        return this.securityContext;
    }

    public static interface SecurityContext {
        public static final String AUTHENTICATION_SCHEME_ID = "authn_scheme_id";
        public static final String AUTHENTICATION_DATA_ID = "authn_data_id";

        public Object getProperty(String var1);

        public Map<String, Object> getAllProperties();
    }

    public static class ApplicationData {
        private Map<String, String> wireData;

        public ApplicationData() {
            this.wireData = Collections.unmodifiableMap(new HashMap());
        }

        public ApplicationData(Map<String, String> data) {
            this.wireData = Collections.unmodifiableMap(new HashMap<String, String>(data));
        }

        public String getProperty(String key) {
            return this.wireData.get(key);
        }

        public Map<String, String> getAllProperties() {
            return this.wireData;
        }
    }
}

