/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.common.http.impl;

import com.vmware.vapi.internal.protocol.common.http.BinaryInput;
import com.vmware.vapi.internal.protocol.common.http.FrameDeserializer;
import com.vmware.vapi.internal.protocol.common.http.impl.FixedLengthFieldDeserializer;
import com.vmware.vapi.internal.protocol.common.http.impl.LengthFieldDeserializer;
import java.io.IOException;

public final class ChunkedTransferEncodingFrameDeserializer
implements FrameDeserializer {
    private static final int MAX_HEX_DIGITS_IN_LEN_FIELD = 8;
    private State state = State.LENGTH;
    private LengthFieldDeserializer lengthDeserializer;
    private int length;
    private FixedLengthFieldDeserializer fixedLengthFieldDeserializer;
    private byte[] payload;

    @Override
    public byte[] readFrame(BinaryInput inp) throws IOException {
        byte[] result = null;
        boolean enoughData = true;
        while (enoughData && result == null) {
            switch (this.state) {
                case LENGTH: {
                    enoughData = this.atLength(inp);
                    break;
                }
                case DATA: {
                    enoughData = this.atData(inp);
                    break;
                }
                case CR: {
                    enoughData = this.atCr(inp);
                    break;
                }
                case LF: {
                    enoughData = this.atLf(inp);
                    break;
                }
                case FRAME: {
                    result = this.payload;
                }
            }
        }
        if (result != null) {
            this.state = State.LENGTH;
            this.length = -1;
            this.payload = null;
        }
        return result;
    }

    private boolean atLength(BinaryInput inp) throws IOException {
        Integer len;
        if (this.lengthDeserializer == null) {
            this.lengthDeserializer = new LengthFieldDeserializer(8);
        }
        if ((len = this.lengthDeserializer.read(inp)) == null) {
            return false;
        }
        this.lengthDeserializer = null;
        this.length = len;
        this.state = State.DATA;
        return true;
    }

    private boolean atData(BinaryInput inp) throws IOException {
        byte[] frame;
        if (this.fixedLengthFieldDeserializer == null) {
            this.fixedLengthFieldDeserializer = new FixedLengthFieldDeserializer(this.length);
        }
        if ((frame = this.fixedLengthFieldDeserializer.read(inp)) == null) {
            return false;
        }
        this.fixedLengthFieldDeserializer = null;
        this.payload = frame;
        this.state = State.CR;
        return true;
    }

    private boolean atCr(BinaryInput inp) throws IOException {
        int b = inp.read();
        if (b == -2) {
            return false;
        }
        if (b == -1) {
            throw new IOException("Unexpected end of stream while reading frame trailer.");
        }
        if (b != 13) {
            throw new IOException("Expected carriage-return ASCII character. Found " + b);
        }
        this.state = State.LF;
        return true;
    }

    private boolean atLf(BinaryInput inp) throws IOException {
        int b = inp.read();
        if (b == -2) {
            return false;
        }
        if (b == -1) {
            throw new IOException("Unexpected end of stream while reading frame trailer.");
        }
        if (b != 10) {
            throw new IOException("Expected line-feed ASCII character. Found " + b);
        }
        this.state = State.FRAME;
        return true;
    }

    private static enum State {
        LENGTH,
        DATA,
        CR,
        LF,
        FRAME;

    }
}

