/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.protocol.server.rpc.http.impl;

import com.vmware.vapi.protocol.server.rpc.RequestReceiver;
import com.vmware.vapi.protocol.server.rpc.http.MediaTypeResolver;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;

public final class MediaTypeResolverImpl
implements MediaTypeResolver {
    private final Map<String, RequestReceiver> mediaTypeToHandler;

    public static MediaTypeResolver newJsonResolver(RequestReceiver jsonHandler) {
        Validate.notNull((Object)jsonHandler);
        HashMap<String, RequestReceiver> m = new HashMap<String, RequestReceiver>();
        m.put("application/json", jsonHandler);
        return new MediaTypeResolverImpl(m);
    }

    public MediaTypeResolverImpl(Map<String, RequestReceiver> mediaTypeToHandler) {
        Validate.notNull(mediaTypeToHandler);
        for (Map.Entry<String, RequestReceiver> e : mediaTypeToHandler.entrySet()) {
            Validate.notEmpty((String)e.getKey());
            Validate.notNull((Object)e.getValue());
        }
        this.mediaTypeToHandler = Collections.unmodifiableMap(mediaTypeToHandler);
    }

    @Override
    public RequestReceiver getHandler(String mediaType) {
        Validate.notNull((Object)mediaType);
        return this.mediaTypeToHandler.get(mediaType);
    }
}

