/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.provider.aggregator;

import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.diagnostics.LogDiagnosticUtil;
import com.vmware.vapi.diagnostics.LogDiagnosticsConfigurator;
import com.vmware.vapi.diagnostics.Slf4jMDCLogConfigurator;
import com.vmware.vapi.internal.provider.introspection.IntrospectionFilter;
import com.vmware.vapi.provider.aggregator.ProviderAggregation;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiAggregator
implements ApiProvider {
    static final Logger logger = LoggerFactory.getLogger(ApiAggregator.class);
    public static final String AGGREGATOR_DEFAULT_NAME = "ApiAggregator";
    private final LogDiagnosticsConfigurator logDiag = new Slf4jMDCLogConfigurator();
    private final ApiProvider impl;

    public ApiAggregator(String name, Map<String, ApiProvider> ifaceMap) {
        this(name, ifaceMap, true);
    }

    public ApiAggregator(String name, Map<String, ApiProvider> ifaceMap, boolean deployIntrospectionServices) {
        Validate.notNull(ifaceMap);
        Validate.noNullElements(ifaceMap.keySet());
        Validate.noNullElements(ifaceMap.values());
        ProviderAggregation core = new ProviderAggregation(ApiAggregator.getAggregatorName(name), ifaceMap);
        ApiProvider provider = deployIntrospectionServices ? new IntrospectionFilter(core, core, ProviderAggregation.AGGREGATOR_ERROR_DEFS) : core;
        this.impl = provider;
    }

    private static String getAggregatorName(String name) {
        name = name != null && !name.trim().isEmpty() ? name.trim() : AGGREGATOR_DEFAULT_NAME;
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(String serviceId, String operationId, DataValue input, ExecutionContext ctx, AsyncHandle<MethodResult> asyncHandle) {
        try {
            this.logDiag.configureContext(LogDiagnosticUtil.getDiagnosticContext(ctx));
            this.impl.invoke(serviceId, operationId, input, ctx, asyncHandle);
        }
        catch (RuntimeException ex) {
            logger.error("Exception thrown in invokeMethod", (Throwable)ex);
            asyncHandle.setError(ex);
        }
        finally {
            this.logDiag.cleanUpContext(LogDiagnosticUtil.getDiagnosticKeys());
        }
    }
}

