/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.security;

import com.vmware.vapi.ErrorValueFactory;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.DecoratorApiProvider;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.InterfaceIdentifier;
import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorDefinition;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.internal.security.SecurityUtil;
import com.vmware.vapi.provider.introspection.ErrorAugmentingFilter;
import com.vmware.vapi.security.AuthenticationConfig;
import com.vmware.vapi.security.AuthenticationHandler;
import com.vmware.vapi.std.StandardDataFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthenticationFilter
extends DecoratorApiProvider {
    private static final String PACKAGE_DELIMITER = ".";
    private static Logger logger = LoggerFactory.getLogger(AuthenticationFilter.class);
    private static final AuthenticationHandler NO_AUTHN_HANDLER = new NoAuthnHandler();
    private static final AuthenticationConfig.AuthnScheme NO_AUTHN_SCHEME = AuthenticationConfig.AuthnScheme.getNoAuthenticationScheme();
    static final Set<ErrorDefinition> AUTHN_FILTER_ERROR_DEFS = Collections.singleton(StandardDataFactory.createStandardErrorDefinition("com.vmware.vapi.std.errors.unauthenticated"));
    private final Map<String, List<AuthenticationConfig.AuthnScheme>> ifaceRulesTable;
    private final Map<String, List<AuthenticationConfig.AuthnScheme>> packageRulesTable;
    private final Map<String, List<AuthenticationConfig.AuthnScheme>> operationRulesTable;
    private final List<AuthenticationHandler> authnHandlers;

    public AuthenticationFilter(ApiProvider decoratedProvider, AuthenticationConfig authnConfig, List<AuthenticationHandler> authnHandlers) {
        super(new ErrorAugmentingFilter(decoratedProvider, AUTHN_FILTER_ERROR_DEFS));
        Validate.notNull((Object)authnConfig);
        Validate.notNull(authnHandlers);
        this.ifaceRulesTable = Collections.unmodifiableMap(authnConfig.getIFaceAuthenticationRules());
        this.packageRulesTable = Collections.unmodifiableMap(authnConfig.getPackageAuthenticationRules());
        this.operationRulesTable = Collections.unmodifiableMap(authnConfig.getOperationAuthenticationRules());
        this.authnHandlers = Collections.unmodifiableList(authnHandlers);
    }

    @Override
    public void invoke(final String serviceId, final String operationId, final DataValue input, final ExecutionContext ctx, final AsyncHandle<MethodResult> asyncHandle) {
        boolean userSchemeNotAllowed;
        MethodIdentifier method = new MethodIdentifier(new InterfaceIdentifier(serviceId), operationId);
        final ErrorValue notAuthenticatedError = ErrorValueFactory.buildErrorValue("com.vmware.vapi.std.errors.unauthenticated", MessageFactory.getMessage("vapi.method.authentication.required", new String[0]));
        List<AuthenticationConfig.AuthnScheme> requiredAuthnSchemes = this.getMethodAuthnScheme(method);
        final ExecutionContext.SecurityContext secCtx = ctx.retrieveSecurityContext();
        AuthenticationConfig.AuthnScheme userScheme = this.extractWireScheme(secCtx);
        boolean userSchemeIsNoAuth = NO_AUTHN_SCHEME == userScheme;
        boolean noAuthnIsAllowed = this.isSchemeAllowed(requiredAuthnSchemes, NO_AUTHN_SCHEME);
        boolean bl = userSchemeNotAllowed = !this.isSchemeAllowed(requiredAuthnSchemes, userScheme);
        if (userSchemeIsNoAuth && noAuthnIsAllowed) {
            this.decoratedProvider.invoke(serviceId, operationId, input, ctx, asyncHandle);
            return;
        }
        if (userSchemeNotAllowed && noAuthnIsAllowed) {
            if (secCtx != null && logger.isDebugEnabled()) {
                logger.debug("Unexpected scheme found '" + userScheme + "' for a method '" + method.getFullyQualifiedName() + "' that allows 'NoAuthentication'");
            }
            this.decoratedProvider.invoke(serviceId, operationId, input, new ExecutionContext(ctx.retrieveApplicationData(), null), asyncHandle);
            return;
        }
        if (userSchemeNotAllowed) {
            if (logger.isDebugEnabled()) {
                logger.debug("Ivalid authentication for method: " + serviceId + PACKAGE_DELIMITER + operationId);
            }
            asyncHandle.setResult(MethodResult.newErrorResult(notAuthenticatedError));
            return;
        }
        AuthenticationHandler authnHandler = this.findHandler(secCtx);
        if (authnHandler == null) {
            asyncHandle.setResult(MethodResult.newErrorResult(notAuthenticatedError));
            return;
        }
        authnHandler.authenticate(secCtx, new AsyncHandle<AuthenticationHandler.AuthenticationResult>(){

            @Override
            public void updateProgress(DataValue progress) {
            }

            @Override
            public void setResult(AuthenticationHandler.AuthenticationResult result) {
                ExecutionContext.SecurityContext authnSecCtx = secCtx;
                if (result != null && result.getSecurityContext() != null) {
                    authnSecCtx = result.getSecurityContext();
                }
                AuthenticationFilter.this.decoratedProvider.invoke(serviceId, operationId, input, new ExecutionContext(ctx.retrieveApplicationData(), new SecurityContextImpl(authnSecCtx, result)), asyncHandle);
            }

            @Override
            public void setError(RuntimeException error) {
                logger.info("Not successful authentication", (Throwable)error);
                asyncHandle.setResult(MethodResult.newErrorResult(notAuthenticatedError));
            }
        });
    }

    private AuthenticationHandler findHandler(ExecutionContext.SecurityContext ctx) {
        if (ctx == null) {
            return null;
        }
        Object schemeIdObject = ctx.getProperty("authn_scheme_id");
        String schemeId = SecurityUtil.narrowType(schemeIdObject, String.class);
        if (schemeId == null) {
            schemeId = "com.vmware.vapi.std.security.no_authentication";
        }
        for (AuthenticationHandler handler : this.authnHandlers) {
            if (!handler.supportedAuthenticationSchemes().contains(schemeId)) continue;
            return handler;
        }
        if (NO_AUTHN_HANDLER.supportedAuthenticationSchemes().contains(schemeId)) {
            return NO_AUTHN_HANDLER;
        }
        return null;
    }

    private List<AuthenticationConfig.AuthnScheme> getMethodAuthnScheme(MethodIdentifier method) {
        List<AuthenticationConfig.AuthnScheme> requiredSchemesList = this.operationRulesTable.get(method.getFullyQualifiedName());
        if (requiredSchemesList != null) {
            return requiredSchemesList;
        }
        String ifaceName = method.getInterfaceIdentifier().getName();
        requiredSchemesList = this.ifaceRulesTable.get(ifaceName);
        if (requiredSchemesList != null) {
            return requiredSchemesList;
        }
        String closestPackage = this.findClosestPackage(ifaceName, this.packageRulesTable.keySet());
        requiredSchemesList = this.packageRulesTable.get(closestPackage);
        if (requiredSchemesList == null) {
            requiredSchemesList = Arrays.asList(NO_AUTHN_SCHEME);
        }
        return requiredSchemesList;
    }

    private boolean isSchemeAllowed(List<AuthenticationConfig.AuthnScheme> allowedList, AuthenticationConfig.AuthnScheme userScheme) {
        for (AuthenticationConfig.AuthnScheme scheme : allowedList) {
            if (!scheme.isAllowed(userScheme)) continue;
            return true;
        }
        return false;
    }

    private AuthenticationConfig.AuthnScheme extractWireScheme(ExecutionContext.SecurityContext ctx) {
        AuthenticationConfig.AuthnScheme wireScheme;
        if (ctx == null) {
            wireScheme = AuthenticationConfig.AuthnScheme.getNoAuthenticationScheme();
        } else {
            Object schemeIdObject = ctx.getProperty("authn_scheme_id");
            String schemeId = SecurityUtil.narrowType(schemeIdObject, String.class);
            if (schemeId == null) {
                logger.debug("Invalid scheme id (assuming no authn scheme): " + schemeIdObject);
                wireScheme = AuthenticationConfig.AuthnScheme.getNoAuthenticationScheme();
            } else {
                wireScheme = new AuthenticationConfig.AuthnScheme(Collections.singletonList(schemeId));
            }
        }
        return wireScheme;
    }

    private String findClosestPackage(String invocationPackage, Set<String> registergedPackages) {
        String result = "";
        for (String packageName : registergedPackages) {
            if (!this.startsWith(invocationPackage, packageName) || packageName.length() <= result.length()) continue;
            result = packageName;
        }
        return result;
    }

    private boolean startsWith(String invocationPackage, String rulePackage) {
        if (invocationPackage.equals(rulePackage)) {
            return true;
        }
        return invocationPackage.startsWith(rulePackage + PACKAGE_DELIMITER);
    }

    private static final class NoAuthnHandler
    implements AuthenticationHandler {
        private NoAuthnHandler() {
        }

        @Override
        public void authenticate(ExecutionContext.SecurityContext ctx, AsyncHandle<AuthenticationHandler.AuthenticationResult> asyncHandle) {
            asyncHandle.setResult(null);
        }

        @Override
        public List<String> supportedAuthenticationSchemes() {
            return Collections.singletonList("com.vmware.vapi.std.security.no_authentication");
        }
    }

    private final class SecurityContextImpl
    implements ExecutionContext.SecurityContext {
        private final Map<String, Object> ctxData;

        private SecurityContextImpl(ExecutionContext.SecurityContext ctx, AuthenticationHandler.AuthenticationResult result) {
            this.ctxData = new HashMap<String, Object>(ctx.getAllProperties());
            this.ctxData.put("authn_data_id", result);
        }

        @Override
        public Object getProperty(String key) {
            return this.ctxData.get(key);
        }

        @Override
        public Map<String, Object> getAllProperties() {
            return Collections.unmodifiableMap(this.ctxData);
        }
    }
}

