/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.contentlibrary.helpers;

import com.vmware.content.library.Item;
import com.vmware.content.library.item.UpdateSession;
import com.vmware.content.library.item.UpdateSessionModel;
import com.vmware.content.library.item.updatesession.FileTypes;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import vmware.samples.common.HttpClient;

public class ItemUploadHelper {
    public static void performUpload(UpdateSession uploadService, com.vmware.content.library.item.updatesession.File uploadFileService, Item libItemService, String libItemId, List<String> fileLocations) {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (String location : fileLocations) {
            File file = new File(location);
            fileNames.add(file.getName());
        }
        String sessionId = ItemUploadHelper.createUploadSession(uploadService, libItemService, libItemId);
        ItemUploadHelper.uploadFiles(uploadFileService, sessionId, fileNames, fileLocations);
        List invalidFiles = uploadFileService.validate(sessionId).getInvalidFiles();
        Set missingFiles = uploadFileService.validate(sessionId).getMissingFiles();
        System.out.println("UploadSession Info : " + uploadService.get(sessionId));
        System.out.println("Invalid Files : " + invalidFiles);
        System.out.println("Missing Files : " + missingFiles);
        if (missingFiles.size() == 0 && invalidFiles.size() == 0) {
            uploadService.complete(sessionId);
            uploadService.delete(sessionId);
        }
        if (invalidFiles.size() != 0) {
            uploadService.fail(sessionId, ((FileTypes.ValidationError)invalidFiles.get(0)).getErrorMessage().toString());
            uploadService.delete(sessionId);
            System.out.println("Invalid files : " + invalidFiles);
            throw new RuntimeException(invalidFiles.toString());
        }
        if (missingFiles.size() != 0) {
            uploadService.cancel(sessionId);
            System.out.println("Following files are missing : " + missingFiles);
            throw new RuntimeException("Missing the required files : " + missingFiles);
        }
        System.out.println("The Library Item version after the upload commit : " + libItemService.get(libItemId).getContentVersion());
    }

    private static String createUploadSession(UpdateSession uploadService, Item libItemService, String libraryItemId) {
        String currentVersion = libItemService.get(libraryItemId).getContentVersion();
        UpdateSessionModel createSpec = new UpdateSessionModel();
        createSpec.setLibraryItemId(libraryItemId);
        createSpec.setLibraryItemContentVersion(currentVersion);
        String sessionId = uploadService.create(UUID.randomUUID().toString(), createSpec);
        return sessionId;
    }

    private static void uploadFiles(com.vmware.content.library.item.updatesession.File uploadFileService, String sessionId, List<String> fileNames, List<String> fileLocations) {
        assert (fileNames.size() == fileLocations.size());
        for (int i = 0; i < fileNames.size(); ++i) {
            ItemUploadHelper.uploadFile(uploadFileService, sessionId, fileNames.get(i), fileLocations.get(i));
        }
    }

    public static FileTypes.Info uploadFile(com.vmware.content.library.item.updatesession.File uploadFileService, String sessionId, String fileName, String fileLocation) {
        HttpClient httpClient = new HttpClient(true);
        FileTypes.AddSpec addSpec = new FileTypes.AddSpec();
        addSpec.setName(fileName);
        addSpec.setSourceType(FileTypes.SourceType.PUSH);
        uploadFileService.add(sessionId, addSpec);
        FileTypes.Info fileInfo = uploadFileService.get(sessionId, fileName);
        URI transferUri = fileInfo.getUploadEndpoint().getUri();
        System.out.println("File Location : " + fileLocation);
        File file1 = new File(fileLocation);
        System.out.println("File Name " + file1.getName());
        try {
            String transferUrl = transferUri.toURL().toString();
            System.out.println("Upload/Transfer URL : " + transferUrl);
            httpClient.upload(file1, transferUrl);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to upload due to IOException!", e);
        }
        fileInfo = uploadFileService.get(sessionId, fileName);
        return fileInfo;
    }

    public static File createTempDir(String prefix) throws IOException {
        File temp = File.createTempFile(prefix, "");
        temp.delete();
        temp.mkdir();
        temp.deleteOnExit();
        return temp;
    }

    public static String copyResourceToFile(String resourceName, File dir, String filename) throws IOException {
        File tempFile = new File(dir, filename);
        tempFile.deleteOnExit();
        ClassLoader classLoader = ItemUploadHelper.class.getClassLoader();
        try (InputStream in = classLoader.getResourceAsStream(resourceName);
             FileOutputStream out = new FileOutputStream(tempFile);){
            int n;
            byte[] buffer = new byte[4096];
            while ((n = in.read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, n);
            }
        }
        return tempFile.getAbsolutePath();
    }
}

