/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.sso.soaphandlers;

import javax.xml.bind.JAXBElement;
import javax.xml.soap.SOAPException;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.AttributedString;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.ObjectFactory;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.PasswordString;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.UsernameTokenType;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import vmware.samples.sso.soaphandlers.SSOHeaderHandler;
import vmware.samples.sso.soaphandlers.WssHelper;

public class UserCredentialHandler
extends SSOHeaderHandler {
    private final String userName;
    private final String passwd;

    public UserCredentialHandler(String username, String password) {
        this.userName = username;
        this.passwd = password;
    }

    private final JAXBElement<UsernameTokenType> createUsernameToken() {
        ObjectFactory objFactory = new ObjectFactory();
        UsernameTokenType userNameToken = objFactory.createUsernameTokenType();
        AttributedString user = objFactory.createAttributedString();
        user.setValue(this.userName.toString());
        userNameToken.setUsername(user);
        if (this.passwd != null) {
            PasswordString pass = objFactory.createPasswordString();
            pass.setValue(this.passwd);
            userNameToken.setPassword(pass);
        }
        return objFactory.createUsernameToken(userNameToken);
    }

    public boolean handleMessage(SOAPMessageContext smc) {
        if (WssHelper.isOutgoingMessage(smc)) {
            try {
                Node securityNode = WssHelper.getSecurityElement(WssHelper.getSOAPHeader(smc));
                Element usernameNode = WssHelper.marshallJaxbElement(this.createUsernameToken()).getDocumentElement();
                securityNode.appendChild(securityNode.getOwnerDocument().importNode(usernameNode, true));
            }
            catch (DOMException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            catch (SOAPException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return true;
    }
}

