/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.spbm.impl;

import com.vmware.vim.vmomi.client.ext.InvocationContext;
import com.vmware.vim.vmomi.client.ext.InvocationInterceptor;
import com.vmware.vise.util.OpIdUtil;
import com.vmware.vise.util.logging.LogUtil;
import com.vmware.vise.util.reflection.ReflectionUtil;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;

public class PbmInvocationInterceptor
implements InvocationInterceptor {
    private String _vcGuid;
    private static final Log _opIdLogger = LogUtil.getOpIdLogger();

    public PbmInvocationInterceptor(String vcGuid) {
        this._vcGuid = vcGuid;
    }

    public void completeInvocation(InvocationContext invocationContext, boolean completionStatus) {
    }

    public void beginInvocation(InvocationContext invocationContext) {
        long invocationStartInNanos = System.nanoTime();
        invocationContext.putInvocationContextObject("#invocation.start#", (Object)invocationStartInNanos);
        this.logInvocation(invocationContext);
    }

    private Object getOpId(InvocationContext invocationContext) {
        Object opId = invocationContext.getInvocationContextObject("operationID");
        return opId;
    }

    private void logInvocation(InvocationContext invocationContext) {
        Method method = invocationContext.getMethod().getMethod();
        LogUtil.LogLevel logLevel = OpIdUtil.determineLogLevelFor((Log)_opIdLogger, (Method)method);
        if (logLevel == LogUtil.LogLevel.OFF) {
            return;
        }
        Object opId = this.getOpId(invocationContext);
        StringBuilder msg = new StringBuilder(200);
        String methodSignature = ReflectionUtil.getBasicSignatureInfo((Method)method);
        msg.append("Invoking method '").append(methodSignature).append("' for VC ").append(this._vcGuid).append(" for opId '").append(opId).append("' (").append(this.getClass().getName()).append(')');
        if (logLevel == LogUtil.LogLevel.TRACE) {
            _opIdLogger.trace((Object)msg);
        } else {
            _opIdLogger.debug((Object)msg);
        }
    }
}

