/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.spbm.impl;

import com.vmware.vim.binding.pbm.capability.CapabilityInstance;
import com.vmware.vim.binding.pbm.profile.CapabilityBasedProfile;
import com.vmware.vim.binding.pbm.profile.IofilterInfo;
import com.vmware.vim.binding.pbm.profile.Profile;
import com.vmware.vim.binding.pbm.profile.ProfileDetails;
import com.vmware.vim.binding.pbm.profile.ProfileId;
import com.vmware.vim.binding.pbm.profile.ProfileToIofilterMap;
import com.vmware.vim.binding.pbm.profile.ResourceType;
import com.vmware.vim.binding.pbm.profile.SubProfileCapabilityConstraints;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.ResultItemComparator;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vsphere.client.spbm.PbmService;
import com.vmware.vsphere.client.spbm.PbmServiceFactory;
import com.vmware.vsphere.client.spbm.ProfileContentFormatter;
import com.vmware.vsphere.client.spbm.data.NamespaceCapabilityMetadata;
import com.vmware.vsphere.client.spbm.data.profile.content.ProfileContent;
import com.vmware.vsphere.client.spbm.util.ManagedUtil;
import com.vmware.vsphere.client.spbm.util.MetadataUtil;
import com.vmware.vsphere.client.spbm.util.PbmSessionUtil;
import com.vmware.vsphere.client.spbm.util.PbmUtil;
import com.vmware.vsphere.client.spbm.util.PbmVcUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadPoolExecutor;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@type(value="PbmRequirementStorageProfile,PbmCapabilityStorageProfile,PbmDataServiceStorageProfile")
public class ProfileProviderAdapter
implements DataProviderAdapter {
    public static final String NAME_PROPERTY = "name";
    private static final String DESCRIPTION_PROPERTY = "description";
    private static final String CREATE_TIME_PROPERTY = "createdTime";
    private static final String EDIT_TIME_PROPERTY = "modifiedTime";
    public static final String PROFILE_CONTENT_PROPERTY = "profileContent";
    private static final String FORMATTED_PROFILE_CONTENT_PROPERTY = "formattedProfileContent";
    private static final String PROFILE_VC_NAME_PROPERTY = "vCenterName";
    private static final String LINE_OF_SERVICE_PROFILE_PROPERTY = "lineOfService";
    private static final String IOFILTER_INFO_PROFILE_PROPERTY = "iofilterInfo";
    private static final String DATA_SERVICE_PROFILE_OWNER_PROPERTY = "owner";
    public static final String PBM_PROFILE_RELATION = "pbmProfiles";
    private static final String VIRTUAL_CENTER_TYPE = "Folder";
    private static final Log _logger = LogFactory.getLog(ProfileProviderAdapter.class);
    private QueryExecutor _queryExecutor;
    private ThreadPoolExecutor _threadPoolExecutor;
    private PbmServiceFactory _pbmServiceFactory;
    private ProfileContentFormatter _profileFormatter;

    public ProfileProviderAdapter(PbmServiceFactory pbmServiceFactory, QueryExecutor queryExecutor, ProfileContentFormatter profileContentFormatter, ThreadPoolExecutor threadPoolExecutor) {
        this._pbmServiceFactory = pbmServiceFactory;
        this._queryExecutor = queryExecutor;
        this._profileFormatter = profileContentFormatter;
        this._threadPoolExecutor = threadPoolExecutor;
    }

    public Response getData(RequestSpec request) {
        Validate.notNull((Object)request);
        QuerySpec[] querySpecs = request.querySpec;
        ResultSet[] resultSets = new ResultSet[querySpecs.length];
        for (int i = 0; i < querySpecs.length; ++i) {
            resultSets[i] = this.processQuery(querySpecs[i]);
        }
        Response response = new Response();
        response.resultSet = resultSets;
        return response;
    }

    private ResultSet processQuery(QuerySpec querySpec) {
        ResultSet resultSet = new ResultSet();
        boolean hasOrderingCriteria = querySpec.resultSpec != null && querySpec.resultSpec.order != null && !querySpec.resultSpec.order.equals((Object)Utils.getDefaultOrderingCriteria());
        try {
            URI[] profiles = null;
            Object[] identityConstraints = ProfileProviderAdapter.getObjectIdentityConstraints(querySpec.resourceSpec.constraint);
            String constraintTargetType = querySpec.resourceSpec.constraint.targetType;
            if (constraintTargetType == null && !ArrayUtils.isEmpty((Object[])identityConstraints)) {
                constraintTargetType = ManagedUtil.getProfileTypeByUri((URI)((ObjectIdentityConstraint)identityConstraints[0]).target);
            }
            ResourceType resourceType = ManagedUtil.getResourceTypeByProfileType(constraintTargetType);
            CapabilityBasedProfile.ProfileCategoryEnum profileCategory = ManagedUtil.getProfileCategory(constraintTargetType);
            if (!ArrayUtils.isEmpty((Object[])identityConstraints)) {
                profiles = new URI[identityConstraints.length];
                for (int i = 0; i < identityConstraints.length; ++i) {
                    profiles[i] = (URI)((ObjectIdentityConstraint)identityConstraints[i]).target;
                }
            } else if (querySpec.resourceSpec.constraint instanceof RelationalConstraint) {
                RelationalConstraint rc = (RelationalConstraint)querySpec.resourceSpec.constraint;
                if (PBM_PROFILE_RELATION.equals(rc.relation) && rc.constraintOnRelatedObject instanceof ObjectIdentityConstraint) {
                    ObjectIdentityConstraint relatedEntityConstraint = (ObjectIdentityConstraint)rc.constraintOnRelatedObject;
                    profiles = this.getRelatedProfilesForEntity(relatedEntityConstraint.target, resourceType, profileCategory);
                }
            } else {
                profiles = PbmVcUtil.getProfilesForResourceType(resourceType, profileCategory, this._pbmServiceFactory, this._queryExecutor, this._threadPoolExecutor);
            }
            if (profiles != null) {
                FilterData filterData = ProfileProviderAdapter.getFilterData(querySpec.resourceSpec.constraint);
                resultSet = this.getPropertySet(profiles, querySpec.resourceSpec.propertySpecs, filterData, resourceType, !hasOrderingCriteria);
            }
        }
        catch (Exception e) {
            resultSet.error = PbmUtil.getMethodFault(e);
        }
        resultSet.queryName = querySpec.name;
        resultSet.totalMatchedObjectCount = resultSet.items != null ? resultSet.items.length : 0;
        try {
            if (resultSet.items != null && hasOrderingCriteria) {
                Arrays.sort(resultSet.items, new ResultItemComparator(querySpec.resultSpec.order));
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to sort profiles: ", (Throwable)ex);
        }
        if (resultSet.items != null && querySpec.resultSpec != null) {
            ResultItem[] allResults = resultSet.items;
            int startIndex = 0;
            if (querySpec.resultSpec.offset != null && querySpec.resultSpec.offset >= 0) {
                startIndex = querySpec.resultSpec.offset;
            }
            int maxResultCount = allResults.length - startIndex;
            if (querySpec.resultSpec.maxResultCount != null && querySpec.resultSpec.maxResultCount >= 0) {
                maxResultCount = Math.min(maxResultCount, querySpec.resultSpec.maxResultCount);
            }
            if (startIndex >= allResults.length || maxResultCount == 0) {
                resultSet.items = new ResultItem[0];
            } else if (startIndex != 0 || maxResultCount != allResults.length) {
                resultSet.items = Arrays.copyOfRange(allResults, startIndex, startIndex + maxResultCount);
            }
        }
        return resultSet;
    }

    private static ObjectIdentityConstraint[] getObjectIdentityConstraints(Constraint constraint) {
        if (constraint instanceof ObjectIdentityConstraint) {
            return new ObjectIdentityConstraint[]{(ObjectIdentityConstraint)constraint};
        }
        if (constraint instanceof CompositeConstraint) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            if (!ArrayUtils.isEmpty((Object[])compositeConstraint.nestedConstraints)) {
                ArrayList<ObjectIdentityConstraint> results = new ArrayList<ObjectIdentityConstraint>();
                for (Constraint constraintItem : compositeConstraint.nestedConstraints) {
                    if (!(constraintItem instanceof ObjectIdentityConstraint)) continue;
                    ObjectIdentityConstraint objIdConstraint = (ObjectIdentityConstraint)constraintItem;
                    if (objIdConstraint.target == null || !ManagedUtil.isProfileObject(objIdConstraint.target)) continue;
                    results.add(objIdConstraint);
                }
                return results.toArray(new ObjectIdentityConstraint[0]);
            }
        }
        return null;
    }

    private static FilterData getFilterData(Constraint constraint) {
        FilterData result = null;
        if (constraint instanceof CompositeConstraint) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            if (Conjoiner.AND.equals((Object)compositeConstraint.conjoiner) && compositeConstraint.nestedConstraints != null && compositeConstraint.nestedConstraints.length == 2) {
                CompositeConstraint nestedPropertyConstraints = null;
                if (compositeConstraint.nestedConstraints[0] instanceof CompositeConstraint) {
                    nestedPropertyConstraints = (CompositeConstraint)compositeConstraint.nestedConstraints[0];
                }
                if (compositeConstraint.nestedConstraints[1] instanceof CompositeConstraint) {
                    nestedPropertyConstraints = (CompositeConstraint)compositeConstraint.nestedConstraints[1];
                }
                if (nestedPropertyConstraints != null && Conjoiner.OR.equals((Object)nestedPropertyConstraints.conjoiner) && !ArrayUtils.isEmpty((Object[])nestedPropertyConstraints.nestedConstraints)) {
                    for (Constraint nestedConstraint : nestedPropertyConstraints.nestedConstraints) {
                        String filterString;
                        if (!(nestedConstraint instanceof PropertyConstraint)) continue;
                        PropertyConstraint propertyConstraint = (PropertyConstraint)nestedConstraint;
                        if (!Comparator.CONTAINS.equals((Object)propertyConstraint.comparator) || !(propertyConstraint.comparableValue instanceof String) || (filterString = (String)propertyConstraint.comparableValue) == null || filterString.trim().length() <= 0) continue;
                        if (result == null) {
                            result = new FilterData();
                        }
                        result.filterString = filterString.toLowerCase().trim();
                        result.propertyNames.add(propertyConstraint.propertyName);
                    }
                }
            }
        }
        return result;
    }

    private URI[] getRelatedProfilesForEntity(Object entity, ResourceType resourceType, CapabilityBasedProfile.ProfileCategoryEnum profileCategory) throws Exception {
        ArrayList<URI> profiles = new ArrayList<URI>();
        if (entity instanceof ManagedObjectReference && VIRTUAL_CENTER_TYPE.equals(((ManagedObjectReference)entity).getType())) {
            PbmVcUtil.getProfilesForVc(resourceType, profileCategory, this._pbmServiceFactory, this._queryExecutor, ((ManagedObjectReference)entity).getServerGuid(), profiles);
        } else if (entity instanceof URI && "PbmDataServiceStorageProfile".equals(ManagedUtil.getProfileTypeByUri((URI)entity))) {
            this.getParentProfiles(resourceType, profileCategory, (URI)entity, profiles);
        }
        return profiles.toArray(new URI[profiles.size()]);
    }

    private void getParentProfiles(ResourceType resourceType, CapabilityBasedProfile.ProfileCategoryEnum profileCategory, URI dataServiceProfile, ArrayList<URI> profiles) throws Exception {
        String vcServiceGuid = ManagedUtil.getVcGuid(dataServiceProfile);
        ProfileId dataServiceProfileId = ManagedUtil.uriToProfileId(dataServiceProfile);
        PbmService pbmService = PbmSessionUtil.getService(vcServiceGuid, this._pbmServiceFactory);
        ProfileId[] parentProfileIds = PbmUtil.getParentProfileId(pbmService.getProfileManager(), dataServiceProfileId);
        if (parentProfileIds == null) {
            return;
        }
        for (ProfileId profileId : parentProfileIds) {
            profiles.add(ManagedUtil.buildProfileUri(resourceType, profileCategory, vcServiceGuid, profileId));
        }
    }

    private ResultSet getPropertySet(URI[] profileUris, PropertySpec[] properties, FilterData filterData, final ResourceType resourceType, boolean sortProfilesByName) {
        ResultSet result = new ResultSet();
        if (profileUris == null || profileUris.length == 0) {
            return result;
        }
        ArrayList<ResultItem> items = new ArrayList<ResultItem>();
        try {
            if (ProfileProviderAdapter.emptyPropertySpecs(properties)) {
                for (URI profileUri : profileUris) {
                    items.add(this.buildEmptyResultItem(profileUri));
                }
            } else {
                final CapabilityBasedProfile.ProfileCategoryEnum profileCategory = ManagedUtil.getProfileCategory(ManagedUtil.getProfileTypeByUri(profileUris[0]));
                Map<String, List<URI>> profilesByGuid = ManagedUtil.getProfilesByServerGuid(profileUris);
                Set<String> serverGuids = profilesByGuid.keySet();
                boolean retrieveNamespaceOwners = ProfileProviderAdapter.containsProperty(properties, DATA_SERVICE_PROFILE_OWNER_PROPERTY);
                final boolean retrieveFormattedContent = ProfileProviderAdapter.containsProperty(properties, FORMATTED_PROFILE_CONTENT_PROPERTY);
                final boolean retrieveIoFilterMap = ProfileProviderAdapter.containsProperty(properties, IOFILTER_INFO_PROFILE_PROPERTY);
                ArrayList<Callable<Void>> retrieveProfileContentTasks = new ArrayList<Callable<Void>>();
                ArrayList<VcProfileRequestData> vcProfileRequests = new ArrayList<VcProfileRequestData>();
                final HttpServletRequest threadContext = SessionUtil.getHttpRequest();
                for (final String vcServerGuid : serverGuids) {
                    final PbmService pbmService = PbmSessionUtil.getService(vcServerGuid, this._pbmServiceFactory);
                    final List<URI> profileUriList = profilesByGuid.get(vcServerGuid);
                    final boolean isAllVcProfilesUri = ManagedUtil.isAllVcProfilesSystemUri(profileUriList.get(0));
                    final VcProfileRequestData vcProfileRequestData = new VcProfileRequestData(vcServerGuid, pbmService);
                    vcProfileRequests.add(vcProfileRequestData);
                    if (retrieveNamespaceOwners || retrieveFormattedContent) {
                        retrieveProfileContentTasks.add(new Callable<Void>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public Void call() throws Exception {
                                try {
                                    SessionUtil.setHttpRequest((HttpServletRequest)threadContext);
                                    Map namespaceMetadata = ProfileProviderAdapter.this.retrieveNamespaceMetadata(vcServerGuid, resourceType);
                                    VcProfileRequestData vcProfileRequestData2 = vcProfileRequestData;
                                    synchronized (vcProfileRequestData2) {
                                        vcProfileRequestData.namespaceMetadata = namespaceMetadata;
                                    }
                                }
                                catch (Exception ex) {
                                    _logger.error((Object)("Failed to retrieve namespaceMetadata: " + ex.getMessage()), (Throwable)ex);
                                    throw ex;
                                }
                                return null;
                            }
                        });
                    }
                    if (retrieveIoFilterMap && !isAllVcProfilesUri) {
                        retrieveProfileContentTasks.add(new Callable<Void>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public Void call() throws Exception {
                                block6: {
                                    try {
                                        SessionUtil.setHttpRequest((HttpServletRequest)threadContext);
                                        ProfileToIofilterMap[] maps = pbmService.getProfileManager().queryIOFiltersFromProfileId(ManagedUtil.uriListToProfileId(profileUriList));
                                        if (maps == null) break block6;
                                        Map<String, IofilterInfo[]> map = vcProfileRequestData.iofilterMap;
                                        synchronized (map) {
                                            for (ProfileToIofilterMap map2 : maps) {
                                                vcProfileRequestData.iofilterMap.put(map2.key.uniqueId, map2.iofilters);
                                            }
                                        }
                                    }
                                    catch (Exception ex) {
                                        _logger.error((Object)("Failed to retrieve ioFilter map: " + ex.getMessage()), (Throwable)ex);
                                        throw ex;
                                    }
                                }
                                return null;
                            }
                        });
                    }
                    retrieveProfileContentTasks.add(new Callable<Void>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Void call() throws Exception {
                            try {
                                SessionUtil.setHttpRequest((HttpServletRequest)threadContext);
                                Object[] profiles = null;
                                if (isAllVcProfilesUri) {
                                    ProfileDetails[] profileDetails = pbmService.getProfileManager().queryProfileDetails(profileCategory.toString(), retrieveIoFilterMap);
                                    if (profileDetails != null) {
                                        profiles = new Profile[profileDetails.length];
                                        for (int i = 0; i < profiles.length; ++i) {
                                            profiles[i] = profileDetails[i].profile;
                                        }
                                        if (retrieveIoFilterMap) {
                                            Map<String, IofilterInfo[]> map = vcProfileRequestData.iofilterMap;
                                            synchronized (map) {
                                                for (ProfileDetails details : profileDetails) {
                                                    vcProfileRequestData.iofilterMap.put(details.profile.profileId.uniqueId, details.iofInfos);
                                                }
                                            }
                                        }
                                    }
                                } else {
                                    profiles = PbmVcUtil.getProfileContent(profileUriList, vcServerGuid, ProfileProviderAdapter.this._pbmServiceFactory);
                                }
                                if (ArrayUtils.isEmpty((Object[])profiles)) {
                                    return null;
                                }
                                Map nestedProfiles = null;
                                if (retrieveFormattedContent) {
                                    nestedProfiles = ProfileProviderAdapter.this.retrieveNestedProfiles(pbmService, (Profile[])profiles);
                                }
                                VcProfileRequestData vcProfileRequestData2 = vcProfileRequestData;
                                synchronized (vcProfileRequestData2) {
                                    vcProfileRequestData.profiles = profiles;
                                    vcProfileRequestData.nestedProfiles = nestedProfiles;
                                }
                            }
                            catch (Exception ex) {
                                _logger.error((Object)("Failed to retrieve profile content: " + ex.getMessage()), (Throwable)ex);
                                throw ex;
                            }
                            return null;
                        }
                    });
                }
                if (!retrieveProfileContentTasks.isEmpty()) {
                    this._threadPoolExecutor.invokeAll(retrieveProfileContentTasks);
                    this.buildResultItems(items, vcProfileRequests, filterData, resourceType, profileCategory, properties, sortProfilesByName);
                }
            }
        }
        catch (Exception ex) {
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        result.items = items.toArray(new ResultItem[items.size()]);
        return result;
    }

    private void buildResultItems(ArrayList<ResultItem> items, List<VcProfileRequestData> vcProfileRequestData, FilterData filterData, ResourceType resourceType, CapabilityBasedProfile.ProfileCategoryEnum profileCategory, PropertySpec[] properties, boolean sortProfilesByName) {
        for (VcProfileRequestData vcData : vcProfileRequestData) {
            if (vcData.profiles == null || vcData.profiles.length == 0) continue;
            if (sortProfilesByName) {
                Arrays.sort(vcData.profiles, new java.util.Comparator<Profile>(){

                    @Override
                    public int compare(Profile o1, Profile o2) {
                        if (o1 == null || o1.name == null) {
                            return -1;
                        }
                        if (o2 == null) {
                            return 1;
                        }
                        return o1.name.compareToIgnoreCase(o2.name);
                    }
                });
            }
            for (Profile profile : vcData.profiles) {
                URI profileUri = ManagedUtil.buildProfileUri(resourceType, profileCategory, vcData.vcGuid, profile.profileId);
                ResultItem profileItem = this.buildResultItem(profile, profileUri, properties, vcData);
                if (!ProfileProviderAdapter.textuallyMatches(profileItem, filterData)) continue;
                items.add(profileItem);
            }
        }
    }

    private static boolean emptyPropertySpecs(PropertySpec[] propertySpecs) {
        if (propertySpecs == null || propertySpecs.length == 0) {
            return true;
        }
        for (PropertySpec propertySpec : propertySpecs) {
            if (propertySpec == null || propertySpec.propertyNames == null || propertySpec.propertyNames.length <= 0) continue;
            return false;
        }
        return true;
    }

    private static boolean containsProperty(PropertySpec[] propertySpecs, String property) {
        if (ArrayUtils.isEmpty((Object[])propertySpecs) || property == null) {
            return false;
        }
        for (PropertySpec propertySpec : propertySpecs) {
            if (propertySpec == null || propertySpec.propertyNames == null) continue;
            for (String propertyName : propertySpec.propertyNames) {
                if (!property.equals(propertyName)) continue;
                return true;
            }
        }
        return false;
    }

    private Map<String, NamespaceCapabilityMetadata> retrieveNamespaceMetadata(String vcServerGuid, ResourceType resourceType) throws Exception {
        PbmService pbmService = PbmSessionUtil.getService(vcServerGuid, this._pbmServiceFactory);
        NamespaceCapabilityMetadata[] namespaceInfos = MetadataUtil.getLocalizedNamespaceCapabilityMetadata(pbmService, resourceType, vcServerGuid);
        HashMap<String, NamespaceCapabilityMetadata> result = new HashMap<String, NamespaceCapabilityMetadata>();
        if (namespaceInfos != null) {
            for (NamespaceCapabilityMetadata namespaceInfo : namespaceInfos) {
                result.put(namespaceInfo.namespaceInfo.namespace, namespaceInfo);
            }
        }
        return result;
    }

    private Map<String, Profile> retrieveNestedProfiles(PbmService pbmService, Profile[] profiles) throws Exception {
        HashMap<String, Profile> nestedProfilesMap = new HashMap<String, Profile>();
        List<ProfileId> nestedProfileIds = MetadataUtil.getNestedProfileIds(profiles);
        if (nestedProfileIds.isEmpty()) {
            return nestedProfilesMap;
        }
        Profile[] nestedProfiles = pbmService.getProfileManager().retrieveContent(nestedProfileIds.toArray(new ProfileId[nestedProfileIds.size()]));
        if (nestedProfiles != null) {
            for (Profile nestedProfile : nestedProfiles) {
                nestedProfilesMap.put(nestedProfile.profileId.uniqueId, nestedProfile);
            }
        }
        return nestedProfilesMap;
    }

    private static boolean textuallyMatches(ResultItem item, FilterData filterData) {
        if (filterData == null) {
            return true;
        }
        if (item.properties == null) {
            return false;
        }
        for (PropertyValue propVal : item.properties) {
            String value;
            if (!filterData.propertyNames.contains(propVal.propertyName) || propVal.value == null || !(propVal.value instanceof String) || (value = (String)propVal.value).toLowerCase().indexOf(filterData.filterString) < 0) continue;
            return true;
        }
        return false;
    }

    private Profile findProfileByUri(Profile[] profiles, URI profileUri) {
        String profileId = ManagedUtil.getProfileUid(profileUri);
        for (Profile profile : profiles) {
            if (profile == null || profile.profileId == null || profile.profileId.uniqueId == null || !profile.profileId.uniqueId.equals(profileId)) continue;
            return profile;
        }
        return null;
    }

    private ResultItem buildEmptyResultItem(URI profileUri) {
        ResultItem resultItem = new ResultItem();
        resultItem.resourceObject = profileUri;
        resultItem.properties = new PropertyValue[0];
        return resultItem;
    }

    private ResultItem buildResultItem(Profile profile, URI profileUri, PropertySpec[] propertySpecs, VcProfileRequestData vcData) {
        ArrayList<PropertyValue> propertyValues = new ArrayList<PropertyValue>();
        if (propertySpecs != null && profile != null) {
            for (PropertySpec propertySpec : propertySpecs) {
                for (String property : propertySpec.propertyNames) {
                    if (NAME_PROPERTY.equals(property)) {
                        propertyValues.add(this.buildPropertyValue(NAME_PROPERTY, profile.name, profileUri));
                        continue;
                    }
                    if (PROFILE_CONTENT_PROPERTY.equals(property)) {
                        propertyValues.add(this.buildPropertyValue(PROFILE_CONTENT_PROPERTY, profile, profileUri));
                        continue;
                    }
                    if (DESCRIPTION_PROPERTY.equals(property)) {
                        propertyValues.add(this.buildPropertyValue(DESCRIPTION_PROPERTY, profile.description, profileUri));
                        continue;
                    }
                    if (CREATE_TIME_PROPERTY.equals(property)) {
                        propertyValues.add(this.buildPropertyValue(CREATE_TIME_PROPERTY, profile.creationTime, profileUri));
                        continue;
                    }
                    if (EDIT_TIME_PROPERTY.equals(property)) {
                        propertyValues.add(this.buildPropertyValue(EDIT_TIME_PROPERTY, profile.lastUpdatedTime, profileUri));
                        continue;
                    }
                    if (PROFILE_VC_NAME_PROPERTY.equals(property)) {
                        String vcServiceGuid = ManagedUtil.getVcGuid(profileUri);
                        String vcName = VcServiceUtil.getServiceName((String)vcServiceGuid);
                        propertyValues.add(this.buildPropertyValue(PROFILE_VC_NAME_PROPERTY, vcName, profileUri));
                        continue;
                    }
                    if (LINE_OF_SERVICE_PROFILE_PROPERTY.equals(property)) {
                        if (profile instanceof CapabilityBasedProfile) {
                            propertyValues.add(this.buildPropertyValue(LINE_OF_SERVICE_PROFILE_PROPERTY, ((CapabilityBasedProfile)profile).lineOfService, profileUri));
                            continue;
                        }
                        propertyValues.add(this.buildPropertyValue(LINE_OF_SERVICE_PROFILE_PROPERTY, null, profileUri));
                        continue;
                    }
                    if (DATA_SERVICE_PROFILE_OWNER_PROPERTY.equals(property)) {
                        String owner = ProfileProviderAdapter.getOwnerProperty(profile, vcData.namespaceMetadata);
                        propertyValues.add(this.buildPropertyValue(DATA_SERVICE_PROFILE_OWNER_PROPERTY, owner, profileUri));
                        continue;
                    }
                    if (FORMATTED_PROFILE_CONTENT_PROPERTY.equals(property)) {
                        ProfileContent formattedContent = this._profileFormatter.formatProfileContent(profile, vcData.namespaceMetadata, this.getParameters(property, propertySpec.parameters), vcData.nestedProfiles, vcData.pbmService, vcData.vcGuid);
                        propertyValues.add(this.buildPropertyValue(FORMATTED_PROFILE_CONTENT_PROPERTY, formattedContent, profileUri));
                        continue;
                    }
                    if (!IOFILTER_INFO_PROFILE_PROPERTY.equals(property)) continue;
                    propertyValues.add(this.buildPropertyValue(IOFILTER_INFO_PROFILE_PROPERTY, vcData.iofilterMap.get(profile.profileId.uniqueId), profileUri));
                }
            }
        }
        ResultItem resultItem = new ResultItem();
        resultItem.resourceObject = profileUri;
        resultItem.properties = propertyValues.toArray(new PropertyValue[0]);
        return resultItem;
    }

    private Map<String, Object> getParameters(String propertyName, ParameterSpec[] parameterSpecs) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (ArrayUtils.isEmpty((Object[])parameterSpecs)) {
            return parameters;
        }
        Object parameter = null;
        for (ParameterSpec parameterSpec : parameterSpecs) {
            if (parameterSpec == null || !propertyName.equals(parameterSpec.propertyName)) continue;
            parameter = parameterSpec.parameter;
            break;
        }
        if (parameter == null) {
            return parameters;
        }
        if (FORMATTED_PROFILE_CONTENT_PROPERTY.equals(propertyName) && parameter instanceof Boolean[]) {
            Boolean[] vsanCapabilities = (Boolean[])parameter;
            parameters.put("isVsanNestedFdsSupported", vsanCapabilities[0]);
            parameters.put("isVsanHciMeshPolicySupported", vsanCapabilities[1]);
        }
        return parameters;
    }

    private static String getOwnerProperty(Profile profile, Map<String, NamespaceCapabilityMetadata> namespaceMetadataMap) {
        if (!(profile instanceof CapabilityBasedProfile) || namespaceMetadataMap == null) {
            return null;
        }
        String owner = null;
        CapabilityBasedProfile capabilityBasedProfile = (CapabilityBasedProfile)profile;
        if (capabilityBasedProfile == null || !(capabilityBasedProfile.constraints instanceof SubProfileCapabilityConstraints)) {
            return null;
        }
        SubProfileCapabilityConstraints constraints = (SubProfileCapabilityConstraints)capabilityBasedProfile.constraints;
        if (constraints == null || constraints.subProfiles == null) {
            return owner;
        }
        for (SubProfileCapabilityConstraints.SubProfile subProfile : constraints.subProfiles) {
            if (subProfile == null || subProfile.capability == null) continue;
            for (CapabilityInstance capability : subProfile.capability) {
                String capabilityOwner;
                if (capability == null || capability.id == null) continue;
                NamespaceCapabilityMetadata namespaceCapabilityMetadata = namespaceMetadataMap.get(capability.id.namespace);
                String string = capabilityOwner = namespaceCapabilityMetadata != null && namespaceCapabilityMetadata.namespaceInfo != null ? namespaceCapabilityMetadata.namespaceInfo.owner : null;
                if (capabilityOwner == null || "spbmDataDrivenUI".equals(capabilityOwner)) {
                    owner = "spbmDataDrivenUI";
                    continue;
                }
                if (capabilityOwner == null || capabilityOwner.isEmpty()) continue;
                return capabilityOwner;
            }
        }
        return owner;
    }

    private PropertyValue buildPropertyValue(String propertyName, Object propertyValue, URI profile) {
        PropertyValue pv = new PropertyValue();
        pv.resourceObject = profile;
        pv.propertyName = propertyName;
        pv.value = propertyValue;
        return pv;
    }

    private static class VcProfileRequestData {
        public Profile[] profiles;
        public Map<String, Profile> nestedProfiles;
        public Map<String, NamespaceCapabilityMetadata> namespaceMetadata;
        public Map<String, IofilterInfo[]> iofilterMap;
        public PbmService pbmService;
        public String vcGuid;

        public VcProfileRequestData(String vcGuid, PbmService pbmService) {
            this.pbmService = pbmService;
            this.vcGuid = vcGuid;
            this.iofilterMap = new HashMap<String, IofilterInfo[]>();
        }
    }

    private static class FilterData {
        public String filterString;
        public ArrayList<String> propertyNames = new ArrayList();

        private FilterData() {
        }
    }
}

