/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.spbm.impl.formatters;

import com.vmware.vim.binding.pbm.capability.CapabilityInstance;
import com.vmware.vim.binding.pbm.capability.CapabilityMetadata;
import com.vmware.vim.binding.pbm.capability.Operator;
import com.vmware.vim.binding.pbm.capability.PropertyInstance;
import com.vmware.vim.binding.pbm.capability.PropertyMetadata;
import com.vmware.vim.binding.pbm.capability.TypeInfo;
import com.vmware.vim.binding.pbm.capability.provider.LineOfServiceInfo;
import com.vmware.vim.binding.pbm.capability.provider.VaioDataServiceInfo;
import com.vmware.vim.binding.pbm.capability.types.BuiltinTypesEnum;
import com.vmware.vim.binding.pbm.capability.types.DescriptiveValue;
import com.vmware.vim.binding.pbm.capability.types.DiscreteSet;
import com.vmware.vim.binding.pbm.capability.types.TimeSpan;
import com.vmware.vim.binding.pbm.profile.Profile;
import com.vmware.vim.binding.pbm.profile.SubProfileCapabilityConstraints;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vsphere.client.spbm.data.NamespaceCapabilityMetadata;
import com.vmware.vsphere.client.spbm.impl.formatters.LabelValuePair;
import com.vmware.vsphere.client.spbm.impl.formatters.TimeSpanUtil;
import com.vmware.vsphere.client.spbm.util.MetadataUtil;
import com.vmware.vsphere.client.spbm.util.PbmUtil;
import com.vmware.vsphere.client.spbm.util.RuleSetUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FormatterUtil {
    private static final Log _logger = LogFactory.getLog(FormatterUtil.class);

    public static NamespaceCapabilityMetadata getCapabilityInstanceNamespaceMetadata(Map<String, NamespaceCapabilityMetadata> namespaceMetadata, Map<String, Profile> dataServiceProfiles, CapabilityInstance capabilityInstance) {
        if (MetadataUtil.isDataServiceReferenceCapability(capabilityInstance)) {
            Profile dataServiceProfile = dataServiceProfiles.get(capabilityInstance.id.id);
            if (dataServiceProfile == null) {
                return null;
            }
            String dataServiceProfileNamespace = RuleSetUtil.getSubProfileVendorNamespace(RuleSetUtil.getFirstSubProfile(dataServiceProfile));
            if (dataServiceProfileNamespace != null) {
                return namespaceMetadata.get(dataServiceProfileNamespace);
            }
        } else {
            return namespaceMetadata.get(capabilityInstance.id.namespace);
        }
        return null;
    }

    public static List<SubProfileCapabilityConstraints.SubProfile> getNormalizedSubProfiles(SubProfileCapabilityConstraints.SubProfile[] rawSubProfiles, Map<String, NamespaceCapabilityMetadata> namespaceMetadata, Map<String, Profile> dataServiceProfiles, boolean isDataServiceFeatureSupported) {
        ArrayList<SubProfileCapabilityConstraints.SubProfile> normalizedSubProfiles = new ArrayList<SubProfileCapabilityConstraints.SubProfile>();
        SubProfileCapabilityConstraints.SubProfile commonSubProfile = null;
        if (rawSubProfiles != null) {
            int regularRuleSetIndex = 1;
            for (SubProfileCapabilityConstraints.SubProfile rawSubProfile : rawSubProfiles) {
                ArrayList<CapabilityInstance> commonCapabilities = new ArrayList<CapabilityInstance>();
                ArrayList<CapabilityInstance> regularCapabilities = new ArrayList<CapabilityInstance>();
                ArrayList<CapabilityInstance> consumptionDomainCapabilities = new ArrayList<CapabilityInstance>();
                if (rawSubProfile.capability != null) {
                    for (CapabilityInstance capabilityInstance : rawSubProfile.capability) {
                        if (isDataServiceFeatureSupported) {
                            NamespaceCapabilityMetadata namespaceCapabilityMetadata = FormatterUtil.getCapabilityInstanceNamespaceMetadata(namespaceMetadata, dataServiceProfiles, capabilityInstance);
                            if (namespaceCapabilityMetadata != null && namespaceCapabilityMetadata.lineOfServiceInfo != null && namespaceCapabilityMetadata.lineOfServiceInfo instanceof VaioDataServiceInfo) {
                                commonCapabilities.add(capabilityInstance);
                                continue;
                            }
                            FormatterUtil.allocateCapabilities(capabilityInstance, consumptionDomainCapabilities, regularCapabilities);
                            continue;
                        }
                        if ("IOFILTERS".equalsIgnoreCase(capabilityInstance.id.namespace)) {
                            commonCapabilities.add(capabilityInstance);
                            continue;
                        }
                        FormatterUtil.allocateCapabilities(capabilityInstance, consumptionDomainCapabilities, regularCapabilities);
                    }
                }
                if (commonSubProfile == null) {
                    commonCapabilities.addAll(consumptionDomainCapabilities);
                    if (!commonCapabilities.isEmpty()) {
                        commonSubProfile = RuleSetUtil.createSubProfile(PbmUtil.getLocalizedString("profile.content.commonRules.title", new String[0]), commonCapabilities);
                        normalizedSubProfiles.add(commonSubProfile);
                    }
                }
                if (regularCapabilities.isEmpty()) continue;
                SubProfileCapabilityConstraints.SubProfile regularSubProfile = RuleSetUtil.createSubProfile(rawSubProfile.name, regularCapabilities);
                NamespaceCapabilityMetadata persistenceNamespace = RuleSetUtil.getSubProfilePersistenceNamespace(regularSubProfile, namespaceMetadata);
                String localizedNamespaceTitle = null;
                if (persistenceNamespace != null) {
                    localizedNamespaceTitle = MetadataUtil.getLocalizedNamespaceTitle(persistenceNamespace);
                }
                regularSubProfile.name = RuleSetUtil.getRuleSetTitle(regularRuleSetIndex, localizedNamespaceTitle);
                ++regularRuleSetIndex;
                normalizedSubProfiles.add(regularSubProfile);
            }
        }
        return normalizedSubProfiles;
    }

    public static String getLocalizedLineOfService(String lineOfService) {
        String localizedLineOfService;
        String localizationKey = "lineOfService." + lineOfService;
        if (localizationKey.equals(localizedLineOfService = PbmUtil.getLocalizedString(localizationKey, new String[0]))) {
            return lineOfService;
        }
        return localizedLineOfService;
    }

    public static String getProviderLabel(String lineOfService) {
        if (LineOfServiceInfo.LineOfServiceEnum.PERSISTENCE.toString().equals(lineOfService)) {
            return PbmUtil.getLocalizedString("profile.content.category.storageTypeLabel", new String[0]);
        }
        return PbmUtil.getLocalizedString("profile.content.category.providerLabel", new String[0]);
    }

    public static String getCapabilityLabel(CapabilityMetadata capabilityMetadata) {
        if (capabilityMetadata != null && capabilityMetadata.summary != null && capabilityMetadata.summary.label != null) {
            return capabilityMetadata.summary.label;
        }
        return "";
    }

    public static String getPropertyMetadataLabel(PropertyMetadata propertyMetadata) {
        if (propertyMetadata != null && propertyMetadata.summary != null && propertyMetadata.summary.label != null) {
            return propertyMetadata.summary.label;
        }
        return "";
    }

    public static String getTagCapabilityLabel(PropertyMetadata propertyMetadata, PropertyInstance propertyInstance) {
        String propertyNameKey = "profile.content.tags.taggedWithTitle";
        if (propertyInstance.operator != null && Operator.NOT.toString().equals(propertyInstance.operator)) {
            propertyNameKey = "profile.content.tags.notTaggedWithTitle";
        }
        if (propertyMetadata != null) {
            return PbmUtil.getLocalizedString(propertyNameKey, FormatterUtil.getPropertyMetadataLabel(propertyMetadata));
        }
        return PbmUtil.getLocalizedString(propertyNameKey, PbmUtil.getLocalizedString("profile.content.tags.missingTagCategory", new String[0]));
    }

    public static String getStringValue(Object value, TypeInfo typeInfo) {
        if (value == null) {
            return "";
        }
        if (BuiltinTypesEnum.XSD_BOOLEAN.toString().equals(typeInfo.typeName)) {
            if (Boolean.TRUE.equals(value)) {
                return PbmUtil.getLocalizedString("profile.content.booleanValues.true", new String[0]);
            }
            return PbmUtil.getLocalizedString("profile.content.booleanValues.false", new String[0]);
        }
        if (BuiltinTypesEnum.VMW_TIMESPAN.toString().equals(typeInfo.typeName)) {
            if (!(value instanceof TimeSpan)) {
                return "";
            }
            return TimeSpanUtil.timeSpanToString((TimeSpan)value);
        }
        if (BuiltinTypesEnum.XSD_STRING.toString().equals(typeInfo.typeName)) {
            if (!(value instanceof String)) {
                _logger.error((Object)("Invalid XSD_STRING value: " + value));
                return "";
            }
            return (String)value;
        }
        if (BuiltinTypesEnum.XSD_DOUBLE.toString().equals(typeInfo.typeName) || BuiltinTypesEnum.XSD_LONG.toString().equals(typeInfo.typeName) || BuiltinTypesEnum.XSD_INT.toString().equals(typeInfo.typeName)) {
            Double doubleValue;
            try {
                doubleValue = Double.valueOf(value.toString());
            }
            catch (NumberFormatException e) {
                _logger.error((Object)String.format("Invalid %s value: %s", typeInfo.typeName, value), (Throwable)e);
                return "";
            }
            return FormatterUtil.formatNumber(doubleValue);
        }
        _logger.error((Object)("Unsupported typeInfo: " + typeInfo.typeName));
        return value.toString();
    }

    public static String formatNumber(Number number) {
        return NumberFormat.getInstance(ResourceUtil.getLocale()).format(number.doubleValue());
    }

    public static String formatNumber(Number number, int precision) {
        NumberFormat numberFormat = NumberFormat.getInstance(ResourceUtil.getLocale());
        numberFormat.setMaximumFractionDigits(precision);
        return numberFormat.format(number.doubleValue());
    }

    private static List<LabelValuePair> getLocalizedLabelValues(DiscreteSet allowedValues, TypeInfo typeInfo) {
        ArrayList<LabelValuePair> result = new ArrayList<LabelValuePair>();
        if (allowedValues != null && allowedValues.values != null) {
            for (Object allowedValue : allowedValues.values) {
                if (allowedValue instanceof DescriptiveValue) {
                    String label = null;
                    DescriptiveValue descriptiveValue = (DescriptiveValue)allowedValue;
                    label = descriptiveValue.description != null && StringUtils.isNotEmpty((CharSequence)descriptiveValue.description.label) ? descriptiveValue.description.label : FormatterUtil.getStringValue(descriptiveValue.value, typeInfo);
                    result.add(new LabelValuePair(label, descriptiveValue.value));
                    continue;
                }
                result.add(new LabelValuePair(FormatterUtil.getStringValue(allowedValue, typeInfo), allowedValue));
            }
        }
        return result;
    }

    public static String getPropertyValue(Object value, TypeInfo typeInfo, DiscreteSet allowedValues, boolean showMissingSuffix) {
        if (value == null) {
            return "";
        }
        if (allowedValues == null) {
            return FormatterUtil.getStringValue(value, typeInfo);
        }
        List<LabelValuePair> allowedLabelValuePairs = FormatterUtil.getLocalizedLabelValues(allowedValues, typeInfo);
        for (LabelValuePair labelValuePair : allowedLabelValuePairs) {
            if (!value.equals(labelValuePair.value)) continue;
            return labelValuePair.label;
        }
        String formattedValue = FormatterUtil.getStringValue(value, typeInfo);
        if (showMissingSuffix) {
            formattedValue = PbmUtil.getLocalizedString("profile.content.missingAllowedValue", formattedValue);
        }
        return formattedValue;
    }

    public static List<String> getDiscreteSetValues(DiscreteSet values, DiscreteSet allowedValues, TypeInfo typeInfo, boolean showMissingSuffix) {
        ArrayList<String> formattedValues = new ArrayList<String>();
        if (values == null || values.values == null) {
            return formattedValues;
        }
        for (Object value : values.values) {
            String formattedValue = FormatterUtil.getPropertyValue(value, typeInfo, allowedValues, showMissingSuffix);
            formattedValues.add(formattedValue);
        }
        return formattedValues;
    }

    public static List<String> getTagValues(PropertyInstance propertyInstance, PropertyMetadata propertyMetadata) {
        TypeInfo typeInfo;
        ArrayList<String> tagValues = new ArrayList<String>();
        if (propertyInstance == null || propertyInstance.value == null || !(propertyInstance.value instanceof DiscreteSet)) {
            return tagValues;
        }
        DiscreteSet validTags = MetadataUtil.tryGetAllowedValueAsSet(propertyMetadata);
        if (validTags == null) {
            validTags = new DiscreteSet();
        }
        if (propertyMetadata != null) {
            typeInfo = propertyMetadata.type;
        } else {
            typeInfo = new TypeInfo();
            typeInfo.typeName = BuiltinTypesEnum.XSD_STRING.toString();
        }
        DiscreteSet tagSet = (DiscreteSet)propertyInstance.value;
        return FormatterUtil.getDiscreteSetValues(tagSet, validTags, typeInfo, true);
    }

    public static String getVsanCacheReservationPropertyValue(PropertyInstance propertyInstance) {
        if (propertyInstance.value instanceof Number) {
            BigDecimal rawValue = BigDecimal.valueOf(((Number)propertyInstance.value).longValue());
            BigDecimal percentValue = rawValue.divide(BigDecimal.valueOf(10000L), 4, RoundingMode.FLOOR);
            return FormatterUtil.formatNumber(percentValue, 4);
        }
        return null;
    }

    private static void allocateCapabilities(CapabilityInstance capabilityInstance, List<CapabilityInstance> consumptionDomainCapabilities, List<CapabilityInstance> regularCapabilities) {
        if ("com.vmware.storage.consumptiondomain".equalsIgnoreCase(capabilityInstance.id.namespace)) {
            consumptionDomainCapabilities.add(capabilityInstance);
        } else {
            regularCapabilities.add(capabilityInstance);
        }
    }
}

