/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.wcp.portgroup.filter;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.vise.common.api.filters.QueryFilterBuilder;
import com.vmware.vise.common.api.filters.annotations.QueryFilter;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public class WcpCompatiblePortGroupInClusterFilterBuilder
implements QueryFilterBuilder {
    private static final String PROPERTY_INSTANCE_UUID = "@instanceUuid";
    private static final String PROPERTY_CLUSTER = "cluster";
    private static final String PROPERTY_ZONES = "zones";
    private static final String PROPERTY_WCP_COMPATIBLE = "wcp_vsphere_network_compatible";
    private final ObjectReferenceService _objectReferenceService;

    public WcpCompatiblePortGroupInClusterFilterBuilder(ObjectReferenceService objectReferenceService) {
        this._objectReferenceService = objectReferenceService;
    }

    @QueryFilter(value="compatible-port-groups")
    public Filter getCompatiblePortGroupsInClusterFilter(String objectId, String[] filterParams) {
        if (filterParams == null || filterParams.length != 1) {
            return new Filter(Collections.emptyList());
        }
        PropertyPredicate clusterRelationPredicate = new PropertyPredicate(PROPERTY_CLUSTER, PropertyPredicate.ComparisonOperator.EQUAL, (Object)ManagedObjectUtil.stringToMoref((String)filterParams[0]));
        return new Filter(Arrays.asList(clusterRelationPredicate, this.getWcpPortGroupCompatiblePredicate()));
    }

    @QueryFilter(value="compatible-port-groups-zones")
    public Filter getCompatiblePortGroupsInZonesFilter(String objectId, String[] filterParams) {
        if (objectId == null || filterParams == null || filterParams.length < 0) {
            return new Filter(Collections.emptyList());
        }
        ArrayList<PropertyPredicate> zonesPredicates = new ArrayList<PropertyPredicate>();
        for (String filterParam : filterParams) {
            PropertyPredicate zonePredicate = new PropertyPredicate(PROPERTY_ZONES, PropertyPredicate.ArrayOperator.ANY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)filterParam);
            zonesPredicates.add(zonePredicate);
        }
        zonesPredicates.add(this.getVcPredicate(objectId));
        zonesPredicates.add(this.getWcpPortGroupCompatiblePredicate());
        return new Filter(zonesPredicates, LogicalOperator.AND);
    }

    private PropertyPredicate getWcpPortGroupCompatiblePredicate() {
        return new PropertyPredicate(PROPERTY_WCP_COMPATIBLE, PropertyPredicate.ComparisonOperator.EQUAL, (Object)true);
    }

    private PropertyPredicate getVcPredicate(String vcId) {
        Object obj = this._objectReferenceService.getReference(vcId, true);
        String serverGuid = this._objectReferenceService.getServerGuid(obj);
        return new PropertyPredicate(PROPERTY_INSTANCE_UUID, PropertyPredicate.ComparisonOperator.EQUAL, (Object)serverGuid);
    }
}

