/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.tagging;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.common.UnexpectedStatusCodeException;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.metadata.PropertyDescriptor;
import com.vmware.vise.metadata.TypeDescriptor;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ServiceEndpointType;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

public class Util {
    private static final String RESOURCE_BUNDLE_NAME = "TaggingService";
    private static final String MANAGED_ENTITY_TYPE = "ManagedEntity";
    private static final String TAG_CATEGORY_PROP = "category";
    private static final String TAG_CATEGORY_TYPE = "inventoryservice:InventoryServiceCategory";
    private static final String TAG_CATEGORY_MULTIPLE_CARDINALITY_PROP = "multipleCardinality";
    private static final String TAG_CATEGORY_CHILD_TAGS_PROP = "childTags";
    private static final String TAG_TYPE = "inventoryservice:InventoryServiceTag";
    private static final String TAG_PROP = "inventoryservice:tag";
    public static final String GLOBAL_SERVER_ID = "GLOBAL";

    public static String getLocalizedString(String key) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)key, (ClassLoader)Util.class.getClassLoader());
    }

    public static String getLocalizedString(String key, String[] args) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)key, (String[])args, (ClassLoader)Util.class.getClassLoader());
    }

    public static void checkValidQuerySpec(QuerySpec spec, Class<?>[] supportedconstraints) {
        if (spec == null) {
            throw new IllegalArgumentException("spec");
        }
        if (spec.resourceSpec == null) {
            throw new IllegalArgumentException("spec.resourceSpec");
        }
        boolean supported = false;
        for (Class<?> c : supportedconstraints) {
            if (!c.isInstance(spec.resourceSpec.constraint)) continue;
            supported = true;
        }
        if (!supported) {
            throw new IllegalArgumentException("spec.resourceSpec.constraint");
        }
    }

    public static void checkNotNull(Object obj, String name) {
        if (obj == null) {
            throw new IllegalArgumentException(name);
        }
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?>[] classes) {
        LinkedList<PropertyDescriptor> result = new LinkedList<PropertyDescriptor>();
        for (Class<?> c : classes) {
            for (Field f : c.getFields()) {
                String propNameKey = String.format("${%s}", f.getName());
                PropertyDescriptor p = new PropertyDescriptor();
                p.name = f.getName();
                p.title = propNameKey;
                p.description = propNameKey;
                p.isOptional = true;
                p.providerName = c.getName();
                p.valueTypeName = f.getType().getName();
                result.add(p);
            }
        }
        return result.toArray(new PropertyDescriptor[result.size()]);
    }

    public static String[] getPropertyNames(Class<?> clazz) {
        LinkedList<String> result = new LinkedList<String>();
        for (Field f : clazz.getFields()) {
            result.add(f.getName());
        }
        return result.toArray(new String[result.size()]);
    }

    public static TypeDescriptor[] getTypeDescriptors(String[] types) {
        LinkedList<TypeDescriptor> result = new LinkedList<TypeDescriptor>();
        for (String type : types) {
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("userSearchable", "true");
            String typeNameKey = String.format("${%s}", type);
            TypeDescriptor t = new TypeDescriptor();
            t.title = typeNameKey;
            t.description = typeNameKey;
            t.name = type;
            t.tags = tags;
            result.add(t);
        }
        return result.toArray(new TypeDescriptor[result.size()]);
    }

    public static VcService getVcServiceByUuid(String serviceUuid) {
        if (serviceUuid == null) {
            throw new IllegalArgumentException(Util.getLocalizedString("error.invalidVcUuid", new String[]{serviceUuid}));
        }
        LinkedVcGroupRegistry registry = VimSessionUtil.getLinkedVcGroupRegistry();
        LinkedVcGroup group = registry.getLinkedGroupByServiceUuid(serviceUuid);
        for (VcService service : group.getVcServices()) {
            ServiceEndpointEx[] endpoints;
            if (service.getServiceGuid().equals(serviceUuid)) {
                return service;
            }
            for (ServiceEndpointEx sep : endpoints = service.getServiceEndPoints()) {
                if (!sep.getInstanceUuid().equals(serviceUuid) || sep.getServiceEndpointType() != ServiceEndpointType.IS) continue;
                return service;
            }
        }
        throw new IllegalArgumentException(Util.getLocalizedString("error.invalidVcUuid", new String[]{serviceUuid}));
    }

    public static URI toURI(Object resource) throws URISyntaxException {
        return new URI(QueryUtil.getReferenceUid((Object)resource));
    }

    public static Object[] filterAssignedObjects(DataService dataService, ManagedObjectReference tag, Object[] potentialTargets) throws Exception {
        ResultItem[] items;
        if (potentialTargets == null || potentialTargets.length == 0) {
            return new Object[0];
        }
        Constraint[] identities = new Constraint[potentialTargets.length];
        for (int i = 0; i < potentialTargets.length; ++i) {
            Object target = potentialTargets[i];
            identities[i] = QueryUtil.createObjectIdentityConstraint((Object)target);
        }
        CompositeConstraint potentials = QueryUtil.createCompositeConstraint((Constraint[])identities, (Conjoiner)Conjoiner.OR);
        RelationalConstraint exclusions = QueryUtil.createRelationalConstraint((String)TAG_PROP, (Constraint)QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{QueryUtil.createObjectIdentityConstraint((Object)tag), QueryUtil.createRelationalConstraint((String)TAG_CATEGORY_PROP, (Constraint)QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{QueryUtil.createPropertyConstraint((String)TAG_CATEGORY_TYPE, (String)TAG_CATEGORY_MULTIPLE_CARDINALITY_PROP, (Comparator)Comparator.EQUALS, (Object)false), QueryUtil.createRelationalConstraint((String)TAG_CATEGORY_CHILD_TAGS_PROP, (Constraint)QueryUtil.createObjectIdentityConstraint((Object)tag), (Boolean)false, (String)TAG_CATEGORY_TYPE)}, (Conjoiner)Conjoiner.AND), (Boolean)false, (String)TAG_TYPE)}, (Conjoiner)Conjoiner.OR), (Boolean)false, (String)MANAGED_ENTITY_TYPE);
        CompositeConstraint filtered = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{potentials, exclusions}, (Conjoiner)Conjoiner.EXCEPT);
        QuerySpec query = QueryUtil.buildQuerySpec((Constraint)filtered, (String[])new String[]{"name"});
        ResultSet resultSet = QueryUtil.getData((DataService)dataService, (QuerySpec)query);
        ArrayList<Object> resultObjects = new ArrayList<Object>();
        if (resultSet != null && (items = resultSet.items) != null && items.length > 0 && items[0] != null) {
            for (ResultItem item : items) {
                resultObjects.add(item.resourceObject);
            }
        }
        return resultObjects.toArray(new Object[resultObjects.size()]);
    }

    public static String formatLogMessage(String endpointUri, String formatText, Object ... args) {
        String msg = String.format(formatText, args);
        String formatttedMsg = String.format("[Server: %1$s] %2$s", endpointUri, msg);
        return formatttedMsg;
    }

    public static boolean isServiceUnavailable(Throwable e) {
        return e instanceof UnexpectedStatusCodeException && ((UnexpectedStatusCodeException)e).getStatusCode() == 503;
    }
}

