/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.provisioning.impl;

import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataException;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.data.uri.resolve.DefaultUriSchemeUtil;
import com.vmware.vise.util.Pair;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vsphere.client.common.data.DataProviderAdapterBase;
import com.vmware.vsphere.client.provisioning.spec.AuthenticationRequirement;
import com.vmware.vsphere.client.provisioning.spec.CredentialsSource;
import com.vmware.vsphere.client.provisioning.spec.HttpResourceProbeResult;
import com.vmware.vsphere.client.provisioning.spec.ProbeStatus;
import com.vmware.vsphere.client.provisioning.spec.TransferSourceProbeResult;
import com.vmware.vsphere.client.provisioning.spec.TransferSourceStatus;
import com.vmware.vsphere.client.provisioning.util.HttpResourceProber;
import com.vmware.vsphere.client.provisioning.util.ProvisioningServiceUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@type(value="com.vmware.vsphere.client.TransferSource")
public class TransferSourcePropertyProvider
extends DataProviderAdapterBase {
    private static final Log _logger = LogFactory.getLog(TransferSourcePropertyProvider.class);
    private static final String UTF_8 = "UTF-8";
    public static final String PROPERTY_SOURCE_PROBE = "sourceProbe";
    private static final int DEFAULT_PROBE_TIMEOUT_IN_MS = 10000;
    private static final Set<String> SUPPORTED_PROPERTIES = new HashSet<String>();
    private static final Set<String> SUPPORTED_SOURCE_SCHEMES = new HashSet<String>();
    private final HttpResourceProber _httpProber;

    public TransferSourcePropertyProvider(KeystoreService keystoreService) {
        this._httpProber = HttpResourceProber.newInstance(keystoreService != null ? keystoreService.getKeyStore() : null);
        this._httpProber.setTimeout(10000);
    }

    public void setProbeTimeout(int timeout) {
        if (this._httpProber == null) {
            throw new IllegalStateException("Not initialized when setting timeout");
        }
        this._httpProber.setTimeout(timeout);
    }

    public int getProbeTimeout() {
        if (this._httpProber == null) {
            throw new IllegalStateException("Not initialized when setting timeout");
        }
        return this._httpProber.getTimeout();
    }

    protected ResultSet processQuery(ObjectIdentityConstraint constraint, QuerySpec parentQuery) throws Exception {
        return this.getProperties(constraint.target, parentQuery.resourceSpec.propertySpecs);
    }

    private ResultSet getProperties(Object object, PropertySpec[] properties) {
        List<PropertyRetrievalSpec> supportedProperties = this.getSupportedProperties(properties);
        if (supportedProperties.isEmpty()) {
            return ResultUtil.newEmptyResultSet();
        }
        assert (supportedProperties.size() == 1);
        PropertyRetrievalSpec retrievalSpec = supportedProperties.get(0);
        assert (PROPERTY_SOURCE_PROBE.equals(retrievalSpec.propertyName)) : "Unknown property " + retrievalSpec.propertyName;
        ResultSet resultSet = new ResultSet();
        try {
            TransferSourceProbeResult result = this.getProbeResult(object, retrievalSpec.parameters);
            PropertyValue propertyValue = ResultUtil.newProperty((String)PROPERTY_SOURCE_PROBE, (Object)result, (Object)object);
            resultSet.items = new ResultItem[]{this.newResultItem(object, propertyValue)};
            resultSet.totalMatchedObjectCount = 1;
        }
        catch (Exception error) {
            _logger.error((Object)("Exception probing " + (object == null ? "null" : object.toString()) + ": "), (Throwable)error);
            Exception ise = new Exception(this.getString("error.transferSourceProbe.internalError", new String[0]), error);
            resultSet.error = DataException.newInstance((Throwable)ise, (Object)object, (String)retrievalSpec.propertyName);
            resultSet.items = new ResultItem[]{this.newResultItem(object, new PropertyValue[0])};
            resultSet.totalMatchedObjectCount = 1;
        }
        return resultSet;
    }

    private TransferSourceProbeResult getProbeResult(Object target, List<Object> parameters) throws Exception {
        URI probeTarget;
        TransferSourceProbeResult result = new TransferSourceProbeResult();
        result.source = probeTarget = this.extractProbeTarget(target);
        if (probeTarget == null || probeTarget.getScheme() == null || probeTarget.getHost() == null) {
            result.errorMessage = this.getString("transferSource.error.invalidSource", new String[0]);
            result.probePerformed = false;
        } else if (!SUPPORTED_SOURCE_SCHEMES.contains(probeTarget.getScheme())) {
            result.errorMessage = this.getString("transferSource.error.unsupportedScheme", new String[0]);
            result.probePerformed = false;
        } else {
            Pair<String, String> credentialsParam = this.getCredentials(parameters);
            if (this.uriContainsBasicAuthCredentials(probeTarget)) {
                result.credentialsSource = CredentialsSource.SOURCE_URL;
                if (credentialsParam != null) {
                    _logger.debug((Object)"Dual credentials specified. Using URL source.");
                }
            } else {
                result.credentialsSource = credentialsParam != null ? CredentialsSource.REQUEST_PARAMETER : CredentialsSource.NONE;
            }
            HttpResourceProbeResult probe = null;
            probe = CredentialsSource.REQUEST_PARAMETER.equals((Object)result.credentialsSource) ? this._httpProber.probe(probeTarget, (String)credentialsParam.first, (String)credentialsParam.second) : this._httpProber.probe(probeTarget);
            result.probePerformed = true;
            result.authenticationRequirement = probe.authenticationRequirement;
            if (ProbeStatus.SUCCESS.equals((Object)probe.status)) {
                this.populateResultFromProbe(result, probe);
            } else {
                result.errorMessage = this.getProbeStatusErrorMessage(probe.status);
                result.status = TransferSourceStatus.ERROR;
            }
        }
        return result;
    }

    private URI extractProbeTarget(Object transferSource) throws Exception {
        if (transferSource == null) {
            return null;
        }
        URI result = null;
        try {
            URI resourceObject = transferSource instanceof URI ? (URI)transferSource : new URI(transferSource.toString());
            String sourceUid = DefaultUriSchemeUtil.getId((URI)resourceObject).replaceAll("\\+", "%2B");
            String decodeSource = URLDecoder.decode(sourceUid, UTF_8);
            String encodeSpaces = this.encodeWhitespaces(decodeSource);
            result = new URI(encodeSpaces);
        }
        catch (URISyntaxException ex) {
            _logger.debug((Object)("Probe target " + transferSource.toString() + " is not a valid URI"), (Throwable)ex);
        }
        return result;
    }

    private List<PropertyRetrievalSpec> getSupportedProperties(PropertySpec[] properties) {
        if (ArrayUtils.isEmpty((Object[])properties)) {
            return Collections.emptyList();
        }
        ArrayList<PropertyRetrievalSpec> result = new ArrayList<PropertyRetrievalSpec>();
        for (PropertySpec property : properties) {
            if (StringUtils.isNotEmpty((String)property.relation)) continue;
            Map<String, List<Object>> paramsByPropertyName = this.orderParameters(property.parameters);
            for (String propertyName : property.propertyNames) {
                if (!SUPPORTED_PROPERTIES.contains(propertyName)) continue;
                PropertyRetrievalSpec spec = new PropertyRetrievalSpec();
                spec.propertyName = propertyName;
                if (paramsByPropertyName.containsKey(propertyName)) {
                    spec.parameters = paramsByPropertyName.get(propertyName);
                }
                result.add(spec);
            }
        }
        return result;
    }

    private Map<String, List<Object>> orderParameters(ParameterSpec[] paramSpecs) {
        if (ArrayUtils.isEmpty((Object[])paramSpecs)) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Object>> result = new HashMap<String, List<Object>>();
        for (ParameterSpec paramSpec : paramSpecs) {
            if (paramSpec.parameter == null) continue;
            if (!result.containsKey(paramSpec.propertyName)) {
                result.put(paramSpec.propertyName, new ArrayList());
            }
            ((List)result.get(paramSpec.propertyName)).add(paramSpec.parameter);
        }
        return result;
    }

    private Pair<String, String> getCredentials(List<Object> parameters) throws Exception {
        if (CollectionUtils.isEmpty(parameters)) {
            return null;
        }
        for (Object obj : parameters) {
            if (!Map.class.isAssignableFrom(obj.getClass())) continue;
            Map param = (Map)obj;
            Object encodedUsername = param.get("username");
            Object encodedPassword = param.get("password");
            if (encodedUsername == null || encodedPassword == null || !(encodedUsername instanceof String) || !(encodedPassword instanceof String)) continue;
            String username = URLDecoder.decode((String)encodedUsername, UTF_8);
            String password = URLDecoder.decode((String)encodedPassword, UTF_8);
            return new Pair((Object)username, (Object)password);
        }
        return null;
    }

    private void populateResultFromProbe(TransferSourceProbeResult result, HttpResourceProbeResult probe) {
        if (probe.responseCode >= 200 && probe.responseCode < 300) {
            result.status = TransferSourceStatus.READY;
        } else if (probe.responseCode == 401) {
            if (AuthenticationRequirement.OTHER.equals((Object)probe.authenticationRequirement) || AuthenticationRequirement.UNKNOWN.equals((Object)probe.authenticationRequirement)) {
                result.status = TransferSourceStatus.ERROR;
                result.errorMessage = this.getString("transferSource.responseCode.401.authenticationMethodNotSupport", new String[0]);
            } else {
                result.status = TransferSourceStatus.UNAUTHENTICATED;
                if (result.credentialsSource == CredentialsSource.SOURCE_URL) {
                    result.errorMessage = this.getString("transferSource.responseCode.401.authFailed.urlCredentials", new String[0]);
                } else if (CredentialsSource.REQUEST_PARAMETER.equals((Object)result.credentialsSource)) {
                    result.errorMessage = this.getString("transferSource.responseCode.401.authFailed", new String[0]);
                } else {
                    _logger.debug((Object)"Source not authenticated. No credentials provided.");
                }
            }
        } else {
            result.status = TransferSourceStatus.ERROR;
            result.errorMessage = this.getProbeResponseCodeError(probe.responseCode);
        }
    }

    private String getProbeStatusErrorMessage(ProbeStatus status) {
        assert (status != ProbeStatus.SUCCESS) : "Not an error status";
        switch (status) {
            case INVALID_SOURCE: {
                return this.getString("transferSource.error.invalidSource", new String[0]);
            }
            case FAILURE: {
                return this.getString("transferSource.error.unknownError", new String[0]);
            }
            case IO_ERROR: {
                return this.getString("transferSource.error.ioError", new String[0]);
            }
            case SSL_ERROR: {
                return this.getString("transferSource.error.sslError", new String[0]);
            }
            case TIMEOUT: {
                return this.getString("transferSource.error.timeout", new String[0]);
            }
            case UNKNOWN_HOST: {
                return this.getString("transferSource.error.unknownHost", new String[0]);
            }
        }
        _logger.error((Object)("Unexpected probe status: " + (Object)((Object)status)));
        return this.getString("error.transferSourceProbe.internalError", new String[0]);
    }

    private String getProbeResponseCodeError(Integer responseCode) {
        assert (responseCode < 200 || responseCode >= 300) : "2xx response code";
        switch (responseCode) {
            case 300: {
                return this.getString("transferSource.responseCode.3x.multipleChoices", new String[0]);
            }
            case 301: 
            case 302: 
            case 303: {
                return this.getString("transferSource.responseCode.3x.moved", new String[0]);
            }
            case 305: {
                return this.getString("transferSource.responseCode.3x.proxied", new String[0]);
            }
            case 307: {
                return this.getString("transferSource.responseCode.3x.temporarilyMoved", new String[0]);
            }
            case 400: {
                return this.getString("transferSource.responseCode.4x.badRequest", new String[0]);
            }
            case 403: {
                return this.getString("transferSource.responseCode.4x.forbidden", new String[0]);
            }
            case 404: {
                return this.getString("transferSource.responseCode.4x.notFound", new String[0]);
            }
            case 410: {
                return this.getString("transferSource.responseCode.4x.removed", new String[0]);
            }
            case 500: 
            case 502: 
            case 503: 
            case 504: {
                return this.getString("transferSource.responseCode.5x.serverError", new String[0]);
            }
            case 405: 
            case 501: 
            case 505: {
                return this.getString("transferSource.responseCode.probeMethodNotAllowed", new String[0]);
            }
        }
        return this.getString("transferSource.responseCode.unexpected", responseCode.toString());
    }

    private boolean uriContainsBasicAuthCredentials(URI uri) {
        String[] credentials = StringUtils.split((String)uri.getUserInfo(), (String)":");
        return credentials != null && credentials.length == 2;
    }

    private String getString(String key, String ... params) {
        return ProvisioningServiceUtil.getLocalizedString(key, params);
    }

    private ResultItem newResultItem(Object resourceObject, PropertyValue ... properties) {
        ResultItem resultItem = new ResultItem();
        resultItem.properties = properties;
        resultItem.resourceObject = resourceObject;
        return resultItem;
    }

    private String encodeWhitespaces(String uri) {
        String result = uri.replaceAll(" ", "%20");
        return result;
    }

    static {
        SUPPORTED_PROPERTIES.add(PROPERTY_SOURCE_PROBE);
        SUPPORTED_SOURCE_SCHEMES.add("http");
        SUPPORTED_SOURCE_SCHEMES.add("https");
    }

    private static class PropertyRetrievalSpec {
        public String propertyName;
        public List<Object> parameters;

        private PropertyRetrievalSpec() {
        }
    }
}

