/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.libraryItem.specs;

import com.vmware.vise.core.model.annotation.optional;
import java.net.URI;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;

public class ImportLibraryItemSpec {
    public URI source;
    public URI[] multipleSources;
    public String sslThumbprint;
    public URI target;
    public String transferType;
    public String itemName;
    @optional
    public String itemDescription;
    public boolean addManifest;
    public boolean addCertificate;
    @optional
    public boolean isUpdate = false;
    @optional
    public String serverGuid;

    public String toString() {
        return this.getStringRepresentation(this.source.toString(), Arrays.toString(this.multipleSources));
    }

    public String toLogString() {
        if (this.source.getUserInfo() == null && ArrayUtils.isEmpty((Object[])this.multipleSources)) {
            return this.toString();
        }
        StringBuilder sourceBuilder = new StringBuilder();
        if (this.source.getUserInfo() != null) {
            sourceBuilder.append(this.source.getScheme()).append("://").append("***:***@").append(this.source.getHost()).append(this.source.getPort()).append(this.source.getPath()).append(this.source.getQuery()).append(this.source.getFragment());
        }
        StringBuilder sourcesBuilder = new StringBuilder();
        if (!ArrayUtils.isEmpty((Object[])this.multipleSources)) {
            for (URI sourceItem : this.multipleSources) {
                sourcesBuilder.append(sourceItem.getScheme()).append("://").append("***:***@").append(sourceItem.getHost()).append(sourceItem.getPort()).append(sourceItem.getPath()).append(sourceItem.getQuery()).append(sourceItem.getFragment());
            }
        }
        return this.getStringRepresentation(sourceBuilder.toString(), sourcesBuilder.toString());
    }

    private String getStringRepresentation(String source, String sources) {
        StringBuilder builder = new StringBuilder();
        builder.append("LibraryItemImportSpec [source=").append(source).append(", multipleSources=").append(sources).append(", target=").append(this.target).append(", itemName=").append(this.itemName).append(", transferType=").append(this.transferType).append(", itemDescription=").append(this.itemDescription).append(", addManifest=").append(this.addManifest).append(", addCertificate=").append(this.addCertificate).append("]");
        return builder.toString();
    }
}

