/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.config.impl;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.vim.binding.vim.host.BIOSInfo;
import com.vmware.vim.binding.vim.host.BmcInfo;
import com.vmware.vim.binding.vim.host.SystemInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vsphere.client.h5.host.config.HostSystemFirmwareDetailsItem;
import com.vmware.vsphere.client.h5.host.model.HostSystemFirmwareDetailsData;
import com.vmware.vsphere.client.h5.host.util.HostStringUtil;
import org.apache.commons.lang3.StringUtils;

public class HostSystemFirmwareDetailsPropertyProvider
implements PropertyProviderBean {
    private final QueryBindingService _queryBindingService;

    public HostSystemFirmwareDetailsPropertyProvider(QueryBindingService queryBindingService) {
        this._queryBindingService = queryBindingService;
    }

    @PropertyProvider(value="HostSystem/hostSystemFirmwareDetails")
    public HostSystemFirmwareDetailsItem getHostSystemFirmwareDetails(ManagedObjectReference hostMor) {
        if (hostMor == null) {
            return null;
        }
        HostSystemFirmwareDetailsItem hostSystemData = new HostSystemFirmwareDetailsItem();
        HostSystemFirmwareDetailsData hostSystemFirmwareDetailsData = (HostSystemFirmwareDetailsData)((Object)this._queryBindingService.prepare(HostSystemFirmwareDetailsData.class).fetch((Object)hostMor));
        BIOSInfo biosInfo = null;
        BmcInfo bmcInfo = null;
        SystemInfo systemInfo = null;
        if (hostSystemFirmwareDetailsData != null) {
            biosInfo = hostSystemFirmwareDetailsData.biosInfo;
            bmcInfo = hostSystemFirmwareDetailsData.bmcInfo;
            systemInfo = hostSystemFirmwareDetailsData.systemInfo;
            if (biosInfo != null) {
                hostSystemData.biosManufacturer = HostSystemFirmwareDetailsPropertyProvider.getItemLabel(biosInfo.vendor);
                hostSystemData.biosVersion = HostSystemFirmwareDetailsPropertyProvider.getItemLabel(biosInfo.biosVersion);
            } else {
                hostSystemData.biosManufacturer = HostStringUtil.getString("host.hardware.firmware.na.label", new String[0]);
                hostSystemData.biosVersion = HostStringUtil.getString("host.hardware.firmware.na.label", new String[0]);
            }
            if (bmcInfo != null) {
                hostSystemData.ipmiVersion = HostSystemFirmwareDetailsPropertyProvider.getItemLabel(bmcInfo.ipmiVersion);
                hostSystemData.bmcManufacturer = HostSystemFirmwareDetailsPropertyProvider.getItemLabel(bmcInfo.manufacturer);
                hostSystemData.bmcFirmwareVersion = HostSystemFirmwareDetailsPropertyProvider.getItemLabel(bmcInfo.bmcVersion);
            } else {
                hostSystemData.ipmiVersion = HostStringUtil.getString("host.hardware.firmware.na.label", new String[0]);
                hostSystemData.bmcManufacturer = HostStringUtil.getString("host.hardware.firmware.na.label", new String[0]);
                hostSystemData.bmcFirmwareVersion = HostStringUtil.getString("host.hardware.firmware.na.label", new String[0]);
            }
            hostSystemData.motherboardModel = systemInfo != null ? HostSystemFirmwareDetailsPropertyProvider.getItemLabel(systemInfo.model) : HostStringUtil.getString("host.hardware.firmware.na.label", new String[0]);
        }
        return hostSystemData;
    }

    private static String getItemLabel(String propertyValue) {
        return StringUtils.isNotEmpty((CharSequence)propertyValue) ? propertyValue : HostStringUtil.getString("host.hardware.firmware.na.label", new String[0]);
    }
}

