/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.config.impl;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.ConfigManager;
import com.vmware.vim.binding.vim.host.FirewallSystem;
import com.vmware.vim.binding.vim.host.Service;
import com.vmware.vim.binding.vim.host.ServiceSystem;
import com.vmware.vim.binding.vim.host.VirtualNicManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.h5.host.config.spec.PtpTimeConfigSpec;
import com.vmware.vsphere.client.h5.host.config.spec.TimeConfigSpec;
import com.vmware.vsphere.client.h5.host.util.HostStringUtil;
import com.vmware.vsphere.client.h5.host.util.TimeConfigUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PtpTimeConfigMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(PtpTimeConfigMutationProvider.class);
    private static final String PTP_NIC_TYPE = "ptp";
    private static final String PTP_SERVICE_KEY = "ptpd";

    public OperationResult apply(ManagedObjectReference mor, PtpTimeConfigSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = mor;
        if (spec == null) {
            String nullPtpSpecMsg = HostStringUtil.getString("error.nullPtpTimeConfigSpec", new String[0]);
            result.error = new IllegalArgumentException(nullPtpSpecMsg);
            return result;
        }
        try {
            HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)mor);
            if (host == null) {
                return null;
            }
            ConfigManager configManager = host.getConfigManager();
            if (spec.enablePtpClient != null) {
                ManagedObjectReference serviceSystemMor = configManager.getServiceSystem();
                ServiceSystem system = (ServiceSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)serviceSystemMor);
                Service ptpService = TimeConfigUtil.getService(system, PTP_SERVICE_KEY);
                ManagedObjectReference firewallSystemMor = configManager.getFirewallSystem();
                if (firewallSystemMor != null) {
                    FirewallSystem firewallSystem = (FirewallSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)firewallSystemMor);
                    TimeConfigUtil.enableService(spec.enablePtpClient, firewallSystem, ptpService, PTP_SERVICE_KEY);
                    if (!spec.enablePtpClient.booleanValue() && ptpService.running) {
                        TimeConfigUtil.changeServiceState(PTP_SERVICE_KEY, TimeConfigSpec.Action.stop, system);
                    }
                }
            }
            if (spec.vnic != null && spec.vnicKey != null && configManager.getVirtualNicManager() != null) {
                ManagedObjectReference vnicManagerMor = configManager.getVirtualNicManager();
                VirtualNicManager vNicManager = (VirtualNicManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vnicManagerMor);
                vNicManager.selectVnic(PTP_NIC_TYPE, spec.vnic);
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Setting PTP Time configuration failed", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }
}

