/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.hardware.ciminfo;

import com.vmware.identity.token.impl.SecureXmlParserFactory;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.cimdataadapter.CimData;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.util.CimMonitorUtil;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HostCimInfoPropertyProvider
implements PropertyProviderBean {
    private static final Log logger = LogFactory.getLog(HostCimInfoPropertyProvider.class);
    private QueryExecutor _queryExecutor;
    private CimData _cimData;

    public HostCimInfoPropertyProvider(QueryExecutor queryExecutor) {
        this._queryExecutor = queryExecutor;
    }

    public void setCimData(CimData cimData) {
        this._cimData = cimData;
    }

    @type(value="HostSystem")
    public String getHardwareStatusXml(ManagedObjectReference hostRef) throws Exception {
        String rawCimXmlData = this.getHardwareStatusData(hostRef);
        Document document = this.parseAndNormalizeXml(rawCimXmlData);
        String xmlString = this.transformAndFormatXmlToString(document);
        return xmlString;
    }

    private String getHardwareStatusData(ManagedObjectReference hostRef) throws Exception {
        OperationResult operationResult = this.getHardwareStatusOperationResult(hostRef);
        String rawCimXmlData = "";
        if (operationResult == null || operationResult.error != null || operationResult.result == null) {
            logger.error((Object)"Cannot read cim host data.");
        } else {
            rawCimXmlData = (String)operationResult.result;
        }
        return rawCimXmlData;
    }

    private OperationResult getHardwareStatusOperationResult(ManagedObjectReference hostRef) throws Exception {
        OperationResult result = new OperationResult();
        result.entity = hostRef;
        try {
            String cimData = this._cimData.getData(hostRef);
            if (StringUtils.isEmpty((CharSequence)cimData)) {
                logger.error((Object)"Unable to retrive runtime health information from host");
            }
            result.result = cimData;
        }
        catch (Exception exception) {
            logger.error((Object)"Failed to retrieve host data!", (Throwable)exception);
            result.error = CimMonitorUtil.getLocalizedException("httpError");
        }
        return result;
    }

    private Document parseAndNormalizeXml(String rawCimXmlData) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        SecureXmlParserFactory factory = new SecureXmlParserFactory();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(rawCimXmlData)));
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList nodeList = (NodeList)xPath.evaluate("//text()[normalize-space()='']", document, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            node.getParentNode().removeChild(node);
        }
        return document;
    }

    private String transformAndFormatXmlToString(Document document) throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        StreamResult result = new StreamResult(new StringWriter());
        DOMSource source = new DOMSource(document);
        transformer.transform(source, result);
        return result.getWriter().toString();
    }
}

