/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.hardware.ciminfo.impl;

import com.vmware.vim.binding.vim.host.Fru;
import com.vmware.vim.binding.vim.host.HardwareStatusInfo;
import com.vmware.vim.binding.vim.host.HealthStatusSystem;
import com.vmware.vim.binding.vim.host.NumericSensorInfo;
import com.vmware.vim.binding.vim.host.ServiceInfo;
import com.vmware.vim.binding.vim.host.SystemEventInfo;
import com.vmware.vim.binding.vim.host.SystemIdentificationInfo;
import com.vmware.vim.binding.vim.host.SystemInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.DateParserAndFormatter;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.ChassisData;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.DpuSensorData;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.FieldReplaceableUnit;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.HealthStatus;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.HostCimData;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.HostHardwareHealthData;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.Sensor;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.SensorComparator;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.SensorStatus;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.StorageSensorData;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.SystemEventData;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.reader.CimMessageReader;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.sensors.details.SensorValueParser;
import com.vmware.vsphere.client.h5.host.util.HostStringUtil;
import com.vmware.vsphere.client.h5.host.util.TimeConfigUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostHardwareHealthUtil {
    private static final String SERVICE_TAG = "ServiceTag";
    private static final String ENCLOSURE_SERIAL_NUMBER = "EnclosureSerialNumberTag";
    private static final String ASSET_TAG = "AssetTag";
    private static final String ASSET_TAG_REPORTING_STRING = "Asset Tag: ";
    private static final String SFCBD_SERVICE_KEY = "sfcbd-watchdog";
    private static final String NAME_DELIM = "---";
    private static final String EMPTY_VALUE = "--";
    private static final Log logger = LogFactory.getLog(HostHardwareHealthUtil.class);
    private static final Map<String, String> baseUnitsMap = new HashMap<String, String>();
    private static final Map<String, String> rateUnitsMap = new HashMap<String, String>();

    static HostCimData createHostCimData(HostHardwareHealthData hostHardwareHealthData) {
        HostCimData hostCimData = new HostCimData();
        HashMap<Long, Long> sensorNumberSelCountMap = new HashMap<Long, Long>();
        hostCimData.systemEventLog = HostHardwareHealthUtil.createSystemEventLog(hostHardwareHealthData.healthStatusSystem, sensorNumberSelCountMap);
        hostCimData.sensors = HostHardwareHealthUtil.buildSensors(hostHardwareHealthData, hostCimData, sensorNumberSelCountMap, (ManagedObjectReference)hostHardwareHealthData.provider);
        hostCimData.storageSensorsData = HostHardwareHealthUtil.buildStorageSensorsData(hostHardwareHealthData.storageStatusInfo);
        ServiceInfo services = hostHardwareHealthData.serviceInfo;
        hostCimData.sfcbdService = TimeConfigUtil.getService(services, SFCBD_SERVICE_KEY);
        hostCimData.dpuSensorsData = HostHardwareHealthUtil.buildDpuSensorsData(hostHardwareHealthData.dpuStatusInfo);
        return hostCimData;
    }

    private static List<StorageSensorData> buildStorageSensorsData(HardwareStatusInfo.StorageStatusInfo[] storageStatusInfo) {
        ArrayList<StorageSensorData> storageSensorsData = new ArrayList<StorageSensorData>();
        try {
            if (!ArrayUtils.isEmpty((Object[])storageStatusInfo)) {
                for (HardwareStatusInfo.StorageStatusInfo statusInfo : storageStatusInfo) {
                    if (statusInfo == null) continue;
                    StorageSensorData storageSensorData = new StorageSensorData();
                    storageSensorData.name = HostHardwareHealthUtil.getItemLabel(statusInfo.getName());
                    storageSensorData.health = HostHardwareHealthUtil.getSensorStatus(HostHardwareHealthUtil.getStorageSensorsHealth(statusInfo));
                    storageSensorData.description = HostHardwareHealthUtil.getItemLabel(statusInfo.getStatus().getSummary());
                    storageSensorsData.add(storageSensorData);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Can't get storage status info", (Throwable)e);
        }
        return storageSensorsData;
    }

    public static List<ChassisData> createChassisData(SystemInfo systemInfo) {
        ChassisData chassisData = new ChassisData();
        chassisData.model = systemInfo.getModel();
        chassisData.tag = systemInfo.getUuid();
        Object[] sysIdentificationInfos = systemInfo.getOtherIdentifyingInfo();
        if (ArrayUtils.isNotEmpty((Object[])sysIdentificationInfos)) {
            for (Object sysIdentificationInfo : sysIdentificationInfos) {
                if (ENCLOSURE_SERIAL_NUMBER.equalsIgnoreCase(((SystemIdentificationInfo)sysIdentificationInfo).identifierType.getKey())) {
                    chassisData.enclosureSerialNumber = sysIdentificationInfo.getIdentifierValue();
                    continue;
                }
                if (SERVICE_TAG.equalsIgnoreCase(((SystemIdentificationInfo)sysIdentificationInfo).identifierType.getKey())) {
                    chassisData.serialNumber = sysIdentificationInfo.getIdentifierValue();
                    continue;
                }
                if (!ASSET_TAG.equalsIgnoreCase(((SystemIdentificationInfo)sysIdentificationInfo).identifierType.getKey())) continue;
                chassisData.otherInfo = ASSET_TAG_REPORTING_STRING + sysIdentificationInfo.getIdentifierValue();
            }
        }
        return Collections.singletonList(chassisData);
    }

    private static List<SystemEventData> createSystemEventLog(ManagedObjectReference healthStatusSystemRef, Map<Long, Long> sensorNumberSelCountMap) {
        ArrayList<SystemEventData> systemEventLog = new ArrayList<SystemEventData>();
        try {
            HealthStatusSystem healthStatusSystem = (HealthStatusSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)healthStatusSystemRef);
            Object[] hostSystemEventInfo = healthStatusSystem.FetchSystemEventLog();
            if (ArrayUtils.isNotEmpty((Object[])hostSystemEventInfo)) {
                for (Object sysEventInfo : hostSystemEventInfo) {
                    String id = String.valueOf(sysEventInfo.getSelType());
                    String message = sysEventInfo.getMessage();
                    String rawTimestamp = sysEventInfo.getWhen();
                    Long formattedTimestamp = null;
                    if (StringUtils.isNotEmpty((CharSequence)rawTimestamp)) {
                        formattedTimestamp = new DateParserAndFormatter(rawTimestamp).getTimestamp();
                    }
                    long sensorNumber = sysEventInfo.getSensorNumber();
                    HostHardwareHealthUtil.updateSensorNumberSelCount(sensorNumberSelCountMap, (SystemEventInfo)sysEventInfo);
                    SystemEventData systemEventData = new SystemEventData(id, message, formattedTimestamp, sensorNumber);
                    systemEventLog.add(systemEventData);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Can't get system event log data", (Throwable)e);
        }
        return systemEventLog;
    }

    private static void updateSensorNumberSelCount(Map<Long, Long> sensorNumberSelCountMap, SystemEventInfo sysEventInfo) {
        Long sensorNumber = sysEventInfo.getSensorNumber();
        Long sensorNumberSelCount = sensorNumberSelCountMap.get(sensorNumber);
        if (sensorNumberSelCount == null) {
            sensorNumberSelCount = 0L;
        }
        Long l = sensorNumberSelCount;
        Long l2 = sensorNumberSelCount = Long.valueOf(sensorNumberSelCount + 1L);
        sensorNumberSelCountMap.put(sensorNumber, sensorNumberSelCount);
    }

    private static List<DpuSensorData> buildDpuSensorsData(HardwareStatusInfo.DpuStatusInfo[] dpuStatusInfo) {
        ArrayList<DpuSensorData> dpuSensorsData = new ArrayList<DpuSensorData>();
        try {
            if (ArrayUtils.isEmpty((Object[])dpuStatusInfo)) {
                return dpuSensorsData;
            }
            for (HardwareStatusInfo.DpuStatusInfo statusInfo : dpuStatusInfo) {
                Object[] dpuOpInfoItems;
                if (statusInfo == null || ArrayUtils.isEmpty((Object[])(dpuOpInfoItems = statusInfo.getSensors()))) continue;
                for (Object dpuOpInfo : dpuOpInfoItems) {
                    DpuSensorData dpuSensorData = new DpuSensorData();
                    dpuSensorData.name = HostHardwareHealthUtil.getItemLabel(((HardwareStatusInfo.DpuStatusInfo.OperationalInfo)dpuOpInfo).sensorId);
                    dpuSensorData.status = HostHardwareHealthUtil.getSensorStatus(HostHardwareHealthUtil.getDpuHealthStatus(dpuOpInfo.getHealthState().getKey()));
                    dpuSensorData.reading = dpuOpInfo.getReading().concat(" ").concat(((HardwareStatusInfo.DpuStatusInfo.OperationalInfo)dpuOpInfo).units);
                    dpuSensorData.timestamp = dpuOpInfo.getTimeStamp().getTimeInMillis();
                    dpuSensorsData.add(dpuSensorData);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Can't get dpu status info", (Throwable)e);
        }
        return dpuSensorsData;
    }

    private static List<Sensor> buildSensors(HostHardwareHealthData hostHardwareHealthData, HostCimData hostCimData, Map<Long, Long> sensorNumberSelCountMap, ManagedObjectReference hostRef) {
        ArrayList<Sensor> sensors = null;
        boolean is66VcOrLater = VcServiceUtil.is66VcOrLaterByServerGuid((String)hostRef.getServerGuid());
        Object[] numericSensorsInfo = hostHardwareHealthData.numericSensorsInfo;
        if (ArrayUtils.isNotEmpty((Object[])numericSensorsInfo)) {
            sensors = new ArrayList<Sensor>(numericSensorsInfo.length);
            int id = 0;
            for (Object sensorInfo : numericSensorsInfo) {
                Sensor sensor = new Sensor();
                sensor.id = Integer.toString(id);
                sensor.sensorId = sensorInfo.getId() != null ? sensorInfo.getId() : EMPTY_VALUE;
                sensor.sensorType = StringUtils.capitalize((String)sensorInfo.getSensorType());
                String name = sensorInfo.getName();
                if (name.contains(NAME_DELIM)) {
                    String[] nameArr = name.split(NAME_DELIM);
                    name = nameArr[0].trim();
                }
                sensor.name = name;
                sensor.healthStatus = HostHardwareHealthUtil.getHealthState((NumericSensorInfo)sensorInfo);
                String reading = Long.valueOf(sensorInfo.getCurrentReading()).toString();
                String baseUnit = HostHardwareHealthUtil.parseBaseUnitLabel(HostHardwareHealthUtil.baseUnitsToUI(sensorInfo.getBaseUnits()));
                String rateUnit = HostHardwareHealthUtil.parseRateUnitLabel(HostHardwareHealthUtil.rateUnitsToUI(sensorInfo.getRateUnits()));
                String modifier = Integer.valueOf(sensorInfo.getUnitModifier()).toString();
                sensor.reading = HostHardwareHealthUtil.convertValue(reading, baseUnit, rateUnit, modifier);
                String timestamp = sensorInfo.getTimeStamp();
                if (timestamp != null) {
                    sensor.timestamp = new DateParserAndFormatter(sensorInfo.getTimeStamp()).getTimestamp();
                }
                sensor.selEntries = HostHardwareHealthUtil.getSelEntriesCount((NumericSensorInfo)sensorInfo, sensorNumberSelCountMap, is66VcOrLater);
                String sensorNumber = HostHardwareHealthUtil.getSensorNumber((NumericSensorInfo)sensorInfo, is66VcOrLater);
                sensor.selEntriesList = HostHardwareHealthUtil.getSensorSelEntriesList(hostCimData.systemEventLog, sensorNumber);
                if (sensorInfo.getRateUnits() != null) {
                    sensor.rateUnits = sensorInfo.getRateUnits();
                }
                if (sensorInfo.getFru() != null) {
                    FieldReplaceableUnit fru = HostHardwareHealthUtil.getSensorFru((NumericSensorInfo)sensorInfo);
                    sensor.fru = HostHardwareHealthUtil.getSensorFruFormatted(fru);
                }
                sensors.add(sensor);
                if (sensor.hasWarning()) {
                    ++hostCimData.sensorCounts.warnings;
                } else if (sensor.hasAlert()) {
                    ++hostCimData.sensorCounts.alerts;
                }
                ++hostCimData.sensorCounts.all;
                if (!sensor.healthStatus.isNormal()) {
                    hostCimData.alertsAndWarnings.add(sensor);
                }
                ++id;
            }
            Collections.sort(sensors, new SensorComparator());
        }
        return sensors;
    }

    private static SensorStatus getSensorStatus(HealthStatus healthStatus) {
        String statusKey = healthStatus.getStatusKey();
        return new SensorStatus(statusKey, HostHardwareHealthUtil.getStatusMessage(statusKey));
    }

    private static String getStatusMessage(String statusKey) {
        return StringUtils.isEmpty((CharSequence)statusKey) ? "" : CimMessageReader.getMessage((String)statusKey);
    }

    private static List<SystemEventData> getSensorSelEntriesList(List<SystemEventData> hostSelEntries, String sensorNumber) {
        List<SystemEventData> allSelEntries = hostSelEntries;
        ArrayList<SystemEventData> sensorSelEntries = new ArrayList<SystemEventData>();
        for (SystemEventData sysEventInfo : allSelEntries) {
            if (sysEventInfo.sensorNumber == 0L || !sensorNumber.equals(String.valueOf(sysEventInfo.sensorNumber))) continue;
            sensorSelEntries.add(sysEventInfo);
        }
        return sensorSelEntries;
    }

    private static Long getSelEntriesCount(NumericSensorInfo sensorInfo, Map<Long, Long> sensorNumberSelCountMap, boolean is66VcOrLater) {
        String sensorNumber = HostHardwareHealthUtil.getSensorNumber(sensorInfo, is66VcOrLater);
        Long selEntriesCount = sensorNumberSelCountMap.get(Long.valueOf(sensorNumber));
        if (selEntriesCount != null) {
            return selEntriesCount;
        }
        return 0L;
    }

    private static String getSensorNumber(NumericSensorInfo sensorInfo, boolean is66VcOrLater) {
        String[] sensorIdParts;
        String sensorNumber = "0";
        if (is66VcOrLater && sensorInfo.getSensorNumber() != null) {
            sensorNumber = String.valueOf(sensorInfo.getSensorNumber());
        } else if (sensorInfo.getId() != null && (sensorIdParts = sensorInfo.getId().split("\\.")).length > 0) {
            sensorNumber = sensorIdParts[sensorIdParts.length - 1];
        }
        return sensorNumber;
    }

    private static String baseUnitsToUI(String unit) {
        String baseUnitKey = baseUnitsMap.get(unit.toLowerCase());
        if (baseUnitKey == null) {
            baseUnitKey = "0";
        }
        return baseUnitKey;
    }

    private static String rateUnitsToUI(String unit) {
        if (unit == null) {
            return "";
        }
        String rateUnitKey = rateUnitsMap.get(unit.toLowerCase());
        if (rateUnitKey == null) {
            rateUnitKey = "0";
        }
        return rateUnitKey;
    }

    private static HealthStatus getHealthState(NumericSensorInfo sensor) {
        if (sensor == null || sensor.getHealthState() == null || sensor.getHealthState().getKey() == null) {
            return HealthStatus.HEALTH_STATUS_UNKNOWN;
        }
        String healthState = sensor.getHealthState().getKey();
        if (healthState.equalsIgnoreCase(NumericSensorInfo.HealthState.green.name())) {
            return HealthStatus.HEALTH_STATUS_OK;
        }
        if (healthState.equalsIgnoreCase(NumericSensorInfo.HealthState.yellow.name())) {
            return HealthStatus.HEALTH_STATUS_WARNING;
        }
        if (healthState.equalsIgnoreCase(NumericSensorInfo.HealthState.red.name())) {
            return HealthStatus.HEALTH_STATUS_ALERT;
        }
        return HealthStatus.HEALTH_STATUS_UNKNOWN;
    }

    private static HealthStatus getDpuHealthStatus(String healthState) {
        if (healthState.equalsIgnoreCase(NumericSensorInfo.HealthState.green.name())) {
            return HealthStatus.HEALTH_STATUS_OK;
        }
        if (healthState.equalsIgnoreCase(NumericSensorInfo.HealthState.yellow.name())) {
            return HealthStatus.HEALTH_STATUS_WARNING;
        }
        if (healthState.equalsIgnoreCase(NumericSensorInfo.HealthState.red.name())) {
            return HealthStatus.HEALTH_STATUS_ALERT;
        }
        return HealthStatus.HEALTH_STATUS_UNKNOWN;
    }

    private static HealthStatus getStorageSensorsHealth(HardwareStatusInfo.StorageStatusInfo statusInfo) {
        if (statusInfo == null || statusInfo.getStatus() == null || statusInfo.getStatus().getKey() == null) {
            return HealthStatus.HEALTH_STATUS_UNKNOWN;
        }
        String health = statusInfo.getStatus().getKey();
        if (health != null) {
            if (health.equalsIgnoreCase(HardwareStatusInfo.Status.Green.name())) {
                return HealthStatus.HEALTH_STATUS_OK;
            }
            if (health.equalsIgnoreCase(HardwareStatusInfo.Status.Yellow.name())) {
                return HealthStatus.HEALTH_STATUS_WARNING;
            }
            if (health.equalsIgnoreCase(HardwareStatusInfo.Status.Red.name())) {
                return HealthStatus.HEALTH_STATUS_ALERT;
            }
        }
        return HealthStatus.HEALTH_STATUS_UNKNOWN;
    }

    public static String convertValue(String value, String baseUnit, String rateUnit, String modifier) {
        String newValue = new SensorValueParser().parseValueWithModifier(value, modifier);
        newValue = newValue + (StringUtils.isNotEmpty((CharSequence)baseUnit) ? " " + baseUnit : "");
        newValue = newValue + (StringUtils.isNotEmpty((CharSequence)rateUnit) ? " " + rateUnit : "");
        return newValue;
    }

    public static String parseBaseUnitLabel(String value) {
        return CimMessageReader.getName((String)("baseunits_" + value));
    }

    public static String parseRateUnitLabel(String value) {
        return CimMessageReader.getName((String)("rateunits_" + value));
    }

    private static FieldReplaceableUnit getSensorFru(NumericSensorInfo sensorInfo) {
        Fru fru = sensorInfo.getFru();
        FieldReplaceableUnit resultFru = new FieldReplaceableUnit();
        resultFru.manufacturer = fru.getManufacturer() != null ? fru.getManufacturer() : "";
        resultFru.type = fru.getType() != null ? fru.getType() : "";
        resultFru.partName = fru.getPartName() != null ? fru.getPartName() : "";
        resultFru.partNumber = fru.getPartNumber() != null ? fru.getPartNumber() : "";
        resultFru.serialNumber = fru.getSerialNumber() != null ? fru.getSerialNumber() : "";
        return resultFru;
    }

    private static String getSensorFruFormatted(FieldReplaceableUnit fru) {
        String resultFru = String.format("%s, %s, %s, %s %s", fru.type, fru.partName, fru.partNumber, fru.manufacturer, fru.serialNumber);
        return StringUtils.isNotEmpty((CharSequence)resultFru) ? resultFru : null;
    }

    private static String getItemLabel(String propertyValue) {
        return StringUtils.isNotEmpty((CharSequence)propertyValue) ? propertyValue : HostStringUtil.getString("host.hardware.firmware.na.label", new String[0]);
    }

    static {
        baseUnitsMap.put("", "");
        baseUnitsMap.put("degrees c", "2");
        baseUnitsMap.put("degrees f", "3");
        baseUnitsMap.put("degrees k", "4");
        baseUnitsMap.put("volts", "5");
        baseUnitsMap.put("amps", "6");
        baseUnitsMap.put("watts", "7");
        baseUnitsMap.put("rpm", "19");
        baseUnitsMap.put("joules", "8");
        baseUnitsMap.put("coulombs", "9");
        baseUnitsMap.put("va", "10");
        baseUnitsMap.put("percentage", "65");
        baseUnitsMap.put("nits", "11");
        baseUnitsMap.put("lumen", "12");
        baseUnitsMap.put("lux", "13");
        baseUnitsMap.put("candela", "14");
        baseUnitsMap.put("kpa", "15");
        baseUnitsMap.put("psi", "16");
        baseUnitsMap.put("newton", "17");
        baseUnitsMap.put("cfm", "18");
        baseUnitsMap.put("hz", "20");
        baseUnitsMap.put("microsecond", "");
        baseUnitsMap.put("millisecond", "");
        baseUnitsMap.put("second", "21");
        baseUnitsMap.put("minute", "22");
        baseUnitsMap.put("hour", "23");
        baseUnitsMap.put("day", "24");
        baseUnitsMap.put("week", "25");
        baseUnitsMap.put("mil", "26");
        baseUnitsMap.put("inches", "27");
        baseUnitsMap.put("feet", "28");
        baseUnitsMap.put("cu in", "29");
        baseUnitsMap.put("cu feet", "30");
        baseUnitsMap.put("mm", "");
        baseUnitsMap.put("cm", "");
        baseUnitsMap.put("m", "31");
        baseUnitsMap.put("cu cm", "");
        baseUnitsMap.put("cu m", "33");
        baseUnitsMap.put("liters", "34");
        baseUnitsMap.put("fluid ounce", "35");
        baseUnitsMap.put("radians", "36");
        baseUnitsMap.put("steradians", "37");
        baseUnitsMap.put("revolutions", "38");
        baseUnitsMap.put("cycles", "39");
        baseUnitsMap.put("gravities", "40");
        baseUnitsMap.put("ounce", "41");
        baseUnitsMap.put("pound", "42");
        baseUnitsMap.put("ft-lb", "43");
        baseUnitsMap.put("oz-in", "44");
        baseUnitsMap.put("gauss", "45");
        baseUnitsMap.put("gilberts", "46");
        baseUnitsMap.put("henry", "47");
        baseUnitsMap.put("millihenry", "");
        baseUnitsMap.put("farad", "48");
        baseUnitsMap.put("microfarad", "");
        baseUnitsMap.put("ohms", "59");
        baseUnitsMap.put("siemens", "50");
        baseUnitsMap.put("mole", "51");
        baseUnitsMap.put("becquerel", "52");
        baseUnitsMap.put("ppm", "53");
        baseUnitsMap.put("reserved", "");
        baseUnitsMap.put("decibels", "54");
        baseUnitsMap.put("dba", "55");
        baseUnitsMap.put("dbc", "56");
        baseUnitsMap.put("gray", "57");
        baseUnitsMap.put("sievert", "58");
        baseUnitsMap.put("color temp deg k", "59");
        baseUnitsMap.put("bit", "60");
        baseUnitsMap.put("kilobit", "");
        baseUnitsMap.put("megabit", "");
        baseUnitsMap.put("gigabit", "");
        baseUnitsMap.put("byte", "61");
        baseUnitsMap.put("kilobyte", "");
        baseUnitsMap.put("megabyte", "");
        baseUnitsMap.put("gigabyte", "");
        baseUnitsMap.put("word", "62");
        baseUnitsMap.put("dword", "63");
        baseUnitsMap.put("qword", "64");
        baseUnitsMap.put("line", "");
        baseUnitsMap.put("hit", "");
        baseUnitsMap.put("miss", "");
        baseUnitsMap.put("retry", "");
        baseUnitsMap.put("reset", "");
        baseUnitsMap.put("overflow", "");
        baseUnitsMap.put("underrun", "");
        baseUnitsMap.put("collision", "");
        baseUnitsMap.put("packets", "");
        baseUnitsMap.put("messages", "");
        baseUnitsMap.put("characters", "");
        baseUnitsMap.put("error", "");
        baseUnitsMap.put("correctable error", "");
        baseUnitsMap.put("uncorrectable error", "");
        rateUnitsMap.put("", "");
        rateUnitsMap.put("per microsecond", "1");
        rateUnitsMap.put("per millisecond", "2");
        rateUnitsMap.put("per second", "3");
        rateUnitsMap.put("per minute", "4");
        rateUnitsMap.put("per hour", "5");
        rateUnitsMap.put("per day", "6");
        rateUnitsMap.put("per week", "7");
        rateUnitsMap.put("per month", "8");
        rateUnitsMap.put("per year", "9");
    }
}

