/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.hardware.ciminfo.sensors.types;

import com.vmware.vsphere.client.h5.host.hardware.ciminfo.sensors.types.SensorConstant;
import org.w3c.dom.Node;

public class SensorConstants {

    public static enum Details implements SensorConstant
    {
        DEFAULT(""),
        CAPACITY("Capacity"),
        MEMORY_SPEED("MemorySpeed"),
        MAX_MEMORY_SPEED("MaxMemorySpeed"),
        MEMORY_TYPE("MemoryType"),
        FORM_FACTOR("FormFactor"),
        ENABLED_STATUS("EnabledState"),
        NETWORK_ADDRESS("NetworkAddresses"),
        LOWER_THRESHOLD_NON_CRITICAL("LowerThresholdNonCritical"),
        UPPER_THRESHOLD_NON_CRITICAL("UpperThresholdNonCritical"),
        LOWER_THRESHOLD_CRITICAL("LowerThresholdCritical"),
        UPPER_THRESHOLD_CRITICAL("UpperThresholdCritical"),
        LOWER_THRESHOLD_FATAL("LowerThresholdFatal"),
        UPPER_THRESHOLD_FATAL("UpperThresholdFatal"),
        CAPABILITIES("Capabilities"),
        VENDOR_ID("Vendorid"),
        PCI_DEVICE_ID("PCIDeviceID"),
        SUBSYSTEM_ID("SubsystemID"),
        SUBSYSTEM_VENDOR_ID("SubsystemVendorID"),
        LEVEL("Level"),
        CACHE_TYPE("CacheType"),
        WRITE_POLICY("WritePolicy"),
        READ_POLICY("ReadPolicy"),
        ASSOCIATIVITY("Associativity"),
        CPU_STATUS("CPUStatus"),
        FAMILY("Family"),
        CURRENT_CLOCK_SPEED("CurrentClockSpeed"),
        MAX_CLOCK_SPEED("MaxClockSpeed"),
        DATA_WIDTH("DataWidth"),
        BATTERY_STATUS("BatteryStatus"),
        WHITE_SPACE("#text"),
        NAME("Name"),
        ELEMENT_NAME("ElementName"),
        MODEL("Model"),
        SERIAL_NUMBER("SerialNumber"),
        TAG("Tag"),
        OTHER_IDENTITY_INFO("OtherIdentifyingInfo"),
        HEALTH_STATE("HealthState"),
        CURRENT_READING("CurrentReading"),
        BASE_UNITS("BaseUnits"),
        RATE_UNITS("RateUnits"),
        UNIT_MODIFIER("UnitModifier"),
        SPEED("Speed"),
        CURRENT_STATE("CurrentState"),
        OPERATIONAL_STATUS("OperationalStatus"),
        REDUNDANCY_STATUS("RedundancyStatus"),
        ENABLED_STATE("EnabledState"),
        TOTAL_OUTPUT_POWER("TotalOutputPower"),
        EXTERNAL_BUS_CLOCK_SPEED("ExternalBusClockSpeed"),
        RELEASE_DATE("ReleaseDate"),
        INSTALL_DATE("InstallDate"),
        LOG_RECORD_CAPTION("Caption"),
        LOG_RECORD_TIMESTAMP("MessageTimestamp");

        private String value;

        private Details(String value) {
            this.value = value;
        }

        public static Details findByLabel(String sensorDetail) {
            Details labelResult = DEFAULT;
            for (Details detail : Details.values()) {
                String detailLabel = detail.getLabel();
                if (!detailLabel.equals(sensorDetail)) continue;
                labelResult = detail;
            }
            return labelResult;
        }

        public static Details findByValue(String sensorDetail) {
            Details labelResult = DEFAULT;
            for (Details detail : Details.values()) {
                String detailLabel = detail.getValue();
                if (!detailLabel.equals(sensorDetail)) continue;
                labelResult = detail;
            }
            return labelResult;
        }

        @Override
        public String getLabel() {
            return this.value.toLowerCase();
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum Types implements SensorConstant
    {
        DEFAULT(""),
        PROCESSOR("CIM_Processor"),
        CACHE_MEMORY("OMC_CacheMemory"),
        MEMORY("CIM_PhysicalMemory"),
        NETWORK("CIM_EthernetPort"),
        PCI_DEVICE("CIM_PCIDevice"),
        VMWARE_BATTERY("VMware_Battery"),
        SOFTWARE_IDENTITY("CIM_SoftwareIdentity"),
        BASEBOARD_MANAGEMENT_CONTROLLER_SMX("SMX_ManagementProcessor"),
        BASEBOARD_MANAGEMENT_CONTROLLER_OMC("OMC_IPMIIPProtocolEndpoint"),
        SERVER_ERROR_LOG("CIM_RecordLog"),
        MEMORY_SLOT("OMC_MemorySlot"),
        POWER("CIM_PowerSupply"),
        DISCRETE_SENSOR("OMC_DiscreteSensor"),
        PHYSICAL_MEMORY("CIM_PhysicalMemory"),
        NUMERIC_SENSOR("CIM_NumericSensor");

        private String value;

        private Types(String value) {
            this.value = value;
        }

        public static Types getSensorTypeByNode(Node node) {
            Types sensorType = DEFAULT;
            String nodeType = node.getNodeName();
            for (Types type2 : Types.values()) {
                if (!type2.value.equals(nodeType)) continue;
                sensorType = type2;
                break;
            }
            return sensorType;
        }

        @Override
        public String getLabel() {
            return this.value.toLowerCase();
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

