/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.model;

import com.vmware.cis.data.model.DerivedProperty;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.SourceProperty;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.cluster.DasFdmAvailabilityState;
import com.vmware.vim.binding.vim.cluster.DasFdmHostState;
import com.vmware.vim.binding.vim.host.BootDeviceInfo;
import com.vmware.vim.binding.vim.host.PartialMaintenanceModeRuntimeInfo;
import com.vmware.vim.binding.vim.host.SgxRegistrationInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vsphere.client.h5.host.util.HostPropertiesUtil;
import java.util.ArrayList;

public class HostExtendedDataModel {
    @Property(value="HostSystem/powerConfigHardware/@info/immutable")
    public Boolean powerConfigInfoImmutable;

    @DerivedProperty(value="HostSystem/isHostInPartialMaintenanceMode")
    public static boolean isHostInPartialMaintenanceMode(@SourceProperty(value="HostSystem/runtime/connectionState") HostSystem.ConnectionState connectionState, @SourceProperty(value="HostSystem/runtime/partialMaintenanceMode") PartialMaintenanceModeRuntimeInfo[] infos) {
        return HostPropertiesUtil.getIsHostInPartMainMode(infos, connectionState);
    }

    @DerivedProperty(value="HostSystem/isHostConnected")
    public static boolean isHostConnected(@SourceProperty(value="HostSystem/runtime/connectionState") HostSystem.ConnectionState connectionState) {
        return HostPropertiesUtil.isHostConnected(connectionState);
    }

    @DerivedProperty(value="HostSystem/isManualTimeSyncEnabled")
    public static boolean isManualTimeSyncEnabled(@SourceProperty(value="HostSystem/config/dateTimeInfo/systemClockProtocol") String systemClockProtocol, @SourceProperty(value="HostSystem/runtime/connectionState") HostSystem.ConnectionState connectionState) {
        boolean isHostConnected = HostPropertiesUtil.isHostConnected(connectionState);
        return isHostConnected && systemClockProtocol == null;
    }

    @DerivedProperty(value="HostSystem/isEditVmStartupShutdownAllowed")
    public static boolean isEditVmStartupShutdownAllowed(@SourceProperty(value="HostSystem/runtime/connectionState") HostSystem.ConnectionState connectionState, @SourceProperty(value="HostSystem/runtime/dasHostState") DasFdmHostState dasState, @SourceProperty(value="HostSystem/vm") ManagedObjectReference[] vms) {
        boolean areVMsPresentOnHost = vms != null && vms.length > 0;
        return HostPropertiesUtil.isHostConnected(connectionState) && areVMsPresentOnHost && (dasState == null || dasState.state.equals(DasFdmAvailabilityState.uninitialized.name()) || dasState.state.equals(DasFdmAvailabilityState.uninitializationError.name()) || dasState.state.equals(DasFdmAvailabilityState.initializationError.name()));
    }

    @DerivedProperty(value="HostSystem/isAttachedHostProfileAllowed")
    public static boolean isAttachHostProfileAllowed(@SourceProperty(value="HostSystem/runtime/connectionState") HostSystem.ConnectionState connectionState, @SourceProperty(value="HostSystem/hp") ManagedObjectReference profile, @SourceProperty(value="HostSystem/isHostPartOfCMEnabledCluster") Boolean isHostPartOfCMEnabledCluster) {
        return !Boolean.TRUE.equals(isHostPartOfCMEnabledCluster) && HostPropertiesUtil.isHostConnected(connectionState) && profile == null;
    }

    @DerivedProperty(value="HostSystem/isDetachedHostProfileAllowed")
    public static boolean isDetachHostProfileAllowed(@SourceProperty(value="HostSystem/runtime/connectionState") HostSystem.ConnectionState connectionState, @SourceProperty(value="HostSystem/hp") ManagedObjectReference profile) {
        return HostPropertiesUtil.isHostConnected(connectionState) && profile != null;
    }

    @DerivedProperty(value="HostSystem/isChangeHostProfileAllowed")
    public static boolean getIsChangeHostProfileAllowed(@SourceProperty(value="HostSystem/hp") ManagedObjectReference hp, @SourceProperty(value="HostSystem/isHostPartOfCMEnabledCluster") Boolean isHostPartOfCMEnabledCluster) {
        return !Boolean.TRUE.equals(isHostPartOfCMEnabledCluster) && hp != null;
    }

    @DerivedProperty(value="HostSystem/refreshCertificateVisible")
    public static boolean isRefreshCertificateVisible(@SourceProperty(value="HostSystem/runtime/connectionState") HostSystem.ConnectionState connectionState, @SourceProperty(value="HostSystem/configManager/certificateManager") ManagedObjectReference certManager) {
        return HostPropertiesUtil.isHostConnected(connectionState) && certManager != null;
    }

    @DerivedProperty(value="HostSystem/hyperthreadingEditAllowed")
    public static boolean isHyperthreadEditAllowed(@SourceProperty(value="HostSystem/runtime/connectionState") HostSystem.ConnectionState connectionState, @SourceProperty(value="HostSystem/config/hyperThread/available") Boolean htAvailable) {
        return HostPropertiesUtil.isHostConnected(connectionState) && htAvailable != false;
    }

    @DerivedProperty(value="HostSystem/bootDevicesEditAllowed")
    public static boolean isBootDevicesEditAllowed(@SourceProperty(value="HostSystem/runtime/connectionState") HostSystem.ConnectionState connectionState, @SourceProperty(value="HostSystem/bootDeviceInfo") BootDeviceInfo bootDeviceInfo) {
        boolean hasBootDevices = bootDeviceInfo != null && bootDeviceInfo.bootDevices != null && bootDeviceInfo.bootDevices.length > 0;
        return HostPropertiesUtil.isHostConnected(connectionState) && hasBootDevices;
    }

    @DerivedProperty(value="HostSystem/sgxRegisterAllowed")
    public static boolean isSgxRegisterAllowed(@SourceProperty(value="HostSystem/hardware/sgxInfo/registrationInfo") SgxRegistrationInfo registrationInfo) {
        return registrationInfo != null && registrationInfo.biosError == null && SgxRegistrationInfo.RegistrationStatus.incomplete.toString().equalsIgnoreCase(registrationInfo.status);
    }

    @DerivedProperty(value="HostSystem/isHostCustomizationsAvailable")
    public static boolean isHostCustomizationsAvailable(@SourceProperty(value="HostSystem/parent") ManagedObjectReference parent, @SourceProperty(value="HostSystem/runtime/connectionState") HostSystem.ConnectionState connectionState, @SourceProperty(value="HostSystem/hp") ManagedObjectReference profile) {
        return HostPropertiesUtil.isHostConnected(connectionState) && profile != null && parent != null && VcServiceUtil.is65VcOrLaterByServerGuid((String)parent.getServerGuid());
    }

    @DerivedProperty(value="ClusterComputeResource/isHostCustomizationsAvailable")
    public static boolean isHostCustomizationsAvailable(@SourceProperty(value="ClusterComputeResource/hp") ManagedObjectReference profile, @SourceProperty(value="ClusterComputeResource/parent") ManagedObjectReference parent, @SourceProperty(value="ClusterComputeResource/host") ManagedObjectReference[] hosts) {
        return profile != null && parent != null && VcServiceUtil.is65VcOrLaterByServerGuid((String)parent.getServerGuid()) && hosts != null && hosts.length > 0;
    }

    @DerivedProperty(value="HostSystem/isHostConnectedAndHasAttachedProfile")
    public static boolean getIsHostConnectedAndHasAttachedProfile(@SourceProperty(value="HostSystem/hp") ManagedObjectReference associatedHostProfileMor, @SourceProperty(value="HostSystem/runtime/connectionState") HostSystem.ConnectionState connectionState) {
        boolean isHostProfileAttached = associatedHostProfileMor != null;
        boolean isHostConnected = HostPropertiesUtil.isHostConnected(connectionState);
        return isHostConnected && isHostProfileAttached;
    }

    @DerivedProperty(value="HostProfile/isEditTreeHostCustomizationsAvailable")
    public static boolean getIsEditTreeHostCustomizationsAvailable(@SourceProperty(value="HostProfile/entity") ManagedObjectReference[] entities, @SourceProperty(value="HostProfile/isBulkAnswerFileEnabled") boolean isBulkAnswerFileEnabled) {
        ArrayList<ManagedObjectReference> hostRefs = new ArrayList<ManagedObjectReference>();
        if (entities != null) {
            for (ManagedObjectReference ref : entities) {
                if (!HostSystem.class.getSimpleName().equals(ref.getType())) continue;
                hostRefs.add(ref);
            }
        }
        return hostRefs.size() > 0 && isBulkAnswerFileEnabled;
    }

    @DerivedProperty(value="HostSystem/canEditDefaultHwVersionAction")
    public static boolean getCanEditDefaultHwVersionAction(@SourceProperty(value="HostSystem/runtime/connectionState") HostSystem.ConnectionState connectionState, @SourceProperty(value="HostSystem/isStandalone") Boolean isStandalone) {
        return Boolean.TRUE.equals(isStandalone) && HostPropertiesUtil.isHostConnected(connectionState);
    }

    @DerivedProperty(value="HostSystem/consumedPMemPercentage")
    public static long getConsumedPMemPercentage(@SourceProperty(value="HostSystem/consumedPMem") long consumedPMem, @SourceProperty(value="HostSystem/hardware/persistentMemoryInfo/capacityInMB") Long capacity) {
        if (capacity == null || capacity == 0L) {
            return 0L;
        }
        return Math.round((double)consumedPMem * 100.0 / (double)capacity.longValue());
    }
}

