/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.model;

import com.vmware.cis.data.model.DerivedProperty;
import com.vmware.cis.data.model.SourceProperty;
import com.vmware.vim.binding.vim.host.ImageConfigManager;
import com.vmware.vim.binding.vim.host.SoftwarePackage;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.Version;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vsphere.client.h5.host.model.SoftwarePackageData;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;

public class HostSoftwarePackagesExtendedDataModel {
    private static final Version HOST_VERSION_6_1 = new Version("6.1.0");

    @DerivedProperty(value="HostSystem/isSoftwarePackagesAvailable")
    public static boolean isSoftwarePackagesAvailable(@SourceProperty(value="HostSystem/parent") ManagedObjectReference hostParentMor, @SourceProperty(value="HostSystem/config/product/version") String hostVersionString) {
        Version hostVersion = new Version(hostVersionString);
        String serverGuid = hostParentMor.getServerGuid();
        boolean isVc65OrLater = VcServiceUtil.is65VcOrLaterByServerGuid((String)serverGuid);
        return isVc65OrLater && hostVersion.compareTo(HOST_VERSION_6_1) >= 0;
    }

    @DerivedProperty(value="HostSystem/softwarePackages")
    public static SoftwarePackageData[] getSoftwarePackages(@SourceProperty(value="HostSystem/configManager/imageConfigManager") ManagedObjectReference imageConfigManagerMor) throws Exception {
        SoftwarePackage[] softwarePackages;
        ImageConfigManager manager = (ImageConfigManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)imageConfigManagerMor);
        ArrayList<SoftwarePackageData> softwarePackageDataList = new ArrayList<SoftwarePackageData>();
        if (manager != null && (softwarePackages = manager.fetchSoftwarePackages()) != null) {
            for (SoftwarePackage softwarePackage : softwarePackages) {
                SoftwarePackageData currentModel = new SoftwarePackageData(softwarePackage);
                softwarePackageDataList.add(currentModel);
            }
        }
        Collections.sort(softwarePackageDataList, new Comparator<SoftwarePackageData>(){

            @Override
            public int compare(SoftwarePackageData o1, SoftwarePackageData o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return softwarePackageDataList.toArray(new SoftwarePackageData[0]);
    }

    @DerivedProperty(value="HostSystem/hostInstallDateInMillis")
    public static Long getHostInstallDateInMillis(@SourceProperty(value="HostSystem/configManager/imageConfigManager") ManagedObjectReference imageConfigManagerMor) throws Exception {
        Long hostInstallDateInMillis = null;
        ImageConfigManager manager = (ImageConfigManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)imageConfigManagerMor);
        if (manager != null) {
            Calendar hostInstallDate = manager.installDate();
            hostInstallDateInMillis = hostInstallDate.getTimeInMillis();
        }
        return hostInstallDateInMillis;
    }
}

