/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.util;

import com.vmware.vim.binding.vim.fault.HostConfigFault;
import com.vmware.vim.binding.vim.fault.InvalidState;
import com.vmware.vim.binding.vim.fault.NotFound;
import com.vmware.vim.binding.vim.host.DateTimeInfo;
import com.vmware.vim.binding.vim.host.FirewallInfo;
import com.vmware.vim.binding.vim.host.FirewallSystem;
import com.vmware.vim.binding.vim.host.Ruleset;
import com.vmware.vim.binding.vim.host.Service;
import com.vmware.vim.binding.vim.host.ServiceInfo;
import com.vmware.vim.binding.vim.host.ServiceSystem;
import com.vmware.vsphere.client.h5.host.config.spec.TimeConfigSpec;
import com.vmware.vsphere.client.h5.host.util.HostStringUtil;

public class TimeConfigUtil {
    private static final String SERVICE_STATUS_NOT_FOUND = "timeConfig.ntpServiceStatusNotFound";
    private static final String SERVICE_STATUS_STOPPED = "timeConfig.ntpServiceStatusStopped";
    private static final String SERVICE_STATUS_RUNNING = "timeConfig.ntpServiceStatusRunning";
    private static final String SERVICE_STATUS_MONITORING = "timeConfig.ntpServiceStatusMonitoring";
    private static final String STATUS_ENABLED = "timeConfig.ntpStatusEnabled";
    private static final String STATUS_DISABLED = "timeConfig.ntpStatusDisabled";
    private static final String NTP_SERVICE_KEY = "ntpd";

    public static void enableService(boolean enabled, FirewallSystem firewall, Service service, String rulesetKey) throws Exception {
        int i;
        boolean currentlyEnabled = service.running;
        FirewallInfo info = firewall.getFirewallInfo();
        if (info != null) {
            for (i = 0; i < info.ruleset.length; ++i) {
                Ruleset ruleSet = info.ruleset[i];
                if (!ruleSet.key.toLowerCase().contains(rulesetKey)) continue;
                currentlyEnabled = ruleSet.enabled;
                break;
            }
        }
        if (enabled && currentlyEnabled) {
            return;
        }
        for (i = 0; i < service.ruleset.length; ++i) {
            String rule = service.ruleset[i];
            if (enabled) {
                firewall.enableRuleset(rule);
                continue;
            }
            firewall.disableRuleset(rule);
        }
    }

    public static Service getService(ServiceSystem system, String serviceKey) throws Exception {
        Service result = null;
        ServiceInfo info = system.getServiceInfo();
        for (int i = 0; i < info.service.length; ++i) {
            Service s = info.service[i];
            if (!s.key.equalsIgnoreCase(serviceKey)) continue;
            result = s;
            break;
        }
        if (result == null) {
            String errorMsg = HostStringUtil.getString("error.timeConfigPtpServiceIsNull", new String[0]);
            throw new Exception(errorMsg);
        }
        return result;
    }

    public static String getNtpMonitoringServiceStatus(Service ntpService, String systemClockProtocol) {
        if (ntpService == null) {
            return HostStringUtil.getString(SERVICE_STATUS_NOT_FOUND, new String[0]);
        }
        if (ntpService.running) {
            return systemClockProtocol == null || systemClockProtocol.equals(DateTimeInfo.Protocol.ptp.toString()) ? HostStringUtil.getString(SERVICE_STATUS_MONITORING, new String[0]) : HostStringUtil.getString(SERVICE_STATUS_RUNNING, new String[0]);
        }
        return HostStringUtil.getString(SERVICE_STATUS_STOPPED, new String[0]);
    }

    public static String getServiceStatus(ServiceInfo services, String serviceKey) {
        Service service = TimeConfigUtil.getService(services, serviceKey);
        if (service == null) {
            return HostStringUtil.getString(SERVICE_STATUS_NOT_FOUND, new String[0]);
        }
        if (service.running) {
            return HostStringUtil.getString(SERVICE_STATUS_RUNNING, new String[0]);
        }
        return HostStringUtil.getString(SERVICE_STATUS_STOPPED, new String[0]);
    }

    public static Service getService(ServiceInfo services, String serviceKey) {
        if (services != null && services.service != null) {
            for (Service s : services.service) {
                if (!serviceKey.equals(s.key)) continue;
                return s;
            }
        }
        return null;
    }

    public static Ruleset getRuleset(FirewallInfo firewallInfo, String clientKey) {
        if (firewallInfo == null || firewallInfo.ruleset == null) {
            return null;
        }
        for (Ruleset rs : firewallInfo.ruleset) {
            if (rs.key == null || !rs.key.contains(clientKey)) continue;
            return rs;
        }
        return null;
    }

    public static boolean getClientEnabled(FirewallInfo firewallInfo, String clientKey) {
        Ruleset rs = TimeConfigUtil.getRuleset(firewallInfo, clientKey);
        return rs != null && rs.enabled;
    }

    public static String getClientStatus(FirewallInfo firewallInfo, String clientKey) {
        if (TimeConfigUtil.getClientEnabled(firewallInfo, clientKey)) {
            return HostStringUtil.getString(STATUS_ENABLED, new String[0]);
        }
        return HostStringUtil.getString(STATUS_DISABLED, new String[0]);
    }

    public static void changeServiceState(String serviceId, TimeConfigSpec.Action action, ServiceSystem system) throws InvalidState, NotFound, HostConfigFault {
        if (action == TimeConfigSpec.Action.start) {
            system.start(serviceId);
        } else if (action == TimeConfigSpec.Action.stop) {
            system.stop(serviceId);
        } else if (action == TimeConfigSpec.Action.restart) {
            system.restart(serviceId);
        }
    }
}

