/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.vmdp;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.AssignableHardwareConfig;
import com.vmware.vim.binding.vim.host.AssignableHardwareManager;
import com.vmware.vim.binding.vim.host.NetworkInfo;
import com.vmware.vim.binding.vim.host.PciDevice;
import com.vmware.vim.binding.vim.host.PciPassthruInfo;
import com.vmware.vim.binding.vim.host.SriovInfo;
import com.vmware.vim.binding.vim.host.StorageDeviceInfo;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualPCIPassthrough;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.Pair;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.h5.host.model.VmDevicesData;
import com.vmware.vsphere.client.h5.host.util.HostStringUtil;
import com.vmware.vsphere.client.h5.host.vmdp.VmdpDeviceInfo;
import com.vmware.vsphere.client.h5.host.vmdp.VmdpDeviceInfoUtil;
import com.vmware.vsphere.client.h5.host.vmdp.VmdpDeviceNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class VmdpDeviceInfoConverter {
    private static final Log logger = LogFactory.getLog(VmdpDeviceInfoConverter.class);
    private final PciDevice[] pciDevicesArray;
    private final NetworkInfo networkInfo;
    private final StorageDeviceInfo storageDeviceInfo;
    private final Map<String, PciPassthruInfo> pciPassthruMap;
    private final boolean isHostAssignableHwCapable;
    private final ManagedObjectReference assignableHwMor;
    private final boolean isHostRebindWithoutRebootCapable;
    private final boolean assignHwPciConfigSupported;
    private final VmDevicesData[] vmDevicesData;
    private final ManagedObjectReference hostRef;

    VmdpDeviceInfoConverter(PciPassthruInfo[] hostPciPassthruInfo, PciDevice[] pciDevicesArray, NetworkInfo networkInfo, StorageDeviceInfo storageDeviceInfo, ManagedObjectReference assignableHwMor, boolean isHostAssignableHwCapable, boolean isHostRebindWithoutRebootCapable, boolean assignHwPciConfigSupported, VmDevicesData[] vmDevicesData, ManagedObjectReference hostRef) {
        this.pciDevicesArray = pciDevicesArray;
        this.networkInfo = networkInfo;
        this.storageDeviceInfo = storageDeviceInfo;
        this.pciPassthruMap = this.createPassthruMap(hostPciPassthruInfo);
        this.isHostAssignableHwCapable = isHostAssignableHwCapable;
        this.assignableHwMor = assignableHwMor;
        this.isHostRebindWithoutRebootCapable = isHostRebindWithoutRebootCapable;
        this.assignHwPciConfigSupported = assignHwPciConfigSupported;
        this.vmDevicesData = vmDevicesData;
        this.hostRef = hostRef;
    }

    Map<String, PciPassthruInfo> createPassthruMap(PciPassthruInfo[] hostPciPassthruInfo) {
        HashMap<String, PciPassthruInfo> pciPassthruMap = new HashMap<String, PciPassthruInfo>();
        if (hostPciPassthruInfo == null) {
            return pciPassthruMap;
        }
        for (PciPassthruInfo info : hostPciPassthruInfo) {
            pciPassthruMap.put(info.getId(), info);
        }
        return pciPassthruMap;
    }

    List<VmdpDeviceInfo> createEnabledVmdpDeviceInfoList() {
        ArrayList<VmdpDeviceInfo> deviceInfoList = new ArrayList<VmdpDeviceInfo>();
        if (this.pciPassthruMap.size() == 0 || this.pciDevicesArray == null || this.pciDevicesArray.length == 0) {
            return deviceInfoList;
        }
        Map<String, List<Pair<String, ManagedObjectReference>>> devToVmMap = this.getDeviceToVMMapping(this.hostRef);
        for (PciDevice pciDevice : this.pciDevicesArray) {
            String pciDeviceId = pciDevice.getId();
            PciPassthruInfo pciPassthruInfo = this.pciPassthruMap.get(pciDeviceId);
            if (!this.isPciDeviceAvailable(pciPassthruInfo, this.isHostRebindWithoutRebootCapable)) continue;
            VmdpDeviceNode vmdpDeviceInfo = this.createVmdpDeviceNode(this.pciPassthruMap.get(pciDeviceId), pciDevice);
            vmdpDeviceInfo.vmData = devToVmMap.get(pciDeviceId);
            deviceInfoList.add(vmdpDeviceInfo);
        }
        return deviceInfoList;
    }

    List<VmdpDeviceNode> createVmdpDeviceNodeList() {
        return this.createVmdpDeviceNodeList(false);
    }

    List<VmdpDeviceNode> createVmdpAllDevicesNodeList() {
        return this.createVmdpDeviceNodeList(true);
    }

    private List<VmdpDeviceNode> createVmdpDeviceNodeList(boolean includeNonPassthruCapableDevices) {
        HashMap<String, VmdpDeviceNode> configurableDevices = new HashMap<String, VmdpDeviceNode>();
        Map<String, VmdpDeviceNode> deviceNodeMap = this.getVmdpNodeDevicesMap();
        Map<String, List<Pair<String, ManagedObjectReference>>> devToVmMap = this.getDeviceToVMMapping(this.hostRef);
        for (VmdpDeviceNode vmdpDeviceNode : deviceNodeMap.values()) {
            VmdpDeviceNode parentDevice = deviceNodeMap.get(vmdpDeviceNode.parentDeviceId);
            if (parentDevice == null) continue;
            vmdpDeviceNode.parentId = parentDevice.nodeId;
        }
        for (VmdpDeviceNode vmdpDeviceNode : deviceNodeMap.values()) {
            vmdpDeviceNode.vmData = devToVmMap.get(vmdpDeviceNode.vmdpDeviceId);
            if (includeNonPassthruCapableDevices) {
                configurableDevices.put(vmdpDeviceNode.vmdpDeviceId, vmdpDeviceNode);
                this.putAllNodeParentsInMap(vmdpDeviceNode, deviceNodeMap, configurableDevices);
                continue;
            }
            PciPassthruInfo pciPassthruInfo = this.pciPassthruMap.get(vmdpDeviceNode.vmdpDeviceId);
            if (pciPassthruInfo == null || !pciPassthruInfo.isPassthruCapable()) continue;
            configurableDevices.put(vmdpDeviceNode.vmdpDeviceId, vmdpDeviceNode);
            this.putAllNodeParentsInMap(vmdpDeviceNode, deviceNodeMap, configurableDevices);
        }
        ArrayList<VmdpDeviceNode> list = new ArrayList<VmdpDeviceNode>(configurableDevices.values());
        Collections.sort(list, new Comparator<VmdpDeviceNode>(){

            @Override
            public int compare(VmdpDeviceNode o1, VmdpDeviceNode o2) {
                return o1.hasChildren - o2.hasChildren;
            }
        });
        return list;
    }

    public Map<String, List<Pair<String, ManagedObjectReference>>> getDeviceToVMMapping(ManagedObjectReference hostRef) {
        HashMap<String, List<Pair<String, ManagedObjectReference>>> deviceToVmsMap = new HashMap<String, List<Pair<String, ManagedObjectReference>>>();
        try {
            HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRef);
            if (host == null) {
                return Collections.emptyMap();
            }
            if (this.vmDevicesData == null) {
                return Collections.emptyMap();
            }
            for (VmDevicesData vmData : this.vmDevicesData) {
                VirtualDevice[] devices = vmData.virtualDevices;
                if (devices == null) continue;
                for (VirtualDevice device : devices) {
                    VirtualPCIPassthrough pciDevice;
                    if (!(device instanceof VirtualPCIPassthrough) || !((pciDevice = (VirtualPCIPassthrough)device).getBacking() instanceof VirtualPCIPassthrough.DeviceBackingInfo)) continue;
                    String deviceId = ((VirtualPCIPassthrough.DeviceBackingInfo)pciDevice.getBacking()).id;
                    ArrayList<Pair> arrayVms = (ArrayList<Pair>)deviceToVmsMap.get(deviceId);
                    Pair vmPair = new Pair((Object)vmData.name, (Object)((ManagedObjectReference)vmData.provider));
                    if (arrayVms == null) {
                        arrayVms = new ArrayList<Pair>();
                    }
                    arrayVms.add(vmPair);
                    deviceToVmsMap.put(deviceId, arrayVms);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"No virtual machine using the device");
            return Collections.emptyMap();
        }
        return deviceToVmsMap;
    }

    private void putAllNodeParentsInMap(VmdpDeviceNode node, Map<String, VmdpDeviceNode> deviceNodeMap, Map<String, VmdpDeviceNode> configurableDevices) {
        while (node.parentDeviceId != null && (node = deviceNodeMap.get(node.parentDeviceId)) != null) {
            node.hasChildren = 1;
            configurableDevices.put(node.vmdpDeviceId, node);
        }
    }

    private Map<String, VmdpDeviceNode> getVmdpNodeDevicesMap() {
        HashMap<String, VmdpDeviceNode> deviceNodeMap = new HashMap<String, VmdpDeviceNode>();
        if (this.pciPassthruMap.size() == 0 || this.pciDevicesArray == null || this.pciDevicesArray.length == 0) {
            return deviceNodeMap;
        }
        int nodeId = 0;
        for (PciDevice pciDevice : this.pciDevicesArray) {
            String pciDeviceId = pciDevice.getId();
            PciPassthruInfo pciPassthruInfo = this.pciPassthruMap.get(pciDeviceId);
            if (pciPassthruInfo == null) continue;
            VmdpDeviceNode vmdpDeviceNode = this.initVmdpDeviceNode(pciPassthruInfo, pciDevice, nodeId++);
            deviceNodeMap.put(vmdpDeviceNode.vmdpDeviceId, vmdpDeviceNode);
        }
        return deviceNodeMap;
    }

    private VmdpDeviceNode initVmdpDeviceNode(PciPassthruInfo pciPassthruInfo, PciDevice pciDevice, Integer nodeId) {
        VmdpDeviceNode vmdpDeviceNode = this.createVmdpDeviceNode(pciPassthruInfo, pciDevice);
        vmdpDeviceNode.nodeId = nodeId;
        if (pciDevice.getParentBridge() != null) {
            vmdpDeviceNode.parentDeviceId = pciDevice.getParentBridge();
        }
        boolean dependantDeviceAvailable = StringUtils.isNotEmpty((CharSequence)pciPassthruInfo.dependentDevice);
        if (vmdpDeviceNode.vmdpDeviceId != null && dependantDeviceAvailable && !vmdpDeviceNode.vmdpDeviceId.equals(pciPassthruInfo.dependentDevice)) {
            vmdpDeviceNode.dependentDevice = pciPassthruInfo.dependentDevice;
        }
        if (pciPassthruInfo instanceof SriovInfo) {
            vmdpDeviceNode.sriovEnabled = ((SriovInfo)pciPassthruInfo).sriovEnabled;
            vmdpDeviceNode.sriovCapable = ((SriovInfo)pciPassthruInfo).sriovCapable;
            vmdpDeviceNode.numVirtualFunction = ((SriovInfo)pciPassthruInfo).numVirtualFunction;
            vmdpDeviceNode.maxVirtualFunctionSupported = ((SriovInfo)pciPassthruInfo).maxVirtualFunctionSupported;
            vmdpDeviceNode.supportedNumVFsValues = ((SriovInfo)pciPassthruInfo).supportedNumVFsValues;
        }
        return vmdpDeviceNode;
    }

    private boolean isPciDeviceAvailable(PciPassthruInfo pciPassthruInfo, boolean isHostRebindWithoutRebootCapable) {
        if (pciPassthruInfo == null) {
            return false;
        }
        boolean available = isHostRebindWithoutRebootCapable ? pciPassthruInfo.isPassthruEnabled() && pciPassthruInfo.isPassthruActive() : pciPassthruInfo.isPassthruEnabled() || pciPassthruInfo.isPassthruActive();
        return available && pciPassthruInfo.isPassthruCapable();
    }

    private VmdpDeviceNode createVmdpDeviceNode(PciPassthruInfo pciPassthruInfo, PciDevice device) {
        VmdpDeviceNode vmdpDeviceInfo = new VmdpDeviceNode();
        vmdpDeviceInfo.vmdpDeviceId = device.getId();
        vmdpDeviceInfo.vendor = device.getVendorName();
        vmdpDeviceInfo.deviceName = VmdpDeviceInfoUtil.getVmdprDeviceInfoName(device.getDeviceName(), device.getClassId());
        VmdpDeviceInfoUtil.VmdpDeviceDirectPathState vmdpDeviceDirectPathState = VmdpDeviceInfoUtil.getVmdprDeviceInfoStatusAndMessage(pciPassthruInfo.isPassthruCapable(), pciPassthruInfo.isPassthruEnabled(), pciPassthruInfo.isPassthruActive(), this.isHostRebindWithoutRebootCapable);
        vmdpDeviceInfo.status = vmdpDeviceDirectPathState.getStatus();
        vmdpDeviceInfo.statusMessage = vmdpDeviceDirectPathState.getDirectPathStatusMessage();
        vmdpDeviceInfo.directPathMessage = vmdpDeviceDirectPathState.getDirectPathStateMessage();
        vmdpDeviceInfo.deviceId = VmdpDeviceInfoUtil.getUnsignedShortAsHexString(device.getDeviceId());
        vmdpDeviceInfo.subDeviceId = VmdpDeviceInfoUtil.getUnsignedShortAsHexString(device.getSubDeviceId());
        vmdpDeviceInfo.classId = VmdpDeviceInfoUtil.getUnsignedShortAsHexString(device.getClassId());
        vmdpDeviceInfo.vendorId = VmdpDeviceInfoUtil.getUnsignedShortAsHexString(device.getVendorId());
        vmdpDeviceInfo.subVendorId = VmdpDeviceInfoUtil.getUnsignedShortAsHexString(device.getSubVendorId());
        String notConfigurable = HostStringUtil.getString("vmdpConfig.devStatus.cantConfig", new String[0]);
        String notApplicable = HostStringUtil.getString("host.hardware.firmware.na.value", new String[0]);
        if (vmdpDeviceInfo.vmdpDeviceId != null) {
            if (vmdpDeviceInfo.statusMessage.equals(notConfigurable)) {
                vmdpDeviceInfo.assignableHw = notApplicable;
            } else if (this.assignHwPciConfigSupported && StringUtils.isNotEmpty((CharSequence)vmdpDeviceInfo.assignableHw)) {
                vmdpDeviceInfo.assignableHw = pciPassthruInfo.hardwareLabel;
            } else if (this.isHostAssignableHwCapable && this.assignableHwMor != null) {
                try {
                    AssignableHardwareManager assignableHwMgr = (AssignableHardwareManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)this.assignableHwMor);
                    AssignableHardwareConfig assignableHwConfig = assignableHwMgr.getConfig();
                    AssignableHardwareConfig.AttributeOverride[] attributeOverrideValues = assignableHwConfig.getAttributeOverride();
                    vmdpDeviceInfo.assignableHw = VmdpDeviceInfoConverter.getLabel(VmdpDeviceInfoConverter.getAssignableHwValue(attributeOverrideValues, vmdpDeviceInfo.vmdpDeviceId));
                }
                catch (Exception e) {
                    vmdpDeviceInfo.assignableHw = VmdpDeviceInfoConverter.getLabel(null);
                }
            }
            vmdpDeviceInfo.busId = vmdpDeviceInfo.vmdpDeviceId.toUpperCase();
        }
        vmdpDeviceInfo.bus = VmdpDeviceInfoUtil.getUnsignedByteAsHexString(device.getBus());
        vmdpDeviceInfo.busSlot = VmdpDeviceInfoUtil.getUnsignedByteAsHexString(device.getSlot());
        vmdpDeviceInfo.function = VmdpDeviceInfoUtil.getUnsignedByteAsHexString(device.function);
        vmdpDeviceInfo.esxDeviceInfo = VmdpDeviceInfoUtil.getEsxDeviceInfo(this.storageDeviceInfo, this.networkInfo, vmdpDeviceInfo.vmdpDeviceId, vmdpDeviceInfo.classId);
        return vmdpDeviceInfo;
    }

    private static String getAssignableHwValue(AssignableHardwareConfig.AttributeOverride[] assignableHwConfig, String id) {
        String assignableHwValue = null;
        if (assignableHwConfig != null) {
            for (AssignableHardwareConfig.AttributeOverride attribute : assignableHwConfig) {
                if (!attribute.getInstanceId().contains(id)) continue;
                assignableHwValue = String.valueOf(attribute.getValue());
                break;
            }
        }
        return assignableHwValue;
    }

    private static String getLabel(String value) {
        return StringUtils.isEmpty((CharSequence)value) ? HostStringUtil.getString("host.hardware.firmware.na.label", new String[0]) : value;
    }
}

