/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms;

import com.google.common.base.Optional;
import com.vmware.opsmgmt.client.extension.alarms.AlarmDefinition;
import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.vim.binding.vim.alarm.AlarmInfo;
import com.vmware.vim.binding.vim.alarm.AlarmState;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;

public class AlarmDefinitionCreator {
    private static final String DEFINED_IN = "definedIn.this.object";
    private static final String ALARM_INFO_ENTITY_NAME = "name";
    private static final String DECLARED_ALARMS = "declaredAlarmState";
    private static final String ALARM_INFO = "info";
    private final QueryExecutor _queryExecutor;

    public AlarmDefinitionCreator(QueryExecutor queryExecutor) {
        Validate.notNull((Object)queryExecutor);
        this._queryExecutor = queryExecutor;
    }

    public List<AlarmDefinition> createAlarmDefinitions(Object obj, String vcName) throws Exception {
        Validate.notNull((Object)obj);
        Object[] alarmStates = (AlarmState[])this._queryExecutor.getProperty(obj, DECLARED_ALARMS);
        if (ArrayUtils.isEmpty((Object[])alarmStates)) {
            return Collections.emptyList();
        }
        Set<ManagedObjectReference> alarmInfoMors = this.findAlarmInfoMors((AlarmState[])alarmStates);
        PropertyValue[] alarmInfos = this._queryExecutor.getProperty(alarmInfoMors.toArray(), ALARM_INFO);
        Set<ManagedObjectReference> alarmInfoEntities = this.findAlarmInfoEntities(alarmInfos);
        PropertyValue[] alarmInfoEntityNames = null;
        if (!alarmInfoEntities.isEmpty()) {
            alarmInfoEntityNames = this._queryExecutor.getProperty(alarmInfoEntities.toArray(), ALARM_INFO_ENTITY_NAME);
        }
        ArrayList<AlarmDefinition> alarmDefinitions = new ArrayList<AlarmDefinition>();
        for (Object as : alarmStates) {
            Optional<AlarmInfo> aiOpt = this.findAlarmInfo(alarmInfos, ((AlarmState)as).alarm);
            if (!aiOpt.isPresent()) continue;
            AlarmInfo ai = (AlarmInfo)aiOpt.get();
            String definedInName = this.makeDefinedInName(obj, vcName, alarmInfoEntityNames, ai);
            AlarmDefinition ad = new AlarmDefinition((AlarmState)as, ai, definedInName);
            alarmDefinitions.add(ad);
        }
        return alarmDefinitions;
    }

    private String makeDefinedInName(Object obj, String vcName, PropertyValue[] alarmInfoEntityNames, AlarmInfo ai) {
        String definedInName = obj.equals(ai.entity) ? Localization.getString(DEFINED_IN) : this.findDefinedInName(alarmInfoEntityNames, ai.entity, vcName);
        return definedInName;
    }

    private Set<ManagedObjectReference> findAlarmInfoMors(AlarmState[] alarmStates) {
        HashSet<ManagedObjectReference> alarmInfoMors = new HashSet<ManagedObjectReference>();
        for (AlarmState as : alarmStates) {
            alarmInfoMors.add(as.alarm);
        }
        return alarmInfoMors;
    }

    private String findDefinedInName(PropertyValue[] alarmInfoEntityNames, ManagedObjectReference entity, String vcName) {
        if (ManagedObjectUtil.isRootFolder((ManagedObjectReference)entity)) {
            return vcName;
        }
        if (ArrayUtils.isEmpty((Object[])alarmInfoEntityNames)) {
            return "";
        }
        for (PropertyValue pv : alarmInfoEntityNames) {
            if (!pv.resourceObject.equals(entity)) continue;
            return (String)pv.value;
        }
        return "";
    }

    private Optional<AlarmInfo> findAlarmInfo(PropertyValue[] alarmInfos, ManagedObjectReference alarm) {
        if (ArrayUtils.isEmpty((Object[])alarmInfos)) {
            return Optional.absent();
        }
        for (PropertyValue pv : alarmInfos) {
            if (!pv.resourceObject.equals(alarm)) continue;
            AlarmInfo ai = (AlarmInfo)pv.value;
            return Optional.of((Object)ai);
        }
        return Optional.absent();
    }

    private Set<ManagedObjectReference> findAlarmInfoEntities(PropertyValue[] alarmInfos) {
        HashSet<ManagedObjectReference> result = new HashSet<ManagedObjectReference>();
        if (ArrayUtils.isEmpty((Object[])alarmInfos)) {
            return result;
        }
        for (PropertyValue pv : alarmInfos) {
            AlarmInfo ai = (AlarmInfo)pv.value;
            if (ManagedObjectUtil.isRootFolder((ManagedObjectReference)ai.entity)) continue;
            result.add(ai.entity);
        }
        return result;
    }
}

