/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.actions;

import com.vmware.vim.binding.vim.alarm.AlarmAction;
import com.vmware.vim.binding.vim.alarm.AlarmTriggeringAction;
import com.vmware.vim.binding.vim.alarm.GroupAlarmAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlarmActionWrapper {
    private static final Log _logger = LogFactory.getLog(AlarmActionWrapper.class);
    private List<AlarmTriggeringAction> _alarmTrigeringActions;

    public AlarmActionWrapper(AlarmAction action) {
        Validate.notNull((Object)action);
        this._alarmTrigeringActions = new ArrayList<AlarmTriggeringAction>();
        this.processActions(action);
    }

    public List<AlarmTriggeringAction> getAlarmTrigeringActions() {
        return this._alarmTrigeringActions;
    }

    public void addAction(AlarmTriggeringAction action) {
        Validate.notNull((Object)action);
        this._alarmTrigeringActions.add(action);
    }

    public void removeAction(AlarmTriggeringAction action) {
        Validate.notNull((Object)action);
        this._alarmTrigeringActions.remove(action);
    }

    public void removeAllActions() {
        this._alarmTrigeringActions = new ArrayList<AlarmTriggeringAction>();
    }

    private void processActions(AlarmAction action) {
        if (action == null) {
            return;
        }
        if (action instanceof GroupAlarmAction) {
            GroupAlarmAction groupAction = (GroupAlarmAction)action;
            for (AlarmAction alarmAction : groupAction.action) {
                this.processActions(alarmAction);
            }
        } else if (action instanceof AlarmTriggeringAction) {
            this._alarmTrigeringActions.add((AlarmTriggeringAction)action);
        } else {
            _logger.warn((Object)("Unsupported type of action " + action));
        }
    }
}

