/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.perfstats;

import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vsphere.client.data.util.DataUtil;
import com.vmware.vsphere.client.perfstats.Metric;
import com.vmware.vsphere.client.perfstats.PerformanceManagerService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class PerfStatsPropertyProviderAdapter
implements PropertyProviderAdapter {
    private final PerformanceManagerService _perfManager;
    private final Map<String, Metric> _metricsByProp;
    private final Map<Metric, String> _propsByMetric;

    public PerfStatsPropertyProviderAdapter(DataServiceExtensionRegistry registry, PerformanceManagerService perfManager, Map<String, Metric> metricsByProp) {
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
        this._perfManager = perfManager;
        this._metricsByProp = metricsByProp;
        this._propsByMetric = new HashMap<Metric, String>();
        for (Map.Entry<String, Metric> entry : this._metricsByProp.entrySet()) {
            this._propsByMetric.put(entry.getValue(), entry.getKey());
        }
    }

    protected abstract TypeInfo[] getProvidedTypeInfos();

    public ResultSet getProperties(PropertyRequestSpec prSpec) {
        ResultSet metricsData = this._perfManager.getStats(this.toMetrics(prSpec));
        return this.toProperties(metricsData);
    }

    private ResultSet toProperties(ResultSet rs) {
        for (ResultItem item : rs.items) {
            for (PropertyValue pv : item.properties) {
                if (!(pv.value instanceof PerformanceManager.IntSeries)) continue;
                PerformanceManager.IntSeries perfMetricData = (PerformanceManager.IntSeries)pv.value;
                if (perfMetricData.id == null) continue;
                Metric queriedMetric = new Metric(pv.propertyName, perfMetricData.id.instance);
                pv.propertyName = this._propsByMetric.get(queriedMetric);
                pv.value = perfMetricData.value[0];
            }
        }
        return rs;
    }

    private Map<ManagedObjectReference, List<Metric>> toMetrics(PropertyRequestSpec request) {
        HashMap<ManagedObjectReference, List<Metric>> map = new HashMap<ManagedObjectReference, List<Metric>>();
        for (Object entity : request.objects) {
            map.put((ManagedObjectReference)entity, this.extractMetricNames(request));
        }
        return map;
    }

    private List<Metric> extractMetricNames(PropertyRequestSpec request) {
        ArrayList<Metric> metricNames = new ArrayList<Metric>();
        for (String propName : DataUtil.extractPropertyNames(request)) {
            metricNames.add(this._metricsByProp.get(propName));
        }
        return metricNames;
    }
}

