/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vapi.tasks;

import com.vmware.vapi.bindings.client.AsyncCallbackFuture;
import com.vmware.vapi.bindings.client.InvocationConfig;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.vapi.util.VapiUtil;
import com.vmware.vsphere.client.vapi.tasks.VapiTaskMonitor;
import java.util.concurrent.ExecutionException;

public class VapiAsyncCallback<T>
extends AsyncCallbackFuture<T> {
    protected String _activationId;
    protected String _nodeUuid;
    protected VapiTaskMonitor _taskMonitor;

    public VapiAsyncCallback() {
        this(null, null, null);
    }

    public VapiAsyncCallback(VapiTaskMonitor taskMonitor) {
        this(null, taskMonitor, null);
    }

    public VapiAsyncCallback(String activationId, VapiTaskMonitor taskMonitor) {
        this(activationId, taskMonitor, null);
    }

    public VapiAsyncCallback(VapiTaskMonitor taskMonitor, String nodeUuid) {
        this(null, taskMonitor, nodeUuid);
    }

    public VapiAsyncCallback(String activationId, VapiTaskMonitor taskMonitor, String nodeUuid) {
        this.init(activationId, taskMonitor, nodeUuid);
    }

    private void init(String activationId, VapiTaskMonitor taskMonitor, String nodeUuid) {
        this._activationId = activationId != null ? activationId : VapiUtil.newClientToken();
        this._taskMonitor = taskMonitor;
        this._nodeUuid = nodeUuid;
    }

    public String getActivationId() {
        return this._activationId;
    }

    public String getNodeUuid() {
        return this._nodeUuid;
    }

    public InvocationConfig getInvocationConfig() {
        return VapiUtil.newInvocationConfig((String)this._nodeUuid, (String)this.getActivationId());
    }

    public ManagedObjectReference waitForActivationTask() throws InterruptedException, ExecutionException {
        if (this._taskMonitor == null) {
            return null;
        }
        return this._taskMonitor.waitForActivationTask(this._activationId, this._nodeUuid, this);
    }
}

