/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cluster.filter;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.cluster.DasVmConfigInfo;
import com.vmware.vim.binding.vim.cluster.DrsVmConfigInfo;
import com.vmware.vim.binding.vim.cluster.VmOrchestrationInfo;
import com.vmware.vise.common.api.filters.QueryFilterBuilder;
import com.vmware.vise.common.api.filters.annotations.QueryFilter;
import com.vmware.vise.data.query.ObjectReferenceService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class ClusterFilterBuilder
implements QueryFilterBuilder {
    private final ObjectReferenceService _objectReferenceService;
    private final QueryService _queryService;
    public static final String PROPERTY_CLUSTER = "cluster";
    public static final String PROPERTY_IS_NORMAL_VM_OR_PRIMARY_FTVM = "isNormalVMOrPrimaryFTVM";
    public static final String PROPERTY_DRS_OVERRIDES = "configurationEx/drsVmConfig";
    public static final String PROPERTY_HA_OVERRIDES = "configurationEx/dasVmConfig";
    public static final String PROPERTY_ORCH_OVERRIDES = "configurationEx/vmOrchestration";
    public static final String PROPERTY_HA_ENABLED = "configurationEx/dasConfig/enabled";
    public static final String PROPERTY_DRS_ENABLED = "configurationEx/drsConfig/enabled";

    public ClusterFilterBuilder(ObjectReferenceService objectReferenceService, QueryServiceFactory queryServiceFactory) {
        this._objectReferenceService = objectReferenceService;
        this._queryService = queryServiceFactory.getQueryService();
    }

    @QueryFilter(value="clusterObjectsExcludeObjectsFilter")
    public Filter clusterObjectsExcludeObjectsFilter(String clusterId, String[] objectIds) {
        Validate.notNull((Object)clusterId);
        Validate.notNull((Object)objectIds);
        Validate.isTrue((objectIds.length == 0 || StringUtils.isNoneBlank((CharSequence[])objectIds) ? 1 : 0) != 0);
        Object clusterRef = this._objectReferenceService.getReference(clusterId, true);
        if (clusterRef == null) {
            return null;
        }
        ArrayList<PropertyPredicate> predicateList = new ArrayList<PropertyPredicate>();
        this.addObjectsInClusterPredicate(predicateList, clusterRef);
        List<Object> excludedObjects = this.getObjectRefsById(objectIds);
        this.addExcludedObjectsPredicate(predicateList, excludedObjects);
        return new Filter(predicateList);
    }

    @QueryFilter(value="clusterObjectsFilter")
    public Filter clusterObjectsFilter(String clusterId) {
        Validate.notNull((Object)clusterId);
        Object clusterRef = this._objectReferenceService.getReference(clusterId, true);
        if (clusterRef == null) {
            return null;
        }
        ArrayList<PropertyPredicate> predicateList = new ArrayList<PropertyPredicate>();
        this.addObjectsInClusterPredicate(predicateList, clusterRef);
        return new Filter(predicateList);
    }

    @QueryFilter(value="clusterVmsExceptSecondaryVmsExcludeVmsFilter")
    public Filter clusterVmsExceptSecondaryVmsExcludeVmsFilter(String clusterId, String[] objectIds) {
        Validate.notNull((Object)clusterId);
        Validate.notNull((Object)objectIds);
        Validate.isTrue((objectIds.length == 0 || StringUtils.isNoneBlank((CharSequence[])objectIds) ? 1 : 0) != 0);
        Object clusterRef = this._objectReferenceService.getReference(clusterId, true);
        if (clusterRef == null) {
            return null;
        }
        ArrayList<PropertyPredicate> predicateList = new ArrayList<PropertyPredicate>();
        this.addObjectsInClusterPredicate(predicateList, clusterRef);
        this.addIsNotSecondaryVmPredicate(predicateList);
        List<Object> excludedVms = this.getObjectRefsById(objectIds);
        this.addExcludedObjectsPredicate(predicateList, excludedVms);
        return new Filter(predicateList);
    }

    @QueryFilter(value="clusterVmsExceptSecondaryVmsFilter")
    public Filter clusterVmsExceptSecondaryVmsFilter(String clusterId) {
        Validate.notNull((Object)clusterId);
        Object clusterRef = this._objectReferenceService.getReference(clusterId, true);
        if (clusterRef == null) {
            return null;
        }
        ArrayList<PropertyPredicate> predicateList = new ArrayList<PropertyPredicate>();
        this.addObjectsInClusterPredicate(predicateList, clusterRef);
        this.addIsNotSecondaryVmPredicate(predicateList);
        return new Filter(predicateList);
    }

    @QueryFilter(value="clusterVmsExceptOverriddenVmsExcludeVmsFilter")
    public Filter clusterVmsExceptOverriddenVmsExcludeVmsFilter(String clusterId, String[] objectIds) {
        Validate.notNull((Object)clusterId);
        Validate.notNull((Object)objectIds);
        Validate.isTrue((objectIds.length == 0 || StringUtils.isNoneBlank((CharSequence[])objectIds) ? 1 : 0) != 0);
        Object clusterRef = this._objectReferenceService.getReference(clusterId, true);
        if (clusterRef == null) {
            return null;
        }
        ArrayList<PropertyPredicate> predicateList = new ArrayList<PropertyPredicate>();
        this.addObjectsInClusterPredicate(predicateList, clusterRef);
        this.addIsNotSecondaryVmPredicate(predicateList);
        Set<Object> overriddenVms = this.getOverriddenVmRefs(clusterRef);
        List<Object> excludedVms = this.getObjectRefsById(objectIds);
        if (!overriddenVms.isEmpty()) {
            excludedVms.addAll(overriddenVms);
        }
        this.addExcludedObjectsPredicate(predicateList, excludedVms);
        return new Filter(predicateList);
    }

    @QueryFilter(value="clusterVmsExceptOverriddenVmsFilter")
    public Filter clusterVmsExceptOverriddenVmsFilter(String clusterId) {
        Validate.notNull((Object)clusterId);
        Object clusterRef = this._objectReferenceService.getReference(clusterId, true);
        if (clusterRef == null) {
            return null;
        }
        ArrayList<PropertyPredicate> predicateList = new ArrayList<PropertyPredicate>();
        this.addObjectsInClusterPredicate(predicateList, clusterRef);
        this.addIsNotSecondaryVmPredicate(predicateList);
        this.addIsNotOverriddenVmPredicate(predicateList, clusterRef);
        return new Filter(predicateList);
    }

    private void addObjectsInClusterPredicate(List<PropertyPredicate> predicateList, Object clusterRef) {
        PropertyPredicate objectsInCluster = new PropertyPredicate(PROPERTY_CLUSTER, PropertyPredicate.ComparisonOperator.EQUAL, clusterRef);
        predicateList.add(objectsInCluster);
    }

    private void addExcludedObjectsPredicate(List<PropertyPredicate> predicateList, Collection<Object> objects) {
        PropertyPredicate alreadySelectedObjects = new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.NOT_IN, objects);
        predicateList.add(alreadySelectedObjects);
    }

    private List<Object> getObjectRefsById(String[] objectIds) {
        ArrayList<Object> objects = new ArrayList<Object>(objectIds.length);
        for (String objectId : objectIds) {
            objects.add(this._objectReferenceService.getReference(objectId, true));
        }
        return objects;
    }

    private void addIsNotSecondaryVmPredicate(List<PropertyPredicate> predicateList) {
        PropertyPredicate objectsInCluster = new PropertyPredicate(PROPERTY_IS_NORMAL_VM_OR_PRIMARY_FTVM, PropertyPredicate.ComparisonOperator.EQUAL, (Object)true);
        predicateList.add(objectsInCluster);
    }

    private void addIsNotOverriddenVmPredicate(List<PropertyPredicate> predicateList, Object clusterRef) {
        Set<Object> overriddenVms = this.getOverriddenVmRefs(clusterRef);
        if (!overriddenVms.isEmpty()) {
            this.addExcludedObjectsPredicate(predicateList, overriddenVms);
        }
    }

    private Set<Object> getOverriddenVmRefs(Object clusterRef) {
        VmOrchestrationInfo[] orchOverrides;
        ResultSet resultSet = this._queryService.select(new String[]{PROPERTY_DRS_OVERRIDES, PROPERTY_HA_OVERRIDES, PROPERTY_ORCH_OVERRIDES, PROPERTY_DRS_ENABLED, PROPERTY_HA_ENABLED}).from(new String[]{ClusterComputeResource.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, clusterRef)}).fetch();
        HashSet<Object> overriddenVms = new HashSet<Object>();
        ResourceItem clusterResult = (ResourceItem)resultSet.getItems().get(0);
        DrsVmConfigInfo[] drsOverrides = (DrsVmConfigInfo[])clusterResult.get(PROPERTY_DRS_OVERRIDES);
        boolean drsEnabled = (Boolean)clusterResult.get(PROPERTY_DRS_ENABLED);
        if (drsOverrides != null && drsEnabled) {
            for (DrsVmConfigInfo vmOverride : drsOverrides) {
                overriddenVms.add(vmOverride.key);
            }
        }
        DasVmConfigInfo[] haOverrides = (DasVmConfigInfo[])clusterResult.get(PROPERTY_HA_OVERRIDES);
        boolean haEnabled = (Boolean)clusterResult.get(PROPERTY_HA_ENABLED);
        if (haOverrides != null && haEnabled) {
            for (DasVmConfigInfo vmOverride : haOverrides) {
                overriddenVms.add(vmOverride.key);
            }
        }
        if ((orchOverrides = (VmOrchestrationInfo[])clusterResult.get(PROPERTY_ORCH_OVERRIDES)) != null && haEnabled) {
            for (VmOrchestrationInfo vmOverride : orchOverrides) {
                overriddenVms.add(vmOverride.vm);
            }
        }
        return overriddenVms;
    }
}

