/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.commonservice.impl;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vsphere.client.commonservice.util.Util;

public class IsCreateVmAllowedPropertyProvider
implements PropertyProviderBean {
    private static final String RELATION_RESOURCE_POOL = "resourcePool";
    private static final String RELATION_VM_FOLDER = "vmFolder";
    private static final String PRIVILEGE_VM_INVENTORY_CREATE = "VirtualMachine.Inventory.Create";
    private static final String PRIVILEGE_ASSIGN_VM_TO_POOL = "Resource.AssignVMToPool";
    private static final String PROPERTY_GRANTED_PRIVILEGES = "grantedPrivileges";
    private static final String PROPERTY_DISABLED_METHODS = "disabledMethod";
    private static final String CREATE_VM_METHOD = "CreateVM_Task";
    private QueryExecutor _queryExecutor;

    public void setQueryExecutor(QueryExecutor queryExecutor) {
        this._queryExecutor = queryExecutor;
    }

    @type(value="Datacenter,ClusterComputeResource")
    public boolean getIsCreateVmAllowed(ManagedObjectReference moRef) throws Exception {
        String type2 = moRef.getType();
        if (Datacenter.class.getSimpleName().equals(type2)) {
            boolean createOnDcAvailable = this.isCreateVmOnDcAvailable(moRef);
            return createOnDcAvailable;
        }
        if (ClusterComputeResource.class.getSimpleName().equals(type2)) {
            boolean createOnClusterAvailable = this.isCreateOnClusterAvailable(moRef);
            return createOnClusterAvailable;
        }
        throw new IllegalArgumentException("Unexpected managed object type: " + type2);
    }

    private boolean isCreateVmOnDcAvailable(ManagedObjectReference dcRef) throws Exception {
        PropertyValue[] pvs = this._queryExecutor.getPropertyForRelatedObjects((Object)dcRef, RELATION_VM_FOLDER, Folder.class.getSimpleName(), PROPERTY_GRANTED_PRIVILEGES);
        String[] grantedPrivileges = (String[])Util.getProperty(pvs, PROPERTY_GRANTED_PRIVILEGES);
        boolean privGranted = AuthorizationUtil.isPrivilegeGranted((String[])new String[]{PRIVILEGE_VM_INVENTORY_CREATE}, (String[])grantedPrivileges);
        return privGranted;
    }

    private boolean isCreateOnClusterAvailable(ManagedObjectReference clusterRef) throws Exception {
        PropertyValue[] pvs = this._queryExecutor.getPropertiesForRelatedObjects((Object)clusterRef, RELATION_RESOURCE_POOL, ResourcePool.class.getSimpleName(), new String[]{PROPERTY_DISABLED_METHODS, PROPERTY_GRANTED_PRIVILEGES});
        String[] disabledMethods = (String[])Util.getProperty(pvs, PROPERTY_DISABLED_METHODS);
        String[] grantedPrivileges = (String[])Util.getProperty(pvs, PROPERTY_GRANTED_PRIVILEGES);
        boolean operationAllowed = AuthorizationUtil.isOperationAllowed((String[])new String[]{CREATE_VM_METHOD}, (String[])disabledMethods);
        boolean privGranted = AuthorizationUtil.isPrivilegeGranted((String[])new String[]{PRIVILEGE_ASSIGN_VM_TO_POOL}, (String[])grantedPrivileges);
        return operationAllowed && privGranted;
    }
}

