/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.datastore.filter;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.common.api.filters.QueryFilterBuilder;
import com.vmware.vise.common.api.filters.annotations.QueryFilter;
import com.vmware.vise.data.query.ObjectReferenceService;
import java.util.ArrayList;
import org.apache.commons.lang3.Validate;

public class DatastoreFilterBuilder
implements QueryFilterBuilder {
    private static final String HOST_KEY_PROP_NAME = "hostKey";
    private static final String NFS_TYPE = "NFS*";
    private static final String DATASTORE_TYPE_PROP_NAME = "specificType";
    private final ObjectReferenceService _objectReferenceService;

    public DatastoreFilterBuilder(ObjectReferenceService objectReferenceService) {
        this._objectReferenceService = objectReferenceService;
    }

    @QueryFilter(value="nfsDatastores")
    public Filter nfsDatastoresFilter(String hostId) {
        Validate.notNull((Object)hostId);
        ManagedObjectReference hostRef = (ManagedObjectReference)this._objectReferenceService.getReference(hostId, true);
        if (hostRef == null) {
            return null;
        }
        ArrayList<PropertyPredicate> predicateList = new ArrayList<PropertyPredicate>();
        predicateList.add(new PropertyPredicate(HOST_KEY_PROP_NAME, PropertyPredicate.ComparisonOperator.EQUAL, (Object)hostRef));
        predicateList.add(new PropertyPredicate(DATASTORE_TYPE_PROP_NAME, PropertyPredicate.ComparisonOperator.LIKE, (Object)NFS_TYPE, true));
        return new Filter(predicateList);
    }
}

