/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.library.filter;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.vise.common.api.filters.QueryFilterBuilder;
import com.vmware.vise.common.api.filters.annotations.QueryFilter;
import com.vmware.vise.data.query.ObjectReferenceService;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentLibraryFilterBuilder
implements QueryFilterBuilder {
    private static final Log logger = LogFactory.getLog(ContentLibraryFilterBuilder.class);
    private static final String VSAND = "vsanD";
    private static final String SERVER_GUID_PROPERTY = "serverGuid";
    private static final String DS_TYPE_PROPERTY = "summary/type";
    private final ObjectReferenceService objectReferenceService;

    public ContentLibraryFilterBuilder(ObjectReferenceService objectReferenceService) {
        this.objectReferenceService = objectReferenceService;
    }

    @QueryFilter(value="datastoresSuitableForContentLibraryCreation")
    public Filter datastoresSuitableForContentLibraryCreation(String vcId) {
        Object vcRef = this.objectReferenceService.getReference(vcId, true);
        if (vcRef == null) {
            logger.warn((Object)String.format("Cannot obtain object reference for vCenter Server '%s'.", vcId));
            return null;
        }
        String serverGuid = this.objectReferenceService.getServerGuid(vcRef);
        if (serverGuid == null) {
            logger.warn((Object)String.format("Cannot obtain server GUID for vCenter Server '%s'.", vcId));
            return null;
        }
        return new Filter(Arrays.asList(new PropertyPredicate(SERVER_GUID_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)serverGuid), new PropertyPredicate(DS_TYPE_PROPERTY, PropertyPredicate.ComparisonOperator.NOT_EQUAL, (Object)VSAND)));
    }
}

