/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sdk.filter;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.common.api.filters.QueryFilterBuilder;
import com.vmware.vise.common.api.filters.annotations.QueryFilter;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class SdkVcDescendantObjectFilterBuilder
implements QueryFilterBuilder {
    private static final String IS_NON_ROOT_RP_PROPERTY = "isNonRootRP";
    private static final String IS_SYSTEM_FOLDER_PROPERTY = "isSystemFolder";
    private static final String IS_DATACENTER_FOLDER_PROPERTY = "isDatacenterFolder";
    private static final String IS_DATASTORE_FOLDER_PROPERTY = "isDatastoreFolder";
    private static final String IS_COMPUTE_RESOURCE_FOLDER_PROPERTY = "isComputeResourceFolder";
    private static final String IS_NETWORK_FOLDER_PROPERTY = "isNetworkFolder";
    private static final String IS_VIRTUAL_MACHINE_FOLDER_PROPERTY = "isVirtualMachineFolder";
    private final ObjectReferenceService _objectReferenceService;

    public SdkVcDescendantObjectFilterBuilder(ObjectReferenceService objectReferenceService) {
        Validate.notNull((Object)objectReferenceService);
        this._objectReferenceService = objectReferenceService;
    }

    @QueryFilter(value="sdkVcDescendantContentLibraryFilter")
    public Filter sdkVcDescendantContentLibraryFilter(String rootFolderId) {
        ManagedObjectReference rootFolderRef = this.getRootFolderMoRef(rootFolderId);
        PropertyPredicate serverGuidPredicate = new PropertyPredicate("@instanceUuid", PropertyPredicate.ComparisonOperator.EQUAL, (Object)rootFolderRef.getServerGuid());
        List<PropertyPredicate> criteria = Collections.singletonList(serverGuidPredicate);
        return new Filter(criteria, LogicalOperator.AND);
    }

    @QueryFilter(value="sdkVcDescendantContentLibraryItemFilter")
    public Filter sdkVcDescendantContentLibraryItemFilter(String rootFolderId) {
        ManagedObjectReference rootFolderRef = this.getRootFolderMoRef(rootFolderId);
        PropertyPredicate serverGuidPredicate = new PropertyPredicate("@instanceUuid", PropertyPredicate.ComparisonOperator.EQUAL, (Object)rootFolderRef.getServerGuid());
        List<PropertyPredicate> criteria = Collections.singletonList(serverGuidPredicate);
        return new Filter(criteria, LogicalOperator.AND);
    }

    @QueryFilter(value="sdkVcDescendantDatacenterFolderFilter")
    public Filter sdkVcDescendantDatacenterFolderFilter(String rootFolderId) {
        return this.createStandardFolderFilter(rootFolderId, IS_DATACENTER_FOLDER_PROPERTY);
    }

    @QueryFilter(value="sdkVcDescendantDatastoreFolderFilter")
    public Filter sdkVcDescendantDatastoreFolderFilter(String rootFolderId) {
        return this.createStandardFolderFilter(rootFolderId, IS_DATASTORE_FOLDER_PROPERTY);
    }

    @QueryFilter(value="sdkVcDescendantFolderFilter")
    public Filter sdkVcDescendantFolderFilter(String rootFolderId) {
        return this.createStandardFolderFilter(rootFolderId, null);
    }

    @QueryFilter(value="sdkVcDescendantHostFolderFilter")
    public Filter sdkVcDescendantHostFolderFilter(String rootFolderId) {
        return this.createStandardFolderFilter(rootFolderId, IS_COMPUTE_RESOURCE_FOLDER_PROPERTY);
    }

    @QueryFilter(value="sdkVcDescendantNetworkFilter")
    public Filter sdkVcDescendantNetworkFilter(String rootFolderId) {
        ManagedObjectReference rootFolderRef = this.getRootFolderMoRef(rootFolderId);
        PropertyPredicate serverGuidPredicate = new PropertyPredicate("@instanceUuid", PropertyPredicate.ComparisonOperator.EQUAL, (Object)rootFolderRef.getServerGuid());
        List<PropertyPredicate> criteria = Collections.singletonList(serverGuidPredicate);
        return new Filter(criteria, LogicalOperator.AND);
    }

    @QueryFilter(value="sdkVcDescendantNetworkFolderFilter")
    public Filter sdkVcDescendantNetworkFolderFilter(String rootFolderId) {
        return this.createStandardFolderFilter(rootFolderId, IS_NETWORK_FOLDER_PROPERTY);
    }

    @QueryFilter(value="sdkVcDescendantOpaqueNetworkFilter")
    public Filter sdkVcDescendantOpaqueNetworkFilter(String rootFolderId) {
        ManagedObjectReference rootFolderRef = this.getRootFolderMoRef(rootFolderId);
        PropertyPredicate serverGuidPredicate = new PropertyPredicate("@instanceUuid", PropertyPredicate.ComparisonOperator.EQUAL, (Object)rootFolderRef.getServerGuid());
        List<PropertyPredicate> criteria = Collections.singletonList(serverGuidPredicate);
        return new Filter(criteria, LogicalOperator.AND);
    }

    @QueryFilter(value="sdkVcDescendantResourcePoolFilter")
    public Filter sdkVcDescendantResourcePoolFilter(String rootFolderId) {
        ManagedObjectReference rootFolderRef = this.getRootFolderMoRef(rootFolderId);
        PropertyPredicate serverGuidPredicate = new PropertyPredicate("@instanceUuid", PropertyPredicate.ComparisonOperator.EQUAL, (Object)rootFolderRef.getServerGuid());
        PropertyPredicate rootFolderPredicate = new PropertyPredicate(IS_NON_ROOT_RP_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)true);
        List<PropertyPredicate> criteria = Arrays.asList(serverGuidPredicate, rootFolderPredicate);
        return new Filter(criteria, LogicalOperator.AND);
    }

    @QueryFilter(value="sdkVcDescendantVirtualMachineFolderFilter")
    public Filter sdkVcDescendantVirtualMachineFolderFilter(String rootFolderId) {
        return this.createStandardFolderFilter(rootFolderId, IS_VIRTUAL_MACHINE_FOLDER_PROPERTY);
    }

    private Filter createStandardFolderFilter(String rootFolderId, String folderTypePropertyName) {
        ManagedObjectReference rootFolderRef = this.getRootFolderMoRef(rootFolderId);
        ArrayList<PropertyPredicate> criteria = new ArrayList<PropertyPredicate>(3);
        PropertyPredicate serverGuidPredicate = new PropertyPredicate("@instanceUuid", PropertyPredicate.ComparisonOperator.EQUAL, (Object)rootFolderRef.getServerGuid());
        criteria.add(serverGuidPredicate);
        PropertyPredicate isSystemFolderPredicate = new PropertyPredicate(IS_SYSTEM_FOLDER_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)false);
        criteria.add(isSystemFolderPredicate);
        if (folderTypePropertyName != null) {
            PropertyPredicate folderTypePredicate = new PropertyPredicate(folderTypePropertyName, PropertyPredicate.ComparisonOperator.EQUAL, (Object)true);
            criteria.add(folderTypePredicate);
        }
        return new Filter(criteria, LogicalOperator.AND);
    }

    private ManagedObjectReference getRootFolderMoRef(String rootFolderId) {
        Object objectRef = this._objectReferenceService.getReference(rootFolderId, true);
        if (!(objectRef instanceof ManagedObjectReference) || !ManagedObjectUtil.isRootFolder((ManagedObjectReference)((ManagedObjectReference)objectRef))) {
            throw new IllegalArgumentException(String.format("rootFolderId: \"%s\" is not a valid root folder object ID.", rootFolderId));
        }
        return (ManagedObjectReference)objectRef;
    }
}

