/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin;

import com.vmware.vise.data.uri.ResourceTypeResolver;
import com.vmware.vise.data.uri.ResourceTypeResolverRegistry;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.StringUtil;
import java.net.URI;

public final class SsoUriSchemeResolver
implements ResourceTypeResolver {
    private static final String PREFIX = "urn:vri";
    private static final String TYPE_PREFIX = "sso:";
    private static final String SCHEME = "urn:vri:sso";
    private static final char SEPARATOR = ':';

    SsoUriSchemeResolver() {
    }

    public static SsoUriSchemeResolver getResolver(ResourceTypeResolverRegistry resourceTypeRegistry) {
        SsoUriSchemeResolver resolver = new SsoUriSchemeResolver();
        if (resourceTypeRegistry != null) {
            resourceTypeRegistry.unregisterSchemeResolver(SCHEME);
            resourceTypeRegistry.registerSchemeResolver(SCHEME, (ResourceTypeResolver)resolver);
        }
        return resolver;
    }

    public String getServerGuid(URI uri) {
        String uriString = uri.toString();
        if (uriString.indexOf(35) != -1) {
            Pair uriParts = StringUtil.removeLastWord((String)uriString, (char)'#');
            uriString = (String)uriParts.first;
        }
        int typeSeparatorIndex = SsoUriSchemeResolver.getTypeSeparatorIndex(uriString);
        int serverGuidSeparatorIndex = uriString.lastIndexOf(58);
        if (serverGuidSeparatorIndex == typeSeparatorIndex) {
            return null;
        }
        String serverGuid = null;
        String type = uriString.substring(typeSeparatorIndex + 1, serverGuidSeparatorIndex);
        if (type.length() > TYPE_PREFIX.length()) {
            serverGuid = uriString.substring(serverGuidSeparatorIndex + 1);
        }
        return serverGuid;
    }

    public String getResourceType(URI uri) {
        int idSeparatorIndex;
        String uriString = uri.toString();
        int typeSeparatorIndex = SsoUriSchemeResolver.getTypeSeparatorIndex(uriString);
        if (typeSeparatorIndex == (idSeparatorIndex = uriString.lastIndexOf(58))) {
            return uriString.substring(typeSeparatorIndex + 1);
        }
        String type = uriString.substring(typeSeparatorIndex + 1, idSeparatorIndex);
        if (type.length() <= TYPE_PREFIX.length()) {
            type = uriString.substring(typeSeparatorIndex + 1);
        }
        return type;
    }

    private static int getTypeSeparatorIndex(String uriString) {
        int typeSeparatorIndex = uriString.indexOf(58, PREFIX.length());
        if (typeSeparatorIndex < 0 || typeSeparatorIndex >= uriString.length() - 1 || uriString.substring(typeSeparatorIndex + 1).length() <= TYPE_PREFIX.length()) {
            throw new IllegalArgumentException("Invalid SSO URI: " + uriString);
        }
        return typeSeparatorIndex;
    }
}

