/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.impl;

import com.vmware.sso.tokenmgmt.SsoDomainHelper;
import com.vmware.vcenter.apigw.api.sso.SsoDomain;
import com.vmware.vim.binding.sso.admin.Group;
import com.vmware.vim.binding.sso.admin.PersonUser;
import com.vmware.vim.binding.sso.admin.PrincipalDiscoveryService;
import com.vmware.vim.binding.sso.admin.SolutionUser;
import com.vmware.vim.binding.vim.UserSearchResult;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vise.vim.users.DomainSearchResult;
import com.vmware.vise.vim.users.UserDirectorySpec;
import com.vmware.vsphere.client.sso.admin.impl.IdentitySourceDomainManagementService;
import com.vmware.vsphere.client.sso.admin.impl.PrincipalManagementServiceImpl;
import com.vmware.vsphere.client.sso.admin.model.DomainSpec;
import com.vmware.vsphere.client.sso.admin.model.ExternalDomainSpec;
import com.vmware.vsphere.client.sso.admin.model.LocalOSDomainSpec;
import com.vmware.vsphere.client.sso.admin.model.NativeAdDomainSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SsoUserDirectoryPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(SsoUserDirectoryPropertyProvider.class);
    private SsoServiceManager _ssoMgr = null;
    private final ObjectReferenceService _objRefService;
    private ConfigurationService _configurationService;

    public SsoUserDirectoryPropertyProvider(SsoServiceManager ssoServiceManager, ObjectReferenceService objRefService, ConfigurationService configurationService) {
        this._ssoMgr = ssoServiceManager;
        this._objRefService = objRefService;
        this._configurationService = configurationService;
    }

    @ModelMetadata(type={"*"}, property="vsphere:domainList")
    public DomainSearchResult[] getDomainList(Object object) throws Exception {
        SsoDomain ssoDomain = SsoDomainHelper.getLocal();
        String ssoDomainId = this._objRefService.getServerGuid(object);
        if (StringUtils.isNotBlank((CharSequence)ssoDomainId)) {
            ssoDomain = SsoDomainHelper.valueOf((String)ssoDomainId, null, null);
        }
        SsoAdminService adminService = this._ssoMgr.getSolutionAdminService(object, ssoDomain);
        IdentitySourceDomainManagementService domainMgmt = new IdentitySourceDomainManagementService(adminService, this._configurationService);
        List<DomainSpec> domains = domainMgmt.getDomains();
        ArrayList<DomainSearchResult> domainList = new ArrayList<DomainSearchResult>();
        for (DomainSpec domain : domains) {
            DomainSearchResult dsr = new DomainSearchResult(domain.domainName);
            if (domain instanceof ExternalDomainSpec || domain instanceof NativeAdDomainSpec) {
                dsr.isSystem = false;
            } else if (domain instanceof LocalOSDomainSpec) {
                dsr.isLocal = true;
            } else {
                dsr.isSystem = true;
            }
            domainList.add(dsr);
        }
        _logger.debug((Object)("getDomainList found " + domainList.size() + " domains."));
        return domainList.toArray(new DomainSearchResult[domainList.size()]);
    }

    @ModelMetadata(type={"*"}, property="vsphere:systemDomainList")
    public String[] getSystemDomainsList(Object object) throws Exception {
        SsoDomain ssoDomain = SsoDomainHelper.getLocal();
        String ssoDomainId = this._objRefService.getServerGuid(object);
        if (StringUtils.isNotBlank((CharSequence)ssoDomainId)) {
            ssoDomain = SsoDomainHelper.valueOf((String)ssoDomainId, null, null);
        }
        SsoAdminService adminService = this._ssoMgr.getSolutionAdminService(object, ssoDomain);
        IdentitySourceDomainManagementService domainMgmt = new IdentitySourceDomainManagementService(adminService, this._configurationService);
        Set<String> domains = domainMgmt.getSystemDomains();
        return domains.toArray(new String[domains.size()]);
    }

    /*
     * WARNING - void declaration
     */
    @ModelMetadata(type={"*"}, property="vsphere:userGroups")
    public UserSearchResult[] getUserGroups(Object object, UserDirectorySpec spec) throws Exception {
        UserSearchResult searchResult;
        if (spec.searchString == null) {
            spec.searchString = "";
        }
        SsoDomain ssoDomain = SsoDomainHelper.getLocal();
        String ssoDomainId = this._objRefService.getServerGuid(object);
        if (StringUtils.isNotBlank((CharSequence)ssoDomainId)) {
            ssoDomain = SsoDomainHelper.valueOf((String)ssoDomainId, null, null);
        }
        ArrayList<UserSearchResult> result = new ArrayList<UserSearchResult>();
        SsoAdminService adminService = this._ssoMgr.getSolutionAdminService(object, ssoDomain);
        PrincipalManagementServiceImpl principalDiscovery = new PrincipalManagementServiceImpl(adminService);
        PrincipalDiscoveryService.SearchResult usersAndGroups = principalDiscovery.find(spec.domain, spec.searchString);
        if (spec.findUsers) {
            void var13_17;
            Object[] users = usersAndGroups.personUsers;
            for (PersonUser personUser : (PersonUser[])ArrayUtils.nullToEmpty((Object[])users, PersonUser[].class)) {
                searchResult = new UserSearchResult();
                searchResult.principal = personUser.id.name;
                searchResult.group = false;
                searchResult.fullName = this.getFullName(personUser.details.firstName, personUser.details.lastName);
                result.add(searchResult);
            }
            Object[] solutionUsers = usersAndGroups.solutionUsers;
            SolutionUser[] solutionUserArray = (SolutionUser[])ArrayUtils.nullToEmpty((Object[])solutionUsers, SolutionUser[].class);
            int n = solutionUserArray.length;
            boolean bl = false;
            while (var13_17 < n) {
                SolutionUser solutionUser = solutionUserArray[var13_17];
                UserSearchResult searchResult2 = new UserSearchResult();
                searchResult2.principal = solutionUser.id.name;
                searchResult2.group = false;
                searchResult2.fullName = solutionUser.details.description;
                result.add(searchResult2);
                ++var13_17;
            }
        }
        if (spec.findGroups) {
            Object[] groups = usersAndGroups.groups;
            for (PersonUser personUser : (Group[])ArrayUtils.nullToEmpty((Object[])groups, Group[].class)) {
                searchResult = new UserSearchResult();
                searchResult.principal = personUser.id.name;
                searchResult.group = true;
                searchResult.fullName = personUser.details.description;
                result.add(searchResult);
            }
        }
        if (spec.exactMatch) {
            result = this.filterByPrincipal(result, spec.searchString);
        }
        return result.toArray(new UserSearchResult[result.size()]);
    }

    private ArrayList<UserSearchResult> filterByPrincipal(ArrayList<UserSearchResult> list, String criteria) {
        ArrayList<UserSearchResult> result = new ArrayList<UserSearchResult>();
        for (UserSearchResult searchResult : list) {
            if (!criteria.equalsIgnoreCase(searchResult.principal)) continue;
            result.add(searchResult);
        }
        return result;
    }

    private String getFullName(String firstName, String lastName) {
        String result = "";
        if (StringUtils.isNotEmpty((CharSequence)firstName)) {
            result = result + firstName;
        }
        if (StringUtils.isNotEmpty((CharSequence)lastName)) {
            result = result + (result.length() > 0 ? " " + lastName : lastName);
        }
        return result;
    }
}

